// Borland C++ Builder
// Copyright (c) 1995, 1998 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'MathInterpreter.pas' rev: 3.00

#ifndef MathInterpreterHPP
#define MathInterpreterHPP
#include <MathItem.hpp>
#include <Dialogs.hpp>
#include <Forms.hpp>
#include <Controls.hpp>
#include <Graphics.hpp>
#include <Classes.hpp>
#include <SysUtils.hpp>
#include <Messages.hpp>
#include <Windows.hpp>
#include <SysInit.hpp>
#include <System.hpp>

//-- user supplied -----------------------------------------------------------

namespace Mathinterpreter
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS TMathInterpreter;
typedef void __fastcall (__closure *TUnknownSymbolEvent)(TMathInterpreter* Sender, const System::AnsiString 
	Identifier, const System::Variant &Parameters, System::Variant &Value);

class PASCALIMPLEMENTATION TMathInterpreter : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	Mathitem::TDumpFormat FDumpFormat;
	System::AnsiString FExpression;
	System::Variant FExpressionResult;
	bool FPersistant;
	Mathitem::TMExpressions* FPreparedExpressions;
	Cardinal FMaxFunctionNesting;
	bool FCaseSensitiveSymbols;
	TUnknownSymbolEvent FOnUnknownSymbol;
	char FEscapeChar;
	void __fastcall SetExpression(const System::AnsiString Value);
	System::AnsiString __fastcall GetExpressionResult();
	void __fastcall SetExpressionResult(const System::AnsiString Value);
	System::AnsiString __fastcall GetDumpText();
	void __fastcall SetDumpText(const System::AnsiString Value);
	System::Variant __fastcall GetVariables(System::AnsiString VarName);
	System::Variant __fastcall GetVariablesByHandle(int VarHandle);
	void __fastcall SetVariables(System::AnsiString VarName, const System::Variant &Value);
	void __fastcall SetVariablesByHandle(int VarHandle, const System::Variant &Value);
	int __fastcall GetVariableHandles(System::AnsiString VarName);
	void __fastcall SetCaseSensitiveSymbols(const bool Value);
	void __fastcall WriteSymbols(Classes::TWriter* Writer);
	void __fastcall ReadSymbols(Classes::TReader* Reader);
	
protected:
	virtual void __fastcall DefineProperties(Classes::TFiler* Filer);
	void __fastcall ParseExpression(const System::AnsiString Text, Mathitem::TMItems* ParsedItems);
	void __fastcall ProcessExpressionKeywords(Mathitem::TMItems* ParsedItems);
	void __fastcall RewireReferences(void);
	Mathitem::TMValue* __fastcall RPN(Mathitem::TMItems* &ParsedItems);
	
public:
	Mathitem::TMSymbols* FSymbols;
	Cardinal CurrentFunctionNesting;
	virtual void __fastcall DoUnknownSymbol(const System::AnsiString Identifier, const System::Variant 
		&Parameters, System::Variant &Value);
	__fastcall virtual TMathInterpreter(Classes::TComponent* AOwner);
	__fastcall virtual ~TMathInterpreter(void);
	void __fastcall DebugParseExpression(const System::AnsiString Text, Classes::TStrings* Output);
	System::Variant __fastcall Execute(const System::AnsiString Text, Classes::TStrings* Errors);
	System::Variant __fastcall ExecuteExpression(const System::AnsiString Text);
	System::AnsiString __fastcall Dump(const System::AnsiString Delimiter, const Mathitem::TDumpFormat 
		DumpFormat);
	System::AnsiString __fastcall DumpStreamable();
	System::AnsiString __fastcall DumpSymbol(const System::AnsiString SymbolName, const Mathitem::TDumpFormat 
		DumpFormat);
	int __fastcall PrepareExpression(const System::AnsiString Text);
	System::Variant __fastcall ExecutePreparedExpression(const int PreparedExpressionHandle);
	void __fastcall FreePreparedExpression(const int PreparedExpressionHandle);
	void __fastcall ClearPreparedExpressions(void);
	bool __fastcall IsValidPreparedExpression(const int PreparedExpressionHandle);
	bool __fastcall SymbolExists(const System::AnsiString Identifier);
	void __fastcall ClearSymbols(void);
	int __fastcall SymbolCount(void);
	bool __fastcall IsEqualString(const System::AnsiString S1, const System::AnsiString S2);
	System::Variant __fastcall ExecuteFromStream(Classes::TStream* Stream, Classes::TStrings* Errors);
	virtual void __fastcall LoadSymbolsFromStream(Classes::TStream* Stream);
	virtual void __fastcall SaveSymbolsToStream(Classes::TStream* Stream);
	System::Variant __fastcall ExecuteFromFile(const System::AnsiString FileName, Classes::TStrings* Errors
		);
	virtual void __fastcall LoadSymbolsFromFile(const System::AnsiString FileName);
	virtual void __fastcall SaveSymbolsToFile(const System::AnsiString FileName);
	__property System::Variant Variables[System::AnsiString VarName] = {read=GetVariables, write=SetVariables
		};
	__property int VariableHandles[System::AnsiString VarName] = {read=GetVariableHandles};
	__property System::Variant VariablesByHandle[int VarHandle] = {read=GetVariablesByHandle, write=SetVariablesByHandle
		};
	
__published:
	__property bool CaseSensitiveSymbols = {read=FCaseSensitiveSymbols, write=SetCaseSensitiveSymbols, 
		nodefault};
	__property Mathitem::TDumpFormat DumpFormat = {read=FDumpFormat, write=FDumpFormat, nodefault};
	__property System::AnsiString DumpText = {read=GetDumpText, write=SetDumpText, stored=false};
	__property char EscapeChar = {read=FEscapeChar, write=FEscapeChar, nodefault};
	__property System::AnsiString Expression = {read=FExpression, write=SetExpression, stored=false};
	__property System::AnsiString ExpressionResult = {read=GetExpressionResult, write=SetExpressionResult
		, stored=false};
	__property Cardinal MaxFunctionNesting = {read=FMaxFunctionNesting, write=FMaxFunctionNesting, nodefault
		};
	__property TUnknownSymbolEvent OnUnknownSymbol = {read=FOnUnknownSymbol, write=FOnUnknownSymbol};
};

//-- var, const, procedure ---------------------------------------------------
extern PACKAGE void __fastcall Register(void);

}	/* namespace Mathinterpreter */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Mathinterpreter;
#endif
//-- end unit ----------------------------------------------------------------
#endif	// MathInterpreter
