// Borland C++ Builder
// Copyright (c) 1995, 1998 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'MathControls.pas' rev: 3.00

#ifndef MathControlsHPP
#define MathControlsHPP
#include <ComCtrls.hpp>
#include <MathInterpreter.hpp>
#include <StdCtrls.hpp>
#include <Dialogs.hpp>
#include <Forms.hpp>
#include <Controls.hpp>
#include <Graphics.hpp>
#include <Classes.hpp>
#include <SysUtils.hpp>
#include <Messages.hpp>
#include <Windows.hpp>
#include <SysInit.hpp>
#include <System.hpp>

//-- user supplied -----------------------------------------------------------

namespace Mathcontrols
{
//-- type declarations -------------------------------------------------------
enum TMathErrorOption { meoRaiseExceptions, meoWriteExceptionMessage };

typedef Set<TMathErrorOption, meoRaiseExceptions, meoWriteExceptionMessage>  TMathErrorOptions;

enum TMathEditOption { meoSelfUpdate, meoExecuteOnReturn };

typedef Set<TMathEditOption, meoSelfUpdate, meoExecuteOnReturn>  TMathEditOptions;

typedef void __fastcall (__closure *TAfterExecuteExpressionEvent)(System::TObject* Sender, const System::Variant 
	&Res);

class DELPHICLASS TMathEdit;
class PASCALIMPLEMENTATION TMathEdit : public Stdctrls::TEdit 
{
	typedef Stdctrls::TEdit inherited;
	
private:
	Mathinterpreter::TMathInterpreter* FMathInterpreter;
	TMathEditOptions FMathEditOptions;
	TAfterExecuteExpressionEvent FAfterExecuteExpression;
	TMathErrorOptions FMathErrorOptions;
	void __fastcall SetMathInterpreter(const Mathinterpreter::TMathInterpreter* Value);
	
protected:
	DYNAMIC void __fastcall KeyDown(Word &Key, Classes::TShiftState Shift);
	virtual void __fastcall DoAfterExecuteExpression(const System::Variant &Res);
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation Operation
		);
	
public:
	__fastcall virtual TMathEdit(Classes::TComponent* AOwner);
	System::Variant __fastcall ExecuteExpression();
	
__published:
	__property TMathEditOptions MathEditOptions = {read=FMathEditOptions, write=FMathEditOptions, nodefault
		};
	__property TMathErrorOptions MathErrorOptions = {read=FMathErrorOptions, write=FMathErrorOptions, nodefault
		};
	__property Mathinterpreter::TMathInterpreter* MathInterpreter = {read=FMathInterpreter, write=SetMathInterpreter
		};
	__property TAfterExecuteExpressionEvent AfterExecuteExpression = {read=FAfterExecuteExpression, write=
		FAfterExecuteExpression};
public:
	/* TWinControl.CreateParented */ __fastcall TMathEdit(HWND ParentWindow) : Stdctrls::TEdit(ParentWindow
		) { }
	/* TWinControl.Destroy */ __fastcall virtual ~TMathEdit(void) { }
	
};

enum TMathHistoryOption { mhoAllowDuplicates, mhoDeleteDuplicates, mhoPreventDuplicates };

class DELPHICLASS TMathComboBox;
class PASCALIMPLEMENTATION TMathComboBox : public Stdctrls::TComboBox 
{
	typedef Stdctrls::TComboBox inherited;
	
private:
	Mathinterpreter::TMathInterpreter* FMathInterpreter;
	TAfterExecuteExpressionEvent FAfterExecuteExpression;
	TMathEditOptions FMathEditOptions;
	TMathHistoryOption FMathHistoryOption;
	TMathErrorOptions FMathErrorOptions;
	void __fastcall SetMathInterpreter(const Mathinterpreter::TMathInterpreter* Value);
	
protected:
	DYNAMIC void __fastcall KeyDown(Word &Key, Classes::TShiftState Shift);
	virtual void __fastcall DoAfterExecuteExpression(const System::Variant &Res);
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation Operation
		);
	
public:
	__fastcall virtual TMathComboBox(Classes::TComponent* AOwner);
	System::Variant __fastcall ExecuteExpression();
	
__published:
	__property TMathEditOptions MathEditOptions = {read=FMathEditOptions, write=FMathEditOptions, nodefault
		};
	__property TMathErrorOptions MathErrorOptions = {read=FMathErrorOptions, write=FMathErrorOptions, nodefault
		};
	__property TMathHistoryOption MathHistoryOption = {read=FMathHistoryOption, write=FMathHistoryOption
		, nodefault};
	__property Mathinterpreter::TMathInterpreter* MathInterpreter = {read=FMathInterpreter, write=SetMathInterpreter
		};
	__property TAfterExecuteExpressionEvent AfterExecuteExpression = {read=FAfterExecuteExpression, write=
		FAfterExecuteExpression};
public:
	/* TCustomComboBox.Destroy */ __fastcall virtual ~TMathComboBox(void) { }
	
public:
	/* TWinControl.CreateParented */ __fastcall TMathComboBox(HWND ParentWindow) : Stdctrls::TComboBox(
		ParentWindow) { }
	
};

class DELPHICLASS TMathMemo;
class PASCALIMPLEMENTATION TMathMemo : public Stdctrls::TMemo 
{
	typedef Stdctrls::TMemo inherited;
	
private:
	TAfterExecuteExpressionEvent FAfterExecuteExpression;
	Mathinterpreter::TMathInterpreter* FMathInterpreter;
	TMathErrorOptions FMathErrorOptions;
	bool __fastcall SomethingAfterSelStart(void);
	int __fastcall SelLine(void);
	void __fastcall SetMathInterpreter(const Mathinterpreter::TMathInterpreter* Value);
	
protected:
	DYNAMIC void __fastcall KeyDown(Word &Key, Classes::TShiftState Shift);
	virtual void __fastcall DoAfterExecuteExpression(const System::Variant &Res);
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation Operation
		);
	
public:
	__fastcall virtual TMathMemo(Classes::TComponent* AOwner);
	System::Variant __fastcall ExecuteExpression();
	
__published:
	__property TMathErrorOptions MathErrorOptions = {read=FMathErrorOptions, write=FMathErrorOptions, nodefault
		};
	__property Mathinterpreter::TMathInterpreter* MathInterpreter = {read=FMathInterpreter, write=SetMathInterpreter
		};
	__property TAfterExecuteExpressionEvent AfterExecuteExpression = {read=FAfterExecuteExpression, write=
		FAfterExecuteExpression};
public:
	/* TCustomMemo.Destroy */ __fastcall virtual ~TMathMemo(void) { }
	
public:
	/* TWinControl.CreateParented */ __fastcall TMathMemo(HWND ParentWindow) : Stdctrls::TMemo(ParentWindow
		) { }
	
};

enum TMathRichEditOption { mroUseResultFont, mroUseErrorFont };

typedef Set<TMathRichEditOption, mroUseResultFont, mroUseErrorFont>  TMathRichEditOptions;

class DELPHICLASS TMathRichEdit;
class PASCALIMPLEMENTATION TMathRichEdit : public Comctrls::TRichEdit 
{
	typedef Comctrls::TRichEdit inherited;
	
private:
	TAfterExecuteExpressionEvent FAfterExecuteExpression;
	Graphics::TFont* FMathResultFont;
	Graphics::TFont* FMathErrorFont;
	Mathinterpreter::TMathInterpreter* FMathInterpreter;
	TMathRichEditOptions FMathRichEditOptions;
	TMathErrorOptions FMathErrorOptions;
	void __fastcall SetMathErrorFont(const Graphics::TFont* Value);
	void __fastcall SetMathInterpreter(const Mathinterpreter::TMathInterpreter* Value);
	void __fastcall SetMathResultFont(const Graphics::TFont* Value);
	int __fastcall SelLine(void);
	bool __fastcall SomethingAfterSelStart(void);
	
protected:
	DYNAMIC void __fastcall KeyDown(Word &Key, Classes::TShiftState Shift);
	virtual void __fastcall DoAfterExecuteExpression(const System::Variant &Res);
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation Operation
		);
	
public:
	__fastcall virtual TMathRichEdit(Classes::TComponent* AOwner);
	__fastcall virtual ~TMathRichEdit(void);
	System::Variant __fastcall ExecuteExpression();
	
__published:
	__property Graphics::TFont* MathErrorFont = {read=FMathErrorFont, write=SetMathErrorFont};
	__property TMathErrorOptions MathErrorOptions = {read=FMathErrorOptions, write=FMathErrorOptions, nodefault
		};
	__property Mathinterpreter::TMathInterpreter* MathInterpreter = {read=FMathInterpreter, write=SetMathInterpreter
		};
	__property Graphics::TFont* MathResultFont = {read=FMathResultFont, write=SetMathResultFont};
	__property TMathRichEditOptions MathRichEditOptions = {read=FMathRichEditOptions, write=FMathRichEditOptions
		, nodefault};
	__property TAfterExecuteExpressionEvent AfterExecuteExpression = {read=FAfterExecuteExpression, write=
		FAfterExecuteExpression};
public:
	/* TWinControl.CreateParented */ __fastcall TMathRichEdit(HWND ParentWindow) : Comctrls::TRichEdit(
		ParentWindow) { }
	
};

//-- var, const, procedure ---------------------------------------------------
extern PACKAGE void __fastcall Register(void);

}	/* namespace Mathcontrols */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Mathcontrols;
#endif
//-- end unit ----------------------------------------------------------------
#endif	// MathControls
