unit MainForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls, MathInterpreter;

type
  TfrmPrepare = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    Panel3: TPanel;
    PB: TPaintBox;
    tsSymbols: TTabSheet;
    Panel7: TPanel;
    Label3: TLabel;
    Label4: TLabel;
    edExecute: TEdit;
    edResult: TEdit;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    edStartX: TEdit;
    Label5: TLabel;
    edEndX: TEdit;
    Label2: TLabel;
    edF: TEdit;
    btnDrawGraph: TButton;
    Label9: TLabel;
    edSum: TEdit;
    Label10: TLabel;
    edTime: TEdit;
    TabSheet4: TTabSheet;
    Label11: TLabel;
    Memo1: TMemo;
    Panel1: TPanel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    memDump: TMemo;
    MI: TMathInterpreter;
    btnExecute: TButton;
    lblCalcCounter: TLabel;
    edScale: TEdit;
    Label17: TLabel;
    Label16: TLabel;
    Label18: TLabel;
    edResolution: TEdit;
    Label19: TLabel;
    chkOptimization: TCheckBox;
    Label6: TLabel;
    edSumExpression: TEdit;
    btnSum: TButton;
    Label7: TLabel;
    edStartA: TEdit;
    Label8: TLabel;
    edEndA: TEdit;
    btnClear: TButton;
    procedure btnDrawGraphClick(Sender: TObject);
    procedure btnSumClick(Sender: TObject);
    procedure btnExecuteClick(Sender: TObject);
    procedure PageControl1Change(Sender: TObject);
    procedure btnClearClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmPrepare: TfrmPrepare;

implementation

{$R *.DFM}

procedure TfrmPrepare.btnDrawGraphClick(Sender: TObject);

  procedure Swap(var a,b: real);
  var
    Tmp: real;
  begin
    Tmp := a;
    a := b;
    b := Tmp
  end;

  procedure Sort2(var a,b: real);
  begin
    if b < a then
      Swap(a,b)
  end;

  procedure PutPixel(const cx,cy: integer; const x,y,Scale: real);
  var
    xi,yi: integer;
  begin
    xi := Trunc(cx + x * Scale);
    yi := Trunc(cy - y * Scale);
    PB.Canvas.Pixels[xi,yi] := clBlack
  end;

var
  cx,cy: integer; // Pixel coordinates of the coordinate beginning.
  x,y,StartX,EndX,StartY,EndY,Scale,Resolution: real;
  VarHandle,ExpressionHandle: integer;
  CalcCounter: integer;
begin

  lblCalcCounter.Caption := 'working...';
  lblCalcCounter.Refresh;

  // First, we draw axes.

  cx := PB.Width div 2;
  cy := PB.Height div 2;
  PB.Canvas.MoveTo(0,cy); // Horizontal axis.
  PB.Canvas.LineTo(PB.Width,cy);
  PB.Canvas.MoveTo(cx,0); // Vartical axis.
  PB.Canvas.LineTo(cx,PB.Height);

  Scale := StrToFloat(edScale.Text); // 'Scale' is length of 1 in pixels.
  StartX := StrToFloat(edStartX.Text);
  EndX := StrToFloat(edEndX.Text);
  StartY := -(PB.Height / 2) / Scale;
  EndY := (PB.Height / 2) / Scale;
  Sort2(StartX,EndX);
  Sort2(StartY,EndY);

  // Then, we draw grid.

  x := Trunc(StartX);
  while x <= EndX do
  begin
    y := Trunc(StartY);
    while y <= EndY do
    begin
      PutPixel(cx,cy,x,y,Scale);
      y := y + 1
    end;
    x := x + 1;
  end;

  Resolution := StrToFloat(edResolution.Text);


  MI.ExecuteExpression('x=0');
  VarHandle := MI.VariableHandles['x'];
  x := StartX;
  CalcCounter := 0;

  if chkOptimization.Checked then
  begin
    ExpressionHandle := MI.PrepareExpression(edF.Text);
    try
      while x <= EndX do
      begin
        MI.VariablesByHandle[VarHandle] := x; // Same as "MI.Variables['x'] := i;" but faster.
        y := MI.ExecutePreparedExpression(ExpressionHandle);
        PutPixel(cx,cy,x,y,Scale);
        x := x + (1 / Scale) / Resolution;
        Inc(CalcCounter);
      end;
    finally
      MI.FreePreparedExpression(ExpressionHandle)
    end
  end
  else
    while x <= EndX do
    begin
      MI.VariablesByHandle[VarHandle] := x; // Same as "MI.Variables['x'] := i;" but faster.
      y := MI.ExecuteExpression(edF.Text);
      PutPixel(cx,cy,x,y,Scale);
      x := x + (1 / Scale) / Resolution;
      Inc(CalcCounter);
    end;

  lblCalcCounter.Caption := IntToStr(CalcCounter) + ' execution(s)'

end;

procedure TfrmPrepare.btnSumClick(Sender: TObject);
var
  a: integer;
  ExpressionHandle,VarHandle: integer;
  Sum: real;
  TimeStart, TimeLength: DWORD;
begin
  MI.ExecuteExpression('a=0');
  ExpressionHandle := MI.PrepareExpression(edSumExpression.Text);
  try
    VarHandle := MI.VariableHandles['a'];
    Sum := 0;
    TimeStart := GetTickCount;
    for a := StrToInt(edStartA.Text) to StrToInt(edEndA.Text) do
    begin
      MI.VariablesByHandle[VarHandle] := a;
      Sum := Sum + MI.ExecutePreparedExpression(ExpressionHandle)
    end;
    TimeLength := GetTickCount - TimeStart;
    edSum.Text := FloatToStr(Sum);
    edTime.Text := FloatToStr(TimeLength / 1000)
  finally
    MI.FreePreparedExpression(ExpressionHandle)
  end
end;

procedure TfrmPrepare.btnExecuteClick(Sender: TObject);
begin
  try
    edResult.Text := VarToStr(MI.ExecuteExpression(edExecute.Text));
  except
    edResult.Clear;
    raise
  end;
  memDump.Lines.Text := MI.DumpText
end;

procedure TfrmPrepare.PageControl1Change(Sender: TObject);
begin
  if (Sender as TPageControl).ActivePage = tsSymbols then
    memDump.Lines.Text := MI.DumpText
end;

procedure TfrmPrepare.btnClearClick(Sender: TObject);
begin
  PB.Invalidate
end;

end.
