unit MainForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  MathInterpreter, StdCtrls, ExtCtrls;

type
  TfrmMain = class(TForm)
    Memo1: TMemo;
    Panel1: TPanel;
    cmbExecute: TComboBox;
    btnExecute: TButton;
    Label1: TLabel;
    edResult: TEdit;
    GroupBox1: TGroupBox;
    memDump: TMemo;
    Label3: TLabel;
    Label2: TLabel;
    LabelA: TLabel;
    LabelB: TLabel;
    MI: TMathInterpreter;
    chkCase: TCheckBox;
    Label4: TLabel;
    procedure FormShow(Sender: TObject);
    procedure btnExecuteClick(Sender: TObject);
    procedure MIUnknownSymbol(Sender: TMathInterpreter;
      const Identifier: String; const Parameters: Variant;
      var Value: Variant);
    procedure chkCaseClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}

procedure TfrmMain.FormShow(Sender: TObject);
begin
  memDump.Lines.Text := MI.DumpText
end;

procedure TfrmMain.btnExecuteClick(Sender: TObject);
begin
  edResult.Text := VarToStr(MI.ExecuteExpression(cmbExecute.Text));
  memDump.Lines.Text := MI.DumpText
end;

// Handles variables a, b and function f.
procedure TfrmMain.MIUnknownSymbol(Sender: TMathInterpreter;
  const Identifier: String; const Parameters: Variant; var Value: Variant);
begin

  // Read from variables/functions.
  if VarIsEmpty(Value) then
  begin
    // We use IsEqualString instead of simple "=" in order to properly handle case sensitivity.
    if Sender.IsEqualString(Identifier,'a') then
      Value := StrToFloat(LabelA.Caption)
    else if Sender.IsEqualString(Identifier,'b') then
      Value := StrToFloat(LabelB.Caption)
    else if Sender.IsEqualString(Identifier,'f') then
    begin
      if VarArrayHighBound(Parameters,1) - VarArrayLowBound(Parameters,1) <> 0 then
        raise Exception.Create('TfrmMain.MIExternalSymbol() Wrong number of parameters for external symbol: "f".');
      // f(x) := 3*x+1
      Value := 3 * Parameters[VarArrayLowBound(Parameters,1)] + 1;
    end
  end

  // Write variables.
  else
  begin
    if Sender.IsEqualString(Identifier,'a') then
    begin
      LabelA.Caption := VarToStr(Value);
      VarClear(Value)
    end
    else if Sender.IsEqualString(Identifier,'b') then
    begin
      LabelB.Caption := VarToStr(Value);
      VarClear(Value)
    end
    // We can't write into function f, so it remains unhandled.
  end

end;

procedure TfrmMain.chkCaseClick(Sender: TObject);
begin
  MI.CaseSensitiveSymbols := (Sender as TCheckBox).Checked;
  memDump.Lines.Text := MI.DumpText
end;

end.
