unit MainForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  MathInterpreter, StdCtrls, ExtCtrls;

type
  TfrmMain = class(TForm)
    MI: TMathInterpreter;
    Panel1: TPanel;
    Label1: TLabel;
    btnExecute: TButton;
    cmbExpression: TComboBox;
    Label2: TLabel;
    edResult: TEdit;
    btnLoad: TButton;
    btnSave: TButton;
    GroupBox1: TGroupBox;
    memSymbols: TMemo;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    Bevel1: TBevel;
    procedure btnExecuteClick(Sender: TObject);
    procedure btnLoadClick(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}

procedure TfrmMain.btnExecuteClick(Sender: TObject);
begin
  edResult.Text := VarToStr(MI.ExecuteExpression(cmbExpression.Text));
  memSymbols.Lines.Text := MI.DumpText
end;

procedure TfrmMain.btnLoadClick(Sender: TObject);
begin
  if OpenDialog1.Execute then
  begin
    MI.LoadSymbolsFromFile(OpenDialog1.FileName);
    memSymbols.Lines.Text := MI.DumpText
  end
end;

procedure TfrmMain.btnSaveClick(Sender: TObject);
begin
  if SaveDialog1.Execute then
    MI.SaveSymbolsToFile(SaveDialog1.FileName);
end;



end.
