unit fileoperator;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, FileCtrl, AHMTFileOperator, AHMSystem;

type
  TFileOperatorForm = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    AHMFileOperator1: TAHMFileOperator;
    FileListBox1: TFileListBox;
    DriveComboBox1: TDriveComboBox;
    DirectoryListBox1: TDirectoryListBox;
    DriveComboBox2: TDriveComboBox;
    DirectoryListBox2: TDirectoryListBox;
    FileListBox2: TFileListBox;
    Button5: TButton;
    Label1: TLabel;
    procedure Button5Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure AHMFileOperator1FailCopy(Sender: TObject);
    procedure AHMFileOperator1FailDelete(Sender: TObject);
    procedure AHMFileOperator1FailMove(Sender: TObject);
    procedure AHMFileOperator1FailRename(Sender: TObject);
    procedure AHMFileOperator1SuccessCopy(Sender: TObject);
    procedure AHMFileOperator1SuccessDelete(Sender: TObject);
    procedure AHMFileOperator1SuccessMove(Sender: TObject);
    procedure AHMFileOperator1SuccessRename(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FileOperatorForm: TFileOperatorForm;

implementation

uses Unit1;

{$R *.DFM}














procedure TFileOperatorForm.Button5Click(Sender: TObject);
begin
  close;
end;

procedure TFileOperatorForm.Button1Click(Sender: TObject);
begin
  AHMFileOperator1.FilesFrom.Clear;
  if FileListbox2.FileName<>'' then
  begin
    AHMFileOperator1.FilesFrom.Add(ExtractFilename(FileListbox2.FileName));
    AHMFileOperator1.DirFrom:=DirectoryListbox2.Directory;
    AHMFileOperator1.DirTo:=DirectoryListbox1.Directory;
    AHMFileOperator1.Operation:=CopyFile;
    AHMFileOperator1.Execute;
  end else showmessage('Please select a file');
  FileListbox1.Update;
  FileListbox2.Update;
end;

procedure TFileOperatorForm.Button2Click(Sender: TObject);
begin
  AHMFileOperator1.FilesFrom.Clear;
  if FileListbox2.FileName<>'' then
  begin
    AHMFileOperator1.FilesFrom.Add(ExtractFilename(FileListbox2.FileName));
    AHMFileOperator1.DirFrom:=DirectoryListbox2.Directory;
    AHMFileOperator1.DirTo:=DirectoryListbox1.Directory;
    AHMFileOperator1.Operation:=DeleteFile;
    AHMFileOperator1.Execute;
  end else showmessage('Please select a file');
  FileListbox1.Update;
  FileListbox2.Update;
end;

procedure TFileOperatorForm.Button3Click(Sender: TObject);
begin
  AHMFileOperator1.FilesFrom.Clear;
  if FileListbox2.FileName<>'' then
  begin
    AHMFileOperator1.FilesFrom.Add(ExtractFilename(FileListbox2.FileName));
    AHMFileOperator1.DirFrom:=DirectoryListbox2.Directory;
    AHMFileOperator1.DirTo:=DirectoryListbox1.Directory;
    AHMFileOperator1.Operation:=MoveFile;
    AHMFileOperator1.Execute;
  end else showmessage('Please select a file');
  FileListbox1.Update;
  FileListbox2.Update;
end;

procedure TFileOperatorForm.Button4Click(Sender: TObject);
var Newname : string;
begin
  AHMFileOperator1.FilesFrom.Clear;
  if FileListbox2.FileName<>'' then
  begin
    AHMFileOperator1.FilesFrom.Add(ExtractFilename(FileListbox2.FileName));
    AHMFileOperator1.DirFrom:=DirectoryListbox2.Directory;
    Newname:=FileListbox2.FileName;
    Inputquery('New Filename','New Filename',Newname);
    AHMFileOperator1.DirTo:=NewName;
    AHMFileOperator1.Operation:=RenameFile;
    Form1.Refresh;
    AHMFileOperator1.Execute;
  end else showmessage('Please select a file');
  FileListbox1.Update;
  FileListbox2.Update;
end;

procedure TFileOperatorForm.CheckBox1Click(Sender: TObject);
begin
//
end;

procedure TFileOperatorForm.AHMFileOperator1FailCopy(Sender: TObject);
begin
  Showmessage('Event OnFailCopy would fire here')
end;

procedure TFileOperatorForm.AHMFileOperator1FailDelete(Sender: TObject);
begin
  Showmessage('Event OnFailDelete would fire here')
end;

procedure TFileOperatorForm.AHMFileOperator1FailMove(Sender: TObject);
begin
  Showmessage('Event OnFailMove would fire here')
end;

procedure TFileOperatorForm.AHMFileOperator1FailRename(Sender: TObject);
begin
  Showmessage('Event OnFailRename would fire here')
end;

procedure TFileOperatorForm.AHMFileOperator1SuccessCopy(Sender: TObject);
begin
  Showmessage('Event OnSuccessCopy would fire here')
end;

procedure TFileOperatorForm.AHMFileOperator1SuccessDelete(Sender: TObject);
begin
  Showmessage('Event OnSuccessDelete would fire here')
end;

procedure TFileOperatorForm.AHMFileOperator1SuccessMove(Sender: TObject);
begin
  Showmessage('Event OnSuccessMove would fire here')
end;

procedure TFileOperatorForm.AHMFileOperator1SuccessRename(Sender: TObject);
begin
  Showmessage('Event OnSuccessRename would fire here')
end;

end.
