unit droppedfiles;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, AHMTDroppedFiles, ExtCtrls, AHMSystem, AHMTFormHook;

type
  TDroppedFilesForm = class(TForm)
    ListBox1: TListBox;
    RadioGroup1: TRadioGroup;
    AHMDroppedFiles1: TAHMDroppedFiles;
    Label1: TLabel;
    CheckBox1: TCheckBox;
    Label2: TLabel;
    procedure AHMDroppedFiles1StartDrop(Sender: TObject);
    procedure AHMDroppedFiles1EndDrop(Sender: TObject);
    procedure AHMDroppedFiles1Drop(Sender: TObject; DroppedItem: String);
    procedure RadioGroup1Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  DroppedFilesForm: TDroppedFilesForm;

implementation

{$R *.DFM}

procedure TDroppedFilesForm.AHMDroppedFiles1StartDrop(Sender: TObject);
begin
  Listbox1.Items.Clear;
end;

procedure TDroppedFilesForm.AHMDroppedFiles1EndDrop(Sender: TObject);
begin
  Listbox1.refresh;
end;

procedure TDroppedFilesForm.AHMDroppedFiles1Drop(Sender: TObject;
  DroppedItem: String);
begin
  ListBox1.Items.add(DroppedItem);
end;

procedure TDroppedFilesForm.RadioGroup1Click(Sender: TObject);
begin
 case Radiogroup1.ItemIndex of
   0 : AHMDroppedFiles1.CollectBy:=dFullPath;
   1 : AHMDroppedFiles1.CollectBy:=dFullname;
   2 : AHMDroppedFiles1.CollectBy:=dExtension;
 end;
end;

procedure TDroppedFilesForm.CheckBox1Click(Sender: TObject);
begin
  AHMDroppedFiles1.Active:=CheckBox1.Checked;
end;

end.
