unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls,Buttons,ShellApi, AHMTApplication, AHMTFormHook, AHMTFormSaver,
  Menus, AHMTSystemTray, AHMTIllegalAbort, AHMTLogFile, AHMTTrialRun,
  AHMTOnlyOne, AHMSystem, AHMTFormTopMost,
  ExitWin,FileExecute,StayOnTop,MsgDialogs,  OnlyOne,
  StdCtrls, ScreenSaver,Startup,TimeTrigger,Wallpaper,
  trialrun,waveplayer,cdtriggers,filecollector, LogFile,
  IllegalAbort,ExplForm,ResourceInfo,SystemKeys,MouseController,
  SystemTray, FormSaver,others,
  Fileproperties,DroppedFiles,FileOperator,FormSizes,ratio1,
  AHMTFileProperties, AHMTCDTriggers;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    ScrollBox1: TScrollBox;
    Panel2: TPanel;
    AHMTopMost1: TAHMTopMost;
    AHMOnlyOne1: TAHMOnlyOne;
    AHMTrialRun1: TAHMTrialRun;
    Panel3: TPanel;
    AHMLogFile1: TAHMLogFile;
    AHMIllegalAbort1: TAHMIllegalAbort;
    AHMSystemTray1: TAHMSystemTray;
    PopupMenu1: TPopupMenu;
    MinimizetheApplication1: TMenuItem;
    MaximizetheApplication1: TMenuItem;
    N1: TMenuItem;
    Quit1: TMenuItem;
    AHMFormSaver1: TAHMFormSaver;
    AHMApplication1: TAHMApplication;
    Image1: TImage;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    SpeedButton2: TSpeedButton;
    Label4: TLabel;
    SpeedButton3: TSpeedButton;
    Label5: TLabel;
    MainMenu1: TMainMenu;
    Exit1: TMenuItem;
    Label6: TLabel;
    AHMFileProperties1: TAHMFileProperties;
    SpeedButton1: TSpeedButton;
    AHMCDTriggers1: TAHMCDTriggers;
    procedure FormCreate(Sender: TObject);
    procedure ButtonPress(Sender:TObject);
    procedure AHMOnlyOne1Exceeded(Sender: TObject; NoOfInstances: Integer);
    procedure AHMTrialRun1Expired(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure AHMIllegalAbort1IllegalAbort(Sender: TObject);
    procedure MinimizetheApplication1Click(Sender: TObject);
    procedure MaximizetheApplication1Click(Sender: TObject);
    procedure Quit1Click(Sender: TObject);
    procedure AHMSystemTray1DblClick(Sender: TObject);
    procedure Image1Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure AHMCDTriggers1AfterInsert(Sender: TObject;
      FirstDriveLetter: Char);
    procedure AHMCDTriggers1AfterRemove(Sender: TObject;
      FirstDriveLetter: Char);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  CurrentForm : TForm=nil;
  SelectedTag : Integer;
implementation
{$I AHM.INC}
{$R *.DFM}
{$R ahmsystem.res}

Procedure ShowForm(FormC : TFormClass);
begin
  if CurrentForm<>nil then CurrentForm.Free;
  Currentform:=FormC.Create(Application);
  if FormC<>TDroppedFilesForm then
  begin
    CurrentForm.Parent:=Form1.Panel2;
    CurrentForm.BorderStyle:=bsNone;
    CurrentForm.BorderIcons:=[];
    CurrentForm.Align:=alClient;
  end;
  Form1.Panel3.Caption:=Currentform.Caption;
  CurrentForm.Show;
end;

procedure TForm1.FormCreate(Sender: TObject);
var I : Integer;
    Filename : String;
    CurrentButton : TSpeedButton;
procedure SetValue(var OnButton : TSpeedButton;Name : String);
begin
  OnButton.ShowHint:=True;
  OnButton.Hint:=Name;
  OnButton.Glyph.LoadFromResourceName(HInstance,Name);
end;
begin
  {$IFDEF AHMINPRISE3}
  SpeedButton1.flat:=true;
  {From Delphi 3 onward we have this property. Without it it kind of looks funny}
  {$ENDIF}
  Filename:=ExtractFilePath(Application.Exename)+'\AHM.Log';
  if pos('\\',Filename)>0 then delete(Filename,Pos('\\',Filename),1);
  AHMLogFile1.LogFile:=Filename;
  AHMLogFile1.Log('User Started the Application');
  for I:=1 to 38 do
  begin
    CurrentButton:=TSpeedButton.Create(Scrollbox1);
    with CurrentButton do
    begin
      Parent:=Scrollbox1;
      Top:=0;
      Left:=1+(I-1)*26+27;
      Tag:=I;
      width:=26;
      height:=26;
      {$IFDEF AHMINPRISE3}
      flat:=true; {$ENDIF}
      GroupIndex:=1;
      AllowAllUp:=True;
      OnClick:=ButtonPress;
      case I of
        1 : SetValue(CurrentButton,'TAHMExitWindows');
        2 : SetValue(CurrentButton,'TAHMFileExecute');
        3 : SetValue(CurrentButton,'TAHMTopMost');
        4 : SetValue(CurrentButton,'TAHMOnlyOne');
        5 : SetValue(CurrentButton,'TAHMMsgDlg');
        6 : SetValue(CurrentButton,'TAHMMsgBox');
        7 : SetValue(CurrentButton,'TAHMMsgSelect');
        8 : SetValue(CurrentButton,'TAHMStartup');
        9 : SetValue(CurrentButton,'TAHMScreensaver');
       10 : SetValue(CurrentButton,'TAHMTimeTrigger');
       11 : SetValue(CurrentButton,'TAHMWallPaper');
       12 : SetValue(CurrentButton,'TAHMTrialRun');
       13 : SetValue(CurrentButton,'TAHMFormHook');
       14 : SetValue(CurrentButton,'TAHMMouseController');
       15 : SetValue(CurrentButton,'TAHMWavePlayer');
       16 : SetValue(CurrentButton,'TAHMCDTriggers');
       17 : SetValue(CurrentButton,'TAHMVersionDetails');
       18 : SetValue(CurrentButton,'TAHMMultiLists');
       19 : SetValue(CurrentButton,'TAHMSystemKeys');
       20 : SetValue(CurrentButton,'TAHMFormSizes');
       21 : SetValue(CurrentButton,'TAHMFormAspect');
       22 : SetValue(CurrentButton,'TAHMDriveVolume');
       23 : SetValue(CurrentButton,'TAHMApplication');
       24 : SetValue(CurrentButton,'TAHMStoreData');
       25 : SetValue(CurrentButton,'TAHMIllegalAbort');
       26 : SetValue(CurrentButton,'TAHMFormSaver');
       27 : SetValue(CurrentButton,'TAHMLogFile');
       28 : SetValue(CurrentButton,'TAHMTextReplace');
       29 : SetValue(CurrentButton,'TAHMSystemTray');
       30 : SetValue(CurrentButton,'TAHMFileProperties');
       31 : SetValue(CurrentButton,'TAHMFileOperator');
       32 : SetValue(CurrentButton,'TAHMDroppedFiles');
       33 : SetValue(CurrentButton,'TAHMSystemDetails');
       34 : SetValue(CurrentButton,'TAHMFileCollector');
       35 : SetValue(CurrentButton,'TAHMStringHolder');
       36 : SetValue(CurrentButton,'TAHMJokeHolder');
       37 : SetValue(CurrentButton,'TAHMFormExplode');
       38 : SetValue(CurrentButton,'TAHMResourceInfo');
      else
      end;
    end
  end;
end;


procedure TForm1.ButtonPress(Sender:TObject);
begin
  (Sender as TSpeedButton).Down:=True;
  AHMLogFile1.Log('User viewed Information about the '+(Sender as TSpeedbutton).Hint+' Component');
  SelectedTag:=(Sender as TSpeedButton).Tag;
  case (Sender as TSpeedButton).Tag of
    1 : ShowForm(TExitWinForm);
    2 : ShowForm(TFileExecuteForm);
    3 : ShowForm(TStayOnTopForm);
    4 : ShowForm(TOnlyOneForm);
    5 : ShowForm(TMsgDialogForm);
    6 : ShowForm(TMsgDialogForm);
    7 : ShowForm(TMsgDialogForm);
    8 : ShowForm(TStartupForm);
    9 : ShowForm(TScreenSaverForm);
    10 : ShowForm(TTimeTriggerForm);
    11 : ShowForm(TWallpaperForm);
    12 : ShowForm(TTrialrunForm);
    13: ShowForm(TOtherExForm);
    14 : ShowForm(TMouseControllerForm);
    15 : ShowForm(TWaveplayerForm);
    16 : ShowForm(TCDTriggerForm);
    17 : ShowForm(TResourceInfoForm);
    18 : ShowForm(TOtherExForm);
    19 : ShowForm(TSystemKeysForm);
    20 : ShowForm(TFormSizesForm);
    21 : ShowForm(TRatioForm2);
    22 : ShowForm(TResourceInfoForm);
    23 : ShowForm(TOtherExForm);
    24 : ShowForm(TOtherExForm);
    25 : ShowForm(TIllegalAbortForm);
    26 : ShowForm(TFormSaverForm);
    27 : ShowForm(TLogFileForm);
    28 : ShowForm(TOtherExForm);
    29 : ShowForm(TSystemTrayForm);
    30 : ShowForm(TFilePropertiesForm);
    31 : ShowForm(TFileOperatorForm);
    32 : ShowForm(TDroppedFilesForm);
    33 : ShowForm(TResourceInfoForm);
    34 : ShowForm(TFileCollectorForm);
    35 : ShowForm(TOtherExForm);
    36 : ShowForm(TTimeTriggerForm);
    37 : ShowForm(TFormExplodeForm);
    38 : ShowForm(TResourceInfoForm);
   else
    showmessage(inttostr((Sender as TSpeedButton).Tag));
  end;

end;

procedure TForm1.AHMOnlyOne1Exceeded(Sender: TObject;
  NoOfInstances: Integer);
begin
  showmessage('You have now exceeded the maximum amount of 2 Instances');
end;

procedure TForm1.AHMTrialRun1Expired(Sender: TObject);
begin
  showmessage('This application has expired to show the functionality of the TAHMTrialrun component');
  Halt(1);
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  AHMLogFile1.Log('User quit the Application');
end;

procedure TForm1.AHMIllegalAbort1IllegalAbort(Sender: TObject);
begin
  showmessage('This program was ilegally aborted the last time it was run'+#13+
              'or this is currently another instance that has been called.'+#13+
              'This message belongs to the TAHMIllegalAbort Component Example');
end;

procedure TForm1.MinimizetheApplication1Click(Sender: TObject);
begin
  Application.Minimize;
end;

procedure TForm1.MaximizetheApplication1Click(Sender: TObject);
begin
  Application.Restore;
end;

procedure TForm1.Quit1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.AHMSystemTray1DblClick(Sender: TObject);
begin
  Application.Restore;
  Application.BringToFront;
end;

procedure TForm1.Image1Click(Sender: TObject);
begin
  ShellExecute(0,'open',PChar('http://www.ahm.co.za'),nil,nil,SW_NORMAL);
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
 SpeedButton1.
 Down:=True;
 if CurrentForm<>nil then CurrentForm.close;
 Panel3.Caption:='Examples for the AHM System Components - Part of the AHM Triton Tools 98';
end;

procedure TForm1.SpeedButton3Click(Sender: TObject);
begin
  ShellExecute(0,'open',PChar('mailto:support@ahm.co.za'),nil,nil,SW_NORMAL);
end;

procedure TForm1.SpeedButton2Click(Sender: TObject);
begin
  ShellExecute(0,'open',PChar('http://www.ahm.co.za'),nil,nil,SW_NORMAL);
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.AHMCDTriggers1AfterInsert(Sender: TObject;
  FirstDriveLetter: Char);
begin
  MessageBeep(0);
  showmessage('You inserted a CD into Drive '+FirstDriveLetter);
end;

procedure TForm1.AHMCDTriggers1AfterRemove(Sender: TObject;
  FirstDriveLetter: Char);
begin
  Messagebeep(0);
  showmessage('You removed a CD from Drive '+FirstDriveLetter);
end;

end.
