unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Buttons, ComCtrls, AHMTMapiMail, AHMMails;

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    Edit2: TEdit;
    Memo1: TMemo;
    StatusBar1: TStatusBar;
    AHMMapiMail1: TAHMMapiMail;
    Label3: TLabel;
    Button1: TButton;
    Label1: TLabel;
    Label2: TLabel;
    ComboBox1: TComboBox;
    Label4: TLabel;
    Edit3: TEdit;
    Label5: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure AHMMapiMail1Error(Sender: TObject; Error: Integer;
      VMessage: String);
    procedure AHMMapiMail1LogonFailure(Sender: TObject; ErrorNo: Integer);
    procedure AHMMapiMail1LogoffFailure(Sender: TObject; ErrorNo: Integer);
    procedure AHMMapiMail1LogoffSuccess(Sender: TObject);
    procedure AHMMapiMail1LogonSuccess(Sender: TObject);
    procedure AHMMapiMail1BeforeLogon(Sender: TObject);
    procedure AHMMapiMail1BeforeLogoff(Sender: TObject);
    procedure AHMMapiMail1BeforeSendMail(Sender: TObject;
      Mail: TAHMMapiMessage);
    procedure ComboBox1Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  EFax : Boolean;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
var NewMessage : TAHMMapiMessage;
    I : Integer;
    Rec : String;
begin
  NewMessage:=TAHMMapiMessage.Create(AHMMapiMail1.Messages);
  NewMessage.Subject:=edit1.Text;
  NewMessage.Message.Text:=Memo1.Lines.Text;
  if EFax then
  begin
    NewMessage.FaxTo:=Edit3.text;
    NewMessage.FaxNumber:=Edit2.Text;
    NewMessage.SendMethod:=ccFax;
  end else NewMessage.SendMethod:=ccMail;
  Rec:=edit2.text;
  while Pos(',',rec)>0 do
  begin
    NewMessage.RecipientsTo.Add(Copy(Rec,1,pos(',',Rec)-1));
    Delete(Rec,1,Pos(',',rec));
  end;
  NewMessage.RecipientsTo.Add(Rec);
  try
    AHMMapiMail1.Execute;
  finally
    NewMessage.Free;
  end;
end;

procedure TForm1.AHMMapiMail1Error(Sender: TObject; Error: Integer;
  VMessage: String);
begin
 showmessage(VMessage);
end;

procedure TForm1.AHMMapiMail1LogonFailure(Sender: TObject;
  ErrorNo: Integer);
begin
  showmessage('Can not log onto the mailserver, error code '+Inttostr(ErrorNo));
end;

procedure TForm1.AHMMapiMail1LogoffFailure(Sender: TObject;
  ErrorNo: Integer);
begin
  showmessage('Can not logoff from the mailserver, error code '+Inttostr(ErrorNo));
end;

procedure TForm1.AHMMapiMail1LogoffSuccess(Sender: TObject);
begin
  Statusbar1.SimpleText:='Logoff and Send successfull';
end;

procedure TForm1.AHMMapiMail1LogonSuccess(Sender: TObject);
begin
   Statusbar1.SimpleText:='Logon successfull';
end;

procedure TForm1.AHMMapiMail1BeforeLogon(Sender: TObject);
begin
 Statusbar1.SimpleText:='Logging into mailserver';
end;

procedure TForm1.AHMMapiMail1BeforeLogoff(Sender: TObject);
begin
 Statusbar1.SimpleText:='Logging off';
end;

procedure TForm1.AHMMapiMail1BeforeSendMail(Sender: TObject;
  Mail: TAHMMapiMessage);
begin
  Statusbar1.SimpleText:='Sending Message : '+edit1.text;
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
  if Combobox1.Itemindex=0 then EFax:=False else EFax:=True;
  if EFax then
  begin
    Label2.Caption:='Fax Number';
    Edit2.Text:='000000000';
    Edit3.Visible:=True;
    Label5.Visible:=True;
    Statusbar1.SimpleText:='Ready to send Fax via Mapi';
  end else
  begin
    Label2.Caption:='To E-Mail Address';
    Edit2.Text:='To@Mail.Com';
    Edit3.Visible:=False;
    Label5.Visible:=False;
    Statusbar1.SimpleText:='Ready to send e-mail via Mapi';
  end;
  if not(AHMMapiMail1.MapiAvail) then
  begin
    Button1.Enabled:=False;
    Statusbar1.Simpletext:='Mapi not Installed on this system';
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  combobox1.Itemindex:=0;
  Combobox1Change(self);
end;

end.
