{********************************************************************
TADVGRIDPRINTSETTINGSDIALOG component & property editor
for Delphi 2.0, 3.0, 4.0, 5.0 & C++Builder 1.0, 3.0, 4.0
version 1.0

written by    Christopher Sansone, ScholarSoft
              Web : http://www.meteortech.com/ScholarSoft/
enhanced by : TMS Software
              copyright  1998-1999
              Email : info@tmssoftware.com
              Web : http://www.tmssoftware.com
{********************************************************************}
unit asgprnr;

interface

uses
 asgprint,advgrid,classes,dsgnintf,forms;

type
  TAdvGridPrintSettingsEditor = class(TComponentEditor)
  public
   function GetVerb(index:integer):string; override;
   function GetVerbCount:integer; override;
   procedure ExecuteVerb(Index:integer); override;
  end;

  TPrintSettingsProperty =class(TClassProperty)
  public
   function GetAttributes:TPropertyAttributes; override;
   procedure Edit; override;
  end;


procedure Register;

implementation

procedure Register;
begin
 RegisterComponents('TMS', [TAdvGridPrintSettingsDialog]);
 RegisterComponentEditor(TAdvGridPrintSettingsDialog,TAdvGridPrintSettingsEditor);
 RegisterPropertyEditor(TypeInfo(TPrintSettings),TAdvStringGrid,'PrintSettings',TPrintSettingsProperty);
end;


procedure TAdvGridPrintSettingsEditor.ExecuteVerb(Index: integer);
begin
 (component as TAdvGridPrintSettingsDialog).Execute;
end;

function TAdvGridPrintSettingsEditor.GetVerb(index: integer): string;
begin
 result:='&Execute';
end;

function TAdvGridPrintSettingsEditor.GetVerbCount: integer;
begin
 result:=1;
end;

{ TPrintSettingsProperty }

procedure TPrintSettingsProperty.Edit;
var
 grid:tadvstringgrid;
 settings:TAdvGridPrintSettingsDialog;
begin
 grid:=tadvstringgrid(getcomponent(0));
 settings:=TAdvGridPrintSettingsDialog.Create(Application);
 settings.Grid :=grid;
 settings.Options:=[psBorders,psGeneral,psFonts,psDateTime,psTitle,psPages,psMargins,psSpacing,psOrientation];
 if settings.execute then modified;
 settings.free;
end;

function TPrintSettingsProperty.GetAttributes: TPropertyAttributes;
begin
 result:=[paDialog];
end;


end.




