unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, AdCalc, Menus, ExtCtrls, ComCtrls, TeEngine, Series, TeeProcs,
  Chart, Math, Grids, DBGrids, DBCtrls, DB, DBTables;

const
  ArgumentVar: string = 'x';

  Memo2Handle   = 0;
  Memo1Handle   = 1;
  Edit1Handle   = 2;
  Edit2Handle   = 3;
  Edit3Handle   = 4;
  MessageHandle = 5;

type
  TMainForm = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    Label1: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Memo1: TMemo;
    Memo2: TMemo;
    Panel1: TPanel;
    Label4: TLabel;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    ListBox1: TListBox;
    Panel2: TPanel;
    Label5: TLabel;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    ListBox2: TListBox;
    Chart1: TChart;
    Series1: TFastLineSeries;
    Panel3: TPanel;
    Label2: TLabel;
    Label3: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    ComboBox1: TComboBox;
    Button10: TButton;
    Edit3: TEdit;
    Label10: TLabel;
    CheckBox1: TCheckBox;
    Label11: TLabel;
    Label12: TLabel;
    ComboBox2: TComboBox;
    Label14: TLabel;
    Button9: TButton;
    Button13: TButton;
    AdCalc1: TAdCalc;
    Label13: TLabel;
    TabSheet3: TTabSheet;
    DBGrid1: TDBGrid;
    Panel4: TPanel;
    Table1: TTable;
    DataSource1: TDataSource;
    DBNavigator1: TDBNavigator;
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure ListBox1DblClick(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure ListBox2DblClick(Sender: TObject);
    procedure AdCalc1FunctError(Sender: TObject; FunctName: String;
      ErrorLine, ErrorPosition, ErrorPlace, ErrorCode: Integer;
      ErrorStr: String);
    procedure AdCalc1Error(Sender: TObject; ErrorLine, ErrorPosition,
      ErrorPlace, ErrorCode: Integer; ErrorStr: String; Handle: integer);
    procedure Button10Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure AdCalc1VarList(Sender: TObject; VarName: String;
      VarType: TExprType; Value: Pointer; Description, UserText: String);
    procedure ListBox1Click(Sender: TObject);
    procedure ListBox2Click(Sender: TObject);
    procedure ListBox2Enter(Sender: TObject);
    procedure ListBox1Enter(Sender: TObject);
    procedure ComboBox2Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure AdCalc1GetDateTimeVar(Sender: TObject; VarName: String;
      var Found: Boolean; var Value: TDateTime; Handle: Integer);
    procedure Button13Click(Sender: TObject);
    procedure AdCalc1FunctList(Sender: TObject; FunctName: String;
      Active: Boolean; FunctType: TExprType; Formula: String;
      Params: array of TExprType; Description, UserText: String);
  private
    { Private declarations }
    procedure RefreshVarList;
    procedure RefreshFunctList;
    procedure ApplyFunction;
    function GetVarName:string;
    procedure MakeChart;
    procedure RefreshLib;
    procedure RefreshCombo;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

uses AddF, AddV;

{$R *.DFM}

procedure TMainForm.RefreshVarList;
var
  i:integer;
begin
  ComboBox1.Items.Clear;
  i:=ListBox2.ItemIndex;
  ListBox2.Items.Clear;
  AdCalc1.GetVarList(false);
  Button10.Enabled := ComboBox1.Text <> '';
  if i>ListBox2.Items.Count-1 then
    ListBox2.ItemIndex:=ListBox2.Items.Count-1
  else ListBox2.ItemIndex:=i;
  ListBox2Click(AdCalc1);
end;

procedure TMainForm.RefreshFunctList;
var
  i:integer;
begin
  i:=ListBox1.ItemIndex;
  ListBox1.Items.Clear;
  AdCalc1.GetFunctList;
  if i>ListBox1.Items.Count-1 then
    ListBox1.ItemIndex:=ListBox1.Items.Count-1
  else ListBox1.ItemIndex:=i;
  ListBox1Click(AdCalc1);
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  PageControl1.ActivePage:=TabSheet1;
  ActiveControl:=Memo1;
  RefreshCombo;
end;

procedure TMainForm.ApplyFunction;
var
  FP:array of TExprType;
  i:integer;
begin
  with AddFunct do begin
    SetLength(FP,ListBox1.Items.Count);
    with ListBox1 do for i:=0 to Items.Count-1 do begin
      if Items[i]=ComboBox2.Items[0] then FP[i]:=etInteger;
      if Items[i]=ComboBox2.Items[1] then FP[i]:=etExtended;
      if Items[i]=ComboBox2.Items[2] then FP[i]:=etBoolean;
      if Items[i]=ComboBox2.Items[3] then FP[i]:=etString;
      if Items[i]=ComboBox2.Items[4] then FP[i]:=etDateTime;
    end;
    case ComboBox1.ItemIndex of
      0:MainForm.AdCalc1.RegFunction(Edit1.Text, true, etInteger,
        FP,Memo1.Text,Edit2.Text, '');
      1:MainForm.AdCalc1.RegFunction(Edit1.Text, true, etExtended,
        FP,Memo1.Text,Edit2.Text, '');
      2:MainForm.AdCalc1.RegFunction (Edit1.Text, true, etBoolean,
        FP,Memo1.Text,Edit2.Text, '');
      3:MainForm.AdCalc1.RegFunction (Edit1.Text, true, etString,
        FP,Memo1.Text,Edit2.Text, '');
      4:MainForm.AdCalc1.RegFunction (Edit1.Text, true, etDateTime,
        FP,Memo1.Text,Edit2.Text, '');
    end;
    ClearFields;
    RefReshFunctList;
  end;
end;

procedure TMainForm.Button2Click(Sender: TObject);
begin
  with AddFunct do begin
    ClearFields;
    Caption:='Add function';
    Edit1.Enabled:=true;
    ShowModal;
    if ModalResult=mrOk then ApplyFunction;
  end;
end;

procedure TMainForm.Button3Click(Sender: TObject);
var
  FN, Formula, Description, UserText:string;
  Active: boolean;
  FT:TExprType;
  i: integer;
begin
  if (ListBox1.ItemIndex>-1)and(ListBox1.Items.Count>0) then begin
    FN:=ListBox1.Items[ListBox1.ItemIndex];
    if AdCalc1.GetFunctProperties(FN,Active,FT,Formula,Description,UserText) then
    with AddFunct do begin
      Caption:='Edit function';
      Edit1.Text:=FN;
      Edit1.Enabled:=false;
      Edit2.Text:=Description;
      case FT of
        etInteger  : ComboBox1.ItemIndex:=0;
        etExtended : ComboBox1.ItemIndex:=1;
        etBoolean  : ComboBox1.ItemIndex:=2;
        etString   : ComboBox1.ItemIndex:=3;
        etDateTime : ComboBox1.ItemIndex:=4;
      end;
      Memo1.Text:=Formula;
      ListBox1.Clear;
      for i:=0 to High(AdCalc1.FParams) do
        case AdCalc1.FParams[i] of
          etInteger  : ListBox1.Items.Add(ComboBox2.Items[0]);
          etExtended : ListBox1.Items.Add(ComboBox2.Items[1]);
          etBoolean  : ListBox1.Items.Add(ComboBox2.Items[2]);
          etString   : ListBox1.Items.Add(ComboBox2.Items[3]);
          etDateTime : ListBox1.Items.Add(ComboBox2.Items[4]);
        end;
      ShowModal;
      if ModalResult=mrOk then ApplyFunction;
    end;
  end;
end;

procedure TMainForm.ListBox1DblClick(Sender: TObject);
begin
  Button3Click(Sender);
end;

procedure TMainForm.Button4Click(Sender: TObject);
var
  i:integer;
begin
  with ListBox1 do if (ItemIndex>-1)and
    (ListBox1.Items.Count>0) then with AdCalc1 do begin
    if MessageDlg('Are you sure to delete function "'+
      ListBox1.Items[ListBox1.ItemIndex] + '"',
      mtConfirmation, [mbYes, mbNo], 0) = mrYes then begin
      RemoveFunct(Items[ItemIndex]);
      i:=ListBox1.ItemIndex;
      RefReshFunctList;
      RefReshVarList;
      if i>ListBox1.Items.Count-1 then
        ListBox1.ItemIndex:=ListBox1.Items.Count-1
      else ListBox1.ItemIndex:=i;
    end;
  end;
end;

function TMainForm.GetVarName:string;
var
  i:integer;
begin
  Result:='';
  with ListBox2 do if (ItemIndex>-1)and
    (Items.Count>0) then begin
    i:=1;
    while (Items[ItemIndex][i]<>#32)and
          (i<=Length(Items[ItemIndex])) do begin
      Result:=Result+Items[ItemIndex][i];
      inc(i);
    end;
  end;
end;

procedure TMainForm.Button5Click(Sender: TObject);
var
  IV: integer;
  EV: extended;
  BV: boolean;
  SV, Formula: string;
  DV: TDateTime;
begin
  with AddVar do begin
    Caption:='Add variable';
    Label4.Visible:=false;
    Label5.Visible:=false;
    ClearFields;
    Edit1.Enabled:=true;
    ComboBox1.Enabled:=true;
    ActiveControl:=Edit1;
    ShowModal;
    if ModalResult=mrOk then begin
      Formula:=Edit3.Text;
      case ComboBox1.ItemIndex of
        0:begin
          AdCalc1.RegVariable(Edit1.Text,etInteger,Edit2.Text,'');
          if Edit3.Text<>'' then
            if AdCalc1.GetIntegerResult(Formula,IV,MessageHandle) then
              AdCalc1.SetIntegerVarValue(Edit1.Text,IV);
        end;
        1:begin
          AdCalc1.RegVariable(Edit1.Text,etExtended,Edit2.Text,'');
          if Edit3.Text<>'' then
            if AdCalc1.GetExtendedResult(Formula,EV,MessageHandle) then
              AdCalc1.SetExtendedVarValue(Edit1.Text,EV);
        end;
        2:begin
          AdCalc1.RegVariable(Edit1.Text,etBoolean,Edit2.Text,'');
          if Edit3.Text<>'' then
            if AdCalc1.GetBooleanResult(Formula,BV,MessageHandle) then
              AdCalc1.SetBooleanVarValue(Edit1.Text,BV);
        end;
        3:begin
          AdCalc1.RegVariable(Edit1.Text,etString,Edit2.Text,'');
          if Edit3.Text<>'' then
            if AdCalc1.GetStringResult(Formula,SV,MessageHandle) then
              AdCalc1.SetStringVarValue(Edit1.Text,SV);
        end;
        4:begin
          AdCalc1.RegVariable(Edit1.Text,etDateTime,Edit2.Text,'');
          if Edit3.Text<>'' then
            if AdCalc1.GetDateTimeResult(Formula,DV,MessageHandle) then
              AdCalc1.SetDateTimeVarValue(Edit1.Text,DV);
        end;
      end;
      RefReshVarList;
    end;
  end;
end;

procedure TMainForm.Button7Click(Sender: TObject);
var
  i:integer;
  VN:string;
begin
  VN:=GetVarName;
  if VN<>'' then with AdCalc1 do begin
    if MessageDlg('Are you sure to delete variable "'+VN+'"',
      mtConfirmation, [mbYes, mbNo], 0) = mrYes then begin
      RemoveVar(VN);
      i:=ListBox2.ItemIndex;
      RefReshVarList;
      if i>ListBox2.Items.Count-1 then
        ListBox2.ItemIndex:=ListBox2.Items.Count-1
      else ListBox2.ItemIndex:=i;
    end;
  end;
end;

procedure TMainForm.Button6Click(Sender: TObject);
const
  BoolWords: array[Boolean] of string = ('False', 'True');
var
  VN, Description, UserText: string;
  VT: TExprType;
  Value: pointer;
  IV: integer;
  EV: extended;
  BV: boolean;
  SV, Formula: string;
  DV: TDateTime;
begin
  VN:=GetVarName;
  if VN<>'' then begin
    if AdCalc1.GetVarProperties(VN,VT,Value,Description,UserText) then
    with AddVar do begin
      Caption:='Edit variable';
      Label4.Visible:=true;
      Label5.Visible:=true;
      ClearFields;
      Edit1.Enabled:=false;
      ComboBox1.Enabled:=false;
      Edit1.Text:=VN;
      Edit2.Text:=Description;
      case VT of
        etInteger:begin
          ComboBox1.ItemIndex:=0;
          Label5.Caption:=IntToStr(integer(Value^));
        end;
        etExtended:begin
          ComboBox1.ItemIndex:=1;
          Label5.Caption:=FloatToStr(extended(Value^));
        end;
        etBoolean :begin
          ComboBox1.ItemIndex:=2;
          Label5.Caption:=BoolWords[boolean(Value^)];
        end;
        etString :begin
          ComboBox1.ItemIndex:=3;
          Label5.Caption:='"'+string(Value^)+'"';
        end;
        etDateTime :begin
          ComboBox1.ItemIndex:=4;
          Label5.Caption:=DateTimeToStr(TDateTime(Value^));
        end;
      end;
      ShowModal;
      if (ModalResult=mrOk)and(Edit1.Text<>'') then begin
        Formula:=Edit3.Text;
        case VT of
          etInteger:begin
            AdCalc1.SetVarDescription(VN,Edit2.Text);
            if Edit3.Text<>'' then
              if AdCalc1.GetIntegerResult(Formula,IV,MessageHandle) then begin
                AdCalc1.SetIntegerVarValue(VN,IV);
                ClearFields;
              end;
          end;
          etExtended:begin
            AdCalc1.SetVarDescription(VN,Edit2.Text);
            if Edit3.Text<>'' then
              if AdCalc1.GetExtendedResult(Formula,EV,MessageHandle) then begin
                AdCalc1.SetExtendedVarValue(VN,EV);
                ClearFields;
              end;
          end;
          etBoolean :begin
            AdCalc1.SetVarDescription(VN,Edit2.Text);
            if Edit3.Text<>'' then
              if AdCalc1.GetBooleanResult(Formula,BV,MessageHandle) then begin
                AdCalc1.SetBooleanVarValue(VN,BV);
                ClearFields;
              end;
          end;
          etString :begin
            AdCalc1.SetVarDescription(VN,Edit2.Text);
            if Edit3.Text<>'' then
              if AdCalc1.GetStringResult(Formula,SV,MessageHandle) then begin
                AdCalc1.SetStringVarValue(VN,SV);
                ClearFields;
              end;
          end;
          etDateTime :begin
            AdCalc1.SetVarDescription(VN,Edit2.Text);
            if Edit3.Text<>'' then
              if AdCalc1.GetDateTimeResult(Formula,DV,MessageHandle) then begin
                AdCalc1.SetDateTimeVarValue(VN,DV);
                ClearFields;
              end;
          end;
        end;
        RefReshVarList;
      end;
    end;
  end;
end;

procedure TMainForm.ListBox2DblClick(Sender: TObject);
begin
  Button6Click(Sender);
end;

procedure TMainForm.AdCalc1FunctError(Sender: TObject; FunctName: String;
  ErrorLine, ErrorPosition, ErrorPlace, ErrorCode: Integer;
  ErrorStr: String);
begin
  ShowMessage('Function - "' + FunctName +
    '"; Line - '+IntToStr(ErrorLine)+
    '; Col - '+IntToStr(ErrorPosition)+'; '+ErrorStr);
end;

procedure TMainForm.AdCalc1Error(Sender: TObject; ErrorLine, ErrorPosition,
  ErrorPlace, ErrorCode: Integer; ErrorStr: String; Handle: integer);
begin
  case Handle of
    Memo2Handle:begin
      ActiveControl:=Memo2;
      Label1.Caption:='Error '+IntToStr(ErrorCode)+', Line '+
        IntToStr(ErrorLine)+', '+ErrorStr;
      Memo2.SelStart:=ErrorPlace;
      Memo2.SelLength:=0;
    end;
    Memo1Handle:begin
      ActiveControl:=Memo1;
      Label1.Caption:='Error '+IntToStr(ErrorCode)+', Line '+
        IntToStr(ErrorLine)+', '+ErrorStr;
      Memo1.SelStart:=ErrorPlace;
      Memo1.SelLength:=0;
    end;
    Edit1Handle:begin
      ActiveControl:=Edit1;
      Label1.Caption:=ErrorStr+'; Col - '+IntToStr(ErrorPlace);
      Edit1.SelStart:=ErrorPosition;
      Edit1.SelLength:=0;
    end;
    Edit2Handle:begin
      ActiveControl:=Edit2;
      Label1.Caption:=ErrorStr+'; Col - '+IntToStr(ErrorPlace);
      Edit2.SelStart:=ErrorPosition;
      Edit2.SelLength:=0;
    end;
    Edit3Handle:begin
      ActiveControl:=Edit3;
      Label1.Caption:=ErrorStr+'; Col - '+IntToStr(ErrorPlace);
      Edit3.SelStart:=ErrorPosition;
      Edit3.SelLength:=0;
    end;
    MessageHandle:begin
      ShowMessage(ErrorStr+'; Col - '+IntToStr(ErrorPosition));
    end;
  end;
end;

procedure TMainForm.MakeChart;
var
  X, FX, MinX, MaxX, DeltaX: extended;
begin
  if AdCalc1.GetBlockResult(Memo2.Text,Memo2Handle) then
    if AdCalc1.ConnectExtendedVar(ArgumentVar,X,pvAdCalc) then begin
      try
        if AdCalc1.GetExtendedResult(Edit1.Text,MinX,Edit1Handle) then
          if AdCalc1.GetExtendedResult(Edit2.Text,MaxX,Edit2Handle) then
            if AdCalc1.GetExtendedResult(Edit3.Text,DeltaX,Edit3Handle) then begin
              X:=MinX;
              Series1.Clear;
              AdCalc1.AddText(Memo1.Text, Memo1Handle);
              while X<=MaxX do begin
                if AdCalc1.ExecuteExtended(FX,Memo1Handle) then begin
                  Series1.Add(FX,FloatToStr(X),clRed);
                  X:=X+DeltaX;
                end
                else Exit;
              end;
              PageControl1.ActivePage:=TabSheet2;
            end;
      finally
        AdCalc1.ClearExpressions;
        if CheckBox1.Checked then
          AdCalc1.DisconnectVar(ArgumentVar,pvAdCalc)
        else AdCalc1.DisconnectVar(ArgumentVar,pvCode);
        RefReshVarList;
      end;
    end;
end;

procedure TMainForm.Button10Click(Sender: TObject);
begin
  Label1.Caption:='';
  MakeChart;
end;

procedure TMainForm.ComboBox1Change(Sender: TObject);
begin
  ArgumentVar:=ComboBox1.Text;
  Button10.Enabled := ComboBox1.Text <> '';
end;

procedure TMainForm.AdCalc1VarList(Sender: TObject; VarName: String;
  VarType: TExprType; Value: Pointer; Description, UserText: String);
const
  BoolWords: array[Boolean] of string = ('False', 'True');
var
  vs:string;
begin
  vs:='';
  case VarType of
    etInteger :if Value<>nil then vs:=IntToStr(integer(Value^));
    etExtended:begin
      if Value<>nil then vs:=FloatToStr(extended(Value^));
      ComboBox1.Items.Add(VarName);
      if ArgumentVar=AnsiLowerCase(VarName) then
        ComboBox1.ItemIndex:=ComboBox1.Items.Count-1;
    end;
    etBoolean  :if Value<>nil then vs:=BoolWords[boolean(Value^)];
    etString   :if Value<>nil then vs:='"'+string(Value^)+'"';
    etDateTime :if Value<>nil then vs:=DateTimeToStr(TDateTime(Value^));
  end;
  ListBox2.Items.Add(VarName + ' = ' + vs);
end;

procedure TMainForm.ListBox1Click(Sender: TObject);
var
  s:string;
begin
  with ListBox1 do if (ItemIndex>-1)and(Items.Count>0) then
    if AdCalc1.GetFunctDescription(Items[ItemIndex],s) then
      Label12.Caption:=s;
end;

procedure TMainForm.ListBox2Click(Sender: TObject);
var
  s,VN:string;
begin
  VN:=GetVarName;
  if AdCalc1.GetVarDescription(GetVarName,s) then
    Label12.Caption:=s;
end;

procedure TMainForm.ListBox2Enter(Sender: TObject);
begin
  Listbox1.ItemIndex:=-1;
end;

procedure TMainForm.ListBox1Enter(Sender: TObject);
begin
  Listbox2.ItemIndex:=-1;
end;

procedure TMainForm.RefreshLib;
begin
  Label12.Caption:='';
  Memo2.Lines.LoadFromFile(ComboBox2.Text+'.var');
  Memo1.Lines.LoadFromFile(ComboBox2.Text+'.exp');
  AdCalc1.LoadLibrary(ComboBox2.Text+'.lib');
  RefReshVarList;
  RefReshFunctList;
end;

procedure TMainForm.RefreshCombo;
var
  sr: TSearchRec;
  FileAttrs,i: Integer;
  FName,s:string;
begin
  i:=-1;
  s:=ComboBox2.Text;
  ComboBox2.Items.Clear;
  FileAttrs := faAnyFile;
  if FindFirst('*.exp',FileAttrs,sr)=0 then repeat
    FName:=copy(sr.Name,1,Length(sr.Name)-
      Length(ExtractFileExt(sr.Name)));
    ComboBox2.Items.Add(Fname);
    if FName=s then i:=ComboBox2.Items.Count-1;
  until FindNext(sr)<>0;
  FindClose(sr);
  If (ComboBox2.Items.Count>0)and(i=-1) then begin
    ComboBox2.ItemIndex:=0;
    RefreshLib;
  end
  else ComboBox2.ItemIndex:=i;
end;

procedure TMainForm.ComboBox2Click(Sender: TObject);
begin
  RefreshLib;
end;

procedure TMainForm.Button9Click(Sender: TObject);
const
  BoolWords: array[Boolean] of string = ('False', 'True');
var
  i: integer;
  e: extended;
  b: boolean;
  s: string;
  d: TDateTime;
  ExprType: TExprType;
begin
  Label1.Caption:='';
  if AdCalc1.GetBlockResult(Memo2.Text, Memo2Handle) then begin
    if AdCalc1.GetExprType(Memo1.Text, ExprType) then case ExprType of
      etInteger: begin
        if AdCalc1.GetIntegerResult(Memo1.Text, i, Memo1Handle) then begin
          Label1.Caption := 'Result = '+IntToStr(i);
          Memo1.SelectAll;
        end;
        Label13.Caption := 'Type - Integer';
      end;
      etExtended: begin
        if AdCalc1.GetExtendedResult(Memo1.Text, e, Memo1Handle) then begin
          Label1.Caption := 'Result = '+FloatToStr(e);
          Memo1.SelectAll;
        end;
        Label13.Caption := 'Type - Extended';
      end;
      etBoolean: begin
        if AdCalc1.GetBooleanResult(Memo1.Text, b, Memo1Handle) then begin
          Label1.Caption := 'Result = ' + BoolWords[b];
          Memo1.SelectAll;
        end;
        Label13.Caption := 'Type - Boolean';
      end;
      etString: begin
        if AdCalc1.GetStringResult(Memo1.Text, s, Memo1Handle) then begin
          Label1.Caption:= 'Result = "' + s + '"';
          Memo1.SelectAll;
        end;
        Label13.Caption := 'Type - String';
      end;
      etDateTime: begin
        if AdCalc1.GetDateTimeResult(Memo1.Text, d, Memo1Handle) then begin
          Label1.Caption := 'Result = ' + DateTimeToStr(d);
          Memo1.SelectAll;
        end;
        Label13.Caption := 'Type - DateTime';
      end;
    end
    else Label13.Caption := 'Can''t Recognize Type of Expression';
    RefReshVarList;
  end;
end;

procedure TMainForm.AdCalc1GetDateTimeVar(Sender: TObject; VarName: String;
  var Found: Boolean; var Value: TDateTime; Handle: Integer);
begin
  if AnsiLowerCase(VarName) = LowerCase('Now') then begin
    Found:=true;
    Value:=Now;
  end;
end;

procedure TMainForm.Button13Click(Sender: TObject);
var
  InitPath: string;
begin
  InitPath := ExtractFilePath(ParamStr(0));
  Memo2.Lines.SaveToFile(InitPath + ComboBox2.Text+'.var');
  Memo1.Lines.SaveToFile(InitPath + ComboBox2.Text+'.exp');
  AdCalc1.SaveLibrary(InitPath + ComboBox2.Text+'.lib');
  RefreshCombo;
end;

procedure TMainForm.AdCalc1FunctList(Sender: TObject; FunctName: String;
  Active: Boolean; FunctType: TExprType; Formula: String;
  Params: array of TExprType; Description, UserText: String);
begin
  ListBox1.Items.Add(FunctName);
end;

end.
