unit AdCMsg;

interface
uses Dialogs;

type
  TExpectionError = (
    NoError,
    IntegerExpected,
    ExtendedExpected,
    BooleanExpected,
    StringExpected,
    DateTimeExpected,
    IntegerSignExpected,
    ArithmSignExpected,
    LogSignExpected,
    PlusExpected,
    CompSignExpected,
    LeftParenthExpected,
    RightParenthExpected,
    CommaExpected,
    DivizionByZero,
    OutOfRange,
    VarExpected,
    EqualExpected,
    EndSignExpected,
    FullStopExpected,
    ThenExpected,
    ElseExpected,
    InvalidInt,
    InvalidFloat,
    InvalidDate,
    InvalidTime,
    InvalidDateTime,
    StringSignExpected);

  TExpectionErrors=array[TExpectionError] of record
    Code: integer;
    Descr: string;
  end;

const
  ExpectionErrors: TExpectionErrors=(
    (Code: 0; Descr: ''),                                                  {NoError}
    (Code: 1; Descr: 'Integer type value expected'),                       {IntegerExpected}
    (Code: 2; Descr: 'Integer, Extended or DateTime type value expected'), {ExtendedExpected}
    (Code: 3; Descr: 'Boolean type value expected'),                       {BooleanExpected}
    (Code: 4; Descr: 'String type value expected'),                        {StringExpected}
    (Code: 5; Descr: 'DateTime type value expected'),                      {DateTimeExpected}
    (Code: 6; Descr: '"+", "-", "*", "Div" or "Mod" expected'),            {IntegerSignExpected}
    (Code: 7; Descr: '"+", "-", "*", "/" or "^" expected'),                {ArithmSignExpected}
    (Code: 8; Descr: '"AND", "OR" or "XOR" expected'),                     {LogSignExpected}
    (Code: 9; Descr: '"+" expected'),                                      {PlusExpected}
    (Code: 10; Descr: 'Comparison sign expected'),                         {CompSignExpected}
    (Code: 11; Descr: '"(" expected'),                                     {LeftParenthExpected}
    (Code: 12; Descr: '")" expected'),                                     {RightParenthExpected}
    (Code: 13; Descr: '"," expected'),                                     {CommaExpected}
    (Code: 14; Descr: 'Division by zero'),                                 {DivizionByZero}
    (Code: 15; Descr: 'Number of parameter is out of range'),              {OutOfRange}
    (Code: 16; Descr: 'Variable name expected'),                           {VarExpected}
    (Code: 17; Descr: '"=" expected'),                                     {EqualExpected}
    (Code: 18; Descr: '";" or "." expected'),                              {EndSignExpected}
    (Code: 19; Descr: '"." expected'),                                     {FullStopExpected}
    (Code: 20; Descr: '"Then" expected'),                                  {ThenExpected}
    (Code: 21; Descr: '"Else" expected'),                                  {ElseExpected}
    (Code: 22; Descr: 'Invalid Integer'),                                  {InvalidInt}
    (Code: 23; Descr: 'Invalid Floating Point Number'),                    {InvalidFloat}
    (Code: 24; Descr: 'Invalid Date'),                                     {InvalidDate}
    (Code: 25; Descr: 'Invalid Time'),                                     {InvalidTime}
    (Code: 26; Descr: 'Invalid Date and Time'),                            {InvalidDateTime}
    (Code: 27; Descr: 'String sign expected'));                            {StringSignExpected}

  procedure ShowIdNameMissingMessage;
  procedure ShowResWordMessage(IdName:string);
  procedure ShowIncorrectIdNameMessage;

implementation

procedure ShowIdNameMissingMessage;
{This message is arisen, when a transmitted identifier of variable
 or function is empty}
begin
  MessageDlg('Identifier name missing', mtError, [mbOk], 0);
end;

procedure ShowResWordMessage(IdName:string);
{This message is arisen, when a transmitted identifier of variable
 or function is a reserved word
(param, and, or, true, false, div, mod, if, then, else)}
begin
  MessageDlg('"'+IdName+'" is a reserved word', mtError, [mbOk], 0);
end;

procedure ShowIncorrectIdNameMessage;
{This message is arisen, when a transmitted identifier of variable
 or function contains delimiters}
begin
  MessageDlg('Incorrect identifier name', mtError, [mbOk], 0);
end;

end.
