unit main;

//Small demo to show the functions of TDataExporter.

interface

uses
  Classes, Controls, Forms, StdCtrls, Db, DBTables, DataExporter;

type
  TfrmDemo = class(TForm)
    cbTables: TComboBox;
    btExport: TButton;
    lbFields: TListBox;
    Table1: TTable;
    Label1: TLabel;
    Label2: TLabel;
    DataExporter1: TDataExporter;
    procedure FormCreate(Sender: TObject);
    procedure cbTablesChange(Sender: TObject);
    procedure btExportClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmDemo: TfrmDemo;

implementation

{$R *.DFM}

procedure TfrmDemo.FormCreate(Sender: TObject);
begin
  //Get list of tables in DBDemos database
  Table1.Active := False;
  Session.GetTableNames('DBDEMOS', '*.db',False, False, cbTables.Items);
  cbTables.ItemIndex := 0;
  Table1.TableName := cbTables.Text;
  lbFields.Clear;
  Table1.GetFieldNames(lbFields.Items);
end;

procedure TfrmDemo.cbTablesChange(Sender: TObject);
begin
   //Get fields for selected table
   Table1.Active := False;
   Table1.TableName := cbTables.Text;
   lbFields.Clear;
   Table1.GetFieldNames(lbFields.Items);
   //This will get all fields regardless of type. Blob
   // fields are automatically filtered out during export.
end;

procedure TfrmDemo.btExportClick(Sender: TObject);
begin
  //Perform the export
  DataExporter1.Execute;
end;

end.
