unit LTMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Grids, DBGrids, Db, ASADbTables;

type
  TForm1 = class(TForm)
    ASADatabase1: TASADatabase;
    ASATable1: TASATable;
    ASAQuery1: TASAQuery;
    DataSource1: TDataSource;
    DataSource2: TDataSource;
    DBGrid1: TDBGrid;
    Label1: TLabel;
    Label2: TLabel;
    DBGrid2: TDBGrid;
    Label3: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    Button1: TButton;
    Button2: TButton;
    Label4: TLabel;
    Edit3: TEdit;
    Edit4: TEdit;
    Button3: TButton;
    Button4: TButton;
    btnConnect: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure btnConnectClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
var
  ID: integer;
begin
  ID := StrToInt(Edit1.Text);
  ASATable1.Locate('custno', ID ,[]);
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  FN: String;
begin
  FN := Edit2.Text;
  ASATable1.Locate('company', FN, []);
end;

procedure TForm1.Button3Click(Sender: TObject);
var
  ID: integer;
begin
  ID := StrToInt(Edit3.Text);
  ASAQuery1.Locate('custno', ID ,[]);
end;

procedure TForm1.Button4Click(Sender: TObject);
var
  FN: String;
begin
  FN := Edit4.Text;
  ASAQuery1.Locate('company', FN, []);
end;

procedure TForm1.btnConnectClick(Sender: TObject);
begin
  if btnConnect.Tag=0 then
  begin
    ASADatabase1.Open;
    ASATable1.Open;
    ASAQuery1.Open;
    btnConnect.Tag:=1;
    btnConnect.Caption:='Disconnect';
    Button1.Enabled := True;
    Button2.Enabled := True;
    Button3.Enabled := True;
    Button4.Enabled := True;
  end
  else
  begin
    ASADatabase1.Close;
    btnConnect.Tag:=0;
    btnConnect.Caption:='Connect';
    Button1.Enabled := False;
    Button2.Enabled := False;
    Button3.Enabled := False;
    Button4.Enabled := False;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  DBPath: string;
begin
  DBPath := ExtractFilePath(Application.ExeName);
  DBPath := ExtractFilePath(copy(DBPath,1,length(DBPath)-1)) + 'DB\DEMO.db';
  ASADataBase1.DataBaseFile := DBPath;
end;

end.
