// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'RBTimeView.pas' rev: 5.00

#ifndef RBTimeViewHPP
#define RBTimeViewHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <ImgList.hpp>	// Pascal unit
#include <Menus.hpp>	// Pascal unit
#include <StdCtrls.hpp>	// Pascal unit
#include <ExtCtrls.hpp>	// Pascal unit
#include <Dialogs.hpp>	// Pascal unit
#include <Forms.hpp>	// Pascal unit
#include <Controls.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Messages.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Rbtimeview
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS TRBTimeViewItem;
class DELPHICLASS TRBTimeViewItems;
class DELPHICLASS TRBTimeView;
class DELPHICLASS TRBTimeviewDay;
class PASCALIMPLEMENTATION TRBTimeviewDay : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	Classes::TList* Items;
	TRBTimeView* FParent;
	TDate FDate;
	int FLeft;
	int FWidth;
	bool FShowWorkingHours;
	TTime FBeginWork;
	TTime FEndWork;
	int FColumnCount;
	int TopSpaceItems;
	void __fastcall SetBeginWork(TTime Value);
	void __fastcall SetEndWork(TTime Value);
	void __fastcall SetShowWorkingHours(bool Value);
	TTime __fastcall GetItemsEnd(void);
	TTime __fastcall GetItemsStart(void);
	Windows::TRect __fastcall GetClientRect(void);
	TRBTimeViewItem* __fastcall GetItem(int Index);
	void __fastcall SetItem(int Index, const TRBTimeViewItem* Value);
	int __fastcall GetIndex(void);
	
protected:
	TRBTimeViewItem* DraggedItem;
	void __fastcall CalcItemsDisplay(void);
	int __fastcall FindFreeIndexForItem(TRBTimeViewItem* Item);
	Windows::TRect __fastcall GetItemsRect(void);
	void __fastcall DrawItem(TRBTimeViewItem* Item);
	void __fastcall PaintCaption(void);
	void __fastcall PaintTopSpace(void);
	void __fastcall PaintBottomSpace(void);
	void __fastcall PaintGap(void);
	void __fastcall PaintTimeLines(void);
	void __fastcall PaintTimeSelection(void);
	void __fastcall PaintItems(void);
	void __fastcall PaintAllDayItems(void);
	void __fastcall PaintSelectedItems(void);
	void __fastcall PaintWorkingHours(void);
	void __fastcall PaintDay(void);
	void __fastcall Paint(void);
	
public:
	__fastcall TRBTimeviewDay(TRBTimeView* AParent);
	__fastcall virtual ~TRBTimeviewDay(void);
	TRBTimeViewItem* __fastcall GetItemAt(int X, int Y);
	Windows::TRect __fastcall GetItemRect(TRBTimeViewItem* Item);
	void __fastcall Invalidate(void);
	__property TTime BeginWork = {read=FBeginWork, write=SetBeginWork};
	__property TTime EndWork = {read=FEndWork, write=SetEndWork};
	__property bool ShowWorkingHours = {read=FShowWorkingHours, write=SetShowWorkingHours, nodefault};
	__property TTime ItemsStart = {read=GetItemsStart};
	__property TTime ItemsEnd = {read=GetItemsEnd};
	__property int Index = {read=GetIndex, nodefault};
	__property Windows::TRect ClientRect = {read=GetClientRect};
	__property int ColumnCount = {read=FColumnCount, nodefault};
	__property TDate Date = {read=FDate};
	__property int Left = {read=FLeft, nodefault};
	__property int Width = {read=FWidth, nodefault};
	__property TRBTimeView* Parent = {read=FParent};
	__property TRBTimeViewItem* Item[int Index] = {read=GetItem, write=SetItem/*, default*/};
};


typedef void __fastcall (__closure *TRBTVDayChangedEvent)(System::TObject* Sender, TRBTimeviewDay* Day
	);

#pragma option push -b-
enum TRBTVDragMode { dmStartDrag, dmDragging, dmEndDrag };
#pragma option pop

typedef void __fastcall (__closure *TRBTVDayDragEvent)(System::TObject* Sender, TRBTimeviewDay* Day, 
	TRBTVDragMode Mode);

typedef void __fastcall (__closure *TRBTVSelectionChangedEvent)(System::TObject* Sender, System::TDateTime 
	StartTime, System::TDateTime EndTime);

typedef void __fastcall (__closure *TRBTVItemDragEvent)(System::TObject* Sender, TRBTimeViewItem* Item
	, TRBTVDragMode Mode);

typedef void __fastcall (__closure *TRBTVItemChangedEvent)(System::TObject* Sender, TRBTimeViewItem* 
	Item);

typedef void __fastcall (__closure *TRBTVItemNotifyEvent)(System::TObject* Sender, TRBTimeViewItem* 
	Item);

#pragma option push -b-
enum RBTimeView__5 { tvoTimeSelection, tvoMutipleDaySelection, tvoItemsSelection, tvoShowDaysGapCover, 
	tvoAutoTimeScaleAdjust, tvoSnapItemToItem, tvoSnapItemToWorkingHours, tvoItemsBelowMark, tvoItemsAboveMark 
	};
#pragma option pop

typedef Set<RBTimeView__5, tvoTimeSelection, tvoItemsAboveMark>  TRBTVOptions;

typedef void __fastcall (__closure *TRBTVSelectionHintEvent)(System::TObject* Sender, System::TDateTime 
	StartTime, System::TDateTime EndTime, AnsiString &Hint, int &HintWidth);

typedef void __fastcall (__closure *TRBTVDrawCaptionEvent)(System::TObject* Sender, Graphics::TCanvas* 
	Canvas, const Windows::TRect &Rect, TRBTimeviewDay* Day);

#pragma option push -b-
enum TRBTVRulerMarkMinutes { rmm5Minutes, rmm6Minutes, rmm10Minutes, rmm15Minutes, rmm30Minutes, rmm60Minutes 
	};
#pragma option pop

typedef void __fastcall (__closure *TRBTVDrawItemEvent)(System::TObject* Sender, Graphics::TCanvas* 
	Canvas, TRBTimeViewItem* Item, const Windows::TRect &Rect);

typedef void __fastcall (__closure *TRBTVItemDragHintEvent)(System::TObject* Sender, TRBTimeViewItem* 
	Item, System::TDateTime StartTime, System::TDateTime EndTime, AnsiString &Hint, int &HintWidth);

#pragma option push -b-
enum RBTimeView__8 { hoBeginWorkDrag, hoEndWorkDrag, hoSelection, hoAllDaySelection, hoItemStartDrag, 
	hoItemEndDrag };
#pragma option pop

typedef Set<RBTimeView__8, hoBeginWorkDrag, hoItemEndDrag>  TRBTVHintsOptions;

#pragma option push -b-
enum RBTimeView__7 { doBeginWork, doEndWork, doItemStart, doItemStartToOtherDay, doItemEnd, doItemEndToOtherDay, 
	doItem, doItemToOtherDay };
#pragma option pop

typedef Set<RBTimeView__7, doBeginWork, doItemToOtherDay>  TRBTVDragOptions;

#pragma option push -b-
enum RBTimeView__6 { cdoCaptions, cdoItems, cdoDays, cdoRuler, cdoTopSpace };
#pragma option pop

typedef Set<RBTimeView__6, cdoCaptions, cdoTopSpace>  TRBTVCustomDrawOptions;

typedef void __fastcall (__closure *TRBTVWorkingHoursDragHintEvent)(System::TObject* Sender, TTime StartWork
	, TTime EndWork, TRBTimeviewDay* Day, AnsiString &Hint, int &HintWidth);

typedef void __fastcall (__closure *TRBTVDrawRulerEvent)(System::TObject* Sender, Graphics::TCanvas* 
	Canvas, const Windows::TRect &Rect, int YOffset);

typedef void __fastcall (__closure *TRBTVDrawDayEvent)(System::TObject* Sender, Graphics::TCanvas* Canvas
	, TRBTimeviewDay* Day, const Windows::TRect &Rect, int YOffset);

typedef void __fastcall (__closure *TRBTVDrawTopSpaceEvent)(System::TObject* Sender, Graphics::TCanvas* 
	Canvas, TRBTimeviewDay* Day, const Windows::TRect &Rect);

typedef void __fastcall (__closure *TRBTVEditedItemEvent)(System::TObject* Sender, TRBTimeViewItem* 
	Item, AnsiString &NewText);

typedef void __fastcall (__closure *TRBTVEditingItemEvent)(System::TObject* Sender, TRBTimeViewItem* 
	Item, bool &CanEdit);

typedef void __fastcall (__closure *TRBTVCreateOnTypeEvent)(System::TObject* Sender, System::TDateTime 
	StartTime, System::TDateTime EndTime, bool AllDayItem, bool &AllowCreation);

typedef void __fastcall (__closure *TRBTVGetEditRectEvent)(System::TObject* Sender, TRBTimeviewDay* 
	Day, TRBTimeViewItem* Item, Windows::TRect &EditRect);

typedef void __fastcall (__closure *TRBTVItemToAllDayEvent)(System::TObject* Sender, TRBTimeViewItem* 
	Item, bool &CanDrag);

class PASCALIMPLEMENTATION TRBTimeView : public Controls::TCustomControl 
{
	typedef Controls::TCustomControl inherited;
	
private:
	bool NeedToEditItem;
	bool DraggingItem;
	Windows::TPoint DraggingStartPoint;
	TRBTimeviewDay* SelectedItemDay;
	Stdctrls::TCustomEdit* ItemEditor;
	TRBTimeViewItem* ItemBeingEdit;
	bool ScrollingDown;
	int ScrollTimer;
	int EditTimer;
	TRBTimeViewItems* FItems;
	Controls::THintWindow* HintWindow;
	int YOffset;
	System::TDateTime DragOffset;
	System::TDateTime OriginalDragStart;
	bool FirstDragEnter;
	TDate FDate;
	bool FShowRuler;
	int FRulerWidth;
	int FDaysCount;
	int FSelectResolution;
	Classes::TList* FDays;
	TRBTimeViewItem* FSelectedItem;
	TTime TempStartSelect;
	TDate TempAllDayStartSelect;
	int TopSpaceItems;
	TRBTimeViewItem* DraggedItem;
	int FRulerMarkHeight;
	int DayHeight;
	int FCaptionHeight;
	Forms::TFormBorderStyle FBorderStyle;
	TRBTVDayChangedEvent FOnChangeBeginWork;
	TRBTVDayChangedEvent FOnChangeEndWork;
	TRBTVDayDragEvent FOnDragBeginWork;
	TRBTVDayDragEvent FOnDragEndWork;
	TRBTVSelectionChangedEvent FOnSelectionChanged;
	TRBTVDayChangedEvent FOnNewDay;
	TRBTVItemDragEvent FOnDragItemStart;
	TRBTVItemDragEvent FOnDragItemEnd;
	TRBTVItemChangedEvent FOnItemClick;
	TRBTVItemChangedEvent FOnItemDblClick;
	TRBTVItemNotifyEvent FOnDeletion;
	TRBTimeviewDay* WorkingHoursDay;
	TRBTimeviewDay* OverDay;
	bool OverBeginWork;
	bool OverEndWork;
	bool DraggingBeginWork;
	bool DraggingEndWork;
	bool OverItemEnd;
	bool OverItemBody;
	bool OverItemStart;
	bool OverSelectArea;
	bool OverTopSpace;
	bool Selecting;
	bool AllDaySelecting;
	bool DraggingItemStart;
	bool DraggingItemEnd;
	bool DraggingItemBody;
	Graphics::TFont* FRulerFont;
	Imglist::TCustomImageList* FImages;
	Imglist::TChangeLink* FImagesChangeLink;
	System::TDateTime FSelectedTimeStart;
	System::TDateTime FSelectedTimeEnd;
	TRBTVOptions FOptions;
	bool FShowTimeLines;
	Graphics::TColor FTimeSelectionColor;
	TRBTVSelectionHintEvent FOnSelectionHint;
	TRBTVDrawCaptionEvent FOnDrawCaption;
	int FDaysGapWidth;
	Graphics::TColor FDaysGapColor;
	Graphics::TColor FTimeLinesColor;
	Graphics::TColor FRulerColor;
	Graphics::TColor FRulerMarksColor;
	TRBTVRulerMarkMinutes FRulerMarkMinutes;
	Graphics::TColor FDaysGapCoverColor;
	TRBTVDrawItemEvent FOnDrawItem;
	Graphics::TColor FItemSelectionColor;
	Graphics::TColor FWorkingHoursColor;
	int FItemDragResolution;
	Classes::TNotifyEvent FOnTimeScaleChanged;
	int FMinItemLength;
	int FItemsSnap;
	TRBTVItemDragHintEvent FOnItemEndDragHint;
	TRBTVItemDragHintEvent FOnItemStartDragHint;
	TRBTVHintsOptions FHintsOptions;
	TRBTVDragOptions FDragOptions;
	TRBTVCustomDrawOptions FCustomDrawOptions;
	TRBTVWorkingHoursDragHintEvent FOnEndWorkDragHint;
	TRBTVWorkingHoursDragHintEvent FOnBeginWorkDragHint;
	int FMinWorkingHours;
	TRBTVDrawRulerEvent FOnDrawRuler;
	TRBTVDrawDayEvent FOnDrawDay;
	Graphics::TBitmap* FItemsAboveMark;
	Graphics::TBitmap* FItemsBelowMark;
	int FTopSpace;
	int FBottomSpace;
	Graphics::TColor FTopSpaceColor;
	Graphics::TColor FBottomSpaceColor;
	int FPrivateImageIndex;
	int FReminderImageIndex;
	TDate FAllDaySelectedEnd;
	TDate FAllDaySelectedStart;
	TRBTVSelectionChangedEvent FOnAllDaySelectionChanged;
	TRBTVSelectionHintEvent FOnAllDaySelectionHint;
	TRBTVDrawTopSpaceEvent FOnDrawTopSpace;
	bool FReadOnly;
	bool FEditing;
	TRBTVEditedItemEvent FOnEditedItem;
	TRBTVEditingItemEvent FOnEditingItem;
	Graphics::TColor FAllDayItemSelectionColor;
	bool FSmoothScroll;
	Graphics::TColor FAllDaySelectionColor;
	bool FCreateOnType;
	TRBTVCreateOnTypeEvent FOnCreateOnType;
	TRBTVItemNotifyEvent FOnCreatedOnType;
	TRBTVGetEditRectEvent FOnGetEditRect;
	bool FCustomEditing;
	TRBTVItemDragEvent FOnDragItem;
	bool FShowTopSpace;
	AnsiString FShortCaptionFormat;
	AnsiString FLongCaptionFormat;
	AnsiString FMediumCaptionFormat;
	TRBTVItemToAllDayEvent FOnDragItemToAllDay;
	TRBTVItemToAllDayEvent FOnDragItemFromAllDay;
	void __fastcall SetDate(TDate Value);
	void __fastcall SetDaysCount(int Value);
	void __fastcall SetCaptionHeight(int Value);
	void __fastcall SetRulerMarkHeight(int Value);
	void __fastcall SetBorderStyle(Forms::TBorderStyle Value);
	void __fastcall SetShowRuler(bool Value);
	void __fastcall SetRulerWidth(int Value);
	void __fastcall SetDay(int Index, TRBTimeviewDay* Value);
	TRBTimeviewDay* __fastcall GetDay(int Index);
	int __fastcall GetVScrollPosition(void);
	void __fastcall SetSelectedItem(TRBTimeViewItem* Item);
	void __fastcall SetItems(const TRBTimeViewItems* Value);
	int __fastcall GetMarksMinutes(void);
	void __fastcall ActivateHint(int X, int Y, int Width, AnsiString S);
	void __fastcall HideHintWindow(void);
	void __fastcall KillEditTimer(void);
	void __fastcall SetRulerFont(const Graphics::TFont* Value);
	void __fastcall RulerFontChanged(System::TObject* Sender);
	void __fastcall SetImages(const Imglist::TCustomImageList* Value);
	void __fastcall ImagesChanged(System::TObject* Sender);
	void __fastcall SetSelectedTimeEnd(const System::TDateTime Value);
	void __fastcall SetSelectedTimeStart(const System::TDateTime Value);
	void __fastcall SetOptions(const TRBTVOptions Value);
	void __fastcall SetShowTimeLines(const bool Value);
	void __fastcall SetTimeSelectionColor(const Graphics::TColor Value);
	void __fastcall SetDaysGapColor(const Graphics::TColor Value);
	void __fastcall SetDaysGapWidth(const int Value);
	void __fastcall SetTimeLinesColor(const Graphics::TColor Value);
	void __fastcall SetSelectResolution(const int Value);
	void __fastcall SetRulerColor(const Graphics::TColor Value);
	void __fastcall SetRulerMarksColor(const Graphics::TColor Value);
	void __fastcall SetRulerMarkMinutes(const TRBTVRulerMarkMinutes Value);
	void __fastcall SetDaysGapCoverColor(const Graphics::TColor Value);
	void __fastcall SetItemSelectionColor(const Graphics::TColor Value);
	void __fastcall SetWorkingHoursColor(const Graphics::TColor Value);
	void __fastcall SetItemDragResolution(const int Value);
	void __fastcall SetMinItemLength(const int Value);
	void __fastcall SetItemsSnap(const int Value);
	void __fastcall SetHintsOptions(const TRBTVHintsOptions Value);
	void __fastcall SetCustomDrawOptions(const TRBTVCustomDrawOptions Value);
	void __fastcall SetMinWorkingHours(const int Value);
	void __fastcall SetItemsAboveMark(Graphics::TBitmap* Value);
	void __fastcall SetItemsBelowMark(Graphics::TBitmap* Value);
	void __fastcall SetBottomSpaceColor(const Graphics::TColor Value);
	void __fastcall SetTopSpaceColor(const Graphics::TColor Value);
	void __fastcall SetPrivateImageIndex(const int Value);
	void __fastcall SetReminderImageIndex(const int Value);
	void __fastcall SetAllDaySelectedEnd(const TDate Value);
	void __fastcall SetAllDaySelectedStart(const TDate Value);
	void __fastcall SetReadOnly(const bool Value);
	void __fastcall SetAllDayItemSelectionColor(const Graphics::TColor Value);
	void __fastcall SetSmoothScroll(const bool Value);
	void __fastcall SetAllDaySelectionColor(const Graphics::TColor Value);
	int __fastcall GetTopSpace(void);
	void __fastcall SetShowTopSpace(const bool Value);
	void __fastcall SetLongCaptionFormat(const AnsiString Value);
	void __fastcall SetMediumCaptionFormat(const AnsiString Value);
	void __fastcall SetShortCaptionFormat(const AnsiString Value);
	
protected:
	void __fastcall CalcDisplay(void);
	void __fastcall AllocDays(void);
	void __fastcall FreeDays(void);
	virtual bool __fastcall EditItem(TRBTimeViewItem* Item, TRBTimeviewDay* OnDay);
	virtual void __fastcall HideItemEditor(bool UpdateText);
	DYNAMIC void __fastcall MouseMove(Classes::TShiftState Shift, int X, int Y);
	DYNAMIC void __fastcall MouseDown(Controls::TMouseButton Button, Classes::TShiftState Shift, int X, 
		int Y);
	DYNAMIC void __fastcall MouseUp(Controls::TMouseButton Button, Classes::TShiftState Shift, int X, int 
		Y);
	DYNAMIC void __fastcall DragOver(System::TObject* Source, int X, int Y, Controls::TDragState State, 
		bool &Accept);
	virtual void __fastcall Delete(TRBTimeViewItem* Item);
	DYNAMIC void __fastcall DblClick(void);
	DYNAMIC void __fastcall DoStartDrag(Controls::TDragObject* &DragObject);
	void __fastcall HandleDraggingBeginWork(int X, int Y);
	void __fastcall HandleDraggingEndWork(int X, int Y);
	void __fastcall HandleDraggingItemStart(int X, int Y);
	void __fastcall HandleDraggingItemEnd(int X, int Y);
	void __fastcall HandleDraggingItemBody(int X, int Y);
	void __fastcall HandleSelecting(int X, int Y);
	void __fastcall HandleAllDaySelecting(int X, int Y);
	void __fastcall HandleAutoScrolling(int X, int Y);
	void __fastcall KillAutoScrolling(void);
	virtual void __fastcall Paint(void);
	DYNAMIC void __fastcall KeyPress(char &Key);
	void __fastcall DrawClock(Graphics::TCanvas* Canvas, const Windows::TRect &R, TTime T);
	void __fastcall PaintItemsMark(void);
	void __fastcall PaintRuler(void);
	void __fastcall SetTopSpace(int Value);
	void __fastcall SetBottomSpace(int Value);
	HIDESBASE MESSAGE void __fastcall WMSize(Messages::TWMSize &Message);
	MESSAGE void __fastcall WMTimer(Messages::TWMTimer &Message);
	virtual void __fastcall CreateParams(Controls::TCreateParams &Params);
	HIDESBASE MESSAGE void __fastcall CMCtl3DChanged(Messages::TMessage &Message);
	void __fastcall UpdateVScrollBar(void);
	HIDESBASE MESSAGE void __fastcall WMVScroll(Messages::TWMScroll &Message);
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation Operation
		);
	MESSAGE void __fastcall WMHideEditor(Messages::TMessage &Msg);
	DYNAMIC bool __fastcall CanEdit(TRBTimeViewItem* Item);
	__property int BottomSpace = {read=FBottomSpace, nodefault};
	__property Graphics::TColor BottomSpaceColor = {read=FBottomSpaceColor, write=SetBottomSpaceColor, 
		default=-2147483632};
	
public:
	__fastcall virtual TRBTimeView(Classes::TComponent* AOwner);
	__fastcall virtual ~TRBTimeView(void);
	virtual void __fastcall Invalidate(void);
	TRBTimeviewDay* __fastcall GetOverDay(int X, int Y);
	int __fastcall TimeToPos(TTime T, int Resolution);
	TTime __fastcall PosToTime(int Y, int Resolution, bool RoundTime);
	void __fastcall SetVScrollPosition(int Value);
	void __fastcall SetDateRange(TDate FromDateValue, int DaysCountValue);
	DYNAMIC void __fastcall DragDrop(System::TObject* Source, int X, int Y);
	void __fastcall SelectTime(System::TDateTime StartTime, System::TDateTime EndTime);
	void __fastcall SelectAllDay(TDate StartDay, TDate EndDay);
	void __fastcall ScrollInView(TRBTimeViewItem* Item, TRBTimeviewDay* Day);
	TRBTimeviewDay* __fastcall GetDayFromDate(TDate ADate);
	TRBTimeviewDay* __fastcall AddDate(TDate ADate);
	void __fastcall DeleteDate(TDate ADate);
	void __fastcall AddDatesRange(TDate FromDate, TDate ToDate);
	void __fastcall DeleteDatesRange(TDate FromDate, TDate ToDate);
	bool __fastcall DayExists(TDate ADate);
	bool __fastcall ItemExistOnDay(TDate ADate);
	bool __fastcall AllDayItemExistOnDay(TDate ADate);
	void __fastcall LoadFromFile(const AnsiString FileName);
	void __fastcall SaveToFile(const AnsiString FileName);
	void __fastcall LoadFromStream(Classes::TStream* Stream);
	void __fastcall SaveToStream(Classes::TStream* Stream);
	__property TRBTimeViewItem* SelectedItem = {read=FSelectedItem, write=SetSelectedItem};
	__property System::TDateTime SelectedTimeStart = {read=FSelectedTimeStart, write=SetSelectedTimeStart
		};
	__property System::TDateTime SelectedTimeEnd = {read=FSelectedTimeEnd, write=SetSelectedTimeEnd};
	__property TDate AllDaySelectedStart = {read=FAllDaySelectedStart, write=SetAllDaySelectedStart};
	__property TDate AllDaySelectedEnd = {read=FAllDaySelectedEnd, write=SetAllDaySelectedEnd};
	__property TRBTimeviewDay* Days[int Index] = {read=GetDay, write=SetDay};
	__property TRBTimeViewItems* Items = {read=FItems, write=SetItems};
	__property int TopSpace = {read=GetTopSpace, nodefault};
	__property bool Editing = {read=FEditing, nodefault};
	
__published:
	__property Graphics::TFont* RulerFont = {read=FRulerFont, write=SetRulerFont};
	__property Imglist::TCustomImageList* Images = {read=FImages, write=SetImages};
	__property int VScrollPosition = {read=GetVScrollPosition, write=SetVScrollPosition, nodefault};
	__property TRBTVOptions Options = {read=FOptions, write=SetOptions, nodefault};
	__property TRBTVHintsOptions HintsOptions = {read=FHintsOptions, write=SetHintsOptions, nodefault};
		
	__property TRBTVCustomDrawOptions CustomDrawOptions = {read=FCustomDrawOptions, write=SetCustomDrawOptions
		, nodefault};
	__property bool CustomEditing = {read=FCustomEditing, write=FCustomEditing, default=0};
	__property TRBTVDragOptions DragOptions = {read=FDragOptions, write=FDragOptions, nodefault};
	__property int RulerMarkHeight = {read=FRulerMarkHeight, write=SetRulerMarkHeight, default=20};
	__property Graphics::TColor DaysGapColor = {read=FDaysGapColor, write=SetDaysGapColor, default=16777215
		};
	__property Graphics::TColor DaysGapCoverColor = {read=FDaysGapCoverColor, write=SetDaysGapCoverColor
		, default=16711680};
	__property int DaysGapWidth = {read=FDaysGapWidth, write=SetDaysGapWidth, default=6};
	__property Graphics::TColor TimeLinesColor = {read=FTimeLinesColor, write=SetTimeLinesColor, default=-2147483632
		};
	__property int CaptionHeight = {read=FCaptionHeight, write=SetCaptionHeight, default=22};
	__property int DaysCount = {read=FDaysCount, write=SetDaysCount, default=1};
	__property bool ShowRuler = {read=FShowRuler, write=SetShowRuler, default=1};
	__property bool ShowTopSpace = {read=FShowTopSpace, write=SetShowTopSpace, default=1};
	__property bool ShowTimeLines = {read=FShowTimeLines, write=SetShowTimeLines, default=1};
	__property int RulerWidth = {read=FRulerWidth, write=SetRulerWidth, default=50};
	__property Graphics::TColor RulerColor = {read=FRulerColor, write=SetRulerColor, default=-2147483633
		};
	__property Graphics::TColor RulerMarksColor = {read=FRulerMarksColor, write=SetRulerMarksColor, default=-2147483632
		};
	__property TRBTVRulerMarkMinutes RulerMarkMinutes = {read=FRulerMarkMinutes, write=SetRulerMarkMinutes
		, default=4};
	__property TDate Date = {read=FDate, write=SetDate};
	__property int SelectResolution = {read=FSelectResolution, write=SetSelectResolution, default=30};
	__property int ItemDragResolution = {read=FItemDragResolution, write=SetItemDragResolution, default=30
		};
	__property Graphics::TColor ItemSelectionColor = {read=FItemSelectionColor, write=SetItemSelectionColor
		, default=16711680};
	__property Graphics::TColor TimeSelectionColor = {read=FTimeSelectionColor, write=SetTimeSelectionColor
		, default=-2147483635};
	__property Graphics::TColor AllDaySelectionColor = {read=FAllDaySelectionColor, write=SetAllDaySelectionColor
		, default=-2147483643};
	__property Graphics::TColor WorkingHoursColor = {read=FWorkingHoursColor, write=SetWorkingHoursColor
		, default=-2147483643};
	__property int ItemsSnap = {read=FItemsSnap, write=SetItemsSnap, default=15};
	__property int MinItemLength = {read=FMinItemLength, write=SetMinItemLength, default=30};
	__property int MinWorkingHours = {read=FMinWorkingHours, write=SetMinWorkingHours, default=30};
	__property Graphics::TBitmap* ItemsAboveMark = {read=FItemsAboveMark, write=SetItemsAboveMark};
	__property Graphics::TBitmap* ItemsBelowMark = {read=FItemsBelowMark, write=SetItemsBelowMark};
	__property Graphics::TColor TopSpaceColor = {read=FTopSpaceColor, write=SetTopSpaceColor, default=-2147483632
		};
	__property int PrivateImageIndex = {read=FPrivateImageIndex, write=SetPrivateImageIndex, default=-1
		};
	__property int ReminderImageIndex = {read=FReminderImageIndex, write=SetReminderImageIndex, default=-1
		};
	__property Forms::TBorderStyle BorderStyle = {read=FBorderStyle, write=SetBorderStyle, default=1};
	__property bool ReadOnly = {read=FReadOnly, write=SetReadOnly, nodefault};
	__property bool SmoothScroll = {read=FSmoothScroll, write=SetSmoothScroll, default=1};
	__property bool CreateOnType = {read=FCreateOnType, write=FCreateOnType, default=1};
	__property Graphics::TColor AllDayItemSelectionColor = {read=FAllDayItemSelectionColor, write=SetAllDayItemSelectionColor
		, default=-2147483643};
	__property AnsiString LongCaptionFormat = {read=FLongCaptionFormat, write=SetLongCaptionFormat};
	__property AnsiString MediumCaptionFormat = {read=FMediumCaptionFormat, write=SetMediumCaptionFormat
		};
	__property AnsiString ShortCaptionFormat = {read=FShortCaptionFormat, write=SetShortCaptionFormat};
		
	__property TRBTVDayChangedEvent OnChangeBeginWork = {read=FOnChangeBeginWork, write=FOnChangeBeginWork
		};
	__property TRBTVDayChangedEvent OnChangeEndWork = {read=FOnChangeEndWork, write=FOnChangeEndWork};
	__property TRBTVDayDragEvent OnDragBeginWork = {read=FOnDragBeginWork, write=FOnDragBeginWork};
	__property TRBTVDayDragEvent OnDragEndWork = {read=FOnDragEndWork, write=FOnDragEndWork};
	__property TRBTVSelectionChangedEvent OnSelectionChanged = {read=FOnSelectionChanged, write=FOnSelectionChanged
		};
	__property TRBTVSelectionChangedEvent OnAllDaySelectionChanged = {read=FOnAllDaySelectionChanged, write=
		FOnAllDaySelectionChanged};
	__property TRBTVDayChangedEvent OnNewDay = {read=FOnNewDay, write=FOnNewDay};
	__property TRBTVItemDragEvent OnDragItemStart = {read=FOnDragItemStart, write=FOnDragItemStart};
	__property TRBTVItemDragEvent OnDragItemEnd = {read=FOnDragItemEnd, write=FOnDragItemEnd};
	__property TRBTVItemDragEvent OnDragItem = {read=FOnDragItem, write=FOnDragItem};
	__property TRBTVItemChangedEvent OnItemClick = {read=FOnItemClick, write=FOnItemClick};
	__property TRBTVItemChangedEvent OnItemDblClick = {read=FOnItemDblClick, write=FOnItemDblClick};
	__property TRBTVItemNotifyEvent OnDeletion = {read=FOnDeletion, write=FOnDeletion};
	__property TRBTVSelectionHintEvent OnSelectionHint = {read=FOnSelectionHint, write=FOnSelectionHint
		};
	__property TRBTVSelectionHintEvent OnAllDaySelectionHint = {read=FOnAllDaySelectionHint, write=FOnAllDaySelectionHint
		};
	__property TRBTVItemDragHintEvent OnItemStartDragHint = {read=FOnItemStartDragHint, write=FOnItemStartDragHint
		};
	__property TRBTVItemDragHintEvent OnItemEndDragHint = {read=FOnItemEndDragHint, write=FOnItemEndDragHint
		};
	__property TRBTVWorkingHoursDragHintEvent OnBeginWorkDragHint = {read=FOnBeginWorkDragHint, write=FOnBeginWorkDragHint
		};
	__property TRBTVWorkingHoursDragHintEvent OnEndWorkDragHint = {read=FOnEndWorkDragHint, write=FOnEndWorkDragHint
		};
	__property TRBTVDrawCaptionEvent OnDrawCaption = {read=FOnDrawCaption, write=FOnDrawCaption};
	__property TRBTVDrawItemEvent OnDrawItem = {read=FOnDrawItem, write=FOnDrawItem};
	__property TRBTVDrawRulerEvent OnDrawRuler = {read=FOnDrawRuler, write=FOnDrawRuler};
	__property TRBTVDrawDayEvent OnDrawDay = {read=FOnDrawDay, write=FOnDrawDay};
	__property TRBTVDrawTopSpaceEvent OnDrawTopSpace = {read=FOnDrawTopSpace, write=FOnDrawTopSpace};
	__property Classes::TNotifyEvent OnTimeScaleChanged = {read=FOnTimeScaleChanged, write=FOnTimeScaleChanged
		};
	__property TRBTVEditingItemEvent OnEditingItem = {read=FOnEditingItem, write=FOnEditingItem};
	__property TRBTVEditedItemEvent OnEditedItem = {read=FOnEditedItem, write=FOnEditedItem};
	__property TRBTVCreateOnTypeEvent OnCreateOnType = {read=FOnCreateOnType, write=FOnCreateOnType};
	__property TRBTVItemNotifyEvent OnCreatedOnType = {read=FOnCreatedOnType, write=FOnCreatedOnType};
	__property TRBTVGetEditRectEvent OnGetEditRect = {read=FOnGetEditRect, write=FOnGetEditRect};
	__property TRBTVItemToAllDayEvent OnDragItemToAllDay = {read=FOnDragItemToAllDay, write=FOnDragItemToAllDay
		};
	__property TRBTVItemToAllDayEvent OnDragItemFromAllDay = {read=FOnDragItemFromAllDay, write=FOnDragItemFromAllDay
		};
	__property Align ;
	__property Anchors ;
	__property BiDiMode ;
	__property Color ;
	__property Constraints ;
	__property Ctl3D ;
	__property DockSite ;
	__property DragCursor ;
	__property DragKind ;
	__property DragMode ;
	__property Enabled ;
	__property ImeMode ;
	__property ImeName ;
	__property Font ;
	__property ParentColor ;
	__property ParentCtl3D ;
	__property ParentFont ;
	__property ParentShowHint ;
	__property ParentBiDiMode ;
	__property PopupMenu ;
	__property ShowHint ;
	__property TabOrder ;
	__property TabStop ;
	__property UseDockManager ;
	__property Visible ;
	__property OnCanResize ;
	__property OnClick ;
	__property OnConstrainedResize ;
	__property OnDblClick ;
	__property OnDockDrop ;
	__property OnDockOver ;
	__property OnDragDrop ;
	__property OnDragOver ;
	__property OnEndDock ;
	__property OnEndDrag ;
	__property OnEnter ;
	__property OnExit ;
	__property OnGetSiteInfo ;
	__property OnKeyDown ;
	__property OnKeyPress ;
	__property OnKeyUp ;
	__property OnMouseDown ;
	__property OnMouseMove ;
	__property OnMouseUp ;
	__property OnMouseWheel ;
	__property OnMouseWheelDown ;
	__property OnMouseWheelUp ;
	__property OnResize ;
	__property OnStartDock ;
	__property OnStartDrag ;
	__property OnUnDock ;
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TRBTimeView(HWND ParentWindow) : Controls::TCustomControl(
		ParentWindow) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TRBTimeViewItems : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	Classes::TList* FItems;
	TRBTimeView* FOwner;
	int FUpdateCount;
	TRBTimeViewItem* __fastcall GetItem(int Index);
	void __fastcall SetItem(int Index, TRBTimeViewItem* Value);
	int __fastcall GetCount(void);
	HWND __fastcall GetHandle(void);
	
protected:
	virtual void __fastcall DefineProperties(Classes::TFiler* Filer);
	void __fastcall ReadData(Classes::TStream* Stream);
	void __fastcall WriteData(Classes::TStream* Stream);
	void __fastcall ReattachToDays(void);
	
public:
	__fastcall TRBTimeViewItems(TRBTimeView* AOwner);
	__fastcall virtual ~TRBTimeViewItems(void);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	void __fastcall BeginUpdate(void);
	void __fastcall Clear(void);
	void __fastcall Delete(TRBTimeViewItem* Item);
	void __fastcall EndUpdate(void);
	TRBTimeViewItem* __fastcall Add(AnsiString Caption, System::TDateTime StartTime, System::TDateTime 
		EndTime, bool AllDay);
	TRBTimeViewItem* __fastcall AddObject(AnsiString Caption, System::TDateTime StartTime, System::TDateTime 
		EndTime, bool AllDay, void * Ptr);
	TRBTimeViewItem* __fastcall GetFirstItem(void);
	TRBTimeViewItem* __fastcall GetLastItem(void);
	__property int Count = {read=GetCount, nodefault};
	__property HWND Handle = {read=GetHandle, nodefault};
	__property TRBTimeViewItem* Item[int Index] = {read=GetItem, write=SetItem/*, default*/};
	__property TRBTimeView* Owner = {read=FOwner};
};


class PASCALIMPLEMENTATION TRBTimeViewItem : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	bool FInTimeView;
	TRBTimeViewItems* FOwner;
	Graphics::TColor FColor;
	AnsiString FCaption;
	System::TDateTime FStartTime;
	System::TDateTime FEndTime;
	int FImageIndex;
	void *FData;
	bool FDragged;
	int FColumn[35];
	int FAllDayIndex;
	bool FAllDay;
	Graphics::TColor FAllDayColor;
	bool FShowReminder;
	bool FPrivateItem;
	bool FCreatedOnType;
	AnsiString FHint;
	bool FShowHint;
	void __fastcall SetStartTime(System::TDateTime Value);
	void __fastcall SetEndTime(System::TDateTime Value);
	void __fastcall SetCaption(AnsiString Value);
	void __fastcall SetColor(Graphics::TColor Value);
	AnsiString __fastcall GetCaption(void);
	void __fastcall ReattachToDays(void);
	void __fastcall DeleteFromDays(void);
	TRBTimeView* __fastcall GetTimeView(void);
	void __fastcall SetData(const void * Value);
	System::TDateTime __fastcall GetDuration(void);
	void __fastcall SetDuration(const System::TDateTime Value);
	void __fastcall SetAllDay(const bool Value);
	void __fastcall SetAllDayColor(const Graphics::TColor Value);
	TRBTimeviewDay* __fastcall GetFirstAppearingDay(void);
	TRBTimeviewDay* __fastcall GetLastAppearingDay(void);
	void __fastcall SetPrivateItem(const bool Value);
	void __fastcall SetShowReminder(const bool Value);
	bool __fastcall GetPrivateImageExists(void);
	bool __fastcall GetReminderImageExists(void);
	bool __fastcall GetEdited(void);
	bool __fastcall GetSelected(void);
	bool __fastcall IsEqual(TRBTimeViewItem* Item);
	AnsiString __fastcall ReadString(Classes::TStream* Stream);
	void __fastcall WriteString(AnsiString S, Classes::TStream* Stream);
	
protected:
	void __fastcall WriteData(Classes::TStream* Stream);
	void __fastcall ReadData(Classes::TStream* Stream);
	
public:
	__fastcall TRBTimeViewItem(TRBTimeViewItems* AOwner);
	__fastcall virtual ~TRBTimeViewItem(void);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	void __fastcall Delete(void);
	bool __fastcall AppearsOnDay(TDate ADay);
	void __fastcall SetStartEnd(System::TDateTime AStartTime, System::TDateTime AEndTime);
	void __fastcall MoveTo(System::TDateTime ToTime);
	__property void * Data = {read=FData, write=SetData};
	__property TRBTimeViewItems* Owner = {read=FOwner};
	__property TRBTimeView* TimeView = {read=GetTimeView};
	__property System::TDateTime StartTime = {read=FStartTime, write=SetStartTime};
	__property System::TDateTime EndTime = {read=FEndTime, write=SetEndTime};
	__property System::TDateTime Duration = {read=GetDuration, write=SetDuration};
	__property int ImageIndex = {read=FImageIndex, write=FImageIndex, default=-1};
	__property AnsiString Caption = {read=GetCaption, write=SetCaption};
	__property Graphics::TColor Color = {read=FColor, write=SetColor, nodefault};
	__property Graphics::TColor AllDayColor = {read=FAllDayColor, write=SetAllDayColor, nodefault};
	__property bool AllDay = {read=FAllDay, write=SetAllDay, nodefault};
	__property TRBTimeviewDay* FirstAppearingDay = {read=GetFirstAppearingDay};
	__property TRBTimeviewDay* LastAppearingDay = {read=GetLastAppearingDay};
	__property bool PrivateItem = {read=FPrivateItem, write=SetPrivateItem, nodefault};
	__property bool ShowReminder = {read=FShowReminder, write=SetShowReminder, nodefault};
	__property bool PrivateImageExists = {read=GetPrivateImageExists, nodefault};
	__property bool ReminderImageExists = {read=GetReminderImageExists, nodefault};
	__property bool Edited = {read=GetEdited, nodefault};
	__property bool Selected = {read=GetSelected, nodefault};
	__property bool CreatedOnType = {read=FCreatedOnType, nodefault};
};


class DELPHICLASS TRBTimeViewItemDragObject;
class PASCALIMPLEMENTATION TRBTimeViewItemDragObject : public Controls::TDragObject 
{
	typedef Controls::TDragObject inherited;
	
public:
	TRBTimeViewItem* Item;
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TRBTimeViewItemDragObject(void) : Controls::TDragObject() { }
		
	#pragma option pop
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TRBTimeViewItemDragObject(void) { }
	#pragma option pop
	
};


//-- var, const, procedure ---------------------------------------------------
static const Shortint RBTV_MAX_DAYS = 0x23;
static const Word WM_HIDEEDITOR = 0x464;
static const Shortint RBTIMEVIEW_VERSION = 0x64;
extern PACKAGE void __fastcall Register(void);

}	/* namespace Rbtimeview */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Rbtimeview;
#endif
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// RBTimeView
