unit SetValueFormUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TSetValueForm = class(TForm)
    CloseButton: TButton;
    ValueScrollBar: TScrollBar;
    Label1: TLabel;
    ValueLabel: TLabel;
    procedure ValueScrollBarChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    PropID : integer;
    procedure SetValues ( PropID , CurrentValue , MinValue , MaxValue : integer );
  end;

var
  SetValueForm: TSetValueForm;

implementation

uses MainFormUnit;

{$R *.DFM}

procedure TSetValueForm.SetValues(PropID, CurrentValue, MinValue,
  MaxValue: integer);
begin
  ValueScrollBar.OnChange := nil;
  ValueScrollBar.OnChange := ValueScrollBarChange;
  Self.PropID := PropID;
  ValueScrollBar.SetParams ( CurrentValue , MinValue , MaxValue );
end;

procedure TSetValueForm.ValueScrollBarChange(Sender: TObject);
begin
  ValueLabel.Caption := IntToStr ( ValueScrollBar.Position );
  case PropID of

  1:  MainForm.RBTimeView.RulerWidth := ValueScrollBar.Position;
  2:  MainForm.RBTimeView.DaysGapWidth := ValueScrollBar.Position;
  3:  MainForm.RBTimeView.RulerMarkHeight := ValueScrollBar.Position;
  4 : MainForm.RBTimeView.CaptionHeight := ValueScrollBar.Position;
  end;
end;

end.
