//----------------------------------------------------------------------------//
//                                                                            //
//                                RBTimeView Demo                             //
//                                                                            //
//                         All Rights Reserved (c) 2000                       //
//                          Borshack Software Solutions                       //
//                                                                            //
//                           http://www.borshack.com                          //
//                                                                            //
//----------------------------------------------------------------------------//
// This code is distributed "as is" without any warranties,                   //
// expressed or implied.                                                      //
//                                                                            //
// The code, DCU, or Objects, in whole or in part, modified or unmodified,    //
// may not be redistributed for profit or as part of another commercial or    //
// shareware software package without the express written permission from     //
// Borshack Software Solutions.                                               //
//                                                                            //
// You may modify this code as you wish, but it will be impossible for us to  //
// support modifed versions, so in any doubt, please revert to the latest     //
// original version.                                                          //
//                                                                            //
// For more information please E-Mail: info@borshack.com                      //
// For support and bugs report, please E-Mail: support@borshack.com           //
//                                                                            //
//----------------------------------------------------------------------------//

unit MainFormUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  RBCalendar, ExtCtrls, RBTimeView, Menus, StdCtrls, ComCtrls, ActnList,
  ImgList, ToolWin;

type
  TMainForm = class(TForm)
    RBTimeView: TRBTimeView;
    CalendarPanel: TPanel;
    RBCalendar: TRBCalendar;
    MainMenu: TMainMenu;
    FileMenu: TMenuItem;
    ExitMI: TMenuItem;
    DeleteMI: TMenuItem;
    ViewMenu: TMenuItem;
    TimeScaleMI: TMenuItem;
    TS5MinutesMI: TMenuItem;
    TS6MinutesMI: TMenuItem;
    TS10MinutesMI: TMenuItem;
    TS20MinutesMI: TMenuItem;
    TS30MinutesMI: TMenuItem;
    TS60MinutesMI: TMenuItem;
    HintsMI: TMenuItem;
    StartItemHintMI: TMenuItem;
    DragItemEndHintMI: TMenuItem;
    TimeSelectionHintMI: TMenuItem;
    HorzSplitter: TSplitter;
    VertSplitter: TSplitter;
    TextPanel: TPanel;
    HelpMenu: TMenuItem;
    AboutMI: TMenuItem;
    DemoTextLabel: TLabel;
    N1: TMenuItem;
    TopSpaceMI: TMenuItem;
    RulerMI: TMenuItem;
    TimeLinesMI: TMenuItem;
    ColorsMenu: TMenuItem;
    RulerColorMI: TMenuItem;
    ColorDialog: TColorDialog;
    SelectionColorMI: TMenuItem;
    TimeLinesColorMI: TMenuItem;
    MainDisplayColorMI: TMenuItem;
    TopSpaceColorMI: TMenuItem;
    RulerMarksColorMI: TMenuItem;
    MainActionList: TActionList;
    ItemChangeColorAction: TAction;
    MainPopupMenu: TPopupMenu;
    ItemChangeColorPMI: TMenuItem;
    ItemsMenu: TMenuItem;
    ItemChangeColorMI: TMenuItem;
    ItemDeleteAction: TAction;
    N2: TMenuItem;
    ItemDeletePMI: TMenuItem;
    FontsMenu: TMenuItem;
    FontDialog: TFontDialog;
    MainDisplayFontMI: TMenuItem;
    RulerFontMI: TMenuItem;
    OptionsMenu: TMenuItem;
    SmoothScrollMI: TMenuItem;
    CustomDrawMI: TMenuItem;
    CustomDrawItemsMI: TMenuItem;
    ManiImageList: TImageList;
    ItemReminderAction: TAction;
    ItemPrivateAction: TAction;
    N3: TMenuItem;
    ItemPrivatePMI: TMenuItem;
    ItemReminderPMI: TMenuItem;
    N4: TMenuItem;
    LeftToRightMI: TMenuItem;
    RightToLeftMI: TMenuItem;
    MarkWorkingHoursAction: TAction;
    N5: TMenuItem;
    SetWorkingHoursPMI: TMenuItem;
    WorkinghoursColorMI: TMenuItem;
    DaysCaptionsCustomDrawMI: TMenuItem;
    HideWorkingHoursAction: TAction;
    HideWorkingHoursPMI: TMenuItem;
    SizesMI: TMenuItem;
    RulerWidthSizeMI: TMenuItem;
    DaysGapWidthMI: TMenuItem;
    RulerMarksHeightMI: TMenuItem;
    DaysCaptionsHeightMI: TMenuItem;
    ItemNewAction: TAction;
    N6: TMenuItem;
    ItemNewMI: TMenuItem;
    ItemNewPMI: TMenuItem;
    N7: TMenuItem;
    SetReminderMI: TMenuItem;
    ItemPrivateMI: TMenuItem;
    ToolBar1: TToolBar;
    NewToolButton: TToolButton;
    OpenToolButton: TToolButton;
    ToolButton1: TToolButton;
    SaveToolButton: TToolButton;
    ToolButton2: TToolButton;
    DeleteToolButton: TToolButton;
    FileOpenAction: TAction;
    FileSaveAction: TAction;
    ToolButton3: TToolButton;
    PrivateToolButton: TToolButton;
    ReminderToolButton: TToolButton;
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    N8: TMenuItem;
    FileOpenMI: TMenuItem;
    FileSaveMI: TMenuItem;
    ToolButton4: TToolButton;
    AboutToolButton: TToolButton;
    AboutAction: TAction;
    DaysCustomDrawMI: TMenuItem;
    BGImageList: TImageList;
    procedure RBCalendarSelectionChange(Sender: TObject);
    procedure ExitMIClick(Sender: TObject);
    procedure TimeScaleMinutesMIClick(Sender: TObject);
    procedure StartItemHintMIClick(Sender: TObject);
    procedure RBTimeViewItemStartDragHint(Sender: TObject;
      Item: TRBTimeViewItem; StartTime, EndTime: TDateTime;
      var Hint: String; var HintWidth: Integer);
    procedure RBTimeViewItemEndDragHint(Sender: TObject;
      Item: TRBTimeViewItem; StartTime, EndTime: TDateTime;
      var Hint: String; var HintWidth: Integer);
    procedure DragItemEndHintMIClick(Sender: TObject);
    procedure TimeSelectionHintMIClick(Sender: TObject);
    procedure RBTimeViewSelectionHint(Sender: TObject; StartTime,
      EndTime: TDateTime; var Hint: String; var HintWidth: Integer);
    procedure HorzSplitterCanResize(Sender: TObject; var NewSize: Integer;
      var Accept: Boolean);
    procedure VertSplitterCanResize(Sender: TObject; var NewSize: Integer;
      var Accept: Boolean);
    procedure TopSpaceMIClick(Sender: TObject);
    procedure RulerMIClick(Sender: TObject);
    procedure TimeLinesMIClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure RulerColorMIClick(Sender: TObject);
    procedure SelectionColorMIClick(Sender: TObject);
    procedure TimeLinesColorMIClick(Sender: TObject);
    procedure MainDisplayColorMIClick(Sender: TObject);
    procedure TopSpaceColorMIClick(Sender: TObject);
    procedure RulerMarksColorMIClick(Sender: TObject);
    procedure ItemChangeColorActionExecute(Sender: TObject);
    procedure ItemDeleteActionExecute(Sender: TObject);
    procedure ItemActionUpdate(Sender: TObject);
    procedure MainDisplayFontMIClick(Sender: TObject);
    procedure RulerFontMIClick(Sender: TObject);
    procedure SmoothScrollMIClick(Sender: TObject);
    procedure CustomDrawItemsMIClick(Sender: TObject);
    procedure RBTimeViewDrawItem(Sender: TObject; Canvas: TCanvas;
      Item: TRBTimeViewItem; Rect: TRect);
    procedure ItemReminderActionUpdate(Sender: TObject);
    procedure ItemPrivateActionUpdate(Sender: TObject);
    procedure ItemPrivateActionExecute(Sender: TObject);
    procedure ItemReminderActionExecute(Sender: TObject);
    procedure LeftToRightMIClick(Sender: TObject);
    procedure RightToLeftMIClick(Sender: TObject);
    procedure MarkWorkingHoursActionUpdate(Sender: TObject);
    procedure MarkWorkingHoursActionExecute(Sender: TObject);
    procedure WorkinghoursColorMIClick(Sender: TObject);
    procedure RBTimeViewDrawCaption(Sender: TObject; Canvas: TCanvas;
      Rect: TRect; Day: TRBTimeviewDay);
    procedure DaysCaptionsCustomDrawMIClick(Sender: TObject);
    procedure HideWorkingHoursActionExecute(Sender: TObject);
    procedure HideWorkingHoursActionUpdate(Sender: TObject);
    procedure RulerWidthSizeMIClick(Sender: TObject);
    procedure DaysGapWidthMIClick(Sender: TObject);
    procedure RulerMarksHeightMIClick(Sender: TObject);
    procedure DaysCaptionsHeightMIClick(Sender: TObject);
    procedure ItemNewActionUpdate(Sender: TObject);
    procedure ItemNewActionExecute(Sender: TObject);
    procedure RBCalendarMark(Sender: TObject; Day: TDate;
      var Mark: Boolean);
    procedure RBTimeViewCreatedOnType(Sender: TObject;
      Item: TRBTimeViewItem);
    procedure RBTimeViewDragItem(Sender: TObject; Item: TRBTimeViewItem;
      Mode: TRBTVDragMode);
    procedure AboutActionExecute(Sender: TObject);
    procedure DaysCustomDrawMIClick(Sender: TObject);
    procedure RBTimeViewDrawDay(Sender: TObject; Canvas: TCanvas;
      Day: TRBTimeviewDay; Rect: TRect; YOffset: Integer);
    procedure FileOpenActionExecute(Sender: TObject);
    procedure FileSaveActionExecute(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

uses AboutFormUnit, SetValueFormUnit;

{$R *.DFM}

procedure TMainForm.RBCalendarSelectionChange(Sender: TObject);
begin
  RBTimeView.SetDateRange ( RBCalendar.SelectionFromDate ,
                            RBCalendar.DaysSelected );
end;

procedure TMainForm.ExitMIClick(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.TimeScaleMinutesMIClick(Sender: TObject);
begin
  RBTimeView.RulerMarkMinutes :=  TRBTVRulerMarkMinutes(( Sender as TMenuItem).Tag );
  ( Sender as TMenuItem).Checked := True;
end;

procedure TMainForm.StartItemHintMIClick(Sender: TObject);
begin
  StartItemHintMI.Checked := not StartItemHintMI.Checked;
  if StartItemHintMI.Checked then
    RBTimeView.HintsOptions := RBTimeView.HintsOptions + [hoItemStartDrag]
  else
    RBTimeView.HintsOptions := RBTimeView.HintsOptions - [hoItemStartDrag]
end;

procedure TMainForm.RBTimeViewItemStartDragHint(Sender: TObject;
  Item: TRBTimeViewItem; StartTime, EndTime: TDateTime; var Hint: String;
  var HintWidth: Integer);
begin
  HintWidth := 80;
  Hint := FormatDateTime ( 'tt',StartTime );
end;

procedure TMainForm.RBTimeViewItemEndDragHint(Sender: TObject;
  Item: TRBTimeViewItem; StartTime, EndTime: TDateTime; var Hint: String;
  var HintWidth: Integer);
begin
  HintWidth := 80;
  Hint := FormatDateTime ( 'tt',EndTime );
end;

procedure TMainForm.DragItemEndHintMIClick(Sender: TObject);
begin
  DragItemEndHintMI.Checked := not DragItemEndHintMI.Checked;
  if DragItemEndHintMI.Checked then
    RBTimeView.HintsOptions := RBTimeView.HintsOptions + [hoItemEndDrag]
  else
    RBTimeView.HintsOptions := RBTimeView.HintsOptions - [hoItemEndDrag]
end;

procedure TMainForm.TimeSelectionHintMIClick(Sender: TObject);
begin
  TimeSelectionHintMI.Checked := not TimeSelectionHintMI.Checked;
  if TimeSelectionHintMI.Checked then
    RBTimeView.HintsOptions := RBTimeView.HintsOptions + [hoSelection ]
  else
    RBTimeView.HintsOptions := RBTimeView.HintsOptions - [hoSelection]
end;

procedure TMainForm.RBTimeViewSelectionHint(Sender: TObject; StartTime,
  EndTime: TDateTime; var Hint: String; var HintWidth: Integer);
begin
  HintWidth := 100;
  Hint := FormatDateTime ( 'tt',StartTime ) + ' to ' +
          FormatDateTime ( 'tt',EndTime );
end;

procedure TMainForm.HorzSplitterCanResize(Sender: TObject;
  var NewSize: Integer; var Accept: Boolean);
var
  i : integer;
begin
  i := (NewSize+ (RBCalendar.MonthHeight div 2)) div RBCalendar.MonthHeight;
  if i < 1 then i := 1;
  RBCalendar.MonthsInHeight := i;
  NewSize := i * RBCalendar.MonthHeight+4;
  Accept := true;
end;

procedure TMainForm.VertSplitterCanResize(Sender: TObject;
  var NewSize: Integer; var Accept: Boolean);
var
  i : integer;
begin
  i := (NewSize+ (RBCalendar.MonthWidth div 2)) div RBCalendar.MonthWidth;
  if i < 1 then i := 1;
  RBCalendar.MonthsInWidth := i;
  NewSize := i * RBCalendar.MonthWidth+4;
  Accept := true;
end;

procedure TMainForm.TopSpaceMIClick(Sender: TObject);
begin
  TopSpaceMI.Checked := not TopSpaceMI.Checked;
  RBTimeView.ShowTopSpace := TopSpaceMI.Checked;
end;

procedure TMainForm.RulerMIClick(Sender: TObject);
begin
  RulerMI.Checked := not RulerMI.Checked;
  RBTimeView.ShowRuler := RulerMI.Checked;
end;

procedure TMainForm.TimeLinesMIClick(Sender: TObject);
begin
  TimeLinesMI.Checked := not TimeLinesMI.Checked;
  RBTimeView.ShowTimeLines := TimeLinesMI.Checked;
end;

procedure TMainForm.FormShow(Sender: TObject);
begin
  RBCalendar.GotoToday;
end;

procedure TMainForm.RulerColorMIClick(Sender: TObject);
begin
  ColorDialog.Color := RBTimeView.RulerColor;
  if ColorDialog.Execute then
    RBTimeView.RulerColor := ColorDialog.Color;
end;

procedure TMainForm.SelectionColorMIClick(Sender: TObject);
begin
  ColorDialog.Color := RBTimeView.TimeSelectionColor;
  if ColorDialog.Execute then
    RBTimeView.TimeSelectionColor := ColorDialog.Color;
end;

procedure TMainForm.TimeLinesColorMIClick(Sender: TObject);
begin
  ColorDialog.Color := RBTimeView.TimeLinesColor;
  if ColorDialog.Execute then
    RBTimeView.TimeLinesColor := ColorDialog.Color;
end;

procedure TMainForm.MainDisplayColorMIClick(Sender: TObject);
begin
  ColorDialog.Color := RBTimeView.Color;
  if ColorDialog.Execute then
    RBTimeView.Color := ColorDialog.Color;
end;

procedure TMainForm.TopSpaceColorMIClick(Sender: TObject);
begin
  ColorDialog.Color := RBTimeView.TopSpaceColor;
  if ColorDialog.Execute then
    RBTimeView.TopSpaceColor := ColorDialog.Color;
end;

procedure TMainForm.RulerMarksColorMIClick(Sender: TObject);
begin
  ColorDialog.Color := RBTimeView.RulerMarksColor;
  if ColorDialog.Execute then
    RBTimeView.RulerMarksColor := ColorDialog.Color;
end;

procedure TMainForm.WorkinghoursColorMIClick(Sender: TObject);
begin
  ColorDialog.Color := RBTimeView.WorkingHoursColor;
  if ColorDialog.Execute then
    RBTimeView.WorkingHoursColor := ColorDialog.Color;
end;

procedure TMainForm.ItemChangeColorActionExecute(Sender: TObject);
begin
  ColorDialog.Color := RBTimeView.SelectedItem.Color;
  if ColorDialog.Execute then
    RBTimeView.SelectedItem.Color := ColorDialog.Color;
end;

procedure TMainForm.ItemDeleteActionExecute(Sender: TObject);
begin
  RBTimeView.SelectedItem.Delete;
  RBCalendar.UpdateChanges;
end;

procedure TMainForm.ItemActionUpdate(Sender: TObject);
begin
  if RBTimeView.SelectedItem <> nil then ( Sender as TAction ).Enabled := True
  else ( Sender as TAction ).Enabled := False; 
end;

procedure TMainForm.MainDisplayFontMIClick(Sender: TObject);
begin
  FontDialog.Font := RBTimeView.Font;
  if FontDialog.Execute then
    RBTimeView.Font := FontDialog.Font;
end;

procedure TMainForm.RulerFontMIClick(Sender: TObject);
begin
  FontDialog.Font := RBTimeView.RulerFont;
  if FontDialog.Execute then
    RBTimeView.RulerFont := FontDialog.Font;
end;

procedure TMainForm.SmoothScrollMIClick(Sender: TObject);
begin
  SmoothScrollMI.Checked := not SmoothScrollMI.Checked;
  RBTimeView.SmoothScroll := SmoothScrollMI.Checked;
end;

procedure TMainForm.CustomDrawItemsMIClick(Sender: TObject);
begin
  CustomDrawItemsMI.Checked := not CustomDrawItemsMI.Checked;
  if CustomDrawItemsMI.Checked then
    RBTimeView.CustomDrawOptions := RBTimeView.CustomDrawOptions + [cdoItems]
  else
    RBTimeView.CustomDrawOptions := RBTimeView.CustomDrawOptions - [cdoItems];
end;

procedure TMainForm.DaysCustomDrawMIClick(Sender: TObject);
begin
  DaysCustomDrawMI.Checked := not DaysCustomDrawMI.Checked;
  if DaysCustomDrawMI.Checked then
    RBTimeView.CustomDrawOptions := RBTimeView.CustomDrawOptions + [cdoDays]
  else
    RBTimeView.CustomDrawOptions := RBTimeView.CustomDrawOptions - [cdoDays];
end;

procedure TMainForm.RBTimeViewDrawItem(Sender: TObject; Canvas: TCanvas;
  Item: TRBTimeViewItem; Rect: TRect);
var
  s : string;
begin
  Canvas.Brush.Style := bsSolid;
  Canvas.Brush.Color := clGray;
  Canvas.RoundRect ( Rect.Left , Rect.Top , Rect.Right-5 , Rect.Bottom-5 ,
                     40 , 40 );
  Rect.left := Rect.Left + 5;
  Rect.Top := Rect.Top + 5;
  Canvas.Brush.Color := Item.Color;
  if Item.Selected then
  begin
    Canvas.Pen.Width := 3;
    Canvas.Pen.Color := clRed;
  end
  else
  begin
    Canvas.Pen.Width := 0;
    Canvas.Pen.Color := clBlack;
  end;
  Canvas.RoundRect ( Rect.Left , Rect.Top , Rect.Right , Rect.Bottom ,
                     40 , 40 );

  Canvas.Font := RBTimeView.Font;
  InflateRect ( Rect , -5 , -5 );
  DrawText ( Canvas.Handle , PChar(Item.Caption), Length(Item.Caption),Rect ,
             DT_CENTER or DT_END_ELLIPSIS or DT_VCENTER or DT_SINGLELINE );
  s := FormatDateTime ( 'tt' , item.StartTime ) + ' - ' +
       FormatDateTime ( 'tt' , item.EndTime );
  Rect.Left := Rect.Left + 10;
  Rect.Top := Rect.Top + 10;
  DrawText ( Canvas.Handle , PChar(s), Length(s),Rect ,
             DT_END_ELLIPSIS or DT_SINGLELINE );


end;

procedure TMainForm.ItemReminderActionUpdate(Sender: TObject);
begin
  if RBTimeView.SelectedItem = nil then ItemReminderAction.Enabled := False
  else
  begin
    ItemReminderAction.Enabled := True;
    ItemReminderAction.Checked := RBTimeView.SelectedItem.ShowReminder;
  end;
end;

procedure TMainForm.ItemPrivateActionUpdate(Sender: TObject);
begin
  if RBTimeView.SelectedItem = nil then ItemPrivateAction.Enabled := False
  else
  begin
    ItemPrivateAction.Enabled := True;
    ItemPrivateAction.Checked := RBTimeView.SelectedItem.PrivateItem;
  end;
end;

procedure TMainForm.ItemPrivateActionExecute(Sender: TObject);
begin
  ItemPrivateAction.Checked := not ItemPrivateAction.Checked;
  RBTimeView.SelectedItem.PrivateItem := ItemPrivateAction.Checked;
end;

procedure TMainForm.ItemReminderActionExecute(Sender: TObject);
begin
  ItemReminderAction.Checked := not ItemReminderAction.Checked;
  RBTimeView.SelectedItem.ShowReminder := ItemReminderAction.Checked;
end;

procedure TMainForm.LeftToRightMIClick(Sender: TObject);
begin
  RBTimeView.BiDiMode := bdLeftToRight;
  LeftToRightMI.Checked := True;
end;

procedure TMainForm.RightToLeftMIClick(Sender: TObject);
begin
  RBTimeView.BiDiMode := bdRightToLeft;
  RightToLeftMI.Checked := True;
end;

procedure TMainForm.MarkWorkingHoursActionUpdate(Sender: TObject);
begin
  if RBTimeView.SelectedTimeStart = RBTimeView.SelectedTimeEnd then
    MarkWorkingHoursAction.Enabled := False
  else
    MarkWorkingHoursAction.Enabled := True;
end;

procedure TMainForm.MarkWorkingHoursActionExecute(Sender: TObject);
var
  day : TRBTimeViewDay;
begin
  day := RBTimeView.GetDayFromDate ( RBTimeView.SelectedTimeStart );
  day.BeginWork := Frac ( RBTimeView.SelectedTimeStart);
  day.EndWork := Frac ( RBTimeView.SelectedTimeEnd );
  day.ShowWorkingHours := True;
end;

procedure TMainForm.RBTimeViewDrawCaption(Sender: TObject; Canvas: TCanvas;
  Rect: TRect; Day: TRBTimeviewDay);
var
  rgn : HRgn;
  orig_rect : TRect;
  s : String;
begin
  orig_rect := Rect;
  with Canvas do
  begin
    Rect.Bottom := Rect.Bottom + 1;
    rgn := CreateRectRgnIndirect ( Rect );
    SelectClipRgn ( Handle , rgn );
    Brush.Style := bsSolid;
    Brush.Color := clWhite;
    Rect.Bottom := Rect.Bottom + 20;
    FillRect ( Rect );
    Brush.Color := clSilver;
    Canvas.RoundRect ( Rect.Left , Rect.Top , Rect.Right , Rect.Bottom+20 , 20 , 20 );
    SelectClipRgn ( Handle , 0 );
    DeleteObject ( rgn );
    Font := RBTimeView.Font;
    s := FormatDateTime ( 'mmm d, yyyy' , Day.Date );
    DrawText ( Handle , PChar(s) , Length(s) , orig_rect ,
               DT_CENTER or DT_SINGLELINE or DT_VCENTER or DT_END_ELLIPSIS );

  end;
end;

procedure TMainForm.DaysCaptionsCustomDrawMIClick(Sender: TObject);
begin
  DaysCaptionsCustomDrawMI.Checked := not DaysCaptionsCustomDrawMI.Checked;
  if DaysCaptionsCustomDrawMI.Checked then
  begin
    RBTimeView.CaptionHeight := 50;
    RBTimeView.CustomDrawOptions := RBTimeView.CustomDrawOptions + [ cdoCaptions ];
  end
  else
  begin
    RBTimeView.CustomDrawOptions := RBTimeView.CustomDrawOptions - [ cdoCaptions ];
    RBTimeView.CaptionHeight := 22;
  end;
end;

procedure TMainForm.HideWorkingHoursActionExecute(Sender: TObject);
var
  day : TRBTimeViewDay;
begin
  day := RBTimeView.GetDayFromDate ( RBTimeView.SelectedTimeStart );
  day.ShowWorkingHours := False;
end;

procedure TMainForm.HideWorkingHoursActionUpdate(Sender: TObject);
begin
  if RBTimeView.SelectedTimeStart = RBTimeView.SelectedTimeEnd then
    HideWorkingHoursAction.Enabled := False
  else
    HideWorkingHoursAction.Enabled := True;
end;

procedure TMainForm.RulerWidthSizeMIClick(Sender: TObject);
begin
  SetValueForm.SetValues ( 1 , RBTimeView.RulerWidth , 45 , 100 );
  SetValueForm.ShowModal;
end;

procedure TMainForm.DaysGapWidthMIClick(Sender: TObject);
begin
  SetValueForm.SetValues ( 2 , RBTimeView.DaysGapWidth  , 1 , 30 );
  SetValueForm.ShowModal;
end;

procedure TMainForm.RulerMarksHeightMIClick(Sender: TObject);
begin
  SetValueForm.SetValues ( 3 , RBTimeView.RulerMarkHeight  , 10 , 40 );
  SetValueForm.ShowModal;
end;

procedure TMainForm.DaysCaptionsHeightMIClick(Sender: TObject);
begin
  SetValueForm.SetValues ( 4 , RBTimeView.CaptionHeight , 10 , 100 );
  SetValueForm.ShowModal;
end;

procedure TMainForm.ItemNewActionUpdate(Sender: TObject);
begin
  if RBTimeView.SelectedTimeStart = RBTimeView.SelectedTimeEnd then
    ItemNewAction.Enabled := False
  else
    ItemNewAction.Enabled := True;
end;

procedure TMainForm.ItemNewActionExecute(Sender: TObject);
begin
  RBTimeView.Items.Add ( 'New meeting' , RBTimeView.SelectedTimeStart ,
                         RBTimeView.SelectedTimeEnd , False );
  RBCalendar.UpdateChanges;
end;

procedure TMainForm.RBCalendarMark(Sender: TObject; Day: TDate;
  var Mark: Boolean);
begin
  Mark := RBTimeView.ItemExistOnDay ( Day );
end;

procedure TMainForm.RBTimeViewCreatedOnType(Sender: TObject;
  Item: TRBTimeViewItem);
begin
  RBCalendar.UpdateChanges;
end;

procedure TMainForm.RBTimeViewDragItem(Sender: TObject;
  Item: TRBTimeViewItem; Mode: TRBTVDragMode);
begin
  if Mode = dmEndDrag then RBCalendar.UpdateChanges;
end;

procedure TMainForm.AboutActionExecute(Sender: TObject);
begin
  AboutForm.ShowModal;
end;


procedure TMainForm.RBTimeViewDrawDay(Sender: TObject; Canvas: TCanvas;
  Day: TRBTimeviewDay; Rect: TRect; YOffset: Integer);
var
  tx , ty , x , y : integer;

begin
  tx := ( Rect.Right - Rect.Left ) div BGImageList.Width;
  ty := ( Rect.Bottom - Rect.Top ) div BGImageList.Height;

  for x := 0 to tx do
    for y := 0 to ty do
      BGImageList.Draw ( Canvas , Rect.Left + x*BGImageList.Width ,
                         Rect.Top + y*BGImageList.Height , 0 );
end;

procedure TMainForm.FileOpenActionExecute(Sender: TObject);
begin
  if OpenDialog.Execute then
  begin
    RBTimeView.LoadFromFile ( OpenDialog.FileName );
    RBCalendar.UpdateChanges;
  end;
end;

procedure TMainForm.FileSaveActionExecute(Sender: TObject);
begin
  if SaveDialog.Execute then
    RBTimeView.SaveToFile ( SaveDialog.FileName );
end;

end.
