unit ThreadDemo_Unit;
// RemoteControl: Send 1 to start, 2 to stop the calculation
// all controlled by the main thread.
// You can terminate the thread when you want - even when calculating.
// or you can simply close the app - even with threads open.

// Note: When Calc-Time equals zero (0) the CPU-usage will be 100%
// and creating a new thread will not give more updates.
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PBShare, ExtCtrls, StdCtrls;

type
  TThreadDemoForm = class(TForm)
    Label1: TLabel;
		Edit1: TEdit;
		NewThread: TButton;
    Edit2: TEdit;
    Label2: TLabel;
    Bevel1: TBevel;
    DeleteThread: TButton;
		PBShareSingle1: TPBShareSingle;
		Timer1: TTimer;
		Label4: TLabel;
		Edit3: TEdit;
    Bevel2: TBevel;
    Label3: TLabel;
    Edit4: TEdit;
    SetCalcTime: TButton;
    UpdateEdit: TCheckBox;
    PauseThreads: TButton;
    RestartThreads: TButton;
    Label5: TLabel;
		procedure FormCreate(Sender: TObject);
		procedure FormDestroy(Sender: TObject);
		procedure NewThreadClick(Sender: TObject);
		procedure DeleteThreadClick(Sender: TObject);
		procedure PBShareSingle1UpdateAll(Sender: TObject;
			const FromHandle: HWND; const ExtraInfo: Integer);
		procedure PBShareSingle1DoReadAll(Sender: TObject;
			const Stream: TMemoryStream; const Reader: TPBReader;
			const FromHandle: HWND; const ExtraInfo: Integer);
		procedure PBShareSingle1DoWriteAll(Sender: TObject;
			const Stream: TMemoryStream; const Writer: TPBWriter;
			var ExtraInfo: Integer);
		procedure PBShareSingle1UpdateShareList(Sender: TObject;
			const FromHandle: HWND; const Index: Integer;
			const ItemOperation: TMultiOperation);
		procedure Timer1Timer(Sender: TObject);
		procedure SetCalcTimeClick(Sender: TObject);
    procedure PauseThreadsClick(Sender: TObject);
    procedure RestartThreadsClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
	private
		{ Private declarations }
	public
		{ Public declarations }
	end;

var
	ThreadDemoForm: TThreadDemoForm;
	Tick, UpdateCounter : Cardinal;
	List : TList;

implementation

uses ThreadDemoThread_Unit;

{$R *.DFM}

procedure TThreadDemoForm.FormCreate(Sender: TObject);
begin
	List := TList.Create;
end;

procedure TThreadDemoForm.FormDestroy(Sender: TObject);
begin
	List.Free;
	List := nil;
end;

procedure TThreadDemoForm.FormCloseQuery(Sender: TObject;
	var CanClose: Boolean);
begin
	while List.Count > 0 do DeleteThreadClick(Self);
	CanClose := True;
end;

procedure TThreadDemoForm.NewThreadClick(Sender: TObject);
begin
	List.Add(TThreadDemoThread.Create(False));
	Edit2.Text := IntToStr(List.Count);
end;

procedure TThreadDemoForm.DeleteThreadClick(Sender: TObject);
begin
	if List.Count > 0 then
	begin
		TThreadDemoThread(List.Last).Terminate;
		TThreadDemoThread(List.Last).WaitFor;
		TThreadDemoThread(List.Last).Free;
		List.Remove(List.Last);
		Edit2.Text := IntToStr(List.Count);
	end;
end;

// ------  Timer event to count updates  ----------------
procedure TThreadDemoForm.Timer1Timer(Sender: TObject);
begin
	Edit3.Text := IntToStr(UpdateCounter);
	UpdateCounter := 0;
end;

procedure TThreadDemoForm.SetCalcTimeClick(Sender: TObject);
begin
// Here synchron update is ok.
	PBShareSingle1.RemoteControl(-StrToInt(Edit4.Text));
end;

// -------------  PBShareSingle1 event-handlers  ------------------
procedure TThreadDemoForm.PBShareSingle1UpdateAll(Sender: TObject;
	const FromHandle: HWND; const ExtraInfo: Integer);
begin
	Inc(UpdateCounter);
	if UpdateEdit.Checked then Edit1.Text := IntToStr(Tick);
end;

procedure TThreadDemoForm.PBShareSingle1DoReadAll(Sender: TObject;
	const Stream: TMemoryStream; const Reader: TPBReader;
	const FromHandle: HWND; const ExtraInfo: Integer);
begin
	Tick := Reader.ReadCardinal;
end;

procedure TThreadDemoForm.PBShareSingle1DoWriteAll(Sender: TObject;
	const Stream: TMemoryStream; const Writer: TPBWriter;
	var ExtraInfo: Integer);
begin
	TPBShareSingle(Sender).WriteSize(0, SizeOf(Cardinal));
	Writer.WriteCardinal(Tick);
end;

procedure TThreadDemoForm.PBShareSingle1UpdateShareList(Sender: TObject;
	const FromHandle: HWND; const Index: Integer;
	const ItemOperation: TMultiOperation);
begin
	if ItemOperation = moAdd then // New thread has been created.
	begin
		// Set calc-time and start the calculation
// Here synchron update is ok.
		PBShareSingle1.RemoteControl(-StrToInt(Edit4.Text), FromHandle);
// Here asynchron update is necessary since it doesn't return immidiately.
		PBShareSingle1.RemoteControl(1, FromHandle, True);
	end;
end;

procedure TThreadDemoForm.PauseThreadsClick(Sender: TObject);
begin
// The threads will be suspended but keep processing messages.

// Here synchron update is ok.
	PBShareSingle1.RemoteControl(2);
end;

procedure TThreadDemoForm.RestartThreadsClick(Sender: TObject);
begin
// Here asynchron update is necessary since it doesn't return immidiately.
	PBShareSingle1.RemoteControl(1, 0, True);
end;

end.
