unit ThreadDemoThread_Unit;

interface

uses
	Windows, Messages, Classes, Forms, PBShare;

type
	TThreadDemoThread = class(TThread)
	private
		{ Private declarations }
		PBShareSingleX : TPBShareSingle;
		Tick, CalcTime : Cardinal;
		Running : Boolean;
		procedure Calculate;
		procedure PBShareSingleXDoReadAll(Sender: TObject;
			const Stream: TMemoryStream; const Reader: TPBReader;
			const FromHandle: HWND; const ExtraInfo: Integer);
		procedure PBShareSingleXDoWriteAll(Sender: TObject;
			const Stream: TMemoryStream; const Writer: TPBWriter;
			var ExtraInfo: Integer);
		procedure PBShareSingleXRemoteControl(Sender: TObject;
			const FromHandle: HWND; const Param: Integer);
		procedure ProcessThreadMessages;
	protected
		procedure Execute; override;
	public
		function WaitFor : LongWord;
		procedure Terminate;
	end;

implementation

{ TThreadDemoThread }

function TThreadDemoThread.WaitFor : LongWord;
// WaitFor is called in the main thread so this is actually a combination
// of WaitFor and Application.ProcessMessages.
var
	ThreadHandle : THandle;
begin
	ThreadHandle := Self.Handle;
	repeat
		Result := MsgWaitForMultipleObjects(1, ThreadHandle, False, INFINITE, QS_ALLINPUT);
		if (Result = WAIT_OBJECT_0 + 1) then ProcessThreadMessages;
	until Result <> (WAIT_OBJECT_0 + 1);
end;

procedure TThreadDemoThread.ProcessThreadMessages;
var
	Msg : TMsg;
begin
	while PeekMessage(Msg, 0, 0, 0, PM_REMOVE) do
	begin
		TranslateMessage(Msg);
		DispatchMessage(Msg);
	end;
end;

procedure TThreadDemoThread.Execute;
var
	Msg : TMsg;
begin
// Normally all PBShare components should have the same property-settings
// except in this case ShareFunction. The threads have sfWriter and the main
// thread have sfReader.
	PBShareSingleX := TPBShareSingle.CreateNoOwner('PBShare-ThreadDemo',
		256, [], True, sfWriter, nil, nil, nil, PBShareSingleXDoReadAll,
		PBShareSingleXDoWriteAll, PBShareSingleXRemoteControl);
	// The thread's main message-loop.
	try
		while (not Terminated) and GetMessage(Msg, 0, 0, 0) do
		begin
			TranslateMessage(Msg);
			DispatchMessage(Msg);
		end;
	finally
		PBShareSingleX.Free;
		PBShareSingleX := nil;
	end;
end;

procedure TThreadDemoThread.Terminate;
begin
	inherited;
	// To make GetMessage wake up and exit
	PostThreadMessage(Self.ThreadID, WM_QUIT, 0, 0);
end;

//  -------------  PBShareSingleX event-handlers  ------------------
procedure TThreadDemoThread.PBShareSingleXDoReadAll(Sender: TObject;
	const Stream: TMemoryStream; const Reader: TPBReader;
	const FromHandle: HWND; const ExtraInfo: Integer);
begin
	Tick := Reader.ReadCardinal;
end;

procedure TThreadDemoThread.PBShareSingleXDoWriteAll(Sender: TObject;
	const Stream: TMemoryStream; const Writer: TPBWriter;
	var ExtraInfo: Integer);
begin
	TPBShareSingle(Sender).WriteSize(0, SizeOf(Cardinal));
	Writer.WriteCardinal(Tick);
end;

procedure TThreadDemoThread.PBShareSingleXRemoteControl(Sender: TObject;
	const FromHandle: HWND; const Param: Integer);
begin
	if Param <= 0 then CalcTime := -Param
	else if (not Running) and (Param = 1) then
	begin
		Running := True;
		while (not Terminated) and Running do Calculate;
	end
	else if Running and (Param = 2) then Running := False;
end;

// The method with calculation (the reason to make the thread).
procedure TThreadDemoThread.Calculate;
var
	Done : Boolean;
begin
// Do Thread-Calcutions here!
	Tick := GetTickCount;
	// Simulate heavy calculation - don't forget to process messages.
	Done := False;
	repeat
		if (GetTickCount >= Tick + CalcTime) then Done := True
		else Sleep(CalcTime div 10);
		ProcessThreadMessages; //periodically process messages.
	until Done or Terminated or (not Running);
	if Done and Running and (not Terminated)
		then PBShareSingleX.WriteAll;
end;

end.
