unit RemoteControlDemo_Unit;

interface

uses
	Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
	Dialogs, StdCtrls, PBShare, PBShareStringList;

type
	TRemoteControlDemoForm = class(TForm)
		Memo1: TMemo;
		Label1: TLabel;
		Label2: TLabel;
		Button1: TButton;
		Button2: TButton;
		Button3: TButton;
		PBShareStringList1: TPBShareStringList;
    CheckBox1: TCheckBox;
    Label3: TLabel;
		procedure FormCreate(Sender: TObject);
		procedure UpdateMemo;
		procedure PBShareStringList1RemoteControl(Sender: TObject;
			const FromHandle: HWND; const Param: Integer);
		procedure Button1Click(Sender: TObject);
		procedure Button2Click(Sender: TObject);
		procedure Button3Click(Sender: TObject);
    procedure PBShareStringList1UpdateShareList(Sender: TObject;
      const FromHandle: HWND; const Index: Integer;
      const ItemOperation: TMultiOperation);
	private
    { Private declarations }
  public
    { Public declarations }
	end;

var
	RemoteControlDemoForm: TRemoteControlDemoForm;

implementation

{$R *.dfm}

procedure TRemoteControlDemoForm.FormCreate(Sender: TObject);
begin
	Randomize;
	Label3.Caption := '(Compiled using version: ' + PBShareStringList1.Version
		+ ' of PBSharePack)';
end;

procedure TRemoteControlDemoForm.UpdateMemo;
var
	t : integer;
begin
	Memo1.Lines.Clear;
	for t := 0 to PBShareStringList1.ShareCount - 1
		do Memo1.Lines.Add(IntToStr(PBShareStringList1.ShareInfos[t].Handle));
end;

// A Param value of 0 Opens the shares
// Param = 1 close the shares
// Other values changes the form's color to that value.

procedure TRemoteControlDemoForm.PBShareStringList1RemoteControl(
	Sender: TObject; const FromHandle: HWND; const Param: Integer);
begin
	case Param of
		0 : (Sender as TPBCustomShare).OpenShare;
		1 : (Sender as TPBCustomShare).CloseShare;
		else Self.Color := TColor(Param);
	end;
end;

procedure TRemoteControlDemoForm.Button1Click(Sender: TObject);
begin
	PBShareStringList1.OpenShare;
	PBShareStringList1.RemoteControl(0, 0, False, True);
end;

procedure TRemoteControlDemoForm.Button2Click(Sender: TObject);
begin
	PBShareStringList1.RemoteControl(1);
	PBShareStringList1.CloseShare;
end;

procedure TRemoteControlDemoForm.Button3Click(Sender: TObject);
begin
	PBShareStringList1.RemoteControl(Random(MAXINT - 1) + 2);
end;

procedure TRemoteControlDemoForm.PBShareStringList1UpdateShareList(
	Sender: TObject; const FromHandle: HWND; const Index: Integer;
	const ItemOperation: TMultiOperation);
begin
	UpdateMemo;
	CheckBox1.Checked := PBShareStringList1.IsOpen;
end;

end.
