unit PBShareSingleDemo_Unit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, PBShare;

type
	TPBShareSingleDemoForm = class(TForm)
		Label1: TLabel;
		ColorButton: TBitBtn;
		ColorDialog1: TColorDialog;
		PBShareSingle1: TPBShareSingle;
		procedure FormCreate(Sender: TObject);
		procedure FormDestroy(Sender: TObject);
		procedure ColorButtonClick(Sender: TObject);
		procedure FormPaint(Sender: TObject);
		procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
			Shift: TShiftState; X, Y: Integer);
		procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
			Y: Integer);
		procedure SetGlyph;
		procedure PBShareSingle1UpdateAll(Sender: TObject; const FromHandle: HWnd;
			const ExtraInfo: Integer);
		procedure PBShareSingle1DoReadAll(Sender: TObject;
			const Stream: TMemoryStream; const Reader: TPBReader;
			const FromHandle: HWnd; const ExtraInfo: Integer);
    procedure PBShareSingle1DoWriteAll(Sender: TObject;
      const Stream: TMemoryStream; const Writer: TPBWriter;
      var ExtraInfo: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
	end;

var
  PBShareSingleDemoForm: TPBShareSingleDemoForm;
	Bitmap : TBitmap;
	Rect0, Rect1 : TRect;

implementation

{$R *.DFM}

procedure TPBShareSingleDemoForm.FormCreate(Sender: TObject);
begin
	Bitmap := TBitmap.Create;
	Bitmap.Width := 400;
	Bitmap.Height := 300;
	Rect0 := Bounds(5, 45, Bitmap.Width + 20, Bitmap.Height + 20);
	Rect1 := Bounds(15, 55, Bitmap.Width, Bitmap.Height);
	SetGlyph;
end;

procedure TPBShareSingleDemoForm.FormDestroy(Sender: TObject);
begin
	Bitmap.Free;
end;

procedure TPBShareSingleDemoForm.ColorButtonClick(Sender: TObject);
begin
	if ColorDialog1.Execute then
	begin
		SetGlyph;
		PBShareSingle1.WriteAll;
	end;
end;

procedure TPBShareSingleDemoForm.FormPaint(Sender: TObject);
var
	TempRect : TRect;
begin
	TempRect := Rect0;
	Frame3D(Canvas, TempRect, clWhite, clGray, 5);
	Frame3D(Canvas, TempRect, clGray, clWhite, 5);
	Canvas.Draw(15, 55, Bitmap);
end;

procedure TPBShareSingleDemoForm.FormMouseDown(Sender: TObject;
	Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
	if (ssRight in Shift) then
	begin
		Bitmap.Canvas.FloodFill(X - 15, Y - 55, ColorDialog1.Color, fsBorder);
		InvalidateRect(Handle, @Rect1, False);
		Update;
		PBShareSingle1.WriteAll;
	end
	else Bitmap.Canvas.PenPos := Point(X - 15, Y - 55);
end;

procedure TPBShareSingleDemoForm.FormMouseMove(Sender: TObject;
	Shift: TShiftState; X, Y: Integer);
begin
	if (ssLeft in Shift) then
	begin
		Bitmap.Canvas.LineTo(X - 15, Y - 55);
		InvalidateRect(Handle, @Rect1, False);
		Update;
		PBShareSingle1.WriteAll;
	end;
end;

procedure TPBShareSingleDemoForm.SetGlyph;
var
	TempRect : TRect;
begin
	ColorButton.NumGlyphs := 1;
	ColorButton.Glyph.Width := ColorButton.Glyph.Height;
	ColorButton.Glyph.PixelFormat := pf32bit;
	ColorButton.Glyph.Canvas.Brush.Color := ColorDialog1.Color;
	TempRect := ColorButton.Glyph.Canvas.ClipRect;
	Frame3D(ColorButton.Glyph.Canvas, TempRect, clBtnFace, clBtnFace, 2);
	ColorButton.Glyph.Canvas.FillRect(TempRect);
	Bitmap.Canvas.Pen.Color := ColorDialog1.Color;
	Bitmap.Canvas.Brush.Color := ColorDialog1.Color;
end;

//  ------------  PBShareSingle1 event handlers  ------------------
procedure TPBShareSingleDemoForm.PBShareSingle1DoReadAll(Sender: TObject;
	const Stream: TMemoryStream; const Reader: TPBReader;
	const FromHandle: HWnd; const ExtraInfo: Integer);
begin
// The map is locked, it's safe to read from it !
// Now copy the information to local variables.
	Bitmap.LoadFromStream(Stream);
end;

procedure TPBShareSingleDemoForm.PBShareSingle1DoWriteAll(Sender: TObject;
	const Stream: TMemoryStream; const Writer: TPBWriter;
	var ExtraInfo: Integer);
begin
// The map is locked, it's safe to write to it !
// Now copy the information to the stream.
	ExtraInfo := Integer(ColorDialog1.Color);
	Bitmap.SaveToStream(Stream);
end;

procedure TPBShareSingleDemoForm.PBShareSingle1UpdateAll(Sender: TObject;
	const FromHandle: HWnd; const ExtraInfo: Integer);
begin
// The map has finished reading and is unlocked, now use the info !
	if ColorDialog1.Color <> TColor(ExtraInfo) then
	begin
		ColorDialog1.Color := TColor(ExtraInfo);
		SetGlyph;
	end;
	InvalidateRect(Handle, @Rect1, False);
	Update;
end;

end.
