unit PBSharePackReg;

{$INCLUDE PBDefines.inc}

interface

uses
	SysUtils, Classes,
{$IFNDEF COMPILER_MAX_4} StrEdit, {$ENDIF}
{$IFDEF COMPILER_MAX_5} DsgnIntf;
{$ELSE}	DesignIntf, DesignEditors, VCLEditors;
{$ENDIF}

procedure Register;

implementation

uses
	PBShare, PBShareMulti, PBShareStringList, PBShareMemIni, PBShareImages,
	PBShareOneInstance;

// --------------------- ComponentEditor ------------------------
type
	TPBShareEditor = class(TDefaultEditor)
	public
{$IFDEF COMPILER_MAX_5}
		procedure EditProperty(PropertyEditor : TPropertyEditor;
			var Continue, FreeEditor : Boolean); override;
{$ELSE}
		procedure EditProperty(const PropertyEditor : IProperty;
			var Continue : Boolean); override;
{$ENDIF}
	end;

{$IFDEF COMPILER_MAX_5} procedure TPBShareEditor.EditProperty(PropertyEditor : TPropertyEditor;
	var Continue, FreeEditor : Boolean);
{$ELSE}
	procedure TPBShareEditor.EditProperty(const PropertyEditor : IProperty;
		var Continue : Boolean);
{$ENDIF}
begin
	if (CompareText(PropertyEditor.GetName, 'OnUpdateAll') = 0) then
	begin
		PropertyEditor.Edit;
		Continue := False;
	end;
end;

// ----------------- TPBShareStrings PropertyEditor ---------------
{$IFNDEF COMPILER_MAX_4}
type
	TPBShareStringsProperty = class (TStringListProperty)
	public
		function GetAttributes : TPropertyAttributes; override;
		function GetValue : string; override;
		procedure Edit; override;
	end;

function TPBShareStringsProperty.GetAttributes : TPropertyAttributes;
begin
	if TPBShareStringList(GetComponent(0)).Strings <> nil
		then Result := inherited GetAttributes
	else Result := [paReadOnly];
end;

function TPBShareStringsProperty.GetValue : string;
begin
	if TPBShareStringList(GetComponent(0)).Strings <> nil
		then Result := inherited GetValue
	else Result := '(External) (=nil)';
end;

procedure TPBShareStringsProperty.Edit;
begin
	if TPBShareStringList(GetComponent(0)).Strings <> nil then inherited
	else Revert;
end;
{$ENDIF}

// ----------------- AutoUpdate PropertyEditor ---------------
type
	TPBAutoUpdateProperty = class (TEnumProperty)
	public
		function GetAttributes : TPropertyAttributes; override;
		function GetValue : string; override;
		procedure Edit; override;
	end;

function TPBAutoUpdateProperty.GetAttributes : TPropertyAttributes;
begin
	if TPBShareStringList(GetComponent(0)).Strings <> nil
		then Result := inherited GetAttributes
	else Result := [paReadOnly];
end;

function TPBAutoUpdateProperty.GetValue : string;
begin
	if TPBShareStringList(GetComponent(0)).Strings <> nil
		then Result := inherited GetValue
	else Result := '(External-ignored)';
end;

procedure TPBAutoUpdateProperty.Edit;
begin
	if TPBShareStringList(GetComponent(0)).Strings <> nil then inherited
	else Revert;
end;

// ----------------------- Register -----------------------------
procedure Register;
begin
	RegisterComponents('PBShare', [TPBShareMulti, TPBShareSingle, TPBShareStringList,
		TPBShareMemIni, TPBShareImages, TPBShareOneInstance]);
	RegisterComponentEditor(TPBCustomShare, TPBShareEditor);
{$IFNDEF COMPILER_MAX_4}
	RegisterPropertyEditor(TypeInfo(TStrings), TPBShareStringList, 'Strings',
		TPBShareStringsProperty);
{$ENDIF}
	RegisterPropertyEditor(TypeInfo(Boolean), TPBShareStringList, 'AutoUpdate',
		TPBAutoUpdateProperty);
end;

end.
