unit PBShareOneInstance;

{$INCLUDE PBDefines.inc}

interface

uses
	Windows, Messages, SysUtils, Classes,{$IFDEF COMPILER_MAX_5} Forms, {$ENDIF}
	PBShareStream;

type
	TNotifyProc = procedure(Self, Sender : TObject);

	TPBShareOneInstance = class(TComponent)
	private
		{ Private declarations }
		FSharePointer : PHandle;
		PTextStart : PChar;
		FShareHandle, FMutex : THandle;
		FShareName, FVersion : string;
		FOneInstanceMessageID : Cardinal;
		FShareWindowhandle : HWnd;
		FParamStr : TStringList;
		FOnSecondInstance, FOnTerminating : TNotifyEvent;
		function MakeMethod(Proc : Pointer) : TMethod;
		procedure CheckInstance;
		procedure Dummy(Value : string);
		procedure WndProc(var FMessage : TMessage);
	protected
		{ Protected declarations }
		procedure Loaded; override;
	public
		{ Public declarations }
		constructor Create(AOwner : TComponent); override;
		constructor CreateNoOwner(AShareName : string;
			AOnSecondInstance : TNotifyEvent);
		constructor CreateNoEvents(AShareName : string;
			AOnSecondInstance : TNotifyProc);
		destructor Destroy; override;
		function FindCmdLineSwitch(const Switch: string;
			const SwitchChars : TSysCharSet): Boolean;
		function ParamCount : integer;
		function ParamStr(Index : integer) : string;
	published
		{ Published declarations }
		property OnSecondInstance : TNotifyEvent read FOnSecondInstance
			write FOnSecondInstance;
		property OnTerminating : TNotifyEvent read FOnTerminating
			write FOnTerminating;
		property ShareName : string read FShareName write FShareName;
		property Version : string read FVersion write Dummy stored False;
	end;

implementation

const
	ComponentVersion = '5.00.00.00';
	ShareSize = 4 * MAX_PATH;

//  -------------------  TPBShareOneInstance  --------------------
constructor TPBShareOneInstance.Create(AOwner : TComponent);
var
	t : integer;
begin
	inherited;
	FVersion := ComponentVersion;
	FShareName := 'PBShare-';
	for t := 0 to 6 do FShareName := FShareName + Chr(Random(26) + Ord('A'));
end;

constructor TPBShareOneInstance.CreateNoOwner(AShareName : string;
	AOnSecondInstance : TNotifyEvent);
begin
	Create(nil);
	FShareName := AShareName;
	FOnSecondInstance := AOnSecondInstance;
	if not (csDesigning in ComponentState) then CheckInstance;
end;

constructor TPBShareOneInstance.CreateNoEvents(AShareName : string;
	AOnSecondInstance : TNotifyProc);
begin
	Create(nil);
	FShareName := AShareName;
	FOnSecondInstance := TNotifyEvent(MakeMethod(@AOnSecondInstance));
	if not (csDesigning in ComponentState) then CheckInstance;
end;

procedure TPBShareOneInstance.Loaded;
begin
	inherited;
	if not (csDesigning in ComponentState) then CheckInstance;
end;

destructor TPBShareOneInstance.Destroy;
begin
	if not (csDesigning in ComponentState) then
	begin
		DeAllocateHWND(FShareWindowhandle);
		FParamStr.Free;
		FParamStr := nil;
		UnMapViewOfFile(FSharePointer);
		FSharePointer := nil;
		CloseHandle(FShareHandle);
		FShareHandle := 0;
		ReleaseMutex(FMutex);
		CloseHandle(FMutex);
		FMutex := 0;
	end;
	inherited;
end;

function TPBShareOneInstance.FindCmdLineSwitch(const Switch: string;
	const SwitchChars : TSysCharSet): Boolean;
var
	t : integer;
begin
	Result := False;
	if FParamStr = nil then Exit;
	for t := 1 to FParamStr.Count - 1 do
	begin
		if (FParamStr[t] <> '') and (FParamStr[t][1] in SwitchChars)
			and (AnsiLowerCase(Copy(FParamStr[t], 2,
			Length(FParamStr[t]) - 1)) = AnsiLowerCase(Switch)) then
		begin
			Result := True;
			Exit;
		end;
	end;
end;

function TPBShareOneInstance.MakeMethod(Proc : Pointer) : TMethod;
begin
	Result.Data := nil;
	Result.Code := Proc;
end;

function TPBShareOneInstance.ParamCount : integer;
begin
	if FParamStr <> nil then Result := FParamStr.Count -1
	else Result := 0;
end;

function TPBShareOneInstance.ParamStr(Index : integer) : string;
begin
	if (FParamStr <> nil) and (FParamStr.Count > Index)
		then	Result := FParamStr[Index]
	else Result := '';
end;

procedure TPBShareOneInstance.CheckInstance;
var
	FirstInstance : Boolean;
	SendToHandle : HWnd;
	t : integer;
	TextPointer : PChar;
begin
	FParamStr := TStringList.Create;
	FShareWindowHandle := AllocateHWND(WndProc);
	FOneInstanceMessageID := RegisterWindowMessage(PChar(FShareName + '-Message'));
	FMutex := CreateMutex(nil, False, PChar(FShareName + '.mtx'));
	if FMutex = 0 then RaiseLastWin32Error;
	FirstInstance := (GetLastError <> ERROR_ALREADY_EXISTS);
	FShareHandle := CreateFileMapping($FFFFFFFF, nil, PAGE_READWRITE or SEC_COMMIT,
		0, ShareSize, PChar(FShareName));
	if (FShareHandle = INVALID_HANDLE_VALUE) or (FShareHandle = 0)
		then RaiseLastWin32Error;
	FSharePointer := MapViewOfFile(FShareHandle, FILE_MAP_ALL_ACCESS, 0, 0, 0);
	if FSharePointer = nil then RaiseLastWin32Error;
	PTextStart := PChar(Integer(FSharePointer) + SizeOf(HWnd));
	WaitForSingleObject(FMutex, INFINITE);
	if FirstInstance then
	begin
		ZeroMemory(FSharePointer, ShareSize);
		CopyMemory(FSharePointer, @FShareWindowHandle, SizeOf(HWnd));
		ReleaseMutex(FMutex);
	end
	else
	begin
		SendToHandle := FSharePointer^;
		FParamStr.Clear;
		for t := 0 to System.ParamCount do FParamStr.Add(System.ParamStr(t));
		if Length(FParamStr.Text) > ShareSize - SizeOf(HWnd) - 1
			then FParamStr.Text := Copy(FParamStr.Text, 1,
			ShareSize - SizeOf(HWnd) - 1);
		TextPointer := FParamStr.GetText;
		CopyMemory(PTextStart, TextPointer, StrLen(TextPointer) + 1);
		StrDispose(TextPointer);
		ReleaseMutex(FMutex);
		PostMessage(SendToHandle, FOneInstanceMessageID, 0, 0);
		if Assigned(FOnTerminating) then FOnTerminating(Self);
		ExitProcess(0);
	end;
end;

procedure TPBShareOneInstance.Dummy(Value : string); begin end;// read-only

procedure	TPBShareOneInstance.WndProc(var FMessage : TMessage);
begin
	with FMessage do
	begin
		if (Msg = FOneInstanceMessageID) then
		begin
			FParamStr.SetText(PTextStart);
			if Assigned(FOnSecondInstance) then FOnSecondInstance(Self);
		end;
		Result := DefWindowProc(FShareWindowHandle, Msg, WParam, LParam);
	end;
end;

end.
