unit PBShareMultiDemo_Unit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	StdCtrls, PBShare, PBShareMulti, Spin, ComCtrls;

type
  TPBShareMultiDemoForm = class(TForm)
		PBShareMulti1: TPBShareMulti;
    Label1: TLabel;
    ReadItem: TButton;
    GroupBox1: TGroupBox;
    Label2: TLabel;
		Label3: TLabel;
    Edit2: TEdit;
		WriteItem: TButton;
		AddItem: TButton;
		DeleteItem: TButton;
		InsertItem: TButton;
		GroupBox2: TGroupBox;
		Label4: TLabel;
		Label5: TLabel;
		Label6: TLabel;
		Edit5: TEdit;
		Edit6: TEdit;
		Edit4: TEdit;
    OkCheckBox: TCheckBox;
    TimePicker1: TDateTimePicker;
    StatusBar1: TStatusBar;
    Add1000: TButton;
    SpinEdit1: TSpinEdit;
		procedure ReadItemClick(Sender: TObject);
		procedure PBShareMulti1DoReadItem(Sender: TObject;
			const Stream: TMemoryStream; const Reader: TPBReader;
			const Index, ItemSize: Integer);
		procedure PBShareMulti1DoWriteItem(Sender: TObject;
			const Stream: TMemoryStream; const Writer: TPBWriter;
			const Index: Integer);
		procedure WriteItemClick(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure AddItemClick(Sender: TObject);
		procedure DeleteItemClick(Sender: TObject);
		procedure InsertItemClick(Sender: TObject);
		procedure ShowComponent;
    procedure PBShareMulti1UpdateAll(Sender: TObject;
			const FromHandle: HWnd; const ExtraInfo: Integer);
    procedure PBShareMulti1UpdateItem(Sender: TObject;
			const FromHandle: HWnd; const Index: Integer;
      const ItemOperation: TMultiOperation);
    procedure Add1000Click(Sender: TObject);
    procedure SpinEdit1Change(Sender: TObject);
    procedure PBShareMulti1Open(Sender: TObject; FirstShare: Boolean);
	private
		{ Private declarations }
	public
		{ Public declarations }
	end;

	TMyRecord = record
		Ok : Boolean;
		Time : TDateTime;
		Str : string;
	end;

var
	PBShareMultiDemoForm: TPBShareMultiDemoForm;
{ This is what you would normally declare:
	MyArray : array of TMyRecord;
	Instead declare just one element: }
	LocalVar : TMyRecord;

implementation

{$R *.DFM}

procedure TPBShareMultiDemoForm.ShowComponent;
begin
	Edit4.Text := IntToStr(PBShareMulti1.Count);
	Edit4.Update;
	Edit5.Text := IntToStr(PBShareMulti1.Capacity);
	Edit5.Update;
	Edit6.Text := IntToStr(PBShareMulti1.Size);
	Edit6.Update;
	SpinEdit1.MaxValue := PBShareMulti1.Count - 1;
	if SpinEdit1.Value > SpinEdit1.MaxValue
		then SpinEdit1.Value := SpinEdit1.MaxValue;
end;

procedure TPBShareMultiDemoForm.SpinEdit1Change(Sender: TObject);
begin
	if StrToIntDef(SpinEdit1.Text, -1) = -1 then SpinEdit1.Value := 0; 
	ReadItemClick(Self);
end;

procedure TPBShareMultiDemoForm.FormCreate(Sender: TObject);
begin
	Randomize;
end;

procedure TPBShareMultiDemoForm.ReadItemClick(Sender: TObject);
var
	Index : integer;
begin
// Get the selected item from shared memory and show it.
	Index := SpinEdit1.Value;
	if Index < PBShareMulti1.Count then
	begin
		PBShareMulti1.ReadItem(Index);
		OkCheckBox.Checked := LocalVar.Ok;
		TimePicker1.Time := LocalVar.Time;
		Edit2.Text := LocalVar.Str;
	end
	else Beep;
	ShowComponent;
end;

procedure TPBShareMultiDemoForm.WriteItemClick(Sender: TObject);
var
	Index : integer;
begin
// Change the item in the shared memory.
	Index := SpinEdit1.Value;
	LocalVar.Ok := OkCheckBox.Checked;
	LocalVar.Time := TimePicker1.Time;
	LocalVar.Str := Edit2.Text;
	if Index < PBShareMulti1.Count then PBShareMulti1.WriteItem(Index)
	else Beep;
	ShowComponent;
end;

procedure TPBShareMultiDemoForm.AddItemClick(Sender: TObject);
begin
// Add the item to the shared memory.
	LocalVar.Ok := OkCheckBox.Checked;
	LocalVar.Time := TimePicker1.Time;
	LocalVar.Str := Edit2.Text;
	SpinEdit1.MaxValue := PBShareMulti1.Count;
	SpinEdit1.Value :=PBShareMulti1.Add;
	ShowComponent;
end;

procedure TPBShareMultiDemoForm.InsertItemClick(Sender: TObject);
var
	Index : integer;
begin
// Insert the item in the shared memory.
	Index := SpinEdit1.Value;
	LocalVar.Ok := OkCheckBox.Checked;
	LocalVar.Time := TimePicker1.Time;
	LocalVar.Str := Edit2.Text;
	if Index < PBShareMulti1.Count then PBShareMulti1.Insert(Index)
	else Beep;
	ShowComponent;
end;

procedure TPBShareMultiDemoForm.DeleteItemClick(Sender: TObject);
var
	Index : integer;
begin
// Delete the item from the shared memory.
	Index := SpinEdit1.Value;
	PBShareMulti1.Delete(Index);
// if the selected index in in the range - show it.
	if Index >= PBShareMulti1.Count then Index := PBShareMulti1.Count - 1;
	if (Index >= 0) and (Index < PBShareMulti1.Count)
		then ReadItemClick(Self)
	else Beep;
	ShowComponent;
end;

procedure TPBShareMultiDemoForm.Add1000Click(Sender: TObject);
var
	t : integer;
begin
// Here you can see the effect of BeginUpdate/EndUpdate.
// The effect is small if only one share is open (like in the OnOpenFirst
// event-handler. Open two or more apps !
// If you comment out the 2 lines the component will still function but
// much slower.
	PBShareMulti1.BeginUpdate;
	for t := 0 to 999 do
	begin
		LocalVar.Ok := Boolean(Random(2));
		LocalVar.Time := Random;
		LocalVar.Str := 'This is String number ' + IntToStr(t)
			+ ' with some nonsens to fill the string so it''s size can be'
			+ ' fairly long - just ignore or read to the end - that is totally'
			+ ' up to you!';
		PBShareMulti1.Add;
	end;
	PBShareMulti1.EndUpdate;
	ReadItemClick(Self);
end;

//  ------  PBShareMulti event handlers  ------------------
procedure TPBShareMultiDemoForm.PBShareMulti1Open(Sender: TObject;
  FirstShare: Boolean);
var
	t : integer;
begin
// Use this Event-handler to fill the entire map with initial values
// for instance load the values from a file or add the variables one by one.
// Call BeginUpdate to temporarily disable synchronization
// (increasing performance). Remember to call EndUpdate.
	if FirstShare then
	begin
		PBShareMulti1.BeginUpdate;
		for t := 0 to 999 do
		begin
			LocalVar.Ok := Boolean(Random(2));
			LocalVar.Time := Random;
			LocalVar.Str := 'This is String number ' + IntToStr(t)
				+ ' with some nonsens to fill the string so it''s size can be'
				+ ' fairly long - just ignore or read to the end - that is totally'
				+ ' up to you!';
			PBShareMulti1.Add;
		end;
		PBShareMulti1.EndUpdate;
		ReadItemClick(Self);
	end;
end;

procedure TPBShareMultiDemoForm.PBShareMulti1DoReadItem(Sender: TObject;
	const Stream: TMemoryStream; const Reader: TPBReader;
	const Index, ItemSize: Integer);
begin
// This eventhandler is a callback proc called for every item.
// Read one item from the stream.
// Either use the stream or the Reader !
	LocalVar.Ok := Reader.ReadBoolean;
	LocalVar.Time := Reader.ReadDateTime;
	LocalVar.Str := Reader.ReadString;
end;

procedure TPBShareMultiDemoForm.PBShareMulti1DoWriteItem(Sender: TObject;
	const Stream: TMemoryStream; const Writer: TPBWriter;
	const Index: Integer);
begin
// This eventhandler is a callback proc called for every item.
// Write one item to the stream.
// Either use the Stream or the Writer !
// When using the Writer - first call 'WriteItemSize' !!!
	PBShareMulti1.WriteItemSize(1, SizeOf(LocalVar.Ok) + SizeOf(LocalVar.Time)
		+ Length(LocalVar.Str));
	Writer.WriteBoolean(LocalVar.Ok);
	Writer.WriteDateTime(LocalVar.Time);
	Writer.WriteString(LocalVar.Str);
end;

procedure TPBShareMultiDemoForm.PBShareMulti1UpdateAll(Sender: TObject;
	const FromHandle: HWnd; const ExtraInfo: Integer);
begin
	ReadItemClick(Self);
	StatusBar1.SimpleText := 'ItemOperation: moWriteAll';
end;

procedure TPBShareMultiDemoForm.PBShareMulti1UpdateItem(Sender: TObject;
	const FromHandle: HWnd; const Index: Integer;
	const ItemOperation: TMultiOperation);
begin
// The Index contains the Index to the changed value!
// ItemOperation describes what has happened to the Item.
// If the index is shown - update it.
	if Index = SpinEdit1.Value then ReadItemClick(Self)
	else ShowComponent;
	StatusBar1.SimpleText := 'Itemindex: ' + IntToStr(Index) + '  ItemOperation: ';
	case ItemOperation of
		moWriteAll : StatusBar1.SimpleText := 'ItemOperation: moWriteAll';
		moAdd : StatusBar1.SimpleText := StatusBar1.SimpleText + 'moAdd';
		moDelete : StatusBar1.SimpleText := StatusBar1.SimpleText + 'moDelete';
		moInsert : StatusBar1.SimpleText := StatusBar1.SimpleText + 'moInsert';
		moWrite : StatusBar1.SimpleText := StatusBar1.SimpleText + 'moWrite';
		else;
	end;
end;

end.
