unit PBShareMemIniDemo_Unit;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	StdCtrls, PBShare, PBShareMemIni;

type
	TPBShareMemIniDemoForm = class(TForm)
		PBShareMemIni1: TPBShareMemIni;
		Memo1: TMemo;
		GetValue: TButton;
		SetValue: TButton;
		Label1: TLabel;
		Label2: TLabel;
		Label3: TLabel;
		Label4: TLabel;
		Edit1: TEdit;
		Edit2: TEdit;
		Edit3: TEdit;
		Clear: TButton;
		Label5: TLabel;
		Deletekey: TButton;
		EraseSection: TButton;
    UpdateFile: TButton;
		procedure GetValueClick(Sender: TObject);
		procedure SetValueClick(Sender: TObject);
		procedure ClearClick(Sender: TObject);
		procedure DeletekeyClick(Sender: TObject);
		procedure EraseSectionClick(Sender: TObject);
		procedure ShowInMemo;
    procedure PBShareMemIni1UpdateAll(Sender: TObject;
			const FromHandle: HWnd; const ExtraInfo: Integer);
    procedure UpdateFileClick(Sender: TObject);
    procedure PBShareMemIni1Open(Sender: TObject; FirstShare: Boolean);
	private
		{ Private declarations }
	public
		{ Public declarations }
	end;

var
	PBShareMemIniDemoForm: TPBShareMemIniDemoForm;

implementation

{$R *.DFM}

procedure TPBShareMemIniDemoForm.ShowInMemo;
begin
// The local MemIniFile (which is exactly equal to all others)
// is shown in the memo as text.
	Memo1.Lines.Clear;
	PBShareMemIni1.MemIni.GetStrings(Memo1.Lines);
end;

procedure TPBShareMemIniDemoForm.GetValueClick(Sender: TObject);
begin
	Edit3.Text := PBShareMemIni1.MemIni.ReadString(Edit1.Text, Edit2.Text, '');
end;

procedure TPBShareMemIniDemoForm.SetValueClick(Sender: TObject);
begin
	PBShareMemIni1.MemIni.WriteString(Edit1.Text, Edit2.Text, Edit3.Text);
// The PBShareMemIni has changed in all open shares !
	ShowInMemo;
end;

procedure TPBShareMemIniDemoForm.ClearClick(Sender: TObject);
begin
	PBShareMemIni1.Clear;
	ShowInMemo;
end;

procedure TPBShareMemIniDemoForm.DeletekeyClick(Sender: TObject);
begin
	PBShareMemIni1.MemIni.Deletekey(Edit1.Text, Edit2.Text);
	ShowInMemo;
end;

procedure TPBShareMemIniDemoForm.EraseSectionClick(Sender: TObject);
begin
	PBShareMemIni1.MemIni.EraseSection(Edit1.Text);
	ShowInMemo;
end;

procedure TPBShareMemIniDemoForm.UpdateFileClick(Sender: TObject);
begin
	PBShareMemIni1.MemIni.UpdateFile;
end;

//  ---------------  PBShareMemIni1  Event-handlers  -------------
procedure TPBShareMemIniDemoForm.PBShareMemIni1UpdateAll(Sender: TObject;
	const FromHandle: HWnd; const ExtraInfo: Integer);
begin
	ShowInMemo;
end;

procedure TPBShareMemIniDemoForm.PBShareMemIni1Open(Sender: TObject;
	FirstShare: Boolean);
begin
	ShowInMemo;
end;

end.
