unit PBShareImagesDemo_Unit;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PBShare, PBShareMulti, PBShareImages, StdCtrls, Buttons, ExtCtrls,
  ComCtrls;

type
	TPBShareImagesDemoForm = class(TForm)
		PBShareImages1: TPBShareImages;
		Play: TButton;
		Stop: TButton;
		AddImage: TButton;
		Label1: TLabel;
		ColorButton: TBitBtn;
		ColorDialog1: TColorDialog;
    Timer1: TTimer;
		TrackBar1: TTrackBar;
    GroupBox1: TGroupBox;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Edit5: TEdit;
    Edit6: TEdit;
    Edit4: TEdit;
    Label2: TLabel;
    Edit1: TEdit;
    LoadButton: TButton;
    SaveButton: TButton;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
		procedure SetGlyph;
		procedure CheckEnabled;
		procedure FormCreate(Sender: TObject);
		procedure ColorButtonClick(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
		procedure AddImageClick(Sender: TObject);
    procedure PlayClick(Sender: TObject);
		procedure Timer1Timer(Sender: TObject);
    procedure StopClick(Sender: TObject);
    procedure PBShareImages1UpdateAll(Sender: TObject;
			const FromHandle: HWnd; const ExtraInfo: Integer);
    procedure TrackBar1Change(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure PBShareImages1UpdateItem(Sender: TObject;
			const FromHandle: HWnd; const Index: Integer;
      const ItemOperation: TMultiOperation);
    procedure PBShareImages1UpdateShareList(Sender: TObject;
      const FromHandle: HWND; const Index: Integer;
      const ItemOperation: TMultiOperation);
    procedure PBShareImages1RemoteControl(Sender: TObject;
      const FromHandle: HWND; const Param: Integer);
    procedure LoadButtonClick(Sender: TObject);
    procedure SaveButtonClick(Sender: TObject);
	private
		{ Private declarations }
	public
		{ Public declarations }
	end;

var
	PBShareImagesDemoForm: TPBShareImagesDemoForm;
	Playing : Boolean;
	ImageIndex : integer;
	Rect0, Rect1, Rect2 : TRect;

implementation

{$R *.DFM}

procedure TPBShareImagesDemoForm.CheckEnabled;
begin
	ColorButton.Enabled := not Playing;
	AddImage.Enabled := not Playing;
	Play.Enabled := (not Playing) and (PBShareImages1.Count > 0);
	Stop.Enabled := Playing;
	Timer1.Enabled := Playing;
	Edit1.Enabled := Playing;
	Edit1.Text := IntToStr(ImageIndex);
	Edit4.Text := IntToStr(PBShareImages1.Count);
	Edit4.Update;
	Edit5.Text := IntToStr(PBShareImages1.Capacity);
	Edit5.Update;
	Edit6.Text := IntToStr(PBShareImages1.Size);
	Edit6.Update;
end;

procedure TPBShareImagesDemoForm.SetGlyph;
var
	TempRect : TRect;
begin
	ColorButton.NumGlyphs := 1;
	ColorButton.Glyph.PixelFormat := pf32bit;
	ColorButton.Glyph.Canvas.Brush.Color := ColorDialog1.Color;
	ColorButton.Glyph.Width := ColorButton.Glyph.Height;
	TempRect := ColorButton.Glyph.Canvas.ClipRect;
	Frame3D(ColorButton.Glyph.Canvas, TempRect, clBtnFace, clBtnFace, 2);
	ColorButton.Glyph.Canvas.FillRect(TempRect);
	PBShareImages1.LocalBitmap.Canvas.Pen.Color := ColorDialog1.Color;
end;

procedure TPBShareImagesDemoForm.FormCreate(Sender: TObject);
begin
	PBShareImages1.LocalBitmap.Width := 400;
	PBShareImages1.LocalBitmap.Height := 300;
	Rect0 := Bounds(5, 45, 420, 320);
	Rect1 := Bounds(15, 55, 400, 300);
	Rect2 := Bounds(15 + TrackBar1.Position, 55, 400 - TrackBar1.Position, 300);
	SetGlyph;
	CheckEnabled;
end;

procedure TPBShareImagesDemoForm.ColorButtonClick(Sender: TObject);
begin
	if ColorDialog1.Execute then
	begin
		PBShareImages1.RemoteControl(Integer(ColorDialog1.Color));
		SetGlyph;
	end;
end;

procedure TPBShareImagesDemoForm.FormPaint(Sender: TObject);
var
	TempRect : TRect;
begin
	TempRect := Rect0;
	Frame3D(Canvas, TempRect, clWhite, clGray, 5);
	Frame3D(Canvas, TempRect, clGray, clWhite, 5);
	Canvas.Draw(15, 55, PBShareImages1.LocalBitmap);
	Canvas.Brush.Color := clWindow;
	Canvas.FillRect(Rect2);
end;

procedure TPBShareImagesDemoForm.FormMouseDown(Sender: TObject;
	Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
	if (ssRight in Shift) then
	begin
		PBShareImages1.LocalBitmap.Canvas.Brush.Color := ColorDialog1.Color;
		PBShareImages1.LocalBitmap.Canvas.FloodFill(X - 15, Y - 55,
			ColorDialog1.Color, fsBorder);
		PBShareImages1.LocalBitmap.Canvas.Brush.Color := clWindow;
		InvalidateRect(Handle, @Rect1, False);
		Update;
	end
	else PBShareImages1.LocalBitmap.Canvas.PenPos := Point(X - 15, Y - 55);
end;

procedure TPBShareImagesDemoForm.FormMouseMove(Sender: TObject;
	Shift: TShiftState; X, Y: Integer);
begin
	if (ssLeft in Shift) then
	begin
		PBShareImages1.LocalBitmap.Canvas.LineTo(X - 15, Y - 55);
		InvalidateRect(Handle, @Rect1, False);
		Update;
	end;
end;

procedure TPBShareImagesDemoForm.TrackBar1Change(Sender: TObject);
begin
	PBShareImages1.LocalBitmap.Width := TrackBar1.Position;
	Rect2 := Bounds(15 + TrackBar1.Position, 55, 400 - TrackBar1.Position, 300);
	InvalidateRect(Handle, @Rect1, False);
	Update;
end;

procedure TPBShareImagesDemoForm.AddImageClick(Sender: TObject);
begin
	PBShareImages1.Add;
	CheckEnabled;
end;

procedure TPBShareImagesDemoForm.PlayClick(Sender: TObject);
begin
	Playing := True;
	CheckEnabled;
end;

procedure TPBShareImagesDemoForm.StopClick(Sender: TObject);
begin
	Playing := False;
	CheckEnabled;
end;

procedure TPBShareImagesDemoForm.Timer1Timer(Sender: TObject);
begin
// A threaded Timer would give better result - but I prefer to use only
// standard components in demos.
	if not Playing then Exit;
	if (PBShareImages1.Count = 0) then StopClick(Self);
	Inc(ImageIndex);
	if ImageIndex >= PBShareImages1.Count then ImageIndex := 0;
	PBShareImages1.ReadItem(ImageIndex); // Reads the local bitmap
// PBShareImages1.LocalBitmap := PBShareImages1.Bitmaps[Imageindex];
// The above will work exactly the same.
	if TrackBar1.Position <> PBShareImages1.LocalBitmap.Width
		then TrackBar1.Position := PBShareImages1.LocalBitmap.Width
	else TrackBar1Change(Self);
	CheckEnabled;
end;

procedure TPBShareImagesDemoForm.FormShow(Sender: TObject);
begin
	CheckEnabled;
end;

procedure TPBShareImagesDemoForm.LoadButtonClick(Sender: TObject);
begin
	if OpenDialog1.Execute
		then PBShareImages1.LoadFromFile(OpenDialog1.FileName);
	CheckEnabled;
end;

procedure TPBShareImagesDemoForm.SaveButtonClick(Sender: TObject);
begin
	if SaveDialog1.Execute
		then PBShareImages1.SaveToFile(SaveDialog1.FileName);
end;

//  -------------------  PBShareImages1 event-handlers  -----------
procedure TPBShareImagesDemoForm.PBShareImages1UpdateAll(Sender: TObject;
	const FromHandle: HWnd; const ExtraInfo: Integer);
begin
	CheckEnabled;
end;

procedure TPBShareImagesDemoForm.PBShareImages1UpdateItem(Sender: TObject;
	const FromHandle: HWnd; const Index: Integer;
	const ItemOperation: TMultiOperation);
begin
	CheckEnabled;
end;

procedure TPBShareImagesDemoForm.PBShareImages1UpdateShareList(
  Sender: TObject; const FromHandle: HWND; const Index: Integer;
  const ItemOperation: TMultiOperation);
begin
	PBShareImages1.RemoteControl(Integer(ColorDialog1.Color), FromHandle);
end;

procedure TPBShareImagesDemoForm.PBShareImages1RemoteControl(
	Sender: TObject; const FromHandle: HWND; const Param: Integer);
begin
	ColorDialog1.Color := TColor(Param);
	SetGlyph;
end;

end.
