unit PBShareImages;

{$INCLUDE PBDefines.inc}

interface

uses
	Windows, Messages, SysUtils, Classes, PBShare, PBShareMulti, PBShareManager,
	Graphics;

type
	TPBShareImages = class(TPBCustomShareMulti)
  private
		{ Private declarations }
		FBitmap : TBitmap;
		function GetBitmaps(const Index : integer) : TBitmap;
		procedure DoReadBitmap(Sender : TObject; const Stream : TMemoryStream;
			const Reader : TPBReader; const Index, ItemSize : integer);
		procedure DoWriteBitmap(Sender : TObject; const Stream : TMemoryStream;
			const Writer : TPBWriter; const Index : integer);
		procedure SetBitmaps(const Index : integer; Value : TBitmap);
	protected
		{ Protected declarations }
	public
		{ Public declarations }
		constructor Create(AOwner : TComponent); override;
		constructor CreateNoOwner(AMapName : string; AAllocBy : integer;
			AFlags : TShareFlags; AOpenNow : Boolean; AShareFunction : TShareFunction;
			AOnClosing : TClosingShareEvent; AOnOpen : TOpenShareEvent;
			AOnUpdateAll : TUpdateAllEvent; AOnUpdateItem : TUpdateItemEvent;
			AOnRemoteControl : TRemoteControlEvent); reintroduce;
		constructor CreateNoEvents(AMapName : string; AAllocBy : integer;
			AFlags : TShareFlags; AOpenNow : Boolean; AShareFunction : TShareFunction;
			AOnClosing : TClosingShareProc; AOnOpen : TOpenShareProc;
			AOnUpdateAll : TUpdateAllProc; AOnUpdateItem : TUpdateItemProc;
			AOnRemoteControl : TRemoteControlProc); reintroduce;
		destructor Destroy; override;
		property LocalBitmap : TBitmap read FBitmap;
		property Bitmaps[const Index : integer] : TBitmap read GetBitmaps
			write SetBitmaps;
	published
		{ Published declarations }
	end;

implementation

//  ----------------  TPBShareImages  -------------------------
constructor TPBShareImages.Create(AOwner : TComponent);
begin
	inherited;
	FBitmap := TBitmap.Create;
	OnDoReadItem := DoReadBitmap;
	OnDoWriteItem := DoWriteBitmap;
end;

constructor TPBShareImages.CreateNoOwner(AMapName : string; AAllocBy : integer;
	AFlags : TShareFlags; AOpenNow : Boolean; AShareFunction : TShareFunction;
	AOnClosing : TClosingShareEvent; AOnOpen : TOpenShareEvent;
	AOnUpdateAll : TUpdateAllEvent;	AOnUpdateItem : TUpdateItemEvent;
	AOnRemoteControl : TRemoteControlEvent);
begin
	inherited CreateNoOwner(AMapName, AAllocBy, AFlags, AShareFunction, AOnClosing,
		AOnOpen, AOnUpdateAll, AOnUpdateItem, AOnRemoteControl);
	FBitmap := TBitmap.Create;
	OnDoReadItem := DoReadBitmap;
	OnDoWriteItem := DoWriteBitmap;
	if AOpenNow then LazyOpenShare;
end;

constructor TPBShareImages.CreateNoEvents(AMapName : string; AAllocBy : integer;
	AFlags : TShareFlags; AOpenNow : Boolean; AShareFunction : TShareFunction;
	AOnClosing : TClosingShareProc; AOnOpen : TOpenShareProc;
	AOnUpdateAll : TUpdateAllProc; AOnUpdateItem : TUpdateItemProc;
	AOnRemoteControl : TRemoteControlProc);
begin
	inherited CreateNoEvents(AMapName, AAllocBy, AFlags, AShareFunction, AOnClosing,
		AOnOpen, AOnUpdateAll, AOnUpdateItem, AOnRemoteControl);
	FBitmap := TBitmap.Create;
	OnDoReadItem := DoReadBitmap;
	OnDoWriteItem := DoWriteBitmap;
	if AOpenNow then LazyOpenShare;
end;

destructor TPBShareImages.Destroy;
begin
	FBitmap.Free;
	FBitmap := nil;
	inherited;
end;

function TPBShareImages.GetBitmaps(const Index : integer) : TBitmap;
begin
	ReadItem(Index);
	Result := FBitmap;
end;

procedure TPBShareImages.DoReadBitmap(Sender : TObject; const Stream : TMemoryStream;
	const Reader : TPBReader; const Index, ItemSize : integer);
begin
	FBitmap.LoadFromStream(Stream);
end;

procedure TPBShareImages.DoWriteBitmap(Sender : TObject; const Stream : TMemoryStream;
	const Writer : TPBWriter; const Index : integer);
begin
	FBitmap.SaveToStream(Stream);
end;


procedure TPBShareImages.SetBitmaps(const Index : integer; Value : TBitmap);
begin
	if Value <> FBitmap then FBitmap.Assign(Value);
	WriteItem(Index);
end;

end.
