unit DLLDemo_Unit;
// A totally useless demo - but it shows how to use PBShare components with a dll.
// The goal could in this case be achieved simply by a function!
// Note InterProcess property is set to False. That way two instances of
// the program will not interfere.
interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, PBShare, StdCtrls;

type
	TDLLDemoForm = class(TForm)
		Label1: TLabel;
		Button1: TButton;
		PBShareSingle1: TPBShareSingle;
		DateTimePicker1: TDateTimePicker;
    InterProcessCheck: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
		procedure PBShareSingle1DoReadAll(Sender: TObject;
			const Stream: TMemoryStream; const Reader: TPBReader;
			const FromHandle: HWnd; const ExtraInfo: Integer);
		procedure PBShareSingle1DoWriteAll(Sender: TObject;
			const Stream: TMemoryStream; const Writer: TPBWriter;
			var ExtraInfo: Integer);
    procedure PBShareSingle1UpdateAll(Sender: TObject;
			const FromHandle: HWnd; const ExtraInfo: Integer);
    procedure Button1Click(Sender: TObject);
    procedure InterProcessCheckClick(Sender: TObject);
	private
		{ Private declarations }
	public
		{ Public declarations }
	end;

	TStatusRecord = packed record // See PBShareSingle1DoWriteAll notes !
		RequestTime : Boolean;
		Time : TDateTime;
	end;

function ChangeInterProcess(Value : Boolean) : integer; stdcall;
	external 'DLLDemoDLL';
function InitDemoDLL : integer; stdcall; external 'DLLDemoDLL';
function FinalizeDemoDLL : integer; stdcall; external 'DLLDemoDLL';

var
	DLLDemoForm: TDLLDemoForm;
	Status : TStatusRecord;

implementation

{$R *.DFM}

procedure TDLLDemoForm.FormCreate(Sender: TObject);
begin
	if InitDemoDLL <> 0 then Raise Exception.Create('Could not initalize DLL !');
end;

procedure TDLLDemoForm.FormDestroy(Sender: TObject);
begin
	FinalizeDemoDLL;
end;

procedure TDLLDemoForm.Button1Click(Sender: TObject);
begin
	Status.RequestTime := True;
	PBShareSingle1.WriteAll;
end;

//  --------------  PBShareSingle1 eventhandlers  ------------------
procedure TDLLDemoForm.PBShareSingle1DoReadAll(Sender: TObject;
	const Stream: TMemoryStream; const Reader: TPBReader;
	const FromHandle: HWnd; const ExtraInfo: Integer);
begin
	Status.RequestTime := Reader.ReadBoolean;
	Status.Time := Reader.ReadDateTime;
end;

procedure TDLLDemoForm.PBShareSingle1DoWriteAll(Sender: TObject;
  const Stream: TMemoryStream; const Writer: TPBWriter;
  var ExtraInfo: Integer);
begin
// The record type is 'packed' so I can directly use SizeOf
// Otherwise - add the size of all elements together. 
	PBShareSingle1.WriteSize(0, SizeOf(Status));
	Writer.WriteBoolean(Status.RequestTime);
	Writer.WriteDateTime(Status.Time);
end;

procedure TDLLDemoForm.PBShareSingle1UpdateAll(Sender: TObject;
	const FromHandle: HWnd; const ExtraInfo: Integer);
begin
	DateTimePicker1.Time := Status.Time;
end;

procedure TDLLDemoForm.InterProcessCheckClick(Sender: TObject);
begin
	PBShareSingle1.CloseShare;
	if InterProcessCheck.Checked
		then PBShareSingle1.Flags := PBShareSingle1.Flags + [sfInterProcess]
	else PBShareSingle1.Flags := PBShareSingle1.Flags - [sfInterProcess];
	PBShareSingle1.OpenShare;
	ChangeInterProcess(InterProcessCheck.Checked);
end;

end.
