library DLLDemoDLL;

uses
	Windows, SysUtils, Classes, PBShare;

type
	TStatusRecord = packed record // See DoWriteAll notes in exe !
		RequestTime : Boolean;
		Time : TDateTime;
	end;

var
	DLLShare : TPBShareSingle;
	Status : TStatusRecord;

procedure DLLShareDoReadAll(Self, Sender: TObject;
	const Stream: TMemoryStream; const Reader: TPBReader;
	const FromHandle: HWnd; const ExtraInfo: Integer);
begin
	Status.RequestTime := Reader.ReadBoolean;
	Status.Time := Reader.ReadDateTime;
end;

procedure DLLShareDoWriteAll(Self, Sender: TObject;
	const Stream: TMemoryStream; const Writer: TPBWriter;
	var ExtraInfo: Integer);
begin
	DLLShare.WriteSize(0, SizeOf(Status));
	Writer.WriteBoolean(Status.RequestTime);
	Writer.WriteDateTime(Status.Time);
end;

procedure DLLShareUpdateAll(Self, Sender: TObject;
	const FromHandle: HWnd; const ExtraInfo: Integer);
begin
	if Status.RequestTime then
	begin
		Status.RequestTime := False;
		Status.Time := Now;
		DLLShare.WriteAll;
	end;
end;

function ChangeInterProcess(Value : Boolean) : integer; stdcall;
begin
	if DllShare = nil then Result := -1
	else
	begin
		DllShare.CloseShare;
		if Value then DllShare.Flags := DllShare.Flags + [sfInterProcess]
		else DllShare.Flags := DllShare.Flags - [sfInterProcess];
		DllShare.OpenShare;
		Result := 0;
	end;
end;

function InitDemoDLL : integer; stdcall;
begin
	try
		DLLShare := TPBShareSingle.CreateNoEvents('PBShare-DLLDemo', 4096,
			[sfUpdateOnOpen],	True, sfAutoSwitch, nil, nil, DLLShareUpdateAll,
			DLLShareDoReadAll, DLLShareDoWriteAll, nil);
		Result := 0;
	except
		Result := -1;
	end;
end;

function FinalizeDemoDLL : integer; stdcall;
begin
	DLLShare.Free;
	DLLShare := nil;
	Result := 0;
end;

{$R *.res}

exports
	ChangeInterProcess,
	InitDemoDLL,
	FinalizeDemoDLL;

begin
end.
 