unit BasicDemo_Unit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PBShare, StdCtrls;

type
  TBasicDemoForm = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Edit1: TEdit;
    PBShareSingle1: TPBShareSingle;
    procedure PBShareSingle1DoReadAll(Sender: TObject;
      const Stream: TMemoryStream; const Reader: TPBReader;
      const FromHandle: HWND; const ExtraInfo: Integer);
    procedure PBShareSingle1DoWriteAll(Sender: TObject;
      const Stream: TMemoryStream; const Writer: TPBWriter;
      var ExtraInfo: Integer);
    procedure FormCreate(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure PBShareSingle1UpdateAll(Sender: TObject;
      const FromHandle: HWND; const ExtraInfo: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
	BasicDemoForm: TBasicDemoForm;

implementation

{$R *.DFM}

procedure TBasicDemoForm.FormCreate(Sender: TObject);
begin
	Edit1.Text := Self.Caption;
end;

procedure TBasicDemoForm.Edit1Change(Sender: TObject);
begin
	if Self.Caption <> Edit1.Text then // to prevent recursion
	begin
		Self.Caption := Edit1.Text;
		PBShareSingle1.WriteAll;
	end;
end;

procedure TBasicDemoForm.FormResize(Sender: TObject);
begin
	PBShareSingle1.WriteAll;
end;

//  -------------  PBShareSingle1 event-handlers  ---------------
procedure TBasicDemoForm.PBShareSingle1DoReadAll(Sender: TObject;
	const Stream: TMemoryStream; const Reader: TPBReader;
	const FromHandle: HWND; const ExtraInfo: Integer);
begin
	Self.Height := Reader.ReadInteger;
	Self.Width := Reader.ReadInteger;
	Self.Caption := Reader.ReadString;
end;

procedure TBasicDemoForm.PBShareSingle1DoWriteAll(Sender: TObject;
	const Stream: TMemoryStream; const Writer: TPBWriter;
	var ExtraInfo: Integer);
begin
	PBShareSingle1.WriteSize(1, 2 * SizeOf(Integer) + Length(Self.Caption));
	Writer.WriteInteger(Self.Height);
	Writer.WriteInteger(Self.Width);
	Writer.WriteString(Self.Caption);
end;

procedure TBasicDemoForm.PBShareSingle1UpdateAll(Sender: TObject;
  const FromHandle: HWND; const ExtraInfo: Integer);
begin
	Edit1.Text := Self.Caption;
end;

end.
