unit Intro;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls;

type
  TIntroduction = class(TForm)
    RichEdit1: TRichEdit;
    Label1: TLabel;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Introduction: TIntroduction;

implementation

{$R *.DFM}

procedure TIntroduction.FormCreate(Sender: TObject);
begin
  With RichEdit1.Lines, RichEdit1 do
  begin
    Clear;
    SelAttributes.Color := RGB(51,51,153);
    SelAttributes.Size := 14;
    Add('Welcome to Data Miner - an artificial inteligence tool');
    Add('');
    Paragraph.Numbering := nsBullet;
    Paragraph.FirstIndent := 10;
    Add('The package presents a set of classification algorithms with top of the class, classification accuracy');
    Add('Offers top performance designed to handle huge amounts of data in real time');
    Add('All included  algorithms feature incremental learning. Ideal for dynamic systems.');
    Add('Common database interface');
    Add('Works with real valued and discrete attributes');
    Add('Automatically selects best attributes with pruning');
    Add('Solves the problem of majority class prevalence');
    Add('Plug & play. One button learn and classify');
    Add('100% VCL');    
    Paragraph.Numbering := nsNone;
    Paragraph.FirstIndent := 0;
    Add('');
    SelAttributes.Style := [fsItalic];
    Add('Navigate through the demo application, to learn more about the ' +
        'Data Miner and experience it''s performance and ease of use. ' +
        'Even if you have no prior expirience in artificial inteligence '+
        'methods, you will learn how to make use of them.');
  end;
  TButton(Self.Owner.FindComponent('btnHelp')).Enabled := false;
end;

initialization
  RegisterClass(TIntroduction);
end.
