unit ClassifyInterface;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Basic2, StdCtrls, Grids, DBGrids, DB, DBTables, ComCtrls,
  ExtCtrls, DBClassifier, Classifier;

type
  TInterfaceForm = class(TBasicForm2)
    DataSource1: TDataSource;
    UserTable: TTable;
    DataDBGrid: TDBGrid;
    Label3: TLabel;
    TablesBox: TComboBox;
    IDLabel: TLabel;
    GuessedClassLabel: TLabel;
    ActualClassLabel: TLabel;
    ClassifierGroup: TRadioGroup;
    LC: TLinearClassifier;
    NB: TNaiveBayes;
    KNN: TKNearestNeighbors;
    DBLC: TDBClassifier;
    procedure UserTableAfterScroll(DataSet: TDataSet);
    procedure TablesBoxChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ClassifierGroupClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  InterfaceForm: TInterfaceForm;

implementation

{$R *.dfm}

procedure TInterfaceForm.UserTableAfterScroll(DataSet: TDataSet);
begin
    IDLabel.Caption := 'ID: ' + IntToStr(UserTable['ID']);
    if not DBLC.IsUpdating then
    GuessedClassLabel.Caption := 'Guessed class: ' + DBLC.ClassifyRecord;
    ActualClassLabel.Caption := 'Actual class: ' + FloatToStr(UserTable['Class']);
end;

procedure TInterfaceForm.TablesBoxChange(Sender: TObject);
begin
    DBLC.Clear;
    UserTable.Close;
    UserTable.TableName := TablesBox.Text;
    UserTable.Open;
    DBLC.LearnData;
end;

procedure TInterfaceForm.FormCreate(Sender: TObject);
var TableNames: TStringList;
    ADir, AName: string;
    i: integer;
begin
    inherited;
    ADir := ExtractFileDir(Application.ExeName)+'\Data';
    AName := 'DewAIDataD';
    TableNames := TStringList.Create;
    try
        UserTable.Close;
        Session.GetAliasNames(TableNames);
        TableNames.Sort;
        if not TableNames.Find(AName,i) then
        begin
             Session.AddStandardAlias(AName,ADir, 'PARADOX');
        end;
        UserTable.DatabaseName := AName;
        Session.GetTableNames(AName,'*.DB',True,false, TableNames);
        TablesBox.Items.Assign(TableNames);
        TablesBox.ItemIndex := 6;
        TablesBoxChange(Sender);
    finally
        TableNames.Destroy;
    end;
    With RichEdit1.Lines, RichEdit1 do
    begin
      Clear;
      Add('The example below illustrates a possible user interface for classification. ' +
          'The purpose of classification is to guess a yet unknown value of a field  ' +
          'by looking at values of other fields. Such a guess can be a good only, if there is a relation (some hidden connection) ' +
          'between values of other fields and the value of the Class field in cases where the value of the Class field is already known. ' +
          'The classification algorithm tries to find that connection, but is not able to express the found connection explicitly. ' +
          'The knowledge about the "hidden connection" is stored internally by the algorithm in forms of some statistics, estimated weights etc.. ' +
          'To check, if the algorithm was able to find the "hidden connection" you should run a classification test. ' +
          'Now lets get back to the example below. ' +
          'When the user selects a table from the dropdown box, the data in that table is immediatelly opened and ' +
          'processed (learned). When the user clicks a record in the table, that record is classified and the label ' +
          'below the table displayes the guessed value of the Class field. In real world application, the learn data and the examples ' +
          'to be classified might be in different tables and the Class field for the new examples would not ' +
          'be known. The tables also contain SplitXX fields. This fields are used to for testing classification accuracy ' +
          'and are not part of the valid data. All data in the tables is indexed. This means, that you will not find ' +
          'string descriptions in the fields, but only numbers. For example: a field "Color" will not have ' +
          'items like: Red, Blue, Yellow. They have been replaced with numbers like this: 0 (for red) ,1 (for green) , 2 (yellow). ');
    end;
    TButton(Self.Owner.FindComponent('btnHelp')).Enabled := false;
end;

procedure TInterfaceForm.ClassifierGroupClick(Sender: TObject);
begin
     case ClassifierGroup.ItemIndex of
     0: DBLC.Classifier := LC;
     1: DBLC.Classifier := NB;
     2: DBLC.Classifier := KNN;
     end;
     TablesBoxChange(Sender);
end;

initialization
   RegisterClass(TInterfaceForm);
finalization
   UnRegisterClass(TInterfaceForm);
end.
