unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, AczTreeView, Buttons, Grids, Db, DBTables, ImgList;

const
  FileNameDefined = '.\AczTreeFile';
type
  TFormDemo = class(TForm)
    AczTreeView1: TAczTreeView;
    ButtonSaveTree: TSpeedButton;
    GroupAddLeafNode: TGroupBox;
    Label3: TLabel;
    EditNewLeafName: TEdit;
    ButtonAddNode: TButton;
    GroupSelected: TGroupBox;
    Label1: TLabel;
    EditSelectedID: TEdit;
    ButtonGetNodeID: TButton;
    Label2: TLabel;
    MemoSelectedPath: TMemo;
    ButtonGetSelectedPath: TButton;
    Label4: TLabel;
    EditParentID: TEdit;
    ButtonGetParentID: TButton;
    Label7: TLabel;
    EditNewURL: TEdit;
    Label8: TLabel;
    EditNewLang: TEdit;
    Label5: TLabel;
    EditURL: TEdit;
    Label6: TLabel;
    EditLang: TEdit;
    ButtonGetOtherInfo: TButton;
    ButtonDeleteNode: TButton;
    GroupBoxAddGroupNode: TGroupBox;
    Label9: TLabel;
    EditNewGroupName: TEdit;
    ButtonAddGroupNode: TButton;
    ImageList1: TImageList;
    ButtonLoadTree: TSpeedButton;
    ButtonLoadExpandedTree: TSpeedButton;
    ButtonClearTree: TSpeedButton;
    ButtonQuit: TSpeedButton;
    UserTable: TTable;
    procedure ButtonLoadTreeClick(Sender: TObject);
    procedure ButtonSaveTreeClick(Sender: TObject);
    procedure ButtonAddLeafNodeClick(Sender: TObject);
    procedure ButtonGetNodeIDClick(Sender: TObject);
    procedure ButtonGetSelectedPathClick(Sender: TObject);
    procedure ButtonClearTreeClick(Sender: TObject);
    procedure ButtonGetParentIDClick(Sender: TObject);
    procedure ButtonQuitClick(Sender: TObject);
    procedure ButtonGetOtherInfoClick(Sender: TObject);
    procedure ButtonDeleteNodeClick(Sender: TObject);
    procedure AczTreeView1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ButtonAddGroupNodeClick(Sender: TObject);
    procedure ClearAllEdit;
    procedure ButtonLoadExpandedTreeClick(Sender: TObject);
    procedure AczTreeView1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FormDemo: TFormDemo;

implementation

{$R *.DFM}


procedure TFormDemo.ButtonSaveTreeClick(Sender: TObject);
begin
  { Checking }
  if AczTreeView1.Items.Count = 0 then
    ShowMessage( ' There is no tree node to save !' )
  else
  { Call SaveTree procedure of AczTreeView1 to save the tree to the file }
    AczTreeView1.SaveTree(FileNameDefined);
  ClearAllEdit;
end;

procedure TFormDemo.ButtonLoadTreeClick(Sender: TObject);
begin
{ AczTreeView1.Items.Clear; }

  { Call LoadTree procedure of AczTreeView1 to load all nodes of the tree from the file,
    when having been loaded, all nodes are not expanded. }
  AczTreeView1.LoadTree(FileNameDefined);
  ClearAllEdit;
end;

procedure TFormDemo.ButtonLoadExpandedTreeClick(Sender: TObject);
begin
{ AczTreeView1.Items.Clear; }

  { Call LoadExpandedTree procedure of AczTreeView1 to load all nodes of the tree from the file,
    when having been loaded, all nodes are expanded or not expanded as they were saved. }
  AczTreeView1.LoadExpandedTree(FileNameDefined);
  ClearAllEdit;
end;

procedure TFormDemo.ButtonAddLeafNodeClick(Sender: TObject);
var
  NewNode: TTreeNode;
  NodeID: integer;
begin
  { Checking }
  if EditNewLeafName.GetTextLen = 0 then
  begin
    ShowMessage( 'There is no node name specified !' );
    exit;
  end;
  if EditNewURL.GetTextLen = 0 then
  begin
    ShowMessage( 'There is no URL specified !' );
    exit;
  end;
  if EditNewLang.GetTextLen = 0 then
  begin
    ShowMessage( 'There is no language specified !' );
    exit;
  end;
  if AczTreeView1.Items.Count = 0 then
  begin
    ShowMessage( 'There is not a root group !' );
    exit;
  end;

  { Call AddNewNode function of the AczTreeView1 to add a new node to the tree }
  NewNode := AczTreeView1.AddNewNode(AczTreeView1.Selected, EditNewLeafName.Text);
  NewNode.ImageIndex := 3;
  NewNode.SelectedIndex := 3;

  { Insert the node's information into User's Table }
  NodeID := AczTreeView1.GetNodeID( NewNode );
  if ( Length(EditNewURL.Text)>0 ) and ( Length(EditNewLang.Text)>0 ) then
  with UserTable do
  begin
    try
      DisableControls;
      Open;
      Edit;
      Insert;
      FieldByName( 'NodeID' ).AsInteger := NodeID;
      FieldByName( 'URL' ).AsString := EditNewURL.Text;
      FieldByName( 'Language' ).AsString := EditNewLang.Text;
      post;
      Close;
      EnableControls;
    except
      ShowMessage('Updating Table Urlbook Error');
    end;
  end;
  EditNewLeafName.Clear;
  EditNewURL.Clear;
  EditNewLang.Clear;
end;

procedure TFormDemo.ButtonGetNodeIDClick(Sender: TObject);
begin
  { Checking }
  if ( AczTreeView1.Items.Count = 0 ) or ( AczTreeView1.Selected = nil ) then
  begin
    ShowMessage( 'There is no node selected !' );
    exit;
  end;
  { Call GetNodeID function of AczTreeView1 to get the ID of currently selected node }
  EditSelectedID.Text := IntToStr( AczTreeView1.GetNodeID(AczTreeView1.Selected) );
end;

procedure TFormDemo.ButtonGetSelectedPathClick(Sender: TObject);
begin
  { Checking }
  if ( AczTreeView1.Items.Count = 0 ) or ( AczTreeView1.Selected = nil ) then
  begin
    ShowMessage( 'There is no node selected !' );
    exit;
  end;
  { Call GetPath function of AczTreeView1 to get the path of currently selected node }
  with MemoSelectedPath do
  begin
    Clear;
    Lines.Add( '' );
    Lines[1] := AczTreeView1.GetPath( AczTreeView1.Selected );
  end;
end;

procedure TFormDemo.ButtonClearTreeClick(Sender: TObject);
begin
  AczTreeView1.Items.Clear;
  ClearAllEdit;
end;

procedure TFormDemo.ButtonGetParentIDClick(Sender: TObject);
begin
  { Checking }
  if ( AczTreeView1.Items.Count = 0 ) or ( AczTreeView1.Selected = nil ) then
  begin
    ShowMessage( 'There is no node selected !' );
    exit;
  end;
  { Call GetNodeID function of AczTreeView1 to get the ID of the parent node of currently selected node }
  EditParentID.Text := IntToStr( AczTreeView1.GetNodeID( AczTreeView1.Selected.Parent ) );
end;

procedure TFormDemo.ButtonQuitClick(Sender: TObject);
begin
  AczTreeView1.Free;
  FormDemo.Close;
end;

procedure TFormDemo.ButtonGetOtherInfoClick(Sender: TObject);
begin
  { Checking }
  if ( AczTreeView1.Items.Count = 0 ) or ( AczTreeView1.Selected = nil ) then
  begin
    ShowMessage( 'There is no node selected !' );
    exit;
  end;
  if AczTreeView1.Selected.HasChildren then
  begin
    ShowMessage( 'The selected node is not a leaf !' );
    exit;
  end;
  { At first call function GetNodeID of AczTreeView1 to get the ID of currently selected node,
    then use the node's ID as a key value to search information in the user's table }
  with UserTable do
  begin
    try
      Open;
      Setkey;
      FieldByName( 'NodeID' ).AsInteger := AczTreeView1.GetNodeID( AczTreeView1.Selected );
      if GotoKey then
      begin
        EditURL.Text  := FieldByName( 'URL' ).AsString ;
        EditLang.Text := FieldByName( 'Language' ).AsString ;
      end
      else
        ShowMessage( 'This node was made to point to no URL information when added to the tree !' );
      Close;
    except
      ShowMessage( 'Read Table Urlbook Error' );
    end;
  end;
end;

procedure TFormDemo.ButtonDeleteNodeClick(Sender: TObject);
begin
  { Checking }
  if ( AczTreeView1.Items.Count = 0 ) or ( AczTreeView1.Selected = nil ) then
  begin
    ShowMessage( 'There is no node selected !' );
    exit;
  end;

  { Delete the record in the user's table according to the key value: node's ID }
  with UserTable do
  begin
    try
      DisableControls;
      Open;
      Edit;
      Setkey;
      FieldByName( 'NodeID' ).AsInteger := AczTreeView1.GetNodeID( AczTreeView1.Selected );
      if GotoKey then
        Delete
      else
        ShowMessage( 'This node was made to point to no URL information when added to the tree !' );
      Close;
      EnableControls;
    except
      ShowMessage( 'Read Table Urlbook Error' );
    end;
  end; { with UserTable }

  { Delete the node selected }
  try
    AczTreeView1.Selected.Delete;
  except
    ShowMessage( 'Delete selected node error !' );
  end;
end;

procedure TFormDemo.AczTreeView1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  ClearAllEdit;
end;

procedure TFormDemo.ButtonAddGroupNodeClick(Sender: TObject);
var
  NewNode: TTreeNode;
begin
  { Checking }
  if EditNewGroupName.GetTextLen = 0 then
  begin
    ShowMessage( 'There is no node name specified !' );
    exit;
  end;

  { Call AddNewNode function of AczTreeView1 to add a new node to the tree }
  if AczTreeView1.Items.Count = 0 then
  begin
    NewNode := AczTreeView1.AddNewNode(nil, EditNewGroupName.Text);
    NewNode.ImageIndex := 0;
    NewNode.SelectedIndex := 0;
  end
  else
  begin
    NewNode := AczTreeView1.AddNewNode(AczTreeView1.Selected, EditNewGroupName.Text);
    NewNode.ImageIndex := 1;
    NewNode.SelectedIndex := 2;
  end;
  ClearAllEdit;
end;

procedure TFormDemo.ClearAllEdit;
begin
  EditNewGroupName.Clear;
  EditNewLeafName.Clear;
  EditNewURL.Clear;
  EditNewLang.Clear;
  EditSelectedID.Clear;
  MemoSelectedPath.Clear;
  EditParentID.Clear;
  EditURL.Clear;
  EditLang.Clear;
end;

procedure TFormDemo.AczTreeView1Click(Sender: TObject);
begin
  ClearAllEdit;
end;

procedure TFormDemo.FormCreate(Sender: TObject);
begin
 { AczTreeView1.RegisterAcz ('Your Serial Number', 'Your Active Number'); }
end;

end.
