unit DemoU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StatusbarDA, ImgList, DBCtrls, Db, StdCtrls, Mask, DBTables,
  ComCtrls, Menus;

type
  TStatusbarDemoWnd = class(TForm)
    Statusbar: TStatusbarDA;
    ilSB: TImageList;
    bvlDA: TBevel;
    imgDA: TImage;
    pgcStatus: TPageControl;
    tsTestet: TTabSheet;
    lblDBName: TLabel;
    lblDBCapital: TLabel;
    lblDBCont: TLabel;
    lblDBArea: TLabel;
    bvlData: TBevel;
    edtDBName: TDBEdit;
    edtDBCapital: TDBEdit;
    edtDBCont: TDBEdit;
    edtDBArea: TDBEdit;
    dbNav: TDBNavigator;
    tblTest: TTable;
    tblTestName: TStringField;
    tblTestCapital: TStringField;
    tblTestContinent: TStringField;
    tblTestArea: TFloatField;
    tblTestPopulation: TFloatField;
    dtsTest: TDataSource;
    bvlProgress: TBevel;
    ScrollBar: TScrollBar;
    tsNew: TTabSheet;
    bvlNew: TBevel;
    cboAlignment: TComboBox;
    chkAutoSize: TCheckBox;
    chkEnabled: TCheckBox;
    chkVisible: TCheckBox;
    cboBevel: TComboBox;
    pnlFont: TPanel;
    btnFont: TButton;
    FontDlg: TFontDialog;
    edtHint: TEdit;
    cboHintStyle: TComboBox;
    cboImage: TComboBox;
    cboStyle: TComboBox;
    edtText: TEdit;
    edtWidth: TEdit;
    udWidth: TUpDown;
    lblAlignment: TLabel;
    lblBevel: TLabel;
    lblFont: TLabel;
    lblHint: TLabel;
    lblHintStyle: TLabel;
    lblImage: TLabel;
    lblStyle: TLabel;
    lblText: TLabel;
    lblWidth: TLabel;
    bvlSep01: TBevel;
    bvlSep02: TBevel;
    lblMin: TLabel;
    edtMin: TEdit;
    udMin: TUpDown;
    lblMax: TLabel;
    edtMax: TEdit;
    udMax: TUpDown;
    lblPosition: TLabel;
    edtPosition: TEdit;
    udPosition: TUpDown;
    btnAdd: TButton;
    lblField: TLabel;
    cboField: TComboBox;
    lblName: TLabel;
    edtName: TEdit;
    Label1: TLabel;
    pmTest: TPopupMenu;
    Item11: TMenuItem;
    Item21: TMenuItem;
    Item31: TMenuItem;
    Item41: TMenuItem;
    Item51: TMenuItem;
    Item61: TMenuItem;
    Item71: TMenuItem;
    Item81: TMenuItem;
    Label2: TLabel;
    Bevel1: TBevel;
    Label3: TLabel;
    btnDataset: TButton;
    Panel1: TPanel;
    procedure ScrollBarChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure cboImageDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure btnFontClick(Sender: TObject);
    procedure btnAddClick(Sender: TObject);
    procedure cboStyleChange(Sender: TObject);
    procedure StatusbarPanels5DblClick(StatusBar: TCustomStatusBarDA;
      Panel: TPanelItem);
    procedure StatusbarPanels0Click(StatusBar: TCustomStatusBarDA;
      Panel: TPanelItem);
    procedure btnDatasetClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  StatusbarDemoWnd: TStatusbarDemoWnd;

implementation

{$R *.DFM}

procedure TStatusbarDemoWnd.ScrollBarChange(Sender: TObject);
var
  I: Integer;
begin
  Statusbar.PanelByName('Pregress').Position := ScrollBar.Position;
  for I := 0 to Statusbar.Panels.Count - 1 do
    if Statusbar.Panels[I].Style = psProgress then
      Statusbar.Panels[I].Position := ScrollBar.Position;
end;

procedure TStatusbarDemoWnd.FormCreate(Sender: TObject);
var
  I: Integer;
begin
  for I := -1 to ilSB.Count - 1 do
    cboImage.Items.Add(IntToStr(I));
  cboField.Items.Add('< NONE >');
  for I := 0 to tblTest.FieldCount - 1 do
    cboField.Items.Add(tblTest.Fields[I].DisplayLabel);
  // Setting Defaults
  cboAlignment.ItemIndex := 0;
  cboBevel.ItemIndex := 1;
  cboHintStyle.ItemIndex := 0;
  cboImage.ItemIndex := 0;
  cboStyle.ItemIndex := 0;
  cboField.ItemIndex := 0;
end;

procedure TStatusbarDemoWnd.cboImageDrawItem(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
var
  S: string;
  R: TRect;
begin
  with cboImage do
  begin
    S := IntToStr(Index - 1);
    R := Rect;
    R.Left := R.Left + ilSB.Width + 6;
    Canvas.FillRect(Rect);
    if Index > 0 then
      ilSB.Draw(Canvas, Rect.Left + 2, Rect.Top, Index - 1);
    DrawText(Canvas.Handle, PChar(S), Length(S), R, DT_SINGLELINE or
      DT_VCENTER);
  end;
end;

procedure TStatusbarDemoWnd.btnFontClick(Sender: TObject);
begin
  FontDlg.Font.Assign(pnlFont.Font);
  if FontDlg.Execute then
    pnlFont.Font.Assign(FontDlg.Font);
end;

procedure TStatusbarDemoWnd.cboStyleChange(Sender: TObject);
begin
  chkAutoSize.Enabled := TPanelStyle(cboStyle.ItemIndex) = StatusbarDA.psText;
end;

procedure TStatusbarDemoWnd.btnAddClick(Sender: TObject);
begin
  with TPanelItem.Create(Statusbar.Panels) do
  begin
    Alignment := TAlignment(cboAlignment.ItemIndex);
    AutoSize := chkAutoSize.Enabled;
    Enabled := chkEnabled.Enabled;
    Visible := chkVisible.Enabled;
    Bevel := TPanelBevel(cboBevel.ItemIndex);
    Font.Assign(pnlFont.Font);
    Hint := edtHint.Text;
    HintStyle := TPanelHintStyle(cboHintStyle.ItemIndex);
    ImageIndex := cboImage.ItemIndex - 1;
    Style := TPanelStyle(cboStyle.ItemIndex);
    if TPanelStyle(cboStyle.ItemIndex) = StatusbarDA.psText then
      Text := edtText.Text;
    Width := udWidth.Position;
    Min := udMin.Position;
    Max := udMax.Position;
    Position := udPosition.Position;
    if cboField.ItemIndex > 0 then
      FieldName := cboField.Text;
    Name := edtName.Text;
  end;
end;

procedure TStatusbarDemoWnd.StatusbarPanels5DblClick(
  StatusBar: TCustomStatusBarDA; Panel: TPanelItem);
begin
 ShowMessage('You have double clicked Time Panel');
end;

procedure TStatusbarDemoWnd.StatusbarPanels0Click(
  StatusBar: TCustomStatusBarDA; Panel: TPanelItem);
begin
 ShowMessage('You have clicked Dataset State Panel');
end;

procedure TStatusbarDemoWnd.btnDatasetClick(Sender: TObject);
begin
  tblTest.Active := not tblTest.Active;
  if tblTest.Active then
    btnDataset.Caption := 'Close Dataset'
  else
    btnDataset.Caption := 'Open Dataset';
end;

end.
