{ ****************************************************************
  Info               :  Property Editor for X2000 Components
                        Freeware

  Source File Name   :  X2000PropEdit.PAS
  Author             :  Baldemaier Florian (Baldemaier.Florian@gmx.net)
  Compiler           :  Delphi 5.0 Professional

**************************************************************** }
unit x2000PropEdit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DsgnIntf;

type
  TAbout2000XEditor = class(TDefaultEditor)
  protected
    procedure EditProperty(PropertyEditor: TPropertyEditor;
      var Continue, FreeEditor: Boolean); override;
  public
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
  end;

  TAbout2000X=class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue: string; override;
  end;

implementation

uses X2000About;

{$I X2000.INC}
{ TAbout2000XEditor }

procedure TAbout2000XEditor.EditProperty(PropertyEditor: TPropertyEditor; var Continue, FreeEditor: Boolean);
var
  PropName: string;
begin
  PropName := Uppercase(PropertyEditor.GetName);
  if (CompareText(PropName, 'ABOUT') = 0) then
  begin
    PropertyEditor.Edit;
    Continue := False;
  end;
end;

function TAbout2000XEditor.GetVerbCount: Integer;
begin
  Result := 1;
end;

function TAbout2000XEditor.GetVerb(Index: Integer): string;
begin
  if Index = 0 then Result := 'About ...' else Result := '';
end;

procedure TAbout2000XEditor.ExecuteVerb(Index: Integer);
begin
  if Index = 0 then Edit;
end;

{ TAbout2000X }

procedure TAbout2000X.Edit;
begin
 with TX2000AboutForm.Create(Application) do begin
  try
    Label2.caption:='Version '+ProgrammVersion;
    Label6.caption:='Build '+ProgrammBuild;
    Refresh;
    ShowModal;
  finally
    Free;
  end;
 end;
end;

function TAbout2000X.GetAttributes: TPropertyAttributes;
begin
    Result := [paMultiSelect, paDialog, paReadOnly];
end;

function TAbout2000X.GetValue: string;
begin
    Result := '(X2000)';
end;

end.
