{ ****************************************************************
  Info               :  X2000 Components
                        Freeware

  Source File Name   :  X2000.PAS
  Author             :  Baldemaier Florian (Baldemaier.Florian@gmx.net)
  Compiler           :  Delphi 5.0 Professional
  Decription         :  This file register all tools from X2000

  Thanks for helping :  Andreas Windisch   (wist@gmx.de)
                        Greg Nixon         (greg@nzcs.co.nz)
                        Gregory L. Bullock (bullock@mbay.net)
                        John McKnight      (Johnmc@ncilp.com)
**************************************************************** }
unit x2000;

interface

uses
   ShellAPI, Windows, Messages, SysUtils, Graphics, Controls, Forms, Classes,
   DsgnIntf, Dialogs;

{$I x2000.inc}

type
  TXFileNameProperty = class(TStringProperty)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
  end;

procedure Register;
procedure Regit;

const
  SPage_X2000SysInfo = String('X2000 SystemInfo');
  SPage_X2000Tools = String('X2000 Tools');
  SPage_X2000Dialogs = String('X2000 Dialogs');

implementation

uses
 X2000SystemInfo,
 X2000FileCompress,
 X2000DiskInfo,
 X2000RemoveCaption,
 X2000Label,
 X2000LabelGC,
 X2000RunOnce,
 X2000IconGrabber,
 X2000NetCardInfo,
 X2000ScreenSaverPasswort,
 X2000FindDialog,
 X2000ExitDialog,
 X2000RunDialog,
 X2000IconDialog,
 X2000OpenDialog,
 X2000AnalogMeter,
 X2000Fontboxes,
 X2000Gradient,
 X2000TrayIcon,
 X2000Base64,
 X2000StringCrypt,
 X2000FindFile,
 X2000Registry,
 X2000CpuInfo,
 X2000DisplayInfo,
 X2000Motherboard,
 X2000Controls,
 X2000PropEdit,
 X2000AboutInfo,
 Offbtn;

procedure TXFileNameProperty.Edit;
begin
  with TOpenDialog.Create(Application) do
  begin
    filename := ExtractFileName(GetValue);
    InitialDir := ExtractFilePath(GetValue);
    if Execute then SetValue(FileName);
    Free
  end;
end;

function TXFileNameProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paMultiSelect, paDialog];
end;

procedure Register;
var
  aVersion: TOSVersionInfo;
  a: boolean;
begin
  aVersion.dwOSVersionInfoSize:= SizeOf(aVersion);
  a:= GetVersionEx(aVersion) and (aVersion.dwPLatformId = VER_PLATFORM_WIN32_NT);
  if a then
   {$DEFINE NT}
  else
   {$DEFINE WIN98};

  {$IFDEF DELPHI5}
     Regit;
     exit;
  {$ENDIF}

  {$IFDEF DELPHI4}
     Regit;
     exit;
  {$ENDIF}

  {$IFDEF DELPHI3}
    MessageDlg('Sorry no Delphi 1,2,3 support. Only Delphi 4 or 5 supported.', mtWarning, [mbOk], 0);
    exit;
  {$ENDIF}

  {$IFDEF DELPHI2}
    MessageDlg('Sorry no Delphi 1,2,3 support. Only Delphi 4 or 5 supported.', mtWarning, [mbOk], 0);
    exit;
  {$ENDIF}

  {$IFDEF DELPHI1}
    MessageDlg('Sorry no Delphi 1,2,3 support. Only Delphi 4 or 5 supported.', mtWarning, [mbOk], 0);
    exit;
  {$ENDIF}
  MessageDlg('Ups, please write the author about this problem. ', mtWarning, [mbOk], 0);

end;

procedure Regit;
begin
    //Property Editors
    RegisterPropertyEditor(TypeInfo(HKEY), TRegistry2000X, 'RootKey', TKeyProperty);
    RegisterPropertyEditor(TypeInfo(TAboutInfo2000X), nil, 'About', TAbout2000X);
    RegisterPropertyEditor(TypeInfo(TFileName), nil, '', TXFileNameProperty);

    //SystemInfo
    {$IFDEF WIN98}
      //TSystemInfo2000X supports only in Win98 or Win98 SE
      RegisterComponents(SPage_X2000SysInfo, [TSystemInfo2000X]);
      RegisterComponents(SPage_X2000SysInfo, [TCpuInfo2000X]);
      RegisterComponents(SPage_X2000SysInfo, [TDisplayInfo2000X]);
      RegisterComponents(SPage_X2000SysInfo, [TMotherboardInfo2000X]);

      RegisterComponentEditor(TSystemInfo2000X, TAbout2000XEditor);
      RegisterComponentEditor(TCpuInfo2000X, TAbout2000XEditor);
      RegisterComponentEditor(TDisplayInfo2000X, TAbout2000XEditor);
      RegisterComponentEditor(TMotherboardInfo2000X, TAbout2000XEditor);
    {$ENDIF}
    RegisterComponents(SPage_X2000SysInfo, [TDiskInfo2000X]);
    RegisterComponents(SPage_X2000SysInfo, [TNetCardInfo2000X]);

    RegisterComponentEditor(TDiskInfo2000X, TAbout2000XEditor);
    RegisterComponentEditor(TNetCardInfo2000X, TAbout2000XEditor);

    //Tools
    {$IFDEF WIN98}
     RegisterComponents(SPage_X2000Tools, [TScrPass2000X]);
     RegisterComponentEditor(TScrPass2000X, TAbout2000XEditor);
    {$ENDIF}

    RegisterComponents(SPage_X2000Tools, [TOffice97Button]);
    RegisterComponents(SPage_X2000Tools, [TRunOnce2000X]);
    RegisterComponents(SPage_X2000Tools, [TIconGrabber2000X]);
    RegisterComponents(SPage_X2000Tools, [TFileCompress2000X]);
    RegisterComponents(SPage_X2000Tools, [TRemoveCaption2000X]);
    RegisterComponents(SPage_X2000Tools, [TLabel2000X]);
    RegisterComponents(SPage_X2000Tools, [TLabelGC2000X]);
    RegisterComponents(SPage_X2000Tools, [TAnalogMeter2000X]);
    RegisterComponents(SPage_X2000Tools, [TFontComboBox2000X]);
    RegisterComponents(SPage_X2000Tools, [TFontListBox2000X]);
    RegisterComponents(SPage_X2000Tools, [TSwComboColor2000X]);
    RegisterComponents(SPage_X2000Tools, [TGradientButton2000X]);
    RegisterComponents(SPage_X2000Tools, [TColorStatusBar2000X]);
    RegisterComponents(SPage_X2000Tools, [TTrayIcon2000X]);
    RegisterComponents(SPage_X2000Tools, [TStringCrypt2000X]);
    RegisterComponents(SPage_X2000Tools, [TFindFile2000X]);
    RegisterComponents(SPage_X2000Tools, [TRegistry2000X]);
    RegisterComponents(SPage_X2000Tools, [TCheckBox2000X]);
    RegisterComponents(SPage_X2000Tools, [TRadiobutton2000X]);
    RegisterComponents(SPage_X2000Tools, [TCheckGroupBox2000X]);

    RegisterComponentEditor(TRunOnce2000X, TAbout2000XEditor);
    RegisterComponentEditor(TIconGrabber2000X, TAbout2000XEditor);
    RegisterComponentEditor(TFileCompress2000X, TAbout2000XEditor);
    RegisterComponentEditor(TRemoveCaption2000X, TAbout2000XEditor);
    RegisterComponentEditor(TLabel2000X, TAbout2000XEditor);
    RegisterComponentEditor(TLabelGC2000X, TAbout2000XEditor);
    RegisterComponentEditor(TAnalogMeter2000X, TAbout2000XEditor);
    RegisterComponentEditor(TFontComboBox2000X, TAbout2000XEditor);
    RegisterComponentEditor(TFontListBox2000X, TAbout2000XEditor);
    RegisterComponentEditor(TSwComboColor2000X, TAbout2000XEditor);
    RegisterComponentEditor(TGradientButton2000X, TAbout2000XEditor);
    RegisterComponentEditor(TColorStatusBar2000X, TAbout2000XEditor);
    RegisterComponentEditor(TTrayIcon2000X, TAbout2000XEditor);
    RegisterComponentEditor(TStringCrypt2000X, TAbout2000XEditor);
    RegisterComponentEditor(TFindFile2000X, TAbout2000XEditor);
    RegisterComponentEditor(TCheckBox2000X, TAbout2000XEditor);
    RegisterComponentEditor(TRadioButton2000X, TAbout2000XEditor);
    RegisterComponentEditor(TCheckGroupBox2000X, TAbout2000XEditor);
    RegisterComponentEditor(TRegistry2000X, TAbout2000XEditor);

    //Dialogs
    RegisterComponents(SPage_X2000Dialogs, [TFindFilesDialog2000X]);
    RegisterComponents(SPage_X2000Dialogs, [TFindComputerDialog2000X]);
    RegisterComponents(SPage_X2000Dialogs, [TShutdownDialog2000X]);
    RegisterComponents(SPage_X2000Dialogs, [TRestartDialog2000X]);
    RegisterComponents(SPage_X2000Dialogs, [TRunDialog2000X]);
    RegisterComponents(SPage_X2000Dialogs, [TIconDialog2000X]);
    RegisterComponents(SPage_X2000Dialogs, [TOpenDialog2000X]);
    RegisterComponents(SPage_X2000Dialogs, [TSaveDialog2000X]);

    RegisterComponentEditor(TFindFilesDialog2000X, TAbout2000XEditor);
    RegisterComponentEditor(TFindComputerDialog2000X, TAbout2000XEditor);
    RegisterComponentEditor(TShutdownDialog2000X, TAbout2000XEditor);
    RegisterComponentEditor(TRestartDialog2000X, TAbout2000XEditor);
    RegisterComponentEditor(TRunDialog2000X, TAbout2000XEditor);
    RegisterComponentEditor(TIconDialog2000X, TAbout2000XEditor);
    RegisterComponentEditor(TOpenDialog2000X, TAbout2000XEditor);
    RegisterComponentEditor(TSaveDialog2000X, TAbout2000XEditor);
end;

end.
