{ ****************************************************************
  Info               :  XFind
                        XBaseUtils Special for X2000
                        Freeware, Version 1.07 (BUILD 18.06.2000)

  Source File Name   :  XFind.pas
  Author             :  Baldemaier Florian
                        Email: Florian.Baldemaier@Chello.at
                        Url:   www.Baldemaier.cjb.net
  Testet on          :  Delphi 5 Professional
**************************************************************** }

unit XFind;

interface

Uses SysUtils, Windows, Classes, ShellApi, Dialogs;

procedure SearchFile       (Directory, Filemask: String; Attribs: integer; FFiles: TStrings);
procedure SearchRecursive  (Directory, Filemask: String; Attribs: integer; TFiles: TStrings);
function  FindSubDirectory (strDirs: TStrings; Directory: String): Boolean;

implementation

procedure SearchFile(Directory, Filemask: string; Attribs: integer; FFiles: TStrings);
var
  i: integer;
  sr: TSearchRec;
begin
  i:=0;
  if Directory[Length(Directory)]<>'\' then AppendStr(Directory,'\');
  if not FileExists(Directory+Filemask) then exit;
  try
    i:=FindFirst(Directory+Filemask, Attribs, sr);
    repeat
      if (sr.Name<>'.') and (sr.Name<>'..') then begin
       FFiles.Add(Directory+sr.Name);
      end;
    until FindNext(sr)<>0;
  finally
    FindClose(i);
  end;
end;

function FindSubDirectory(strDirs:TStrings; Directory:string):Boolean;
var
  i:integer;
  srchRec:TSearchRec;
begin
  Result:=True;
  try
    if Directory[Length(Directory)]<>'\' then AppendStr(Directory,'\');
    i:=FindFirst(Directory+'*.*',faAnyFile,srchRec);
    if i=0 then result:=false;
    repeat
      if ((srchRec.Attr and faDirectory)>0) and (srchRec.Name<>'.') and (srchRec.Name<>'..') then begin
        strDirs.Add(Directory+srchRec.Name);
      end;
    until FindNext(srchRec)<>0;
  finally
    FindClose(i);
  end;
end;

procedure SearchRecursive(Directory, Filemask: String; Attribs: integer; TFiles: TStrings);
var
  FFiles: TStrings;
begin
  FFiles:=TStringlist.create;
  if Directory[Length(Directory)]<>'\' then AppendStr(Directory,'\');
  FFiles.Clear;
  FindSubDirectory(FFiles, Directory);
  while FFiles.Count<>0 do begin
    FindSubDirectory(FFiles, FFiles.Strings[0]);
    SearchFile(FFiles.Strings[0], Filemask, Attribs, TFiles);
    FFiles.Delete(0);
  end;
  FFiles.Free;
end;

end.
