{ ****************************************************************
  Info               :  XFiles
                        XBaseUtils Special for X2000
                        Freeware, Version 1.07 (BUILD 18.06.2000)

  Source File Name   :  XFiles.pas
  Author             :  Baldemaier Florian
                        Email: Florian.Baldemaier@Chello.at
                        Url:   www.Baldemaier.cjb.net
  Testet on          :  Delphi 5 Professional
**************************************************************** }

{$I XBaseutils.inc}

unit XFiles;

interface

Uses SysUtils, Windows, Classes, ShellApi, Dialogs, XConvert, X2000LHACompress;

function  DateiDeKomprimieren (Dateiname: string): boolean;
function  DateiKomprimieren   (Dateiname: string): boolean;

Function  FileOrDirExists     (FileName : String)                        : Boolean;
Function  IsDriveReady        (DriveLetter:PChar):bool;
Function  DirExists           (Dir : String)                             : Boolean; OverLoad;
Function  DirExists           (Dir : String; Var Attrs : Integer)        : Boolean; OverLoad;
function  DiskInDrive         (Drive: Char)                              : Boolean;
Function  ExtractFileNameOnly (Name : String)                            : String;
Function  ExtractLastDirName  (Dir : String)                             : String;
Function  AddSlash            (S : String)                               : String;
Function  RemoveSlash         (S : String)                               : String;

function  VolumeID            (DriveChar: Char)                          : String;
function  NetworkVolume       (DriveChar: Char)                          : String;

procedure BaseFileSeek        (FileHandle: integer);
function  BaseFileOpen        (const FileName: string; AccessMode,ShareMode,CreationDistribution, FlagsAndAttributes: integer): integer;
function  BaseFileGetPointer  (FileHandle: integer)                      : integer;
function  BaseFileEOF         (FileHandle: integer)                      : boolean;
procedure BaseFileClose       (var FileHandle: integer);
procedure BaseFileReadln      (FileHandle: integer; var S: string);
procedure BaseFileReadln2     (FileHandle: integer; var S: string);
procedure BaseFileWriteln     (FileHandle: integer; S: string);
function  ReadZeile           (Filename: string; Zeile: integer)         : string;
function  ReadZeileEx         (Filename, SepChar:string; Zeile, Spalte: integer): string;
function  ReadFile            (Filename:string; Zeilen: TStrings):boolean;
procedure SetLogHeader        (HeaderMessage: string);
procedure WriteLog            (AdFilename, MessageT: string; Withdate, HeavyError: boolean);
procedure WriteZeile          (Dateiname, Zeile: string);

implementation

var
  LogHeader: String;

Function IsDriveReady(DriveLetter:PChar):bool;
	  var
	    OldErrorMode : Word;
	    OldDirectory : String;
	  begin
	    OldErrorMode:=SetErrorMode(SEM_NOOPENFILEERRORBOX);
	    GetDir(0, OldDirectory);
	    {$I-}
	      ChDir(DriveLetter+':\');
	    {$I+}
	    if IoResult<> 0 then
	      Result:=False
          else
	      Result:=True;
          ChDir(OldDirectory);
          SetErrorMode(OldErrorMode);
        end;

procedure WriteZeile (Dateiname, Zeile: string);
        var
          Handle: integer;
        begin
          if not Fileexists(Dateiname) then begin
            Handle:=BaseFileOpen(Dateiname, GENERIC_WRITE, FILE_SHARE_WRITE, CREATE_NEW, FILE_ATTRIBUTE_NORMAL);
          end;
          if Fileexists(Dateiname) then begin
            Handle:=BaseFileOpen(Dateiname, GENERIC_WRITE, FILE_SHARE_WRITE, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL);
          end;
          BaseFileSeek(Handle);

          BaseFileWriteln(Handle,Zeile);
          BaseFileClose(Handle);
        end;

function DateiKomprimieren(Dateiname: string): boolean;
        var
           InStr, OutStr: TFileStream;
           Temp: string;
        begin
           result:=true;
           if not Fileexists(Dateiname) then begin
              result:=false;
              exit;
           end;
           if Fileexists(Dateiname) then begin
              try
               try
                 Temp:=Addslash(ExtractFilepath(Dateiname))+'XTemp.tmp';
                 InStr  := TFileStream.Create(Dateiname,fmOpenRead);
                 OutStr := TFileStream.Create(Temp,fmCreate);
                 LHACompress(InStr, OutStr);
                 InStr.Free;
                 OutStr.Free;
               finally
                 DeleteFile(pchar(Dateiname));
                 RenameFile(Temp, Dateiname);
               end;
              except
                result:=false;
              end;
           end;
        end;

function DateiDeKomprimieren(Dateiname: string): boolean;
        var
           InStr, OutStr: TFileStream;
           Temp: string;
        begin
           result:=true;
           if not Fileexists(Dateiname) then begin
              result:=false;
              exit;
           end;
           if Fileexists(Dateiname) then begin
              try
               try
                 Temp:=Addslash(ExtractFilepath(Dateiname))+'XTemp.tmp';
                 InStr  := TFileStream.Create(Dateiname,fmOpenRead);
                 OutStr := TFileStream.Create(Temp,fmCreate);
                 LHAExpand(InStr, OutStr);
                 InStr.Free;
                 OutStr.Free;
               finally
                 DeleteFile(pchar(Dateiname));
                 RenameFile(Temp, Dateiname);
               end;
              except
                result:=false;
              end;
           end;
        end;

procedure SetLogHeader(HeaderMessage: string);
        // Setzt den LOG Kopfteil der Ausgabe Datei
        begin
          LogHeader:=HeaderMessage;
        end;

procedure WriteLog(AdFilename, MessageT: string; WithDate, HeavyError: boolean);
        // Schreibt eine Zeile in die Log Datei
        // z.B. WriteLog ('c:\test.log', 'Fehler in xxx', true, true) -
        //      Schreibt eine Zeile in die Datei "FEHLER 10.01.1999 08:40:30 Fehler in xxx"
        //
        // z.B. WriteLog ('c:\test.log', 'Fehler in xxx', true, false) -
        //      Schreibt eine Zeile in die Datei "       10.01.1999 08:40:30 Fehler in xxx"
       //
        // z.B. WriteLog ('c:\test.log', 'Fehler in xxx', false, false) -
        //      Schreibt eine Zeile in die Datei "Fehler in xxx"
        var
          xv, handle: integer;
        begin
          xv:=0;
          if not Fileexists(AdFilename) then begin
            Handle:=BaseFileOpen(AdFilename, GENERIC_WRITE, FILE_SHARE_WRITE, CREATE_NEW, FILE_ATTRIBUTE_NORMAL);
            BaseFileWriteln(Handle, LogHeader);
            BaseFileSeek(Handle);
            inc(xv);
          end;
          if (Fileexists(AdFilename)) and (xv=0) then begin
            Handle:=BaseFileOpen(AdFilename, GENERIC_WRITE, FILE_SHARE_WRITE, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL);
            BaseFileSeek(Handle);
          end;
          try
            if HeavyError then begin
               if WithDate then BaseFileWriteln(Handle, 'ERROR '+Datetostr(Date)+' '+Timetostr(time)+' '+MessageT);
               if not WithDate then BaseFileWriteln(Handle, 'ERROR '+MessageT);
            end;
            if not HeavyError then begin
               if WithDate then BaseFileWriteln(Handle, '      '+Datetostr(Date)+' '+Timetostr(time)+' '+MessageT);
               if not WithDate then BaseFileWriteln(Handle, '      '+MessageT);
            end;
          finally
            BaseFileClose(Handle);
          end;
        end;

function ReadFile(Filename:string; Zeilen: TStrings): boolean;
        // Liet eine Datei und stellt die Zeilen in einen TString
        // Zeile:=TStringlist.create;
        // ReadFile('C:\Test.txt', Zeile);
        var
          s: string;
          Handle: integer;
        begin
          result:=false;
          if not Fileexists(Filename) then begin
             result:=false;
             exit;
          end;
          if Fileexists(Filename) then begin
             result:=true;
             Zeilen.Clear;
             Handle:=BaseFileOpen(Filename, GENERIC_READ, FILE_SHARE_READ, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL);
             while not BaseFileEOF(Handle) do begin
               BaseFileReadln(Handle, S);
               Zeilen.Add(s);
             end;
             BaseFileClose(Handle);
          end;
        end;


function ReadZeile(Filename:string; Zeile: integer): string;
        // Liet eine Zeile aus einer Datei
        // z.B. ReadFile('c:\test.txt', 1)
        var
          s: string;
          v, Handle: integer;
        begin
          Handle:=BaseFileOpen(Filename, GENERIC_READ, FILE_SHARE_READ, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL);
          v:=0;
          while not BaseFileEOF(Handle) do begin
            inc(v);
            BaseFileReadln(Handle, S);
            if zeile=v then begin
              result:=s;
              BaseFileClose(Handle);
              exit;
            end;
          end;
          BaseFileClose(Handle);
        end;


function ReadZeileEx(Filename, SepChar:string; Zeile, Spalte: integer): string;
        // Liet eine Zeile aus einer Datei die mit einem Seperator getrennt ist
        // z.B. ReadZeileEx('c:\test.txt', ',', 1, 1) -> Liet die 1 Zeile und 1 Spalte der Datei
        var
          s: string;
          v, Handle: integer;
        begin
          s:=ReadZeile(Filename,Zeile);
          result:=Gettoken(s,Sepchar,Spalte);
        end;

function BaseFileOpen(const FileName: string; AccessMode, ShareMode, CreationDistribution, FlagsAndAttributes: Integer): Integer;
        // ffnet eine Datei mit den angegebenen Zugriffs Rechten
        begin
          Result := CreateFile(PChar(FileName), AccessMode, ShareMode, nil, CreationDistribution,
          FlagsAndAttributes, 0);
        end;

procedure BaseFileClose(var FileHandle: integer);
        // Schliet die Datei
        begin
          FileClose(FileHandle);
          FileHandle:=0;
        end;

function BaseFileGetPointer(FileHandle: integer): integer;
        begin
          Result:=SetFilePointer(FileHandle,0,nil,FILE_CURRENT);
        end;

procedure BaseFileSeek(FileHandle: integer);
        begin
          FileSeek(FileHandle,0,2)
        end;

procedure BaseFileWriteln(FileHandle: integer; S: string);
        begin
          S:=S+#13#10;
          FileWrite(FileHandle,S[1],length(S));
        end;

function BaseFileEOF(FileHandle: integer): boolean;
        begin
          if DWORD(BaseFileGetPointer(FileHandle)) < Windows.GetFileSize(FileHandle,nil) then
            Result:=false
          else
            Result:=true;
        end;

procedure BaseFileReadln(FileHandle: integer; var S: string);
        const
          MaxLen = 100;
        var
          Buf,s1: string;
          n: integer;
        begin
          S:='';
          repeat
            SetLength(Buf,MaxLen);
            n:=FileRead(FileHandle,Buf[1],MaxLen);
            if n = 0 then exit;
            SetLength(Buf,n);
            s1:=Copy2Symb(Buf,#13);
            S:=S+DelChars(s1,#10);
          until length(s1) < n;
          SetFilePointer(FileHandle,length(s1)-n+1,nil,FILE_CURRENT);
        end;

procedure BaseFileReadln2(FileHandle: integer; var S: string);
        const
          MaxLen = 100;
        var
          Buf,s1: string;
          n: integer;
        begin
          S:='';
          repeat
            SetLength(Buf,MaxLen);
            n:=FileRead(FileHandle,Buf[1],MaxLen);
            if n = 0 then exit;
            SetLength(Buf,n);
            s1:=Copy2Symb(Buf,#10);
            S:=S+DelChars(s1,#10);
          until length(s1) < n;
          SetFilePointer(FileHandle,length(s1)-n+1,nil,FILE_CURRENT);
        end;

Function FileOrDirExists(FileName : String) : Boolean;
	Var SRec : TSearchRec;
	Begin
	  Result := FindFirst(FileName, faAnyFile, SRec) = 0;
	  SysUtils.FindCLose(SRec);
	End;

Function DirExists(Dir : String; Var Attrs : Integer) : Boolean;
	Var SRec : TSearchRec;
	Begin
	  Result := ((Length(Dir) <= 3) And (Length(Dir) >= 2))And (Dir[2] = ':');
	  IF Result Then
	   Attrs := 0
	  Else
	  Begin
	    IF FindFirst(Dir, faAnyFile, SRec) = 0 Then
	    Begin
	      Result := (Srec.Attr and faDirectory <> 0);
	      Attrs := Srec.Attr;
	    End;
	    SysUtils.FindCLose(SRec);
	  End;
	End;

Function DirExists(Dir : String) : Boolean;
	Var Dummy : Integer;
	Begin
	  Result := DirExists(Dir, Dummy);
	End;

Function AddSlash(S : String) : String;
	Begin
	  IF (Length(S) > 0) And (S[Length(s)] <> '\') Then
	  Result := S + '\'
	  else
	  Result := S;
	End;

Function RemoveSlash(S : String) : String;
	Begin
	  IF (Length(S) > 0) And (S[Length(s)] = '\') Then
	  Result := Copy(S, 1, Pred(Length(S)))
	  else
	  Result := S;
	End;

function DiskInDrive(Drive: Char): Boolean;
	var  ErrorMode: word;
	begin
	  Drive := UpCase(Drive);
	  if not (Drive in ['A'..'Z']) then
	    raise EConvertError.Create('Not a valid drive ID');
	    ErrorMode := SetErrorMode(SEM_FailCriticalErrors or SEM_NOOPENFILEERRORBOX);
	  try
	    if DiskSize(Ord(Drive) - $40) = -1 then
	    Result := False
	    else
	      Result := True;
	  finally
	    SetErrorMode(ErrorMode);
	  end;
	end;

Function ExtractFileNameOnly(Name : String) : String;
	Var Ext : String;
	Begin
	  Result := ExtractFileName(Name);
	  Ext    := ExtractFileExt(Name);
	  IF Ext <> '' Then
	  Delete(Result, Pos(Ext, Result), Length(Ext));
	End;

Function ExtractLastDirName(Dir : String) : String;
	Var SPos : Integer;
	Begin
	  Result := RemoveSlash(Dir);
	  SPos   := LastPos('\', Result);
	  IF SPos = 0 Then
	  Result := ''
	  Else
	  Result := Copy(Result, Succ(SPos), Length(Result) - SPos);
	End;



function VolumeID(DriveChar: Char): string;
        var
          OldErrorMode: Integer;
          NotUsed, VolFlags: DWORD;
          Buf: array [0..MAX_PATH] of Char;
        begin
          OldErrorMode := SetErrorMode(SEM_FAILCRITICALERRORS);
          try
            Buf[0] := #$00;
            if GetVolumeInformation(PChar(DriveChar + ':\'), Buf, DWORD(sizeof(Buf)),
               nil, NotUsed, VolFlags, nil, 0) then
               SetString(Result, Buf, StrLen(Buf))
            else Result := '';  
            if DriveChar < 'a' then
               Result := AnsiUpperCaseFileName(Result)
            else
               Result := AnsiLowerCaseFileName(Result);
               Result := Format('[%s]',[Result]);
          finally
            SetErrorMode(OldErrorMode);
          end;
        end;

function NetworkVolume(DriveChar: Char): string;
        var
          Buf: Array [0..MAX_PATH] of Char;
          DriveStr: array [0..3] of Char;
          BufferSize: DWORD;
        begin
          BufferSize := sizeof(Buf);
          DriveStr[0] := UpCase(DriveChar);
          DriveStr[1] := ':';
          DriveStr[2] := #0;
          if WNetGetConnection(DriveStr, Buf, BufferSize) = WN_SUCCESS then begin
            SetString(Result, Buf, BufferSize);
            if DriveChar < 'a' then
               Result := AnsiUpperCaseFileName(Result)
            else
               Result := AnsiLowerCaseFileName(Result);
            end
          else
            Result := VolumeID(DriveChar);
        end;

end.
