{ ****************************************************************
  Info               :  XConvert
                        XBaseUtils Special for X2000
                        Freeware, Version 1.07 (BUILD 18.06.2000)

  Source File Name   :  XConvert.pas
  Author             :  Baldemaier Florian
                        Email: Florian.Baldemaier@Chello.at
                        Url:   www.Baldemaier.cjb.net
  Testet on          :  Delphi 5 Professional
**************************************************************** }

{$I XBaseutils.inc}

unit XConvert;

interface

Uses SysUtils, Windows, Classes, ShellApi, Dialogs, Forms,
     X2000LHACompress, X2000Base64;

// Diverse Routinen
Function  LastPos             (Ch : Char; S : String)                                   : Integer;
Function  StrReplace          (S : String; FromC, ToC : Char)                           : String;
Function  StrContains         (Str1, Str2 : String)                                     : Boolean;
Function  StrDeleteChar       (S : String; Ch : Char)                                   : String;
Function  DosDateToDateStr    (wDate : Word)                                            : String;
Function  StrDateToDosDate    (DateStr : String)                                        : Word;
Function  FormatSize          (Size : Integer)                                          : String; Overload;
Function  FormatSize          (Size : Cardinal)                                         : String; Overload;
Function  FormatSize          (Size : Int64)                                            : String; Overload;
Function  HexByte             (b : Byte )                                               : String;
Function  HexWord             (w : Word )                                               : String;
Function  DecToHex            (aValue : LongInt )                                       : String;
function  Copy2Symb           (const S: string; Symb: Char)                             : string;
function  DelChars            (const S: string; Chr: Char)                              : string;
Procedure StrTranslate        (Var S: String; Code : String);

// String mit Seperator Routinen
function  GetToken            (aString, SepChar: String; TokenNum: Byte)                : String;
function  SetToken            (aString, SepChar: String; TokenNum: Byte; Value: String) : String;
function  InsertToken         (aString, SepChar: String; TokenNum: Byte; Value: String) : String;
function  DeleteToken         (aString, SepChar: String; TokenNum: Byte)                : string;
function  NumToken            (aString, SepChar: String)                                : Byte;
function  TokenExists         (aString, SepChar: string)                                : boolean;
function  HowManyToken        (aString, SepChar: string)                                : integer;

// Datum berprfung
function  CheckDatum          (Temp: string)                                            : String;
function  CheckDatumEx        (Temp, Format: string)                                    : string;
function  HigherDate          (Date1, Date2: string)                                    : integer;

// Zwischen Routinen
function  ZwischenTage      (Datum1, Datum2: TDateTime): Longint;
function  ZwischenDatum     (aDatum, Von, Bis: String): boolean;
function  ZwischenString    (aString, Von, Bis: String): boolean;
function  ZwischenCurrency  (aCurrency, Von, Bis: Currency): boolean;
function  ZwischenInteger   (aInteger, Von, Bis: integer): boolean;

// String Routinen
function  Rechts                  (aString: string; Laenge : integer): string;
function  Links                   (aString: string; Laenge : integer): string;
function  TrimNull                (Temp: string): string;
function  TrimEx                  (Temp, Sepchar: string): string;
function  TrimRechtsEx            (Temp, Sepchar: string): string;
function  TrimLinksEx             (Temp, Sepchar: string): string;
function  IsAlphaNumeric          (aString: String): boolean;
function  IsAlpha                 (aString: String): boolean;
function  IsNumeric               (aString: String): boolean;
function  CheckAlphaNum           (aString: String): integer;
function  Anfangsbuchstaben_Gross (Text : String) : String;
function  Zaehle_Woerter          (s : string): integer;
function  StringKomprimieren      (StringIn : String; Crypt: boolean) : String;
function  StringDekomprimieren    (StringIn : String; Crypt: boolean) : String;
function  CheckDouble             (Temp: string): string;
function  DeleteString            (aString, DeleteStr: string): string;

// Whrungs Routinen
function  BruttoTONetto       (Brutto, Tax: Currency): currency;
function  NettoTOBrutto       (Netto,  Tax: Currency): currency;
function  SteuerVONBrutto     (Brutto, Tax: currency): currency;
function  SteuerVONNetto      (Netto,  Tax: currency): currency;
function  SteuerProzVonBetrag (Betrag, Steuer: currency): currency;
function  RoundCurrency       (Betrag: currency): currency;
function  Add2Komma           (Data: string): String;
function  CurrToStr2          (Value: currency): String;

// Kleinster und Groesster Routinen
function Groesster(A, B: Longint): Longint;
function Kleinster(A, B: Longint): Longint;
function GroessterInteger (const Values: array of Longint): Longint;
function KleinsterInteger (const Values: array of Longint): Longint;
function GroesstesFloat   (const Values: array of Extended): Extended;
function KleinstesFloat   (const Values: array of Extended): Extended;
function GroesstesDatum   (const Values: array of TDateTime): TDateTime;
function KleinstesDatum   (const Values: array of TDateTime): TDateTime;
function GroessterWertVon (const Values: array of Variant): Variant;
function KleinsterWertVon (const Values: array of Variant): Variant;

// Formular Routinen
procedure ZentriereForm   (Form: TForm);
function XIsLeapYear(AYear: Integer): Boolean;
function XDaysPerMonth(AYear, AMonth: Integer): Integer;

implementation

// Formular Routinen
// -------------------------------------------------------------------------------

procedure ZentriereForm(Form : TForm);
        begin
          Form.Left := (GetSystemMetrics(sm_CXScreen) - Form.Width) div 2;
          Form.Top  := (GetSystemMetrics(sm_CYScreen) - Form.Height) div 2;
        end;

// Kleinster und Groesster Routinen
// -------------------------------------------------------------------------------

function Groesster(A, B: Longint): Longint;
        begin
          if A > B then Result := A
          else Result := B;
        end;

function Kleinster(A, B: Longint): Longint;
        begin
          if A < B then Result := A
          else Result := B;
        end;

function GroessterInteger(const Values: array of Longint): Longint;
        var
         I: Cardinal;
        begin
          Result := Values[0];
          for I := 0 to High(Values) do
          if Values[I] > Result then Result := Values[I];
        end;

function KleinsterInteger(const Values: array of Longint): Longint;
        var
          I: Cardinal;
        begin
          Result := Values[0];
          for I := 0 to High(Values) do
          if Values[I] < Result then Result := Values[I];
        end;

function GroesstesFloat(const Values: array of Extended): Extended;
        var
          I: Cardinal;
        begin
          Result := Values[0];
          for I := 0 to High(Values) do
          if Values[I] > Result then Result := Values[I];
        end;

function KleinstesFloat(const Values: array of Extended): Extended;
        var
          I: Cardinal;
        begin
          Result := Values[0];
          for I := 0 to High(Values) do
          if Values[I] < Result then Result := Values[I];
        end;

function GroesstesDatum(const Values: array of TDateTime): TDateTime;
        var
          I: Cardinal;
        begin
          Result := Values[0];
          for I := 0 to High(Values) do
          if Values[I] < Result then Result := Values[I];
        end;

function KleinstesDatum(const Values: array of TDateTime): TDateTime;
        var
          I: Cardinal;
        begin
          Result := Values[0];
          for I := 0 to High(Values) do
          if Values[I] < Result then Result := Values[I];
        end;

function GroessterWertVon(const Values: array of Variant): Variant;
        var
          I: Cardinal;
        begin
          Result := Values[0];
          for I := 0 to High(Values) do
          if Values[I] > Result then Result := Values[I];
        end;

function KleinsterWertVon(const Values: array of Variant): Variant;
        var
          I: Cardinal;
        begin
          Result := Values[0];
          for I := 0 to High(Values) do
          if Values[I] < Result then Result := Values[I];
        end;


// String Routinen
// -------------------------------------------------------------------------------

function DeleteString(aString, DeleteStr: string): string;
        var
          ax, i: integer;
        begin
          for i:=1 to length(aString) do begin
            if pos(DeleteStr, aString)<>0 then begin
               ax:=pos(DeleteStr, aString);
               aString:=copy(aString,1,ax-1)+copy(aString,ax+1,length(aString)-1);
            end;
          end;
          result:=aString;
        end;

function CheckDouble (Temp: string): string;
        var
          Check, a, b: integer;
        begin
          Temp:=TrimEx(Temp, ' ');
          Check:=CheckAlphaNum(Temp);
          if Check<>1 then begin
            result:='#-99';
            exit;
          end;
          b:=0;
          for a:=1 to length(Temp) do begin
            if Pos('.', Temp)<>0 then begin
              b:=pos('.', Temp);
              Temp:=copy(Temp,1,b-1)+copy(Temp,b+1,length(Temp)-1);
            end;
          end;
          result:=temp;
        end;

function StringKomprimieren(StringIn : String; Crypt: boolean) : String;
        var
          InStr, OutStr : TStringStream;
        begin
          InStr  := TStringStream.Create(StringIn);
          OutStr := TStringStream.Create('');
          LHACompress(InStr, OutStr);
          if Crypt then result := Base64Encode(OutStr.DataString)
          else result:=OutStr.DataString;
          InStr.Free;
          OutStr.Free;
        end;

function StringDekomprimieren(StringIn : String; Crypt: boolean) : String;
        var
          InStr, OutStr : TStringStream;
          s : String;
        begin
          if crypt then s := Base64Decode(StringIn)
          else s:=Stringin;
          InStr  := TStringStream.Create(s);
          OutStr := TStringStream.Create('');
          LHAExpand(InStr, OutStr);
          result := OutStr.DataString;
          InStr.Free;
          OutStr.Free;
        end;


function Zaehle_Woerter(s : string): integer;
        var
          ps         : PChar;
          nSpaces, n : integer;
        begin
          n  := 0;
          s  := s + #0;
          ps := @s[ 1 ];
          while( #0 <> ps^ ) do begin
            while((' ' = ps^)and(#0 <> ps^)) do begin
              inc( ps );
            end;
            nSpaces := 0;
            while((' ' <> ps^)and(#0 <> ps^))do begin
              inc( nSpaces );
              inc( ps );
            end;
            if ( nSpaces > 0 ) then begin
              inc( n );
            end;
          end;
          Result := n;
        end;

function Anfangsbuchstaben_Gross(Text : String) : String;
        var
          i      : Integer;
          Ch     : Char;
          First  : Boolean;
        begin
          First  := True;
          Result := '';
          for i:=1 to Length(Text) do begin
             Ch:=Text[i];
             if Ch in [#32,'-','.'] then
               First:=True
             else if First then begin
               Ch:=UpCase(Ch);
               First:=False;
             end;
             Result:=Result+Ch;
          end;
        end;

function Links(aString : string; Laenge : integer): string;
        // Gibt einen String zurck (von Links mit der Lnge "Laenge")
        // z.B. Links('1234567890', 4) -> "1234"
        begin
          if (Laenge < 1) or (Length(aString) < Laenge) then Result := ''
          else Result := Copy(aString, 1, Laenge);
        end;

function Rechts(aString : string; Laenge : integer): string;
        // Gibt einen String zurck (von Rechts mit der Lnge "Laenge")
        // z.B. Rechts('1234567890', 4) -> "7890"
        var
          temp : integer;
        begin
          temp := Length(aString);
          if (Laenge < 1) or (temp < Laenge) then Result := ''
          else Result := Copy(aString, temp - Laenge + 1, Laenge);
        end;

function TrimNull(Temp: string): string;
        // Lscht alle Leerzeichen (vorne und hinten) und alle Nullen
        // z.B. TrimNull('  00000100 ') -> "100"
        var
          i: integer;
        begin
          Temp:=TrimEx(Temp, ' ');
          Temp:=TrimLinksEx(Temp, '0');
          result:=Add2Komma(Temp);
        end;

function TrimEx(Temp, Sepchar: string): string;
        // Lscht alle Zeichen (Sepchar) vorne und hinten
        // z.B. TrimEx('???123???', '?') -> "123"
        begin
          Temp:=TrimRechtsEx(Temp, Sepchar);
          Temp:=TrimLinksEx(Temp, Sepchar);
          result:=Temp;
        end;

function TrimRechtsEx(Temp, Sepchar: string): string;
        // Lscht alle Zeichen (Sepchar) hinten
        // z.B. TrimRechtsEx('123???', '?') -> "123"
        var
          i: integer;
        begin
          result:=temp;
          for i:=length(Temp) downto 1 do begin
            if pos(Sepchar, Temp)=i then begin
              Temp:=copy(Temp,1,i-1);
            end;
          end;
          if Length(Temp)<>0 then result:=temp;
        end;

function TrimLinksEx(Temp, Sepchar: string): string;
        // Lscht alle Zeichen (Sepchar) hinten
        // z.B. TrimLinksEx('?????123', '?') -> "123"
        var
          i: integer;
        begin
          result:=temp;
          for i:=1 to length(Temp) do begin
            if pos(Sepchar, Temp)=1 then begin
             Temp:=copy(Temp,2,length(Temp)-1);
            end;
          end;
          if Length(Temp)<>0 then result:=temp;
        end;

function IsAlphaNumeric (aString: String): boolean;
        // Trifft es zu das aString Alphanumerisch ist
        // IsAlphaNumeric('AB12') -> TRUE
        begin
          result:=false;
          if (IsAlpha(aString)) and (IsNumeric(aString)) then result:=true;
        end;

function IsAlpha (aString: String): boolean;
        // Trifft es zu das aString Alphabetisch ist
        // IsAlpha('AB') -> TRUE
        var
          Temp: string;
          a: integer;
        begin
          Temp:=aString; result:=false;
          for a:=1 to length(Temp) do begin
            if (Temp[a] in ['A'..'Z']) or (Temp[a] in ['a'..'z']) then result:=true;
          end;
        end;

function IsNumeric (aString: String): boolean;
        // Trifft es zu das aString Nummerisch ist
        // IsNumeric('123') -> TRUE
        var
          Temp: string;
          a: integer;
        begin
          Temp:=aString; result:=false;
          for a:=1 to length(Temp) do begin
            if (Temp[a] in ['0'..'9']) then result:=true;
            if not (Temp[a] in ['0'..'9']) then result:=false;
          end;
        end;

function CheckAlphaNum (aString:String): integer;
        // Was Ist der String (Alphabetisch, Nummerisch oder AlphaNumerisch)
        // CheckAlphaNum('') -> -1
        // CheckAlphaNum('123') -> 1
        // CheckAlphaNum('ABC') -> 2
        // CheckAlphaNum('A123') -> 3
        begin
           result:=0;
           if aString='' then result:=-1;
           if IsNumeric(aString) then result:=1;
           if IsAlpha(aString) then result:=2;
           if IsAlpha(aString) and IsNumeric(aString) then result:=3;
        end;


// Zwischen Routinen
// -------------------------------------------------------------------------------

function ZwischenTage(Datum1, Datum2: TDateTime): Longint;
        // Gibt die Tage zurck die Zwischen Datum1 und Datum2 liegen
        begin
          Result := Trunc(Datum1) - Trunc(Datum2) + 1;
        end;

function ZwischenString(aString, Von, Bis: string): boolean;
        // Triff es zu das aString Zwischen Von und Bis liegt
        // z.B. ZwischenString('b', 'a', 'c') -> TRUE ("b" liegt Zwischen "a" und "c")
        begin
          if (astring >= Von) and (astring <= Bis) then result:=true
          else result:=false;
        end;

function ZwischenInteger(aInteger, Von, Bis: integer): boolean;
        // Triff es zu das aInteger Zwischen Von und Bis liegt
        // z.B. ZwischenInteger(2, 1, 3) -> TRUE (2 liegt Zwischen 1 und 3)
        begin
          if (aInteger >= Von) and (aInteger <= Bis) then result:=true
          else result:=false;
        end;

function ZwischenCurrency(aCurrency, Von, Bis: Currency): boolean;
        // Triff es zu das aCurrency Zwischen Von und Bis liegt
        // z.B. ZwischenCurrency(12.34, 4.00, 20.40) -> TRUE (12.34 liegt Zwischen 4.00 und 20.40)
        begin
          if (aCurrency >= Von) and (aCurrency <= Bis) then result:=true
          else result:=false;
        end;

function ZwischenDatum(aDatum, Von, Bis: String): boolean;
        // Triff es zu das aDatum Zwischen Von und Bis liegt
        // z.B. ZwischenDatum('10.01.1999', '01.01.1999', '31.12.1999') -> TRUE (10.01.1999 liegt Zwischen 01.01.1999 und 31.12.1999)
        var
           Days1, Days2: longint;
        begin
           result:=false;
           aDatum:=CheckDatum(aDatum);
           Von:=CheckDatum(Von);
           Bis:=CheckDatum(Bis);
           if (aDatum='#-99') or (Von='#-99') or (Bis='#-99') then begin
              result:=false;
              exit;
           end;

           Days1:=ZwischenTage(strtodate(Von), strtodate(Bis));
           Days2:=ZwischenTage(strtodate(aDatum), strtodate(Bis));
           if Days2<0 then begin
              result:=false;
              exit;
           end;
           if Days2<=Days1 then begin
              result:=true;
              exit;
           end;
           if Days2>Days1 then begin
              result:=false;
              exit;
           end;
        end;

// Whrungs Routinen
// -------------------------------------------------------------------------------

function SteuerVONBrutto(Brutto, Tax: currency): currency;
        // Gibt den Steuerbetrag vom Bruttobetrag zurck
        // z.B SteuerVONBrutto(120.00, 20) -> 20.00
        var
           Temp, St: Currency;
        begin
           result:=0;
           St:=(100+Tax)/100;
           Temp:=Brutto-(Brutto / st);
           result:=Temp;
        end;

function SteuerVONNetto(Netto, Tax: currency): currency;
        // Gibt den Steuerbetrag vom Bruttobetrag zurck
        // z.B SteuerVONNetto(100.00, 20) -> 20.00
        var
           Temp, St: Currency;
        begin
           result:=0;
           St:=Tax/100;
           Temp:=Netto*st;
           result:=Temp;
        end;

function BruttoTONetto(Brutto, Tax: currency): currency;
        // Gibt den Nettobetrag zurck.
        // z.B BruttoTONetto(120.00, 20) -> 100.00
        var
           Temp, St: Currency;
        begin
           result:=0;
           if Tax>0 then St:=(100+Tax)/100;
           if Tax<0 then St:=(100-Tax)/100;
           Temp:=Brutto / st;
           result:=Temp;
        end;

function NettoTOBrutto(Netto, Tax: currency): currency;
        // Gibt den Bruttobetrag zurck.
        // z.B NettoTOBrutto(100.00, 20) -> 120.00
        var
           Temp, St: Currency;
        begin
           result:=0;
           St:=Tax/100;
           if Tax>0 then Temp:=Netto+(Netto*st);
           if Tax<0 then Temp:=Netto-(Netto*st);
           result:=Temp;
        end;

function SteuerProzVonBetrag (Betrag, Steuer: currency): currency;
        // Gibt den Steuer Prozentsatz zurck
        // z.B SteuerProzVonBetrag(120.00, 20) -> 20 (=20%)
        var
          Temp: Currency;
        begin
          Temp:=(Betrag*100) / (Betrag-Steuer);
          result:=Temp-100;
        end;

function RoundCurrency(Betrag: currency): currency;
        // Rundet den Betrag auf 2 Stellen
        var
          Temp, Temp2, Temp3: string;
          i: integer;
        begin
          Temp3:='';
          Temp:=CurrToStrF(Betrag, ffCurrency , 2);
          for i:=1 to length(Temp) do begin
              Temp2:=copy(Temp,i,1);
              if (CheckAlphanum(Temp2)=1) or (Temp2=',')then begin
                 Temp3:=Temp3+Temp2;
              end;
          end;
          result:=strtocurr(Add2Komma(Temp3));
        end;

function Add2Komma(Data:string): string;
        // Fgt einen String ,00 oder 0 hinzu
        // z.B. Add2Komma('1,0') -> "1,00"
        // z.B. Add2Komma('1,4') -> "1,40"
        // z.B. Add2Komma('1,04')-> "1,04"
        // z.B. Add2Komma('2')   -> "2,00"
        var
          Temp1, Temp2:string;
        begin
          result:='';
          if not TokenExists(Data,',') then begin
             result:=Data+',00';
             exit;
          end;
          if TokenExists(Data,',') then begin
             Temp1:=Gettoken(Data, ',',1);
             Temp2:=Gettoken(Data, ',',2);
             if length(Temp2)<2 then Temp2:=Temp2+'0';
             if Temp1='' then Temp1:='0';
             result:=Temp1+','+Temp2;
          end;
        end;

function CurrToStr2(Value: currency): String;
        // Convertiert Value zu einem String (gleich wie CurrToStr)
        // fgt jedoch zustzlich 0,00 hinzu (Add2Komma)
        var
          Temp: string;
        begin
          Temp:=Currtostr(Value);
          result:=Add2Komma(Temp);
        end;

// Datum berprfung
// -------------------------------------------------------------------------------

function CheckDatum (Temp: string): string;
        // berprft das Datum und ndert es gegebenfalls
        // Wenn #-99 zurck gegeben wird ist das Datum nicht korrekt.
        //
        // z.B. CheckDatum('10-01-99') -> "10.01.1999" (Ausgabe je nach Systemeinstellung)
        // z.B. CheckDatum('10.01.99') -> "10.01.1999"
        // z.B. CheckDatum('10.01.90') -> "10.01.1990"
        // z.B. CheckDatum('10.01.89') -> "10.01.2089" (ACHTUNG ber 90 ist 19xx unter 90 ist 20xx)
        // z.B. CheckDatum('32.01.90') -> "#-99" Fehler es gibt keinen 32 Jnner
        // z.B. CheckDatum('31.13.90') -> "#-99" Fehler es gibt keinen 13 Monat
        begin
          result:=CheckDatumEx(Temp, '');
        end;

function CheckDatumEx (Temp, Format: string): string;
        // berprft das Datum und ndert es gegebenfalls
        // Wenn #-99 zurck gegeben wird ist das Datum nicht korrekt.
        //
        // z.B. CheckDatumEx('10.01.99', 'MM/TT/YYYY') -> "01/10/1999"
        // z.B. CheckDatumEx('10.01.99', '')           -> "10.01.1999"
        var
          Check, i: integer;
          Datum: string;
          aa,bb,cc: string;
          MaxDays, aa1,bb1,cc1: integer;
          Sep, DFormat: string;

          Tag, Monat, Jahr: integer;
        begin
          //System Format
          Sep:=DateSeparator;
          DFormat:=uppercase(ShortDateFormat);

          //Init
          Datum:=Temp; result:=Datum;

          //Prfen ob Nummerisch
          Check:=CheckAlphaNum(Datum);
          if Check<>1 then begin
             result:='#-99';
             exit;
          end;

          //z.B. 240200
          if (length(Datum)=6) and not Tokenexists(Datum, Sep) then Datum:=copy(Datum,1,2)+Sep+copy(Datum,3,2)+Sep+copy(Datum,5,2);

          //z.B. 24022000
          if (length(Datum)=8) and not Tokenexists(Datum, Sep) then Datum:=copy(Datum,1,2)+Sep+copy(Datum,3,2)+Sep+copy(Datum,5,4);

          //z.B. 24.02.00 ("/" oder "." oder "-")
          if (length(Datum)=8) and Tokenexists(Datum, '.') then Datum:=Gettoken(Datum, '.',1)+Sep+Gettoken(Datum,'.',2)+Sep+Gettoken(Datum,'.',3);
          if (length(Datum)=8) and Tokenexists(Datum, '/') then Datum:=Gettoken(Datum, '/',1)+Sep+Gettoken(Datum,'/',2)+Sep+Gettoken(Datum,'/',3);
          if (length(Datum)=8) and Tokenexists(Datum, '-') then Datum:=Gettoken(Datum, '-',1)+Sep+Gettoken(Datum,'-',2)+Sep+Gettoken(Datum,'/',3);
          if (length(Datum)=8) and Tokenexists(Datum, Sep) then Datum:=Gettoken(Datum, Sep,1)+Sep+Gettoken(Datum,Sep,2)+Sep+Gettoken(Datum,Sep,3);

          //z.B. 24.02.2000 ("/" oder "." oder "-")
          if (length(Datum)=10) and Tokenexists(Datum, '.') then Datum:=Gettoken(Datum,'.',1)+Sep+Gettoken(Datum,'.',2)+Sep+Gettoken(Datum,'.',3);
          if (length(Datum)=10) and Tokenexists(Datum, '/') then Datum:=Gettoken(Datum,'/',1)+Sep+Gettoken(Datum,'/',2)+Sep+Gettoken(Datum,'/',3);
          if (length(Datum)=10) and Tokenexists(Datum, '-') then Datum:=Gettoken(Datum,'-',1)+Sep+Gettoken(Datum,'-',2)+Sep+Gettoken(Datum,'-',3);
          if (length(Datum)=10) and Tokenexists(Datum, Sep) then Datum:=Gettoken(Datum,Sep,1)+Sep+Gettoken(Datum,Sep,2)+Sep+Gettoken(Datum,Sep,3);

          //z.B. 24.02.2000 00:00:00 ("/" oder "." oder "-")
          if (length(Datum)=19) and Tokenexists(Datum, '.') then Datum:=Gettoken(Datum,'.',1)+Sep+Gettoken(Datum,'.',2)+Sep+Gettoken(Datum,'.',3);
          if (length(Datum)=19) and Tokenexists(Datum, '/') then Datum:=Gettoken(Datum,'/',1)+Sep+Gettoken(Datum,'/',2)+Sep+Gettoken(Datum,'/',3);
          if (length(Datum)=19) and Tokenexists(Datum, '-') then Datum:=Gettoken(Datum,'-',1)+Sep+Gettoken(Datum,'-',2)+Sep+Gettoken(Datum,'-',3);
          if (length(Datum)=19) and Tokenexists(Datum, Sep) then Datum:=Gettoken(Datum,Sep,1)+Sep+Gettoken(Datum,Sep,2)+Sep+Gettoken(Datum,Sep,3);

          //z.B. 24.02.00 00:00:00 ("/" oder "." oder "-")
          if (length(Datum)=17) and Tokenexists(Datum, '.') then Datum:=Gettoken(Datum, '.',1)+Sep+Gettoken(Datum,'.',2)+Sep+Gettoken(Datum,'.',3);
          if (length(Datum)=17) and Tokenexists(Datum, '/') then Datum:=Gettoken(Datum, '/',1)+Sep+Gettoken(Datum,'/',2)+Sep+Gettoken(Datum,'/',3);
          if (length(Datum)=17) and Tokenexists(Datum, '-') then Datum:=Gettoken(Datum, '-',1)+Sep+Gettoken(Datum,'-',2)+Sep+Gettoken(Datum,'-',3);
          if (length(Datum)=17) and Tokenexists(Datum, Sep) then Datum:=Gettoken(Datum, Sep,1)+Sep+Gettoken(Datum,Sep,2)+Sep+Gettoken(Datum,Sep,3);

          if length(Datum)>10 then begin
             result:='#-99';
             exit;
          end;
          if Tokenexists(Datum, '.') then begin
             aa:=Gettoken(Datum,'.',1);
             bb:=Gettoken(Datum,'.',2);
             cc:=Gettoken(Datum,'.',3);
          end;
          if Tokenexists(Datum, '/') then begin
             aa:=Gettoken(Datum,'/',1);
             bb:=Gettoken(Datum,'/',2);
             cc:=Gettoken(Datum,'/',3);
          end;
          if Tokenexists(Datum, '-') then begin
             aa:=Gettoken(Datum,'-',1);
             bb:=Gettoken(Datum,'-',2);
             cc:=Gettoken(Datum,'-',3);
          end;
          if Tokenexists(Datum, Sep) then begin
             aa:=Gettoken(Datum,Sep,1);
             bb:=Gettoken(Datum,Sep,2);
             cc:=Gettoken(Datum,Sep,3);
          end;
          Tag:=1; Monat:=2; Jahr:=3;

          if (Uppercase(DFormat)='TT.MM.JJ') or (Uppercase(DFormat)='TT.MM.JJJJ') then begin
             Tag:=1; Monat:=2; Jahr:=3;
          end;
          if (Uppercase(DFormat)='TT/MM/JJ') or (Uppercase(DFormat)='TT/MM/JJJJ') then begin
             Tag:=1; Monat:=2; Jahr:=3;
          end;
          if (Uppercase(DFormat)='MM.TT.JJ') or (Uppercase(DFormat)='MM.TT.JJJJ') then begin
             Tag:=2; Monat:=1; Jahr:=3;
          end;
          if (Uppercase(DFormat)='MM/TT/JJ') or (Uppercase(DFormat)='MM/TT/JJJJ') then begin
             Tag:=2; Monat:=1; Jahr:=3;
          end;
          if (Uppercase(DFormat)='JJ.MM.TT') or (Uppercase(DFormat)='JJJJ.MM.TT') then begin
             Tag:=3; Monat:=2; Jahr:=1;
          end;
          if (Uppercase(DFormat)='JJ/MM/TT') or (Uppercase(DFormat)='JJJJ/MM/TT') then begin
             Tag:=3; Monat:=2; Jahr:=1;
          end;

          if (Uppercase(DFormat)='DD.MM.YY') or (Uppercase(DFormat)='DD.MM.YYYY') then begin
             Tag:=1; Monat:=2; Jahr:=3;
          end;
          if (Uppercase(DFormat)='DD/MM/YY') or (Uppercase(DFormat)='DD/MM/YYYY') then begin
             Tag:=1; Monat:=2; Jahr:=3;
          end;
          if (Uppercase(DFormat)='MM.DD.YY') or (Uppercase(DFormat)='MM.DD.YYYY') then begin
             Tag:=2; Monat:=1; Jahr:=3;
          end;
          if (Uppercase(DFormat)='MM/DD/YY') or (Uppercase(DFormat)='MM/DD/YYYY') then begin
             Tag:=2; Monat:=1; Jahr:=3;
          end;
          if (Uppercase(DFormat)='YY.MM.DD') or (Uppercase(DFormat)='YYYY.MM.DD') then begin
             Tag:=3; Monat:=2; Jahr:=1;
          end;
          if (Uppercase(DFormat)='YY/MM/DD') or (Uppercase(DFormat)='YYYY/MM/DD') then begin
             Tag:=3; Monat:=2; Jahr:=1;
          end;

          if (aa='') or (bb='') or (cc='') then begin
             result:='#-99';
             exit;
          end;

          if (not CheckAlphaNum(aa)=1) or (not CheckAlphaNum(bb)=1) or (not CheckAlphaNum(cc)=1) then begin
             result:='#-99';
             exit;
          end;

          case Tag of
            1:
              begin
               if length(aa)>2 then begin
                  result:='#-99';
                  exit;
               end;
              end;
            2:
              begin
               if length(bb)>2 then begin
                  result:='#-99';
                  exit;
               end;
              end;
            3:
              begin
               if length(cc)>2 then begin
                  result:='#-99';
                  exit;
               end;
              end;
          end;

          case Monat of
            1:
              begin
               if length(aa)>2 then begin
                  result:='#-99';
                  exit;
               end;
              end;
            2:
              begin
               if length(aa)>2 then begin
                  result:='#-99';
                  exit;
               end;
              end;
            3:
              begin
               if length(aa)>2 then begin
                  result:='#-99';
                  exit;
               end;
              end;
          end;

          case Jahr of
            1:
              begin
               if length(aa)>4 then begin
                  result:='#-99';
                  exit;
               end;
               if length(aa)<2 then begin
                  result:='#-99';
                  exit;
               end;
               if length(aa)=2 then begin
                  if strtoint(aa)>=90 then aa:='19'+aa;
                  if strtoint(aa)<90 then aa:='20'+aa;
               end;
              end;
            2:
              begin
               if length(bb)>4 then begin
                  result:='#-99';
                  exit;
               end;
               if length(bb)<2 then begin
                  result:='#-99';
                  exit;
               end;
               if length(bb)=2 then begin
                  if strtoint(bb)>=90 then bb:='19'+bb;
                  if strtoint(bb)<90 then bb:='20'+bb;
               end;
              end;
            3:
              begin
               if length(cc)>4 then begin
                  result:='#-99';
                  exit;
               end;
               if length(cc)<2 then begin
                  result:='#-99';
                  exit;
               end;
               if length(cc)=2 then begin
                  if strtoint(cc)>=90 then cc:='19'+cc;
                  if strtoint(cc)<90 then cc:='20'+cc;
               end;
              end;
          end;
          aa1:=strtoint(aa);
          bb1:=strtoint(bb);
          cc1:=strtoint(cc);

          If (Monat=1) and (Jahr=2) then MaxDays:=XDaysPerMonth(bb1, aa1);
          If (Monat=1) and (Jahr=3) then MaxDays:=XDaysPerMonth(cc1, aa1);
          If (Monat=2) and (Jahr=1) then MaxDays:=XDaysPerMonth(aa1, bb1);
          If (Monat=2) and (Jahr=3) then MaxDays:=XDaysPerMonth(cc1, bb1);
          If (Monat=3) and (Jahr=2) then MaxDays:=XDaysPerMonth(cc1, bb1);
          If (Monat=3) and (Jahr=1) then MaxDays:=XDaysPerMonth(cc1, aa1);
          case Tag of
           1: begin
                if (aa1>MaxDays) or (aa1<1) then begin
                   result:='#-99';
                   exit;
                end;
              end;
           2: begin
                if (bb1>MaxDays) or (bb1<1) then begin
                   result:='#-99';
                   exit;
                end;
              end;
           3: begin
                if (cc1>MaxDays) or (cc1<1) then begin
                   result:='#-99';
                   exit;
                end;
              end;
          end;

          case Monat of
           1: begin
               if (aa1>12) or (aa1<1) then begin
                  result:='#-99';
                  exit;
               end;
              end;
           2: begin
               if (bb1>12) or (bb1<1) then begin
                  result:='#-99';
                  exit;
               end;
              end;
           3: begin
               if (cc1>12) or (cc1<1) then begin
                  result:='#-99';
                  exit;
               end;
              end;
          end;

          case Jahr of
           1: begin
                if (aa1>2090) or (aa1<1990) then begin
                   result:='#-99';
                   exit;
                end;
              end;
           2: begin
                if (bb1>2090) or (bb1<1990) then begin
                   result:='#-99';
                   exit;
                end;
              end;
           3: begin
                if (cc1>2090) or (cc1<1990) then begin
                   result:='#-99';
                   exit;
                end;
              end;
          end;
          if Format<>'' then DFormat:=Format;
          if (Uppercase(DFormat)='TT.MM.JJ') or (Uppercase(DFormat)='TT.MM.JJJJ') then result:=aa+'.'+bb+'.'+cc;
          if (Uppercase(DFormat)='TT/MM/JJ') or (Uppercase(DFormat)='TT/MM/JJJJ') then result:=aa+'/'+bb+'/'+cc;
          if (Uppercase(DFormat)='TT-MM-JJ') or (Uppercase(DFormat)='TT-MM-JJJJ') then result:=aa+'-'+bb+'-'+cc;
          if (Uppercase(DFormat)='TT'+Sep+'MM'+Sep+'JJ') or (Uppercase(DFormat)='TT'+Sep+'MM'+Sep+'JJJJ') then result:=aa+Sep+bb+Sep+cc;

          if (Uppercase(DFormat)='MM.TT.JJ') or (Uppercase(DFormat)='MM.TT.JJJJ') then result:=bb+'.'+aa+'.'+cc;
          if (Uppercase(DFormat)='MM/TT/JJ') or (Uppercase(DFormat)='MM/TT/JJJJ') then result:=bb+'/'+aa+'/'+cc;
          if (Uppercase(DFormat)='MM-TT-JJ') or (Uppercase(DFormat)='MM-TT-JJJJ') then result:=bb+'-'+aa+'-'+cc;
          if (Uppercase(DFormat)='MM'+Sep+'TT'+Sep+'JJ') or (Uppercase(DFormat)='MM'+Sep+'TT'+Sep+'JJJJ') then result:=bb+Sep+aa+Sep+cc;

          if (Uppercase(DFormat)='JJ.MM.TT') or (Uppercase(DFormat)='JJJJ.MM.TT') then result:=cc+'.'+bb+'.'+aa;
          if (Uppercase(DFormat)='JJ/MM/TT') or (Uppercase(DFormat)='JJJJ/MM/TT') then result:=cc+'/'+bb+'/'+aa;
          if (Uppercase(DFormat)='JJ-MM-TT') or (Uppercase(DFormat)='JJJJ-MM-TT') then result:=cc+'-'+bb+'-'+aa;
          if (Uppercase(DFormat)='JJ'+Sep+'MM'+Sep+'TT') or (Uppercase(DFormat)='JJJJ'+Sep+'MM'+Sep+'TT') then result:=cc+Sep+bb+Sep+aa;

          if (Uppercase(DFormat)='DD.MM.YY') or (Uppercase(DFormat)='DD.MM.YYYY') then result:=aa+'.'+bb+'.'+cc;
          if (Uppercase(DFormat)='DD/MM/YY') or (Uppercase(DFormat)='DD/MM/YYYY') then result:=aa+'/'+bb+'/'+cc;
          if (Uppercase(DFormat)='DD-MM-YY') or (Uppercase(DFormat)='DD-MM-YYYY') then result:=aa+'-'+bb+'-'+cc;
          if (Uppercase(DFormat)='DD'+Sep+'MM'+Sep+'YY') or (Uppercase(DFormat)='DD'+Sep+'MM'+Sep+'YYYY') then result:=aa+Sep+bb+Sep+cc;

          if (Uppercase(DFormat)='MM.DD.YY') or (Uppercase(DFormat)='MM.DD.YYYY') then result:=bb+'.'+aa+'.'+cc;
          if (Uppercase(DFormat)='MM/DD/YY') or (Uppercase(DFormat)='MM/DD/YYYY') then result:=bb+'/'+aa+'/'+cc;
          if (Uppercase(DFormat)='MM-DD-YY') or (Uppercase(DFormat)='MM-DD-YYYY') then result:=bb+'-'+aa+'-'+cc;
          if (Uppercase(DFormat)='MM'+Sep+'DD'+Sep+'YY') or (Uppercase(DFormat)='MM'+Sep+'DD'+Sep+'YYYY') then result:=bb+Sep+aa+Sep+cc;

          if (Uppercase(DFormat)='YY.MM.DD') or (Uppercase(DFormat)='YYYY.MM.DD') then result:=cc+'.'+bb+'.'+aa;
          if (Uppercase(DFormat)='YY/MM/DD') or (Uppercase(DFormat)='YYYY/MM/DD') then result:=cc+'/'+bb+'/'+aa;
          if (Uppercase(DFormat)='YY-MM-DD') or (Uppercase(DFormat)='YYYY-MM-DD') then result:=cc+'-'+bb+'-'+aa;
          if (Uppercase(DFormat)='YY'+Sep+'MM'+Sep+'DD') or (Uppercase(DFormat)='YYYY'+Sep+'MM'+Sep+'DD') then result:=cc+Sep+bb+Sep+aa;
        end;

function HigherDate(Date1, Date2: string):integer;
        var
          Temp1, Temp2: string;
          Year1, Month1, Day1: Word;
          Year2, Month2, Day2: Word;
        begin
          result:=0;
          if (Date1='') and (Date2<>'') then begin
             result:=2;
             exit;
          end;
          if (Date2='') and (Date1<>'') then begin
             result:=1;
             exit;
          end;
          if (Date1='') and (Date2='') then begin
             result:=0;
             exit;
          end;
          Temp1:=CheckDatum(Date1);
          Temp2:=CheckDatum(Date2);

          if (Temp1='#-99') or (Temp2='#-99') then begin
             result:=0;
             exit;
          end;

          DecodeDate(strtodate(Temp1), Year1, Month1, Day1);
          DecodeDate(strtodate(Temp2), Year2, Month2, Day2);

          if Year1>Year2 then begin
             result:=1;
             exit;
          end;
          if Year1<Year2 then begin
             result:=2;
             exit;
          end;
          if Year1=Year2 then begin
            if Month1>Month2 then begin
               result:=1;
               exit;
            end;
            if Month1<Month2 then begin
               result:=2;
               exit;
            end;
            if Month1=Month2 then begin
               if Day1<Day2 then begin
                  result:=2;
                  exit;
               end;
               if Day1>Day2 then begin
                  result:=1;
                  exit;
               end;
               if Day1=Day2 then begin
                  result:=3;
                  exit;
               end;
            end;
         end;
       end;

// String mit Seperator Routinen
// -------------------------------------------------------------------------------

function GetToken(aString, SepChar: String; TokenNum: Byte):String;
        // Liet einen Bereich eines String der mit einem Seperator getrennt ist.
        // z.B. Gettoken('Test1, Test2, Test3', ',', 1) -> "Test1"
        // z.B. Gettoken('Test1, Test2, Test3', ',', 2) -> "Test2"
        // z.B. Gettoken('Test1, Test2, Test3', ',', 3) -> "Test3"
        var
         Token : String;
         StrLen : integer;
         TNum : integer;
         TEnd : integer;
        begin
         StrLen := Length(aString);
         TNum := 1;
         TEnd := StrLen;
         if (aString<>'') and (TEnd=0) then TEnd:=Length(aString);
         while ((TNum <= TokenNum) and (TEnd <> 0)) do begin
          TEnd := Pos(SepChar,aString);
          if TEnd <> 0 then begin
             Token := Copy(aString,1,TEnd-1);
             Delete(aString,1,TEnd);
             Inc(TNum);
          end else begin
             Token := aString;
          end;
         end;
         if TNum >= TokenNum then begin
            result:= Token;
         end else begin
            result:= '';
         end;
        end;

function DeleteToken(aString, SepChar: String; TokenNum: Byte): string;
        // Lscht einen Bereich eines String der mit einem Seperator getrennt ist.
        // z.B. aString:=Deletetoken('Test1, Test2, Test3', ',', 1) -> "Test2, Test3"
        // z.B. aString:=Deletetoken('Test1, Test2, Test3', ',', 2) -> "Test1, Test3"
        // z.B. aString:=Deletetoken('Test1, Test2, Test3', ',', 3) -> "Test1, Test2"
        var
          Temp, Temp1: String;
          Von, bis, Token, a, v: integer;
        begin
          Von:=0; Bis:=0; v:=0;
          Temp:=aString;
          Token:=HowManyToken(Temp,Sepchar);
          if TokenNum=Token+1 then v:=1;
          if TokenNum>Token+1 then begin
             result:=aString;
             exit;
          end;
          if TokenNum>1 then begin
             for a:= 1 to TokenNum-1 do begin
               Von:=Von+length(Gettoken(Temp,Sepchar,a))+1;
             end;
             for a:= 1 to TokenNum do begin
               Bis:=Bis+length(Gettoken(Temp,Sepchar,a))+1;
             end;
             Temp1:=Copy(Temp,1,von-v)+copy(Temp,bis+1,length(Temp)-bis);
          end;
          if TokenNum=1 then begin
             Von:=1;
             for a:= 1 to TokenNum do begin
               Bis:=Bis+length(Gettoken(Temp,Sepchar,a))+1;
             end;
             Temp1:=copy(Temp,bis+1,length(Temp)-bis);
          end;
          result:=Temp1;
        end;

function InsertToken(aString, SepChar: String; TokenNum: Byte; Value: String): string;
        // Fgt einen Bereich eines String der mit einem Seperator getrennt ist hinzu.
        // z.B. aString:=Inserttoken('Test1, Test2, Test3', ',', 1, 'Test4') -> "Test4, Test1, Test2, Test3"
        // z.B. aString:=Inserttoken('Test1, Test2, Test3', ',', 2, 'Test4') -> "Test1, Test4, Test2, Test3"
        // z.B. aString:=Inserttoken('Test1, Test2, Test3', ',', 3, 'Test4') -> "Test1, Test2, Test4, Test3"
        var
          Temp, Temp1: String;
          Von, Token, a: integer;
        begin
          Von:=0;
          Temp:=aString;
          Token:=HowManyToken(Temp,Sepchar);
          if TokenNum>Token+1 then begin
             result:=aString+Sepchar+Value;
             exit;
          end;
          if TokenNum>1 then begin
             for a:= 1 to TokenNum-1 do begin
               Von:=Von+length(Gettoken(Temp,Sepchar,a))+1;
             end;
             Temp1:=Copy(Temp,1,von)+Value+copy(Temp,von,length(Temp));
          end;
          if TokenNum=1 then Temp1:=Value+Sepchar+Temp;
          result:=Temp1;
        end;

function SetToken(aString, SepChar: String; TokenNum: Byte; Value: String): string;
        // berschrebt einen Bereich eines String der mit einem Seperator getrennt ist.
        // z.B. aString:=Settoken('Test1, Test2, Test3', ',', 1, 'Test4') -> "Test4, Test2, Test3"
        // z.B. aString:=Settoken('Test1, Test2, Test3', ',', 2, 'Test4') -> "Test1, Test4, Test3"
        // z.B. aString:=Settoken('Test1, Test2, Test3', ',', 3, 'Test4') -> "Test1, Test2, Test4"
        var
          Temp, Temp1: String;
          Von, Bis, Token, a: integer;
        begin
          Von:=0; Bis:=0;
          Temp:=aString;
          Token:=HowManyToken(Temp,Sepchar);
          if TokenNum>Token+1 then begin
             result:=aString+Sepchar+Value;
             exit;
          end;
          if TokenNum>1 then begin
             for a:= 1 to TokenNum-1 do begin
               Von:=Von+length(Gettoken(Temp,Sepchar,a))+1;
             end;
             for a:= 1 to TokenNum do begin
               Bis:=Bis+length(Gettoken(Temp,Sepchar,a))+1;
             end;
             Temp1:=Copy(Temp,1,von)+Value+copy(Temp,bis,length(Temp)-bis+1);
          end;
          if TokenNum=1 then begin
             Von:=1;
             for a:= 1 to TokenNum do begin
               Bis:=Bis+length(Gettoken(Temp,Sepchar,a))+1;
             end;
             Temp1:=Value+copy(Temp,bis,length(Temp)-bis+1);
          end;
          result:=Temp1;
        end;

function NumToken(aString, SepChar: String):Byte;
        // ???? ist nicht von mir.
        var
          RChar : Char;
          StrLen : Byte;
          TNum : Byte;
          TEnd : Byte;
        begin
          if SepChar = '#' then begin
             RChar := '*'
          end else begin
             RChar := '#'
          end;
          StrLen := Length(aString);
          TNum := 0;
          TEnd := StrLen;
          while TEnd <> 0 do begin
             Inc(TNum);
             TEnd := Pos(SepChar,aString);
             if TEnd <> 0 then begin
                aString[TEnd] := RChar;
             end;
          end;
          result:= TNum;
        end;

function TokenExists(aString, SepChar: string): boolean;
        // Existiert ein Token im String
        // z.B. Tokenexists ('Test1, Test2, Test3', ',') -> TRUE
        // z.B. Tokenexists ('Test1?TEST2?TEST3', ',') -> FALSE
        var
          Temp: string;
          i:integer;
        begin
          result:=false;
          Temp:=aString;
          for i:=1 to length(Temp) do begin
             if copy(Temp,i,1)=SepChar then begin
                result:=true;
                exit;
             end;
          end;
        end;

function HowManyToken(aString, SepChar: string): integer;
        // Wieviele Token existieren im String
        // z.B. Tokenexists ('Test1, Test2, Test3', ',') -> 3
        // z.B. Tokenexists ('Test1?TEST2?TEST3', ',') -> 0
        var
          Temp: string;
          i:integer;
        begin
          Temp:=aString;
          result:=0;
          for i:=1 to length(Temp) do begin
            if copy(Temp,i,1)=SepChar then result:=result+1;
          end;
        end;

// Diverse Routinen
// -------------------------------------------------------------------------------

Function LastPos(Ch : Char; S : String) : Integer;
	Var i : Integer;
	Begin
	  Result := 0;
	  For i := Length(S) DownTo 1 do
	  IF S[i] = Ch Then
	  Begin
	    Result := i;
	    Exit;
	  End;
	End;

Function StrReplace(S : String; FromC, ToC : Char) : String;
	Var FoundPos : Integer;
	Begin
	  FoundPos := Pos(FromC, S);
	  While FoundPos <> 0 Do
	  Begin
	    S[FoundPos] := ToC;
	    FoundPos := Pos(FromC, S);
	  End;
	  Result := S;
	End;

Procedure StrTranslate(Var S: String; Code : String);
	Var i : Integer;
	Begin
	  IF (Length(Code) = 0) Or (Length(Code) Mod 2 <> 0) Then Exit;
	  For i := 1 To Length(Code) Div 2 Do
	  Begin
	    While Pos(Code[i*2-1], S) <> 0 Do
	    S[Pos(Code[i*2-1], S)] := Code[i*2];
	  End;
	End;

Function StrDeleteChar(S : String; Ch : Char) : String;
	Var chPos : Integer;
	Begin
	  chPos := Pos(Ch, S);
	  WHile chPos > 0 Do
	  Begin
	    Delete(S, chPos, 1);
	    chPos := Pos(Ch, S);
	  End;
	  Result := S;
	End;

Function StrContains(Str1, Str2 : String) : Boolean;
	Var i : Integer;
	Begin
	  For i := 1 To Length(Str1) Do
	    IF Pos(Str1[i], Str2) <> 0 Then
	    Begin
	      Result := True;
	      Exit;
	    End;
	  Result := False;
	End;

Function DosDateToDateStr(wDate : Word) : String;
	Var FileTime    : TFileTime;
	    SysTime     : TSystemTime;
	    DateTime    : TDateTime;
	Begin
	    DosDateTimeToFileTime(wDate, 0, FileTime);
	    FileTimeToSystemTime(FileTime, SysTime);
	    DateTime := SystemTimeToDateTime(SysTime);
	    Result := FormatDateTime(ShortDateFormat, DateTime);
	End;

Function StrDateToDosDate(DateStr : String) : Word;
	Var FileTime    : TFileTime;
	    SysTime     : TSystemTime;
	    DateTime    : TDateTime;
	    wTime       : Word;
	    wDate       : Word;
	Begin
	  DateTime := StrToDate(DateStr);
	  DateTimeToSystemTime(DateTime, SysTime);
	  SystemTimeToFileTime(SysTime, FileTime);
	  FileTimeToDosDateTime(FileTime, wDate , wTime);
	  Result := wDate;
	End;


Function  FormatSize(Size : Integer) : String;
	Begin
	  Result := FormatSize(Cardinal(ABS(Size)));
	End;

Function FormatSize(Size : Cardinal) : String;
	Var i : Integer;
	    p : Integer;
	Begin
	  p := 0;
	  i := 3;
	  Result := IntToStr(Size);
	  While i + p < Length(Result) Do
	  Begin
	    Insert(ThousandSeparator, Result, Length(Result) - (i + p)+ 1);
	    Inc(p);
	    INC(i, 3);
	  End;
	End; 

Function FormatSize(Size : Int64) : String;
	Var i : Integer;
	    p : Integer;
	Begin
	  p := 0;
	  i := 3;
	  Result := IntToStr(Size);
	  While i + p < Length(Result) Do
	  Begin
	    Insert(ThousandSeparator, Result, Length(Result) - (i + p)+ 1);
	    Inc(p);
	    INC(i, 3);
	  End;
	End;

Function HexByte( b : Byte ) : String;
	Const
	  Hex : Array[ $0..$F ] Of Char = '0123456789ABCDEF';
	Begin
	  HexByte := Hex[ b Shr 4 ] + Hex[ b And $F ];
	End;

Function HexWord( w : Word ) : String;
	Begin
	  HexWord := HexByte( Hi( w ) ) + HexByte( Lo( w ) );
	End;

Function DecToHex( aValue : LongInt ) : String;
	Var
	  w : Array[ 1..2 ] Of Word Absolute aValue;
	Begin
	  Result := HexWord( w[ 2 ] ) + HexWord( w[ 1 ] );
	End;

function Copy2Symb(const S: string; Symb: Char): string;
        var
          P: Integer;
        begin
          P := Pos(Symb, S);
          if P = 0 then P := Length(S) + 1;
          Result := Copy(S, 1, P - 1);
        end;

function DelChars(const S: string; Chr: Char): string;
        var
          I: Integer;
        begin
          Result := S;
          for I := Length(Result) downto 1 do begin
           if Result[I] = Chr then Delete(Result, I, 1);
          end;
        end;

function XIsLeapYear(AYear: Integer): Boolean;
begin
  Result := (AYear mod 4 = 0) and ((AYear mod 100 <> 0) or (AYear mod 400 = 0));
end;

function XDaysPerMonth(AYear, AMonth: Integer): Integer;
const
  DaysInMonth: array[1..12] of Integer =
    (31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
begin
  Result := DaysInMonth[AMonth];
  if (AMonth = 2) and XIsLeapYear(AYear) then Inc(Result); { leap-year Feb is special }
end;

end.
