{ ****************************************************************
  Info               :  System Information for TSystemInfo2000X
                        Freeware

  Source File Name   :  X2000SystemInfoSystem.PAS
  Author             :  Baldemaier Florian (Baldemaier.Florian@gmx.net)
  Compiler           :  Delphi 5.0 Professional
  Decription         :  Some base functions for TSystemInfo2000X.

  not all source code are made by the author.
**************************************************************** }

unit X2000SystemInfoSystem;

interface

Uses
  Windows, Forms, SysUtils, Classes, ShlObj, WinSock, ShellAPI, ActiveX, Registry, Printers, Controls;

type
  TDriveType = (dtUnknown, dtNoDrive, dtFloppy, dtFixed, dtNetwork, dtCDROM, dtRAM);

function  SHFormatDrive(hWnd : HWND;Drive, fmtID, Options : WORD) : longint; stdcall; external  'shell32.dll';

function  GetPath (value: integer)    : String;
function  GetUniversalName( const Drive : Char ): String;
function  DriveType( const Drive : Char ) : TDriveType;

function  GetComputerName             : AnsiString;
function  GetUserName                 : AnsiString;
function  GetFullyQualifiedDomainName : AnsiString;
function  GetWindowsDirectory         : AnsiString;
function  GetSystemDirectory          : AnsiString;
function  GetCurrentDirectory         : AnsiString;
function  GetSystemTime               : AnsiString;
function  GetLocalTime                : AnsiString;
function  GetOSVersion                : AnsiString;

function  DisconnectNetworkDrive( const Drive : Char ): Boolean;
function  AddNetworkDrive( const Resource : String; const Drive : Char ): Boolean;

procedure ShutDown;
procedure FormatDrive( const Drive : Char );

{$I x2000.inc}

Implementation

function GetPath(value: integer):string;
begin
  Result:='(unavailable)';
  with TRegistry.create do begin
   try
    RootKey := Root2;
    LazyWrite := false;
    OpenKey(WIN98_Path_Key, False);
    Case value of
      1:if ReadString('Desktop')<>'' then    Result:= ReadString('Desktop');
      2:if ReadString('Templates')<>'' then  Result:= ReadString('Templates');
      3:if ReadString('AppData')<>'' then    Result:= ReadString('AppData');
      4:if ReadString('Start Menu')<>'' then Result:= ReadString('Start Menu');
      5:if ReadString('Programs')<>'' then   Result:= ReadString('Programs');
      6:if ReadString('Startup')<>'' then    Result:= ReadString('Startup');
      7:if ReadString('Fonts')<>'' then      Result:= ReadString('Fonts');
      8:if ReadString('SendTo')<>'' then     Result:= ReadString('SendTo');
      9:if ReadString('Recent')<>'' then     Result:= ReadString('Recent');
     10:if ReadString('Favorites')<>'' then  Result:= ReadString('Favorites');
     11:if ReadString('NetHood')<>'' then    Result:= ReadString('NetHood');
     12:if ReadString('Personal')<>'' then   Result:= ReadString('Personal');
     13:if ReadString('Cache')<>'' then      Result:= ReadString('Cache');
     14:if ReadString('Cookies')<>'' then    Result:= ReadString('Cookies');
     15:if ReadString('History')<>'' then    Result:= ReadString('History');
    end;
    CloseKey;

    OpenKey(WIN98_Win_Key, False);
    case Value of
     16: if ReadString('WallPaperDir')<>'' then     Result:= ReadString('WallPaperDir');
     17: if ReadString('CommonFilesDir')<>'' then   Result:= ReadString('CommonFilesDir');
     18: if ReadString('ConfigPath')<>'' then       Result:= ReadString('ConfigPath');
     19: if ReadString('DevicePath')<>'' then       Result:= ReadString('DevicePath');
     20: if ReadString('MediaPath')<>'' then        Result:= ReadString('MediaPath');
     21: if ReadString('OtherDevicePath')<>'' then  Result:= ReadString('OtherDevicePath');
     22: if ReadString('SystemRoot')<>'' then       Result:= ReadString('SystemRoot');
     23: if ReadString('ProgramFilesPath')<>'' then Result:= ReadString('ProgramFilesPath');
    end;
    CloseKey;
   finally
    Free;
   end;
  end;
end;

function GetComputerName: AnsiString;
var lpBuffer: array[0..MAX_PATH] of char;
    dwSize: DWORD;
begin
  dwSize:= MAX_PATH;

  if not Windows.GetComputerName(lpBuffer, dwSize) then
    raise Exception.Create(SysErrorMessage(GetLastError()));

  Result:= StrPas(lpBuffer);
end;

function GetUserName: AnsiString;
var lpBuffer: array[0..MAX_PATH] of char;
    dwSize: DWORD;
begin
  dwSize:= MAX_PATH;

  if not Windows.GetUserName(lpBuffer, dwSize) then
    raise Exception.Create(SysErrorMessage(GetLastError()));

  Result:= StrPas(lpBuffer);
end;

function GetFullyQualifiedDomainName: AnsiString;
var HostEnt: PHostEnt;
    szHostname: array[0..MAX_PATH] of char;
begin
  Result:= '';
  if (GetHostName(szHostname, MAX_PATH) = 0) then
  begin
    HostEnt:= GetHostByName(szHostname);
    if Assigned(HostEnt) then
      Result:= StrPas(HostEnt^.h_name);
  end;
end;

function GetWindowsDirectory: AnsiString;
var lpBuffer: array[0..MAX_PATH] of char;
    dwSize: DWORD;
begin
  dwSize:= MAX_PATH;
  ZeroMemory(@lpBuffer, MAX_PATH);

  if Windows.GetWindowsDirectory(lpBuffer, dwSize) = 0 then
    raise Exception.Create(SysErrorMessage(GetLastError()));

  Result:= StrPas(lpBuffer);
end;

function GetSystemDirectory: AnsiString;
var lpBuffer: array[0..MAX_PATH] of char;
begin
  ZeroMemory(@lpBuffer, MAX_PATH);

  if Windows.GetSystemDirectory(lpBuffer, MAX_PATH) = 0 then
    raise Exception.Create(SysErrorMessage(GetLastError()));

  Result:= StrPas(lpBuffer);
end;

function GetCurrentDirectory: AnsiString;
var lpBuffer: array[0..MAX_PATH] of char;
begin
  ZeroMemory(@lpBuffer, MAX_PATH);

  if Windows.GetCurrentDirectory(MAX_PATH, lpBuffer) = 0 then
    raise Exception.Create(SysErrorMessage(GetLastError()));

  Result:= StrPas(lpBuffer);
end;

function GetSystemTime : AnsiString;
var
   stSystemTime : TSystemTime;
begin
   Windows.GetSystemTime( stSystemTime );
   Result := DateTimeToStr( SystemTimeToDateTime( stSystemTime ) );
end;

function GetLocalTime : AnsiString;
var
   stSystemTime : TSystemTime;
begin
   Windows.GetLocalTime( stSystemTime );
   Result := DateTimeToStr( SystemTimeToDateTime( stSystemTime ) );
end;

procedure FormatDrive( const Drive : Char );
var
  wDrive       : WORD;
  dtDrive      : TDriveType;
  strDriveType : String;
begin
   dtDrive := DriveType( Drive );
   if  ( dtDrive <> dtFloppy ) and ( dtDrive <> dtFixed ) then
      begin
         strDriveType := 'Cannot format a ';
         case dtDrive of
            dtUnknown : strDriveType := 'Cannot determine drive type';
            dtNoDrive : strDriveType := 'Specified drive does not exist';
            dtNetwork : strDriveType := strDriveType + 'Network Drive';
            dtCDROM   : strDriveType := strDriveType + 'CD-ROM Drive';
            dtRAM     : strDriveType := strDriveType + 'RAM Drive';
         end;
         raise Exception.Create( strDriveType + '.' );
      end
   else
      begin
         wDrive := Ord( Drive ) - Ord( 'A' );
         SHFormatDrive( Application.Handle, wDrive, $ffff, 0);
      end;
end;

procedure ShutDown;
const
  SE_SHUTDOWN_NAME = 'SeShutdownPrivilege';
var
  hToken       : THandle;
  tkp          : TTokenPrivileges;
  tkpo         : TTokenPrivileges;
  zero         : DWORD;
begin
  if Pos( 'Windows NT', GetOSVersion ) = 1  then
     begin
        zero := 0;
        if not OpenProcessToken( GetCurrentProcess(), TOKEN_ADJUST_PRIVILEGES or TOKEN_QUERY, hToken) then
           begin
             MessageBox( 0, 'Exit Error', 'OpenProcessToken() Failed', MB_OK );
             Exit;
           end;
        if not OpenProcessToken( GetCurrentProcess(), TOKEN_ADJUST_PRIVILEGES or TOKEN_QUERY, hToken) then
           begin
             MessageBox( 0, 'Exit Error', 'OpenProcessToken() Failed', MB_OK );
             Exit;
           end;

        if not LookupPrivilegeValue( nil, 'SeShutdownPrivilege' , tkp.Privileges[ 0 ].Luid ) then
           begin
              MessageBox( 0, 'Exit Error', 'LookupPrivilegeValue() Failed', MB_OK );
              Exit;
           end;
        tkp.PrivilegeCount := 1;
        tkp.Privileges[ 0 ].Attributes := SE_PRIVILEGE_ENABLED;

        AdjustTokenPrivileges( hToken, False, tkp, SizeOf( TTokenPrivileges ), tkpo, zero );
        if Boolean( GetLastError() ) then
           begin
              MessageBox( 0, 'Exit Error', 'AdjustTokenPrivileges() Failed', MB_OK );
              Exit;
           end
        else
           ExitWindowsEx( EWX_FORCE or EWX_SHUTDOWN, 0 );
      end
   else
      begin
        ExitWindowsEx( EWX_FORCE or EWX_SHUTDOWN, 0 );
      end;
end;

function GetOSVersion: AnsiString;
var
   VersionInfo : TOSVersionInfo;
begin
   VersionInfo.dwOSVersionInfoSize := SizeOf( TOSVersionInfo );
   if Windows.GetVersionEx( VersionInfo ) then
      begin
         with VersionInfo do
         begin
            case dwPlatformId of
               VER_PLATFORM_WIN32s	  : result := 'Win32s';
               VER_PLATFORM_WIN32_WINDOWS : result := 'Windows 95';
               VER_PLATFORM_WIN32_NT      : result := 'Windows NT';
            end;
         end;
      end
   else
      Result := '';
end;

function DisconnectNetworkDrive( const Drive : Char ): Boolean;
var
   sDrive    : String;
   pResource : PChar;
begin
   sDrive    := Drive + ':';
   pResource := PChar( sDrive );
   Result    := ( Windows.WNetCancelConnection2( pResource, 0, True ) = NO_ERROR );
end;

function AddNetworkDrive( const Resource : String; const Drive : Char ): Boolean;
var
   sDrive : String;
   pDrive : PChar;
begin
   sDrive := Drive + ':';
   pDrive := PChar( sDrive );
   Result := ( Windows.WNetAddConnection( PChar( Resource ), '', pDrive ) = NO_ERROR );
end;

function GetUniversalName( const Drive : Char ): String;
var
   pResource : PChar;
   lpBuffer  : PUniversalNameInfo;
   dwWDSize  : DWORD;
begin
   pResource := PChar( Drive + ':\' );
   dwWDSize  := 1024;
   GetMem( lpBuffer, dwWDSize );
   try
      if WNetGetUniversalName( pResource, UNIVERSAL_NAME_INFO_LEVEL, lpBuffer, dwWDSize ) = NO_ERROR then
         Result := lpBuffer.lpUniversalName
      else
         Result := 'ERROR';
   finally
      FreeMem( lpBuffer );
   end;
end;

function DriveType( const Drive : Char ) : TDriveType;
begin
   Result := TDriveType(GetDriveType(PChar(Drive + ':\')));
end;

end.
