{ ****************************************************************
  Info               :  Memory Info for TSystemInfo2000X
                        Freeware

  Source File Name   :  X2000SystemInfoMemory.PAS
  Author             :  Baldemaier Florian (Baldemaier.Florian@gmx.net)
  Compiler           :  Delphi 5.0 Professional
  Decription         :  Some base functions for TSystemInfo2000X.

  not all source code are made by the author.
**************************************************************** }

unit X2000SystemInfoMemory;

interface

Uses SysUtils, Windows, Classes, ShellApi, Registry, Printers;

function GetMemoryStatus(Mode : Byte) : LongInt;

var
  hInst16: THandle;
  SR: Pointer;

{$I x2000.inc}

Implementation

function GetMemoryStatus(Mode : Byte) : LongInt;
var
  MemInfo : TMemoryStatus;
begin
  Result:=0;
  MemInfo.dwLength := Sizeof (MemInfo);
  GlobalMemoryStatus(MemInfo);
  with MemInfo do
    case Mode of
      0 : result := dwTotalPhys div 1024;
      1 : result := dwAvailPhys div 1024;
      2 : result := dwTotalPageFile div 1024;
      3 : result := dwAvailPageFile div 1024;
      4 : result := dwTotalVirtual div 1024;
      5 : result := dwAvailVirtual div 1024;
      6 : result := dwMemoryLoad;
    end;
end;

end.
