{ ****************************************************************
  Info               :  Hardware Info for TSystemInfo2000X
                        Freeware

  Source File Name   :  X2000SystemInfoHardware.PAS
  Author             :  Baldemaier Florian (Baldemaier.Florian@gmx.net)
  Compiler           :  Delphi 5.0 Professional
  Decription         :  Some base functions for TSystemInfo2000X.

  not all functions or procedures are made by the author.
**************************************************************** }

unit X2000SystemInfoHardware;

interface

Uses SysUtils, Windows, Classes, ShellApi, Registry, Printers;

function GetCPUSpeed: Double;
function GetModem: string;
function GetBios		  (value: integer): String;
function GetCpu		  (value: integer): string;
function GetDisplay	  (value: integer): string;
function GetProxyServer   (value: integer): string;
function GetPrinterInfo   (value: integer): string;
function FindStr          (Temp: String; Find: string): string;
function GetCPUUsageInfos (value: integer): LongInt;
function GetInputDevices1 (value: integer): boolean;
function GetInputDevices2 (value: integer): string;

procedure GetController       (Liste: TStrings);
procedure GetSystemComponents (Liste: TStrings);
procedure GetMedia            (Liste: TStrings);
procedure GetCapabilities     (value: integer; Akt: TStrings);
procedure DCs_LC              (Ndx : Integer; Msg : String; Liste: TStrings);
procedure DCs_RC			(Ndx : Integer; Msg : String; Liste: TStrings);
procedure DCs_PC			(Ndx : Integer; Msg : String; Liste: TStrings);
procedure DCs_CC			(Ndx : Integer; Msg : String; Liste: TStrings);
procedure DCs_TC			(Ndx : Integer; Msg : String; Liste: TStrings);
procedure GetEmailAccouts     (Liste: TStrings);
procedure GetNetworkAdapters  (Liste: TStrings);
procedure GetNetworkProtocoll (Liste: TStrings);
procedure ReadFontData        (FontName, FontType, FontFile: TStrings);
procedure GetListStuff        (Reg : TRegistry; Dest : TStrings; Key, Val : String);

{$I x2000.inc}

Implementation

procedure GetListStuff(Reg : TRegistry; Dest : TStrings; Key, Val : String);
  var
    i : Integer;
    Buff : TStrings;
  begin
    Buff := TStringlist.create;
    with Reg do begin
      OpenKey(Key, False);
      GetKeyNames(Buff);
      CloseKey;

      if Buff.count>0 then begin
        for i:=0 to Buff.Count-1 do begin
          OpenKey(Key+'\'+Buff.Strings[i], False);
          if ReadString(Val)<>'' then begin
            Dest.Add(ReadString(Val));
          end;
          CloseKey;
        end;
      end;
    end;
    Buff.Free;
end;

function GetCPUSpeed: Double;
const
  DelayTime = 500;
var
  TimerHi, TimerLo: DWORD;
  PriorityClass, Priority: Integer;
begin
  PriorityClass := GetPriorityClass(GetCurrentProcess);
  Priority := GetThreadPriority(GetCurrentThread);

  SetPriorityClass(GetCurrentProcess, REALTIME_PRIORITY_CLASS);
  SetThreadPriority(GetCurrentThread, THREAD_PRIORITY_TIME_CRITICAL);

  Sleep(10);
  asm
    dw 310Fh
    mov TimerLo, eax
    mov TimerHi, edx
  end;
  Sleep(DelayTime);
  asm
    dw 310Fh 
    sub eax, TimerLo
    sbb edx, TimerHi
    mov TimerLo, eax
    mov TimerHi, edx
  end;

  SetThreadPriority(GetCurrentThread, Priority);
  SetPriorityClass(GetCurrentProcess, PriorityClass);

  Result := TimerLo / (1000.0 * DelayTime);
end;

function GetBios(value: integer): String;
// 1...Bios Type
// 2.. Bios Copyright
// 3.. Bios Date
// 4.. Bios Extended Info
// 5.. Bustype
// 6.. MachineType
begin
  result:='(unavailable)';
  case value of
   1: result:=String(Pchar(Ptr($FE061)));
   2: result:=String(Pchar(Ptr($FE091)));
   3: result:=String(Pchar(Ptr($FFFF5)));
   4: result:=String(Pchar(Ptr($FEC71)));
  end;
  with TRegistry.create do begin
   try
    RootKey := Root1;
    LazyWrite := false;
    OpenKey(WIN98_Bios_Key, False);
    case value of
     5: if ReadString('BusType')<>'' then     result:= ReadString('BusType');
     6: if ReadString('MachineType')<>'' then result:= ReadString('MachineType');
    end;
    CloseKey;
   finally
    Free;
   end;
  end;

end;

function GetCpu(value: integer): string;
var
  SI : TSystemInfo;
begin
  Result:='(unavailable)';
  with TRegistry.create do begin
   try
    RootKey := Root1;
    LazyWrite := false;
    OpenKey(WIN98_Cpu_Key, False);
    case value of
     1: if ReadString('Identifier')<>'' then         Result:= ReadString('Identifier');
     2: if ReadString('VendorIdentifier')<>'' then   Result:= ReadString('VendorIdentifier');
     3: if ReadString('MMXIdentifier')<>'' then      Result:= ReadString('MMXIdentifier');
    end;
    CloseKey;

    OpenKey(WIN98_CoProcessor_Key, False);
    case value of
     4: if ReadString('DeviceDesc')<>'' then         Result:= ReadString('DeviceDesc');
    end;
    CloseKey;
   finally
    Free;
   end;
  end;
  GetSystemInfo(SI);
  case value of
   5: result:= Format('%f MHz', [GetCPUSpeed]);
   6: result:= IntToStr(SI.dwNumberOfProcessors);
   7: result:= IntToStr(SI.dwActiveProcessorMask);
   8: result := IntToStr(SI.wProcessorRevision);
  end;
end;

procedure GetController(Liste: TStrings);
var
  Temp, Temp2: string;
begin
  Liste.Clear;
  with TRegistry.create do begin
   try
    RootKey := Root1;
    LazyWrite := false;
    OpenKey(WIN98_IDE_Key2, False);
      if ReadString('PortDriver')<>'' then Temp2:=ReadString('PortDriver') else Temp2:='no portdriver';
    CloseKey;
    OpenKey(WIN98_IDE_Key1, False);
     if ReadString('DriverDate')<>'' then Temp:='('+ReadString('DriverDate')+', ' else temp:='(no Date, ';
     if ReadString('DriverDesc')<>'' then Liste.Add('IDE Controller: '+temp+temp2+')');
    CloseKey;
    OpenKey(WIN98_SCSI_Key, False);
     if ReadString('DriverDate')<>'' then temp:='('+ReadString('DriverDate')+', ' else temp:='(no Date, ';
     if ReadString('PortDriver')<>'' then temp:=temp+ReadString('PortDriver')+')' else temp:=temp+', no portdriver)';
     if ReadString('DriverDesc')<>'' then Liste.Add('SCSI Controller: '+ReadString('DriverDesc')+temp);
    CloseKey;
    OpenKey(WIN98_USB_Key, False);
     if ReadString('DriverDate')<>'' then temp:='('+ReadString('DriverDate')+', ' else temp:='(no Date, ';
     if ReadString('NTMPDriver')<>'' then temp:=temp+ReadString('NTMPDriver')+')' else temp:=temp+', no portdriver)';
     if ReadString('DriverDesc')<>'' then Liste.Add('USB Controller: '+ReadString('DriverDesc')+temp);
    CloseKey;
    if Liste.count=0 then Liste.add('(unavailable)');
   finally
    Free;
   end;
  end;
end;

procedure GetSystemComponents(Liste: TStrings);
var i:integer;
    Provider, DrvDate, VXD, r: string;
begin
  with TRegistry.create do begin
   try
    RootKey := Root1;
    LazyWrite := false;
    for i:=0 to 30 do begin
     r:=inttostr(i);
     if i<10 then r:='0'+r;
     if KeyExists(WIN98_System_key+'\00'+r) then begin
         OpenKey(WIN98_System_key+'\00'+r, False);
         if ReadString('DriverDesc')<>'' then begin
          Provider:=ReadString('ProviderName');
          DrvDate:=ReadString('DriverDate');
          VXD:=ReadString('DevLoader');
          if Provider='' then Provider:='no Providername';
          if DrvDate='' then DrvDate:='??.??.????';
          if VXD='' then VXD:='no VXD';
          Liste.Add(ReadString('DriverDesc')+'  ('+Provider+', '+DrvDate+', '+VXD+')');
         end;
         CloseKey;
     end;
    end;
   finally
     Free;
   end;
   if Liste.count=0 then Liste.Add('(unavailable)');
  end;
end;

function GetDisplay(value: integer): string;
begin
  result:='(unavailable)';
  with TRegistry.create do begin
   try
    RootKey := Root1;
    LazyWrite := false;
    OpenKey(WIN98_Display_Key1, False);
     case value of
      1: if ReadString('DPILogicalX')<>'' then  Result:= ReadString('DPILogicalX');
      2: if ReadString('Resolution')<>'' then   Result:= ReadString('Resolution');
      3: if ReadString('BitsPerPixel')<>'' then Result:= ReadString('BitsPerPixel');
     end;
    CloseKey;

    OpenKey(WIN98_Display_Key2, False);
     case value of
      4:if ReadString('DriverDesc')<>'' then    Result:= ReadString('DriverDesc');
     end;
    CloseKey;

    OpenKey(WIN98_Display_Key2+'\Default', False);
     case value of
      5: if ReadString('Drv')<>'' then          Result:= ReadString('Drv');
     end;
    CloseKey;

    OpenKey(WIN98_Monitor_Key, False);
     case value of
      6: if ReadString('DriverDesc')<>'' then   Result:= ReadString('DriverDesc');
     end;
    CloseKey;
   finally
    free;
   end;
  end;
end;

procedure GetMedia(Liste: TStrings);
var i:integer;
    r: string;
begin
  with TRegistry.create do begin
   try
    RootKey := Root1;
    LazyWrite := false;
    for i:= 0 to 30 do begin
      r:=inttostr(i);
      if i<10 then r:='0'+r;
      if KeyExists(WIN98_Media_key1+'\00'+r) then begin
        OpenKey(WIN98_Media_key1+'\00'+r, False);
        if ReadString('DriverDesc')<>'' then begin
          Liste.Add(ReadString('DriverDesc'));
        end;
        CloseKey;
      end;
    end;
   finally
     Free;
   end;
   if Liste.count=0 then Liste.Add('(unavailable)');
  end;
end;

procedure DCs_LC(Ndx : Integer; Msg : String; Liste: TStrings);
var
    dc : HDC;
begin
    dc := GetDC(0);
    if (GetDeviceCaps(dc, LINECAPS) and Ndx)=Ndx then
        Liste.Add(Msg);
    ReleaseDC(0, dc);
end;

procedure DCs_RC(Ndx : Integer; Msg : String; Liste: TStrings);
var
    dc : HDC;
begin
    dc := GetDC(0);
    if (GetDeviceCaps(dc, RASTERCAPS) and Ndx)=Ndx then
        Liste.Add(Msg);
    ReleaseDC(0, dc);
end;

procedure DCs_CC(Ndx : Integer; Msg : String; Liste: TStrings);
var
    dc : HDC;
begin
    dc := GetDC(0);
    if (GetDeviceCaps(dc, CURVECAPS) and Ndx)=Ndx then
        Liste.Add(Msg);
    ReleaseDC(0, dc);
end;

procedure DCs_PC(Ndx : Integer; Msg : String; Liste: TStrings);
var
    dc : HDC;
begin
    dc := GetDC(0);
    if (GetDeviceCaps(dc, POLYGONALCAPS) and Ndx)=Ndx then
        Liste.Add(Msg);
    ReleaseDC(0, dc);
end;

procedure DCs_TC(Ndx : Integer; Msg : String; Liste: TStrings);
var
    dc : HDC;
begin
    dc := GetDC(0);
    if (GetDeviceCaps(dc, TEXTCAPS) and Ndx)=Ndx then
        Liste.Add(Msg);
    ReleaseDC(0, dc);
end;

procedure GetCapabilities(value: integer; Akt: TStrings);
var
  dc : HDC;
begin
  dc := GetDC(0);
  case value of
   1:
    begin
     Akt.Clear;
     DCs_RC(RC_BANDING,      'Requires Banding', Akt);
     DCs_RC(RC_BITBLT,       'Can Transer Bitmaps', Akt);
     DCs_RC(RC_BITMAP64,     'Supports Bitmaps > 64K', Akt);
     DCs_RC(RC_DI_BITMAP,    'Supports SetDIBits and GetDIBits', Akt);
     DCs_RC(RC_DIBTODEV,     'Supports SetDIBitsToDevice', Akt);
     DCs_RC(RC_FLOODFILL,    'Can Perform Floodfills', Akt);
     DCs_RC(RC_GDI20_OUTPUT, 'Supports Windows 2.0 Features', Akt);
     DCs_RC(RC_PALETTE,      'Palette Based', Akt);
     DCs_RC(RC_SCALING,      'Supports Scaling', Akt);
     DCs_RC(RC_STRETCHBLT,   'Supports StretchBlt', Akt);
     DCs_RC(RC_STRETCHDIB,   'Supports StretchDIBits', Akt);
    end;
   2:
    begin
     Akt.clear;
     if GetDeviceCaps(dc, CURVECAPS)=CC_NONE then
      Akt.Add('Device Does Not Support Curves')
     else
     begin
      DCs_CC(CC_CIRCLES,    'Supports Cirles', Akt);
      DCs_CC(CC_PIE,        'Supports Pie Wedges', Akt);
      DCs_CC(CC_CHORD,      'Supports Chords', Akt);
      DCs_CC(CC_ELLIPSES,   'Supports Ellipses', Akt);
      DCs_CC(CC_WIDE,       'Supports Wide Borders', Akt);
      DCs_CC(CC_STYLED,     'Supports Styled Borders', Akt);
      DCs_CC(CC_WIDESTYLED, 'Supports Wide And Styled Borders', Akt);
      DCs_CC(CC_INTERIORS,  'Supports Interiors', Akt);
      DCs_CC(CC_ROUNDRECT,  'Supports Rounded Rectangles', Akt);
     end;
    end;
   3:
    begin
     Akt.clear;
     if GetDeviceCaps(dc, LINECAPS)=LC_NONE then
      Akt.Add('Device Does Not Support Lines')
     else
     begin
      DCs_LC(LC_POLYLINE,   'Supports Polylines', Akt);
      DCs_LC(LC_MARKER,     'Supports Markers', Akt);
      DCs_LC(LC_POLYMARKER, 'Supports Multiple Markers', Akt);
      DCs_LC(LC_WIDE,       'Supports Wide Lines', Akt);
      DCs_LC(LC_STYLED,     'Supports Styled Lines', Akt);
      DCs_LC(LC_WIDESTYLED, 'Supports Wide And Styled Lines', Akt);
      DCs_LC(LC_INTERIORS,  'Supports Interiors', Akt);
     end;
    end;
   4:
    begin
     Akt.clear;
     if GetDeviceCaps(dc, POLYGONALCAPS)=PC_NONE then
      Akt.Add('Device Does Not Support Polygons')
     else
     begin
      DCs_PC(PC_POLYGON,     'Supports Alternate Fill Polygons', Akt);
      DCs_PC(PC_RECTANGLE,   'Supports Rectangles', Akt);
      DCs_PC(PC_WINDPOLYGON, 'Supports Winding Fill Polygons', Akt);
      DCs_PC(PC_SCANLINE,    'Supports Single Scanlines', Akt);
      DCs_PC(PC_WIDE,        'Supports Wide Borders', Akt);
      DCs_PC(PC_STYLED,      'Supports Styled Borders', Akt);
      DCs_PC(PC_WIDESTYLED,  'Supports Wide And Styled Borders', Akt);
      DCs_PC(PC_INTERIORS,   'Supports Interiors', Akt);
     end;
    end;
   5:
    begin
     Akt.clear;
     DCs_TC(TC_OP_CHARACTER, 'Capable of Character Output Precision', Akt);
     DCs_TC(TC_OP_STROKE,    'Capable of Stroke Output Precision', Akt);
     DCs_TC(TC_CP_STROKE,    'Capable of Stroke Clip Precision', Akt);
     DCs_TC(TC_CR_90,        'Supports 90 Degree Character Rotation', Akt);
     DCs_TC(TC_CR_ANY,       'Supports Character Rotation to Any Angle', Akt);
     DCs_TC(TC_SF_X_YINDEP,  'X And Y Scale Independent', Akt);
     DCs_TC(TC_SA_DOUBLE,    'Supports Doubled Character Scaling', Akt);
     DCs_TC(TC_SA_INTEGER,   'Supports Integer Multiples Only When Scaling', Akt);
     DCs_TC(TC_SA_CONTIN,    'Supports Any Multiples For Exact Character Scaling', Akt);
     DCs_TC(TC_EA_DOUBLE,    'Supports Double Weight Characters', Akt);
     DCs_TC(TC_IA_ABLE,      'Supports Italics', Akt);
     DCs_TC(TC_UA_ABLE,      'Supports Underlines', Akt);
     DCs_TC(TC_SO_ABLE,      'Supports Strikeouts', Akt);
     DCs_TC(TC_RA_ABLE,      'Supports Raster Fonts', Akt);
     DCs_TC(TC_VA_ABLE,      'Supports Vector Fonts', Akt);
     DCs_TC(TC_SCROLLBLT,    'Cannot Scroll Using Blts', Akt);
    end;
  end;
  ReleaseDC(0, dc);
end;

procedure ReadFontData (FontName, FontType, FontFile: TStrings);
var
  s, S_Name, S_Type, S_File : TStringList;
  i, j, a, b   : integer;
  s1     : string;
begin
  with TRegistry.Create do begin
    try
     RootKey := Root1;
     OpenKey(WIN98_FONTS_KEY, false);
     s      := TStringList.Create;
     S_Name := TStringList.Create;
     S_Type := TStringList.Create;
     S_File := TStringList.Create;
     GetValueNames(s);
     j  := s.count;
     for i := 1 to j do begin
       s1 := s[Pred(i)];
       if (Pos('(', s1) > 0) and (Pos(')', s1) > 0) then begin
          a := Pos(')', s1);
          b := Pos('(', s1);
          S_Type.Add(Copy(s1, Succ(b), Pred(a - b)));
          Delete(s1, b, Succ(a -  b));
       end else
          S_Type.Add('???-Font');

       S_Name.Add(s1);
       S_File.Add(ReadString(s[Pred(i)]));
     end;
     FontName.Assign(S_Name);
     FontType.Assign(S_Type);
     FontFile.Assign(S_File);
   finally
    Free;
    s.Free;
    S_Name.Free;
    S_Type.Free;
    S_File.Free;
   end;
  end;
end;

function FindStr(Temp: String; Find: string): string;
var i, k: integer;
begin
 for i:=1 to length(Temp) do begin
  if uppercase(copy(Temp,i,length(Find)))=uppercase(Find) then begin
  for k:=i to length(Temp) do begin
    if copy(Temp,k,1)=';' then begin
       Result:=copy(Temp,length(Find)+i,k-length(Find)-i);
       exit;
    end;
  end;
 end;
 end;
end;


function GetProxyServer (value: integer): string;
var ProxyTemp: String;
begin
  Result:='(unavailable)';
  with TRegistry.Create do begin
    try
     RootKey := Root2;
     OpenKey(WIN98_Proxy_Key,false);
      if ReadString('ProxyServer')<>'' then ProxyTemp:=ReadString('ProxyServer')+';';
      case value of
       1: if ReadString('ProxyOverride')<>'' then Result:=ReadString('ProxyOverride');
      end;
     CloseKey;

     if ProxyTemp='' then exit;
     case value of
      2: Result:=FindStr(ProxyTemp, 'FTP=');
      3: Result:=FindStr(ProxyTemp, 'GOPHER=');
      4: Result:=FindStr(ProxyTemp, 'HTTP=');
      5: Result:=FindStr(ProxyTemp, 'HTTPS=');
      6: Result:=FindStr(ProxyTemp, 'SOCKS=');
     end;
    finally
     Free;
    end;
  end;
end;

procedure GetEmailAccouts (Liste: TStrings);
var Emails: TStrings;
    AccountName, EmailTemp: string;
    POP3Server, POP3User, SMTPServer, SMTPName, SMTPEmailAdress:string;
    i: integer;
begin
  Emails:=TStringlist.create;
  Emails.Clear;
  with TRegistry.Create do begin
    try
     RootKey := Root2;
     LazyWrite := false;
     OpenKey(WIN98_Email_Key,false);
      GetKeyNames(Emails);
     CloseKey;
     if Emails.Count>0 then begin
       for i:=0 to Emails.Count-1 do begin
         OpenKey(WIN98_Email_Key+'\'+Emails.Strings[i], False);
         AccountName:=ReadString('Account Name');
         POP3Server:=ReadString('POP3 Server');
         POP3User:=ReadString('POP3 User Name');
         SMTPServer:=ReadString('SMTP Server');
         SMTPName:=ReadString('SMTP Display Name');
         SMTPEmailAdress:=ReadString('SMTP Email Address');
         if AccountName='' then AccountName:='no Account Name';
         if POP3User='' then POP3User:='no POP3 User';
         if SMTPName='' then SMTPName:='no SMTP Display Name';
         if SMTPEmailAdress='' then SMTPEmailAdress:='no SMTP Email Adress';

         EmailTemp:=AccountName+'; '+POP3Server+'; '+POP3User+'; '+SMTPServer+'; '+SMTPName+'; '+SMTPEmailAdress;
         if POP3Server<>'' then begin
          if SMTPServer<>'' then begin
           Liste.Add(EmailTemp);
          end;
         end;
        CloseKey;
       end;
     end;
    finally
      Free;
      Emails.Free;
    end;
  end;
  if Liste.count=0 then Liste.Add('(unavailable)');
end;

procedure GetNetworkAdapters(Liste: TStrings);
var i: integer;
    r: string;
    Provider, DrvDate, VXD: string;
begin

   with TRegistry.create do begin
    try
     RootKey := Root1;
     LazyWrite := false;
     for i:=0 to 30 do begin
       r:=inttostr(i);
       if i<10 then r:='0'+r;
       if KeyExists(WIN98_Net_Key1+'\00'+r) then begin
          OpenKey(WIN98_Net_Key1+'\00'+r, False);
          if ReadString('DriverDesc')<>'' then begin
            Provider:=ReadString('ProviderName');
            DrvDate:=ReadString('DriverDate');
            VXD:=ReadString('DeviceVxds');
            if Provider='' then Provider:='no Providername';
            if DrvDate='' then DrvDate:='??.??.????';
            if VXD='' then VXD:='no VXD';
            Liste.Add(ReadString('DriverDesc')+'  ('+Provider+', '+DrvDate+', '+VXD+')');
          end;
          CloseKey;
        end;
     end;

     for i:=0 to 30 do begin
       r:=inttostr(i);
       if i<10 then r:='0'+r;
       if KeyExists(WIN98_Net_Key2+'\00'+r) then begin
          OpenKey(WIN98_Net_Key2+'\00'+r, False);
          if ReadString('DriverDesc')<>'' then begin
            Provider:=ReadString('ProviderName');
            DrvDate:=ReadString('DriverDate');
            VXD:=ReadString('DeviceVxds');
            if Provider='' then Provider:='no Providername';
            if DrvDate='' then DrvDate:='??.??.????';
            if VXD='' then VXD:='no VXD';
            Liste.Add(ReadString('DriverDesc')+'  ('+Provider+', '+DrvDate+', '+VXD+')');
          end;
          CloseKey;
       end;
     end;

     for i:=0 to 30 do begin
       r:=inttostr(i);
       if i<10 then r:='0'+r;
       if KeyExists(WIN98_Net_Key3+'\00'+r) then begin
          OpenKey(WIN98_Net_Key3+'\00'+r, False);
          if ReadString('DriverDesc')<>'' then begin
            Provider:=ReadString('ProviderName');
            DrvDate:=ReadString('DriverDate');
            VXD:=ReadString('DeviceVxds');
            if Provider='' then Provider:='no Providername';
            if DrvDate='' then DrvDate:='??.??.????';
            if VXD='' then VXD:='no VXD';
            Liste.Add(ReadString('DriverDesc')+'  ('+Provider+', '+DrvDate+', '+VXD+')');
          end;
           CloseKey;
       end;
     end;
    finally
     Free;
    end;
   end;
   if Liste.count=0 then Liste.Add('(unavailable)');
end;

procedure GetNetworkProtocoll(Liste: TStrings);
var i: integer;
    r: string;
    Provider, DrvDate, VXD: string;
begin
   with TRegistry.create do begin
    try
     RootKey := Root1;
     LazyWrite := false;
     for i:=0 to 30 do begin
       r:=inttostr(i);
       if i<10 then r:='0'+r;
       if KeyExists(WIN98_NetProtocol_key+'\00'+r) then begin
          OpenKey(WIN98_NetProtocol_key+'\00'+r, False);
          if ReadString('DriverDesc')<>'' then begin
            Provider:=ReadString('ProviderName');
            DrvDate:=ReadString('DriverDate');
            VXD:=ReadString('DeviceVxds');
            if Provider='' then Provider:='no Providername';
            if DrvDate='' then DrvDate:='??.??.????';
            if VXD='' then VXD:='no VXD';
            Liste.Add(ReadString('DriverDesc')+'  ('+Provider+', '+DrvDate+', '+VXD+')');
          end;
          CloseKey;
       end;
     end;
    finally
     Free;
    end;
   end;
   if Liste.count=0 then Liste.Add('(unavailable)');
end;

function GetPrinterInfo(value: integer): string;
var
  pDevice :pchar;
  pDriver :pchar;
  pPort   :pchar;
  hDMode  :THandle;
begin
  result:='(unavailable)';
  GetMem(pDevice, cchDeviceName);
  GetMem(pDriver, MAX_PATH);
  GetMem(pPort, MAX_PATH);
  Printer.GetPrinter(pDevice, pDriver, pPort, hDMode);

  case value of
   1: if pdevice<>'' then Result:=pDevice;
   2: if pPort<>'' then   Result:=pPort;
  end;

  FREEMem(pDevice, cchDeviceName);
  FREEMem(pDriver, MAX_PATH);
  FREEMem(pPort, MAX_PATH);
end;

function GetModem: string;
begin
  Result:='(unavailable)';
  with TRegistry.create do begin
   RootKey := Root1;
   LazyWrite := false;
   OpenKey(WIN98_Modem_Key+'\0000', False);
    if ReadString('DriverDesc')<>'' then Result:=ReadString('DriverDesc');
   CloseKey;
   Free;
  end;
end;

function GetCPUUsageInfos(value: integer): LongInt;
var
  lData : Longint;
begin
   result:=0;
   with TRegistry.Create do begin
      try
        RootKey := HKEY_DYN_DATA;
        OpenKey('PerfStats\StatData', false);
        case value of
         1: begin
             ReadBinaryData('KERNEL\CPUUsage', lData, GetDataSize('KERNEL\CPUUsage'));
             result:= lData;
            end;
         2: begin
             ReadBinaryData('KERNEL\Threads', lData, GetDataSize('KERNEL\Threads'));
             result:= lData;
            end;
         3: begin
             ReadBinaryData('KERNEL\VMs', lData, GetDataSize('KERNEL\VMs'));
             result:= lData;
            end;
         4: begin
             ReadBinaryData('VFat\BReadsSec', lData, GetDataSize('VFat\BReadsSec'));
             result:= lData div 1024;
            end;
         5: begin
             ReadBinaryData('VFat\BWritesSec', lData, GetDataSize('VFat\BWritesSec'));
             result:= lData div 1024;
            end;
         6: begin
             ReadBinaryData('VFat\DirtyData', lData, GetDataSize('VFat\DirtyData'));
             result:= lData;
            end;
         7: begin
             ReadBinaryData('VFat\ReadsSec', lData, GetDataSize('VFat\ReadsSec'));
             result:= lData;
            end;
         8: begin
             ReadBinaryData('VFat\WritesSec', lData, GetDataSize('VFat\WritesSec'));
             result:= lData;
            end;
        end;
      finally
         free;
      end;
   end;
end;

function GetInputDevices1(value: integer): boolean;
begin
   result:=false;
   case value of
    1: result:=Boolean(GetSystemMetrics(SM_MOUSEPRESENT));
    2: result:=Boolean(GetSystemMetrics(SM_SWAPBUTTON));
    3: result:=Boolean(GetSystemMetrics(SM_MOUSEWHEELPRESENT));
   end;
end;

function GetInputDevices2(value: integer): string;
begin
   result:='(unavailable)';
   with TRegistry.create do begin
    RootKey := Root1;
    LazyWrite := false;

    OpenKey(WIN98_Mouse_Key1, False);
     case value of
      1: if ReadString('DriverDesc')<>'' then Result:= ReadString('DriverDesc');
     end;
    CloseKey;

    OpenKey(WIN98_Keyboard_Key, False);
     case value of
      2: if ReadString('DriverDesc')<>'' then Result:= ReadString('DriverDesc');
      3: result:= IntToStr(GetKeyboardType(2));
      4: result:= inttostr(GetSystemMetrics(SM_CMOUSEBUTTONS));
     end;
    CloseKey;
   end;
end;

end.
