{ ****************************************************************
  Info               :  TSystemInfo2000X
                        Freeware

  Source File Name   :  X2000SystemInfo.PAS
  Author             :  Baldemaier Florian (Baldemaier.Florian@gmx.net)
  Compiler           :  Delphi 5.0 Professional
  Operating System   :  only Windows 98 (Important!!!!)
  Decription         :  Systeminfo component. All returned information
                        are from the Windows registry.

**************************************************************** }

unit X2000SystemInfo;

interface

uses
     Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, ShlObj,
     WinSock, ShellAPI, ActiveX, Registry, ExtCtrls, StdCtrls, x2000AboutInfo,
     X2000SystemInfoHardware, X2000SystemInfoMemory, X2000SystemInfoSystem;

type
 //=== THARDWAREX Classes ==================================================
 	 TMotherboardX=class (TPersistent)
	  private
	     FBiosDate, FBiosName, FBiosVer, FBiosSer:string;
	     FBusType, FMachineType:string;
	  published
	     property BiosDate     : string read FBiosDate    write FBiosDate      Stored False;
	     property BiosCopyright: string read FBiosName    write FBiosName      Stored False;
	     property BiosVersion  : string read FBiosVer     write FBiosVer       Stored False;
	     property BiosSerial   : string read FBiosSer     write FBiosSer       Stored False;
	     property BusType      : string read FBusType     write FBusType       Stored False;
	     property MachineType  : string read FMachineType write FMachineType   Stored False;
	  end;

	  TControllerX=class (TPersistent)
	  private
	    FControll:TStrings;
	    FSysC    :TStrings;
	  published
	    property Controller        : TStrings read FControll write FControll   Stored False;
	    property System_Components : TStrings read FSysC     write FSysC       Stored False;
	  end;

	  TCpuX=class (TPersistent)
	  private
	     FProcessorSpeed, FNumberOfProcessors, FActiveProcessor, FProcessor, FProcessorVendor, FProcessorMMX:string;
	     FProcessorRevision:string;
	     FCoPro:string;
	  published
	     property Processor          : string read FProcessor          write FProcessor            Stored False;
	     property ProcessorSpeed     : string read FProcessorSpeed     write FProcessorSpeed       Stored False;
	     property ProcessorVendor    : string read FProcessorVendor    write FProcessorVendor      Stored False;
	     property ProcessorRevision  : string read FProcessorRevision  write FProcessorRevision    Stored False;
	     property ProcessorMMX       : string read FProcessorMMX       write FProcessorMMX         Stored False;
	     property NumberOfProcessors : String read FNumberOfProcessors write FNumberOfProcessors   Stored False;
	     property ActiveProcessor    : String read FActiveProcessor    write FActiveProcessor      Stored False;
	     property CoProcessor        : String read FCoPro              write FCoPro                Stored False;
	  end;

	  TCapabilitiesX=class (TPersistent)
	  private
             FRasterCapabilities    :TStrings;
             FCurveCapabilities     :TStrings;
             FLineCapabilities      :TStrings;
             FPolygonalCapabilities :TStrings;
             FTextCapabilities      :TStrings;
          published
             property RasterCapabilities    :TStrings read FRasterCapabilities     Stored False;
             property CurveCapabilities     :TStrings read FCurveCapabilities      Stored False;
             property LineCapabilities      :TStrings read FLineCapabilities       Stored False;
             property PolygonalCapabilities :TStrings read FPolygonalCapabilities  Stored False;
             property TextCapabilities      :TStrings read FTextCapabilities       Stored False;
          end;

	  TDisplayX=class (TPersistent)
	  private
	     FDisplayDrv, FDisplayVXD, FDisplayDPI, FDisplayResolution, FDisplayBpp, FMonitor:string;
	     FModes        :TStrings;
             FCapabilities :TCapabilitiesX;
	  published
	     property Display_Driver_Description : string         read FDisplayDrv        write FDisplayDrv         Stored False;
	     property Display_Driver             : string         read FDisplayVXD        write FDisplayVXD         Stored False;
	     property DisplayDPI                 : string         read FDisplayDPI        write FDisplayDPI         Stored False;
	     property DisplayResolution          : string         read FDisplayResolution write FDisplayResolution  Stored False;
	     property DisplayBpp                 : string         read FDisplayBpp        write FDisplayBpp         Stored False;
	     property Monitor                    : String         read FMonitor           write FMonitor            Stored False;
	     property Modes                      : TStrings       read FModes             write FModes              Stored False;
	     property Capabilities               : TCapabilitiesX read FCapabilities      write FCapabilities       Stored False;
	  end;

	  TKernelX=class(TPersistent)
	  private
	     FCPUUsage, FNumberOfThreads, FNumberOfDOSVirtualMachines : LongInt;
	  published
	     property CPUUsage                   : LongInt read FCPUUsage                   write FCPUUsage                    Stored False;
	     property NumberOfThreads            : LongInt read FNumberOfThreads            write FNumberOfThreads             Stored False;
	     property NumberOfDOSVirtualMachines : LongInt read FNumberOfDOSVirtualMachines write FNumberOfDOSVirtualMachines  Stored False;
	  end;

	  TVFATX=class(TPersistent)
	  private
	     FBytesReadPerSecond, FBytesWrittenPerSecond, FDirty, FReadsPerSecond, FWritesPerSecond : LongInt;
	  published
	     property BytesReadPerSecond    : LongInt read FBytesReadPerSecond    write FBytesReadPerSecond     Stored False;
	     property BytesWrittenPerSecond : LongInt read FBytesWrittenPerSecond write FBytesWrittenPerSecond  Stored False;
	     property Dirty                 : LongInt read FDirty                 write FDirty                  Stored False;
	     property ReadsPerSecond        : LongInt read FReadsPerSecond        write FReadsPerSecond         Stored False;
	     property WritesPerSecond       : LongInt read FWritesPerSecond       write FWritesPerSecond        Stored False;
	  end;

	  TCOMInterfaceX=class(TPersistent)
	  private
	     FAvailable : Boolean;
	     FBaudrate  : String;
	     FMaxOutputBuffer, FMaxInputBuffer, FPacketLength, FPacketVersion : LongInt;
	  published
	     property Available       : Boolean read FAvailable       write FAvailable        Stored False;
	     property Baudrate        : String  read FBaudrate        write FBaudrate         Stored False;
	     property MaxOutputBuffer : LongInt read FMaxOutputBuffer write FMaxOutputBuffer  Stored False;
	     property MaxInputBuffer  : LongInt read FMaxInputBuffer  write FMaxInputBuffer   Stored False;
	     property PacketLength    : LongInt read FPacketLength    write FPacketLength     Stored False;
	     property PacketVersion   : LongInt read FPacketVersion   write FPacketVersion    Stored False;
	  end;

	  TInterfacesX=class(TPersistent)
	  private
	     FCOM1, FCOM2, FCOM3, FCOM4 : TCOMInterfaceX;
	     FLPT1Available, FLPT2Available, FLPT3Available, FLPT4Available : Boolean;
	  published
	     property COM1 : TCOMInterfaceX read FCOM1 write FCOM1 Stored False;
	     property COM2 : TCOMInterfaceX read FCOM2 write FCOM2 Stored False;
	     property COM3 : TCOMInterfaceX read FCOM3 write FCOM3 Stored False;
	     property COM4 : TCOMInterfaceX read FCOM4 write FCOM4 Stored False;
	     property LPT1_Available : Boolean read FLPT1Available write FLPT1Available Stored False;
	     property LPT2_Available : Boolean read FLPT2Available write FLPT2Available Stored False;
	     property LPT3_Available : Boolean read FLPT3Available write FLPT3Available Stored False;
	     property LPT4_Available : Boolean read FLPT4Available write FLPT4Available Stored False;
	  end;

	  TMouseX=class(TPersistent)
	  private
	     FAvailable, FButtonsExchanged, FMouseWheelAvailable : Boolean;
	     FDescription        : String;
	     FNumberOfButtons                                    : Integer;
	  published
	     property Available           : Boolean read FAvailable           write FAvailable           Stored False;
	     property Description         : String  read FDescription         write FDescription         Stored False;
	     property NumberOfButtons     : Integer read FNumberOfButtons     write FNumberOfButtons     Stored False;
	     property ButtonsExchanged    : Boolean read FButtonsExchanged    write FButtonsExchanged    Stored False;
	     property MouseWheelAvailable : Boolean read FMouseWheelAvailable write FMouseWheelAvailable Stored False;
	  end;

	  TKeyBoardX=class(TPersistent)
	  private
	     FKey, FNumberOfFunctionKeys:string;
	  published
	     property Keyboard             : String read FKey                  write FKey                  Stored False;
	     property NumberOfFunctionKeys : String read FNumberOfFunctionKeys write FNumberOfFunctionKeys Stored False;
	  end;

	  TInputX=class(TPersistent)
	  private
             FKeyBoard: TKeyBoardX;
	     FMouse   : TMouseX;
	  published
	     property Mouse    : TMouseX    read FMouse    write FMouse     Stored False;
	     property KeyBoard : TKeyBoardX read FKeyBoard write FKeyBoard  Stored False;
	  end;

	  TMultiMediaX=class(TPersistent)
	  private
	     FModem, FMixer:string;
	     FMedia, FMediaControll, FAudioCompress, FImageCompress, FWave, FMidi:TStrings;
	  published
	     property Modem          : String   read FModem         write FModem         Stored False;
	     property Media          : TStrings read FMedia         write FMedia         Stored False;
	     property Media_Controll : TStrings read FMediaControll write FMediaControll Stored False;
	     property Audio_Compress : TStrings read FAudioCompress write FAudioCompress Stored False;
	     property Image_Compress : TStrings read FImageCompress write FImageCompress Stored False;
	     property Wave           : TStrings read FWave          write FWave          Stored False;
	     property Midi           : TStrings read FMidi          write FMidi          Stored False;
	     property Mixer          : String   read FMixer         write FMixer         Stored False;
	  end;

	  TPrinterX=class(TPersistent)
	  private
	     FPrinter, FPort:string;
	  published
	     property Printer: String read FPrinter write FPrinter Stored False;
	     property Port   : String read FPort    write FPort    Stored False;
	  end;

	  TProxyX=class(TPersistent)
	  private
	    FFTP, FGopher, FHTTP, FHTTPS, FSOCKS, FProxyOverride:string;
	  published
	    property FTP           : String read FFTP           write FFTP           Stored False;
	    property GOPHER        : String read FGOPHER        write FGOPHER        Stored False;
	    property HTTP          : String read FHTTP          write FHTTP          Stored False;
	    property HTTPS         : String read FHTTPS         write FHTTPS         Stored False;
	    property SOCKS         : String read FSOCKS         write FSOCKS         Stored False;
	    property ProxyOverride : String read FProxyOverride write FProxyOverride Stored False;
	  end;

	  TNetX=class(TPersistent)
	  private
	     FNet   : Tstrings;
	     FNetP  : Tstrings;
	     FEmail : Tstrings;
	     FProxy : TProxyX;
	  published
	     property Net            : TStrings read FNet   write FNet    Stored False;
	     property NetProtocol    : TStrings read FNetP  write FNetP   Stored False;
	     property Email_Accounts : TStrings read FEmail write FEmail  Stored False;
	     property ProxyServer    : TProxyX  read FProxy write FProxy  Stored False;
	  end;

	  THardwareX=class(TPersistent)
	  private
	     MotherB      : TMotherboardX;
	     FCpu         : TCpuX;
	     FDisplay     : TDisplayX;
	     FInput       : TInputX;
	     FMulti       : TMultiMediaX;
	     FPrinter     : TPrinterX;
	     FKernel      : TKernelX;
	     FVFAT        : TVFATX;
	     FInt         : TInterfacesX;
	     FController  : TControllerX;
	     FNetwork     : TNetX;
	  published
	     property Motherboard : TMotherboardX read MotherB     write MotherB     Stored False;
	     property CPU         : TCpuX         read FCpu        write FCpu        Stored False;
	     property Display     : TDisplayX     read FDisplay    write FDisplay    Stored False;
	     property Input       : TInputX       read FInput      write FInput      Stored False;
	     property MultiMedia  : TMultiMediaX  read FMulti      write FMulti      Stored False;
	     property Printer     : TPrinterX     read FPrinter    write FPrinter    Stored False;
	     property Kernel      : TKernelX      read FKernel     write FKernel     Stored False;
	     property VFAT        : TVFATX        read FVFAT       write FVFAT       Stored False;
	     property Interfaces  : TInterfacesX  read FInt        write FInt        Stored False;
	     property Controller  : TControllerX  read FController write FController Stored False;
	     property Network     : TNetX         read FNetwork    write FNetwork    Stored False;
	  end;
 //=== End THARDWAREX Classes ==============================================


 //=== TMemory Classes =====================================================
         TMemoryX=class(TPersistent)
         private
 	    FTotalV, FTotalP, FTotalS, FAvailP, FAvailS, FAvailV, FMemLoa: longint;
 	 published
            property PhysicalMemory_Total     : longint read FTotalP      write FTotalP   Stored False;
	    property PhysicalMemory_Available : longint read FAvailP      write FAvailP   Stored False;
	    property VirtualMemory_Total      : longint read FTotalV      write FTotalV   Stored False;
	    property VirtualMemory_Available  : longint read FAvailV      write FAvailV   Stored False;
	    property SwapMemory_Total         : longint read FTotalS      write FTotalS   Stored False;
	    property SwapMemory_Available     : longint read FAvailS      write FAvailS   Stored False;
	    property Memory_Loaded            : longint read FMemLoa      write FMemLoa   Stored False;
	 end;
 //=== End TMemory Classes ==================================================


 //=== TSystemX Classes =====================================================
 	 TSystemPathX=class(TPersistent)
	 private
            class function GetSpecialFolderLocation(nFolder: Integer): AnsiString;
            procedure SetSpecialFolderLocation(Index: Integer; Value: AnsiString);
            function  XGetPath (value: integer): String;
            procedure XSetPath(Index: Integer; Value: AnsiString);
            function  XGetDir (value: integer): AnsiString;
            procedure XSetDir(Index: integer; value: AnsiString);
	 published
	    property Cache                  : string     index 13                            read XGetPath                 write XSetPath                 Stored False;
	    property WallPaperDir           : string     index 16                            read XGetPath                 write XSetPath                 Stored False;
	    property ConfigPath             : string     index 18                            read XGetPath                 write XSetPath                 Stored False;
	    property DevicePath             : string     index 19                            read XGetPath                 write XSetPath                 Stored False;
	    property MediaPath              : string     index 20                            read XGetPath                 write XSetPath                 Stored False;
 	    property OtherDevicePath        : string     index 21                            read XGetPath                 write XSetPath                 Stored False;
	    property ProgramFilesPath       : string     index 23                            read XGetPath                 write XSetPath                 Stored False;
            property Cookies                : AnsiString index CSIDL_COOKIES                 read GetSpecialFolderLocation write SetSpecialFolderLocation Stored False;
            property Desktop                : AnsiString index CSIDL_DESKTOP                 read GetSpecialFolderLocation write SetSpecialFolderLocation Stored False;
            property Favorites              : AnsiString index CSIDL_FAVORITES               read GetSpecialFolderLocation write SetSpecialFolderLocation Stored False;
            property Fonts                  : AnsiString index CSIDL_FONTS                   read GetSpecialFolderLocation write SetSpecialFolderLocation Stored False;
            property SendTo                 : AnsiString index CSIDL_SENDTO                  read GetSpecialFolderLocation write SetSpecialFolderLocation Stored False;
            property Templates              : AnsiString index CSIDL_TEMPLATES               read GetSpecialFolderLocation write SetSpecialFolderLocation Stored False;
            property Startup                : AnsiString index CSIDL_STARTUP                 read GetSpecialFolderLocation write SetSpecialFolderLocation Stored False;
            property Start_Menu             : AnsiString index CSIDL_STARTMENU               read GetSpecialFolderLocation write SetSpecialFolderLocation Stored False;
            property Recent                 : AnsiString index CSIDL_RECENT                  read GetSpecialFolderLocation write SetSpecialFolderLocation Stored False;
            property Programs               : AnsiString index CSIDL_PROGRAMS                read GetSpecialFolderLocation write SetSpecialFolderLocation Stored False;
            property PrintHood              : AnsiString index CSIDL_PRINTHOOD               read GetSpecialFolderLocation write SetSpecialFolderLocation Stored False;
            property Personal               : AnsiString index CSIDL_PERSONAL                read GetSpecialFolderLocation write SetSpecialFolderLocation Stored False;
            property NetHood                : AnsiString index CSIDL_NETHOOD                 read GetSpecialFolderLocation write SetSpecialFolderLocation Stored False;
            property InternetCache          : AnsiString index CSIDL_INTERNET_CACHE          read GetSpecialFolderLocation write SetSpecialFolderLocation Stored False;
            property History                : AnsiString index CSIDL_HISTORY                 read GetSpecialFolderLocation write SetSpecialFolderLocation Stored False;
            property DesktopDirectory       : AnsiString index CSIDL_DESKTOPDIRECTORY        read GetSpecialFolderLocation write SetSpecialFolderLocation Stored False;
            property AppData                : AnsiString index CSIDL_APPDATA                 read GetSpecialFolderLocation write SetSpecialFolderLocation Stored False;
            property CommonDesktopDirectory : AnsiString index CSIDL_COMMON_DESKTOPDIRECTORY read GetSpecialFolderLocation write SetSpecialFolderLocation Stored False;
	    property SystemRoot             : Ansistring index 1 read XGetDir write XSetDir Stored False;
	    property Windows_Directory      : Ansistring index 2 read XGetDir write XSetDir Stored False;
	    property Current_Directory      : Ansistring index 3 read XGetDir write XSetDir Stored False;
	 end;

         TFontsX=class(TPersistent)
         private
           FFontname, FFontType, FFontFile : TStrings;
         published
           property Fontname : TStrings read FFontname write FFontname Stored False;
           property FontType : TStrings read FFontType write FFontType Stored False;
           property FontFile : TStrings read FFontFile write FFontFile Stored False;
         end;

         TSystemMetricsX=class(TPersistent)
         private
           FBootInfo, FBorderSizes, FCursorSize, FDefaultIconSize, FDialogFrameSize,
           FSizableFrameSize, FThickFrameSize, FUsableFullScreen, FMenuDropAlignment : String;
           FPenwindowsSupport : Boolean;
         published
           property BootInfo          : String  read FBootInfo          write FBootInfo          Stored False;
           property BorderSizes       : String  read FBorderSizes       write FBorderSizes       Stored False;
           property CursorSize        : String  read FCursorSize        write FCursorSize        Stored False;
           property DefaultIconSize   : String  read FDefaultIconSize   write FDefaultIconSize   Stored False;
           property DialogFrameSize   : String  read FDialogFrameSize   write FDialogFrameSize   Stored False;
           property SizableFrameSize  : String  read FSizableFrameSize  write FSizableFrameSize  Stored False;
           property ThickFrameSize    : String  read FThickFrameSize    write FThickFrameSize    Stored False;
           property UsableFullScreen  : String  read FUsableFullScreen  write FUsableFullScreen  Stored False;
           property PenwindowsSupport : Boolean read FPenwindowsSupport write FPenwindowsSupport Stored False;
           property MenuDropAlignment : String  read FMenuDropAlignment write FMenuDropAlignment Stored False;
         end;

         TEnvironmentX=class(TPersistent)
         private
            FFonts         : TFontsX;
            FSystemMetrics : TSystemMetricsX;
            FEnviron       : TStrings;
         published
            property Environment   : TStrings        read FEnviron       write FEnviron       Stored False;
            property Fonts         : TFontsX         read FFonts         write FFonts         Stored False;
            property SystemMetrics : TSystemMetricsX read FSystemMetrics write FSystemMetrics Stored False;
         end;

         TDirectX=class(TPersistent)
         private
            FDirectX, FDMusic : string;
            FD3D, FDPlay      : Tstrings;
         published
	    property Version     : String   read FDirectX write FDirectX Stored False;
	    property DirectMusic : String   read FDMusic  write FDMusic  Stored False;
	    property Direct3D    : TStrings read FD3D     write FD3D     Stored False;
	    property DirectPlay  : TStrings read FDPlay   write FDPlay   Stored False;
         end;

	 TOperatingSystemX=class(TPersistent)
	 private
	    FProductName, FProductType, FProductId, FProductKey, FVersion, FVersionNumber:string;
	    FRuntime     : string;
            FEnvironment : TEnvironmentX;
            FUnInstall   : TStrings;
            FDirect      : TDirectX;
	 published
	    property ProductType   : string        read FProductType   write FProductType   Stored False;
	    property ProductName   : string        read FProductName   write FProductName   Stored False;
	    property ProductId     : string        read FProductId     write FProductId     Stored False;
	    property ProductKey    : string        read FProductKey    write FProductKey    Stored False;
	    property VersionNumber : string        read FVersionNumber write FVersionNumber Stored False;
	    property Version       : string        read FVersion       write FVersion       Stored False;
	    property Runtime       : string        read FRuntime       write FRuntime       Stored False;
            property Environment   : TEnvironmentX read FEnvironment   write FEnvironment Stored False;
            property DirectX       : TDirectX      read FDirect        write FDirect      Stored False;
	    property UnInstall     : TStrings      read FUnInstall     write FUnInstall     Stored False;
	 end;

	 TUserX=class (TPersistent)
	 private
	    FWorkgroup, FComputerName, FComment, FRegisteredOwner, FRegisteredOrganization:string;
            function  GetUser (value: integer): AnsiString;
            procedure SetUser(index:integer; value: AnsiString);
	 published
	    property Workgroup              : string     read FWorkgroup              write FWorkgroup               Stored False;
	    property ComputerName           : string     read FComputerName           write FComputerName            Stored False;
            property Username               : AnsiString index 1 read GetUser         write SetUser                  Stored False;
            property Domainname             : AnsiString index 2 read GetUser         write SetUser                  Stored False;
	    property Comment                : string     read FComment                write FComment                 Stored False;
	    property RegisteredOrganization : string     read FRegisteredOrganization write FRegisteredOrganization  Stored False;
	    property RegisteredOwner        : string     read FRegisteredOwner        write FRegisteredOwner         Stored False;
	 end;

	 TSystemX=class(TPersistent)
	 private
	    FSP   : TSystemPathX;
	    FOS   : TOperatingSystemX;
	    FUser : TUserX;
	    FSM_AccessoriesName, FBootCount, FPF_AccessoriesName: string;
	 published
	    property System_Path        : TSystemPathX      read FSP                 write FSP                 Stored False;
	    property Operating_System   : TOperatingSystemX read FOS                 write FOS                 Stored False;
	    property User               : TUserX            read FUser               write FUser               Stored False;
	    property SM_AccessoriesName : string            read FSM_AccessoriesName write FSM_AccessoriesName Stored False;
	    property PF_AccessoriesName : string            read FPF_AccessoriesName write FPF_AccessoriesName Stored False;
	    property BootCount          : string            read FBootCount          write FBootCount          Stored False;
	 end;
 //=== End TSystemX Classes ==================================================

 //=== TSystemInfo2000X Classes ===============================================
 TSystemInfo2000X = class(TComponent)
 private
    FHard  : THardwareX;
    FMem   : TMemoryX;
    FAbout : TAboutInfo2000X;
    FSys   : TSystemX;
    Procedure GetWin98_Infos_Refresh;
 public
    Procedure Refresh;
    Procedure InitSystem;
 published
    constructor Create(AOwner:TComponent); override;
    destructor Destroy; override;
    property About          : TAboutInfo2000X read FAbout write FAbout Stored False;
    property Hardware       : THardwareX  read Fhard  write Fhard Stored False;
    property Memory         : TMemoryX    read FMem   write FMem  Stored False;
    property System         : TSystemX    read FSys   write FSys  Stored False;
 end;
 //=== End TSystemInfo2000X Classes ============================================

var
  LReg: TRegistry;

{$M+}
{$F+}
{$I x2000.inc}

implementation

function  TUserX.GetUser (value: integer): AnsiString;
begin
  case value of
     1: result:=GetUserName;
     2: result:=GetFullyQualifiedDomainName;
  end;
end;

procedure TUserX.SetUser(index:integer; value: AnsiString);
begin
end;

function  TSystemPathX.XGetDir (value: integer): AnsiString;
begin
  case Value of
    1: result:=GetWindowsDirectory;
    2: result:=GetSystemDirectory;
    3: result:=GetCurrentDirectory;
  end;
end;

procedure TSystemPathX.XSetDir(index: integer; value: AnsiString);
begin
end;

function  TSystemPathX.XGetPath (value: integer): String;
begin
  result:=GetPath(value);
end;

procedure TSystemPathX.XSetPath(Index: Integer; Value: AnsiString);
begin
end;

class function TSystemPathX.GetSpecialFolderLocation(nFolder: Integer): AnsiString;
var ppMalloc: IMalloc;
    ppidl: PItemIDList;
    szPath: array[0..MAX_PATH] of char;
begin
  Result:= '(unavailable)';

  if (SHGetMalloc(ppMalloc) = S_OK) then
    if (SHGetSpecialFolderLocation(Application.Handle, nFolder, ppidl) = S_OK) then
      if (SHGetPathFromIDList(ppidl, szPath)) then
         Result:= StrPas(szPath);

  ppMalloc.Free(ppidl);
  ppMalloc._Release();
end;

procedure TSystemPathX.SetSpecialFolderLocation(Index: Integer; Value: AnsiString);
begin
end;

constructor TSystemInfo2000X.Create(AOwner:TComponent);
begin
  inherited create(AOwner);
  Refresh;
end;

destructor TSystemInfo2000X.Destroy;
begin
  inherited Destroy;
end;

procedure TSystemInfo2000X.Refresh;
begin
  Inherited;
  InitSystem;
  GetWin98_Infos_Refresh;
end;

procedure TSystemInfo2000X.InitSystem;
begin
  inherited;

  //Create
  FHard := THardwareX.Create;
  FMem  := TMemoryX.Create;
  FSys  := TSystemX.Create;

  with FSys do begin
    FSP   := TSystemPathX.create;
    FUser := TUserX.create;
    FOS   := TOperatingSystemX.create;
    with FOS do begin
      Environment               := TEnvironmentX.Create;
      Environment.Fonts         := TFontsX.Create;
      Environment.SystemMetrics := TSystemMetricsX.Create;
      Environment.FEnviron      := TStringlist.create;
      DirectX                   := TDirectX.Create;
      FUnInstall                := TStringlist.create;
      DirectX.DirectPlay        := TStringlist.create;
    end;
  end;

  with FHard do begin
    MotherB                := TMotherboardX.create;
    FCpu                   := TCpux.create;
    FDisplay               := TDisplayX.create;
    FDisplay.FCapabilities := TCapabilitiesX.create;
    FInput                 := TInputX.create;
    FMulti                 := TMultiMediaX.create;
    FController            := TControllerX.create;
    FPrinter               := TPrinterX.create;

    Kernel                 := TKernelX.Create;
    VFAT                   := TVFATX.Create;
    Interfaces             := TInterfacesX.Create;
    Interfaces.COM1        := TCOMInterfaceX.Create;
    Interfaces.COM2        := TCOMInterfaceX.Create;
    Interfaces.COM3        := TCOMInterfaceX.Create;
    Interfaces.COM4        := TCOMInterfaceX.Create;
    Input.Mouse            := TMouseX.Create;

    Input.FKeyBoard        := TKeyBoardX.Create;
    FController.System_components := TStringList.Create;
    FController.Controller        := TStringList.create;
    FNetwork                      := TNetX.create;
    with Network do begin
      Net            := TStringList.create;
      NetProtocol    := TStringList.create;
      Email_Accounts := TStringList.create;
      FProxy         := TProxyX.create;
    end;

    with FMulti do begin
      FMediaControll := TStringList.create;
      FAudioCompress := TStringList.create;
      FImageCompress := TStringList.create;
      FWave          := TStringList.create;
      FMidi          := TStringList.create;
    end;

    with Display do begin
     Modes                      :=TStringList.Create;
    end;

    with Display.Capabilities do begin
     FRasterCapabilities    :=tstringlist.create;
     FCurveCapabilities     :=tstringlist.create;
     FLineCapabilities      :=tstringlist.create;
     FPolygonalCapabilities :=tstringlist.create;
     FTextCapabilities      :=tstringlist.create;
    end;
    MultiMedia.Media        := TStringList.Create;
  end;

  with FSys do begin
    with FOS do begin
      with FDirect do begin
        Direct3D             :=TStringlist.create;
      end;
      with Environment do begin
         with Fonts do begin
            FontName := TStringList.Create;
            FontType := TStringList.Create;
            FontFile := TStringList.Create;
         end;
      end;
    end;
  end;
end;

procedure TSystemInfo2000X.GetWin98_Infos_Refresh;
  procedure SetCOMProps(Cmp : TCOMInterfaceX; CP : TCOMMPROP);
  var
     s : String;
  begin
     case CP.dwMaxBaud of
       BAUD_075    : s := '75 bps';
       BAUD_110    : s := '110 bps';
       BAUD_134_5  : s := '134,5 bps';
       BAUD_150    : s := '150 bps';
       BAUD_300    : s := '300 bps';
       BAUD_600    : s := '600 bps';
       BAUD_1200   : s := '1200 bps';
       BAUD_1800   : s := '1800 bps';
       BAUD_2400   : s := '2400 bps';
       BAUD_4800   : s := '4800 bps';
       BAUD_7200   : s := '7200 bps';
       BAUD_9600   : s := '9600 bps';
       BAUD_14400  : s := '14400 bps';
       BAUD_19200  : s := '19200 bps';
       BAUD_38400  : s := '38400 bps';
       BAUD_56K    : s := '56K bps';
       BAUD_57600  : s := '57600 bps';
       BAUD_115200 : s := '115200 bps';
       BAUD_128K   : s := '128K bps';
       BAUD_USER   : s := 'user-specified';
       else          s := 'unknown/not defined: ' + IntToStr(CP.dwMaxBaud);
     end;
     Cmp.Baudrate := s;
     Cmp.MaxOutputBuffer := CP.dwMaxTxQueue;
     Cmp.MaxInputBuffer := CP.dwMaxRxQueue;
     Cmp.PacketLength := CP.wPacketLength;
     Cmp.PacketVersion := CP.wPacketVersion;
  end;
const MAX_PATH=144;
var
  COMM  : pChar;
  comms : string;
  h     : THandle;
  c     : integer;
  CP    : TCOMMPROP;
  CC    : TCOMMCONFIG;
  devmode : TDEVMODE;
  i  : integer;
  Temp:string;
  MediaTemp : TStrings;
  p:pchar;

begin

  //Init

  LReg:= TRegistry.Create;
  LReg.RootKey := Root1;
  LReg.LazyWrite := false;

  MediaTemp := TStringList.Create;

  //Reset
  FHard.Controller.Controller.clear;
  FHard.Display.Modes.clear;
  FHard.MultiMedia.Media.Clear;
  FHard.Controller.System_Components.Clear;
  FHard.Network.Net.Clear;
  FHard.Network.NetProtocol.Clear;
  FHard.Network.Email_Accounts.Clear;
  FHard.MultiMedia.Media_Controll.Clear;
  FHard.MultiMedia.Audio_Compress.Clear;
  FHard.MultiMedia.Image_Compress.Clear;
  FHard.MultiMedia.Wave.Clear;
  FHard.MultiMedia.Midi.Clear;
  FSys.FOS.FDirect.Direct3D.Clear;
  MediaTemp.Clear;

  //Hardware
  with Lreg do begin
   with Fhard.Motherboard do begin
     BiosVersion  :=GetBios(1);
     BiosCopyright:=GetBios(2);
     BiosDate     :=GetBios(3);
     BiosSerial   :=GetBios(4);
     BusType      :=GetBios(5);
     MachineType  :=GetBios(6);
   end;

   with FHard.CPU do begin
     Processor          := GetCpu(1);
     ProcessorVendor    := GetCpu(2);
     ProcessorMMX       := GetCpu(3);
     CoProcessor        := GetCpu(4);
     ProcessorSpeed     := GetCpu(5);
     NumberOfProcessors := GetCpu(6);
     ActiveProcessor    := GetCpu(7);
     ProcessorRevision  := GetCpu(8);
   end;

   with FHard.Controller do begin
     GetController(Controller);
   end;

   with Fhard.Display do begin
    DisplayDPI                 := GetDisplay(1);
    DisplayResolution          := GetDisplay(2);
    DisplayBPP                 := GetDisplay(3);
    Display_Driver_Description := GetDisplay(4);
    Display_Driver             := GetDisplay(5);
    Monitor                    := GetDisplay(6);
    devmode.dmSize        := SizeOf(TDEVMODE);
    devmode.dmDriverExtra := 0;
    for i := 0 to 25 do
      if EnumDisplaySettings(nil, i, devmode) then
        Modes.Add(IntToStr(devmode.dmPelsWidth) + ' x ' + IntToStr(devmode.dmPelsHeight) + ' - ' + IntToStr(devmode.dmBitsPerPel) + 'Bit');
   end;

   GetMedia           (Fhard.MultiMedia.Media);
   GetSystemComponents(Fhard.Controller.System_Components);
   GetNetworkAdapters (FHard.Network.Net);
   GetNetworkProtocoll(Fhard.NetWork.NetProtocol);
   GetEmailAccouts    (Fhard.NetWork.Email_Accounts);

   with FHard.Network.ProxyServer do begin
     ProxyOverride:=GetProxyServer(1);
     FTP          :=GetProxyServer(2);
     GOPHER       :=GetProxyServer(3);
     HTTP         :=GetProxyServer(4);
     HTTPS        :=GetProxyServer(5);
     SOCKS        :=GetProxyServer(6);
   end;

   FHard.MultiMedia.Modem:=GetModem;

   FHard.Printer.Printer:=GetPrinterInfo(1);
   FHard.Printer.Port   :=GetPrinterInfo(2);


   //=== Begin: AW - 14/07/1999 =================================================
   Comms := 'COMX';
   COMM  := StrAlloc(5);

   // COM1-4
   with FHard.Interfaces do begin
    for c := Ord('1') to Ord('4') do begin
     comms[4] := Chr(c);
     StrPCopy(COMM, comms);
     CC.dwSize := SizeOf(TCOMMCONFIG);
     GetDefaultCommConfig(COMM, CC, CC.dwSize);
     h := CreateFile(COMM, GENERIC_READ or GENERIC_WRITE, 0, nil, OPEN_EXISTING, 0, 0);
     if h <> INVALID_HANDLE_VALUE then begin
       case c of
          Ord('1') : COM1.Available := true;
          Ord('2') : COM2.Available := true;
          Ord('3') : COM3.Available := true;
          Ord('4') : COM4.Available := true;
       end;
       GetCommProperties(h, CP);
       case c of
          Ord('1') : SetCOMProps(COM1, CP);
          Ord('2') : SetCOMProps(COM2, CP);
          Ord('3') : SetCOMProps(COM3, CP);
          Ord('4') : SetCOMProps(COM4, CP);
       end;
     end else begin
       case c of
          Ord('1') : COM1.Available := false;
          Ord('2') : COM2.Available := false;
          Ord('3') : COM3.Available := false;
          Ord('4') : COM4.Available := false;
       end;
     end;
     CloseHandle(h);
    end;

    //LPT1-4
    comms := 'LPTX';
    for c := Ord('1') to ORD('4') do begin
     comms[4] := Chr(c);
     StrPCopy(COMM, comms);
     h := CreateFile(COMM, GENERIC_READ OR GENERIC_WRITE, 0, nil, OPEN_EXISTING, 0, 0);
     if h = INVALID_HANDLE_VALUE then begin
       case c of
          Ord('1') : LPT1_Available := false;
          Ord('2') : LPT2_Available := false;
          Ord('3') : LPT3_Available := false;
          Ord('4') : LPT4_Available := false;
       end;
     end else begin
       case c of
          Ord('1') : LPT1_Available := true;
          Ord('2') : LPT2_Available := true;
          Ord('3') : LPT3_Available := true;
          Ord('4') : LPT4_Available := true;
       end;
     end;
     CloseHandle(h);
    end;
    StrDispose(COMM);
   end;

   with FHard.Kernel do begin
    CPUUsage                   := GetCPUUsageInfos(1);
    NumberOfThreads            := GetCPUUsageInfos(2);
    NumberOfDOSVirtualMachines := GetCPUUsageInfos(3);
   end;

   with FHard.VFAT do begin
    BytesReadPerSecond         := GetCPUUsageInfos(4);
    BytesWrittenPerSecond      := GetCPUUsageInfos(5);
    Dirty                      := GetCPUUsageInfos(6);
    ReadsPerSecond             := GetCPUUsageInfos(7);
    WritesPerSecond            := GetCPUUsageInfos(8);
   end;

   with FHard.Input do begin
     with Mouse do begin
       Available           := GetInputDevices1(1);
       NumberOfButtons     := strtoint(GetInputDevices2(4));
       ButtonsExchanged    := GetInputDevices1(2);
       MouseWheelAvailable := GetInputDevices1(3);
       Description         := GetInputDevices2(1);
     end;
     KeyBoard.Keyboard             := GetInputDevices2(2);
     KeyBoard.NumberOfFunctionKeys := GetInputDevices2(3);
   end;

   with FSys.FOS.FEnvironment.FFonts do begin
    ReadFontData (FontName, FontType, FontFile);
   end;

   with FSys.Operating_System.Environment.SystemMetrics do begin
      case GetSystemMetrics(SM_CLEANBOOT) of
        0: BootInfo :='normal';
        1: BootInfo :='abgesichert';
        2: BootInfo :='abgesichert mit Netzwerk';
      end;
      BorderSizes       := 'x: ' + IntToStr(GetSystemMetrics(SM_CXBORDER)) + ', y: ' + IntToStr(GetSystemMetrics(SM_CYBORDER));
      CursorSize        := 'x: ' + IntToStr(GetSystemMetrics(SM_CXCURSOR)) + ', y: ' + IntToStr(GetSystemMetrics(SM_CYCURSOR));
      DefaultIconSize   := 'x: ' + IntToStr(GetSystemMetrics(SM_CXICON))   + ', y: ' + IntToStr(GetSystemMetrics(SM_CYICON));
      DialogFrameSize   := 'x: ' + IntToStr(GetSystemMetrics(SM_CXDLGFRAME))+ ', y: ' +IntToStr(GetSystemMetrics(SM_CYDLGFRAME));
      SizableFrameSize  := 'x: ' + IntToStr(GetSystemMetrics(SM_CXFRAME))  + ', y: ' + IntToStr(GetSystemMetrics(SM_CYFRAME));
      ThickFrameSize    := 'x: ' + IntToStr(GetSystemMetrics(SM_CXSIZEFRAME))+', y: '+ IntToStr(GetSystemMetrics(SM_CYSIZEFRAME));
      UsableFullScreen  := 'x: ' + IntToStr(GetSystemMetrics(SM_CXFULLSCREEN))+', y: '+IntToStr(GetSystemMetrics(SM_CYFULLSCREEN));
      PenwindowsSupport := Boolean(GetSystemMetrics(SM_PENWINDOWS));
      if Boolean(GetSystemMetrics(SM_MENUDROPALIGNMENT)) then
        MenuDropAlignment := 'rightaligned'
      else
        MenuDropAlignment := 'leftaligned (standard)';
   end;
   //=== End: AW - 22/07/1999 =================================================
   with FSys.Operating_System.FEnvironment do begin
     FEnviron.clear;
     p:=GetEnvironmentStrings;
     while p^<>#0 do begin
       FEnviron.add (strpas(p));
       inc(p,LStrLen(p)+1);
     end;
     FreeEnvironmentStrings(p);
   end;

   //Memory
   with FMem do
   begin
    PhysicalMemory_Total     := GetMemoryStatus(0);
    PhysicalMemory_Available := GetMemoryStatus(1);
    SwapMemory_Total         := GetMemoryStatus(2);
    SwapMemory_Available     := GetMemoryStatus(3);
    VirtualMemory_Total      := GetMemoryStatus(4);
    VirtualMemory_Available  := GetMemoryStatus(5);
    Memory_Loaded            := GetMemoryStatus(6);
   end;

   //System
   with FSys.User do
   begin
    OpenKey(WIN98_Name_Key, False);
    if ReadString('Workgroup')<>'' then              Workgroup              := ReadString('Workgroup');
    if ReadString('ComputerName')<>'' then           ComputerName           := ReadString('ComputerName');
    if ReadString('Comment')<>'' then                Comment                := ReadString('Comment');
    CloseKey;

    OpenKey(WIN98_Win_Key, False);
    if ReadString('RegisteredOwner')<>'' then        RegisteredOwner         := ReadString('RegisteredOwner');
    if ReadString('RegisteredOrganization')<>'' then RegisteredOrganization  := ReadString('RegisteredOrganization');
    if ReadString('BootCount')<>'' then              FSys.BootCount          := ReadString('BootCount');
    if ReadString('PF_AccessoriesName')<>'' then     FSys.PF_AccessoriesName := ReadString('PF_AccessoriesName');
    if ReadString('SM_AccessoriesName')<>'' then     FSys.SM_AccessoriesName := ReadString('SM_AccessoriesName');
    CloseKey;
   end;

   //OperatingSystem
   with FSys.FOS do begin
    RootKey := Root1;
    LazyWrite := false;
    OpenKey(WIN98_Win_Key, False);
    if ReadString('ProductName')<>'' then   ProductName   := ReadString('ProductName');
    if ReadString('ProductType')<>'' then   ProductType   := ReadString('ProductType');
    if ReadString('ProductId')<>'' then     ProductId     := ReadString('ProductId');
    if ReadString('ProductKey')<>'' then    ProductKey    := ReadString('ProductKey');
    if ReadString('Version')<>'' then       Version       := ReadString('Version');
    if ReadString('VersionNumber')<>'' then VersionNumber := ReadString('VersionNumber');
    CloseKey;
    i := GetTickCount; // AW - 12/07/1999
    Runtime := (IntToStr(i div (60 * 60 * 1000)) + ' hour(s) and ' + IntToStr((i div (60 * 1000)) - (i div (60 * 60 * 1000)) * 60) + ' minute(s)'); // AW - 12/07/1999

    OpenKey(WIN98_DirectX_Key, False);
    if ReadString('Version')<>'' then DirectX.Version        := ReadString('Version');
    CloseKey;

    OpenKey(WIN98_DirectMusic_Key+'\Defaults', False);
    if ReadString('DefaultOutputPort')<>'' then temp:=ReadString('DefaultOutputPort');
    CloseKey;

    if KeyExists(WIN98_DirectMusic_Key+'\SoftwareSynths\'+temp) then begin
       OpenKey(WIN98_DirectMusic_Key+'\SoftwareSynths\'+temp, False);
       if ReadString('Description')<>'' then FSys.Fos.DirectX.DirectMusic:= ReadString('Description');
       Closekey;
    end;

    GetListStuff(Lreg, FSys.FOS.DirectX.Direct3D,   WIN98_Direct3D_Key,   'Description');
    GetListStuff(Lreg, FSys.FOS.DirectX.DirectPlay, WIN98_DirectPlay_Key, 'DescriptionA');
    GetListStuff(Lreg, FSys.FOS.FUnInstall,         WIN98_UnInstall_Key,  'DisplayName');

    with FHard.MultiMedia do begin
      GetListStuff(Lreg, Image_Compress, WIN98_Media_Key2+'\ICM', 'Description');
      GetListStuff(Lreg, Media_Controll, WIN98_Media_Key2+'\MCI', 'FriendlyName');
      GetListStuff(Lreg, Wave,           WIN98_Media_Key2+'\WAVE','FriendlyName');
      GetListStuff(Lreg, Midi,           WIN98_Media_Key2+'\MIDI','FriendlyName');
      GetListStuff(Lreg, Audio_Compress, WIN98_Media_Key2+'\ACM', 'Description');
    end;

    MediaTemp.Clear;
    OpenKey(WIN98_Media_Key2+'\MIXER', False);
    GetKeyNames(MediaTemp);
    CloseKey;

    if MediaTemp.count>0 then begin
      OpenKey(WIN98_Media_Key2+'\MIXER\'+MediaTemp.Strings[0], False);
      if ReadString('FriendlyName')<>'' then FHard.MultiMedia.Mixer:=ReadString('FriendlyName');
      CloseKey;
    end;

   end;
  end;

  with FHard.Display.Capabilities do begin
    GetCapabilities(1, FRasterCapabilities);
    GetCapabilities(2, FCurveCapabilities);
    GetCapabilities(3, FLineCapabilities);
    GetCapabilities(4, FPolygonalCapabilities);
    GetCapabilities(5, FTextCapabilities);
  end;

  LReg.Free;
end;

end.
