{ ****************************************************************
  Info               :  TRunOnce2000X 
                        Freeware

  Source File Name   :  X2000RunOnce.PAS
  Author             :  Baldemaier Florian (Baldemaier.Florian@gmx.net)
  Compiler           :  Delphi 5.0 Professional
  Decription         :  This component let start only one copy of your application.

  PROPERTIES:
   Terminate: Boolean - Terminate second copy                  
   SwitchToPrevious: Boolean - Activate the previous instance  
                               if exist                        

**************************************************************** }
unit X2000RunOnce;

interface

uses
  Windows, SysUtils, Classes, Controls, Forms, Messages, Dialogs,
  x2000AboutInfo;

type
   TRunOnce2000X = class(TComponent)
   private
     FMessage          : String;
     FAbout            : TAboutInfo2000X;
     FShowMessage      : Boolean;
     FTerminate        : Boolean;
     FSwitchToPrevious : Boolean;
     FAlreadyExist     : TNotifyEvent;
     Mutex             : hWnd;
     IsCreated         : Boolean;
   public
     procedure Loaded; override;
     constructor Create(aOwner: TComponent); override;
     destructor Destroy; override;
   published
     property About            : TAboutInfo2000X  read FAbout            write FAbout Stored False;
     property SwitchToPrevious : Boolean      read FSwitchToPrevious write FSwitchToPrevious;
     property Terminate        : Boolean      read FTerminate        write FTerminate;
     property AlreadyExist     : TNotifyEvent read FAlreadyExist     write FAlreadyExist;
     property ShowMessage      : boolean      read FShowMessage      write FShowMessage;
     property MessageText      : string       read FMessage          write FMessage;
   end;

implementation

procedure TRunOnce2000X.Loaded;
var
  PrevInstHandle: THandle;
  AppTitle: Array[0..$100] of Char;
begin
  inherited Loaded;
  StrPCopy(AppTitle, Application.Title);
  IsCreated := False;

  Mutex := CreateMutex(nil, False, AppTitle);
  if (GetLastError = ERROR_ALREADY_EXISTS) or
     (Mutex = 0) then
  begin
   if Assigned(FAlreadyExist) then FAlreadyExist(Self);

   if FSwitchToPrevious then
    begin
     PrevInsthandle := FindWindow(nil, AppTitle);
     SetWindowText(PrevInsthandle, '');
     PrevInstHandle := FindWindow(nil, AppTitle);
     if PrevInstHandle <> 0 then
      if IsIconic(PrevInstHandle) then
       ShowWindow(PrevInstHandle, SW_RESTORE)
      else
       BringWindowToTop(PrevInstHandle);
    end;

   if FTerminate then
   begin
      if FShowMessage then begin
         MessageDlg(Messagetext,mtInformation,[mbOK],0);
      end;
      Application.Terminate;
   end;
  end;
  IsCreated := True;
end;

constructor TRunOnce2000X.Create(aOwner: TComponent);
begin
  inherited Create(aOwner);
  FTerminate := True;
  FSwitchToPrevious := True;
end;

destructor TRunOnce2000X.Destroy;
begin
  if IsCreated then
   CloseHandle(Mutex);
  inherited Destroy;
end;

end.
