{ ****************************************************************
  Info               :  TRunDialog2000X
                        Freeware 

  Source File Name   :  X2000RunDialog.PAS
  Author             :  Baldemaier Florian (Baldemaier.Florian@gmx.net)
  Original           :  Workshell Software
  Compiler           :  Delphi 5.0 Professional
  Decription         :  Undocumented Windows API functions founded by Workshell Software
**************************************************************** }

unit X2000RunDialog;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  x2000AboutInfo;

type
  TRunDialog2000X = class(TComponent)
  private
    FAbout: TAboutInfo2000X;
    FDescription: String;
    FHideBrowseButton: Boolean;
    FIcon: TIcon;
    FInitialDir: String;
    FTitle: String;
    procedure SetDescription(Value: String);
    procedure SetHideBrowseButton(Value: Boolean);
    procedure SetIcon(Value: TIcon);
    procedure SetInitialDir(Value: String);
    procedure SetTitle(Value: String);
  protected
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  public
    procedure Execute;
  published
    property About             : TAboutInfo2000X read FAbout             write FAbout Stored False;
    property Description: String read FDescription write SetDescription;
    property HideBrowseButton: Boolean read FHideBrowseButton write SetHideBrowseButton;
    property Icon: TIcon read FIcon write SetIcon;
    property InitialDir: String read FInitialDir write SetInitialDir;
    property Title: String read FTitle write SetTitle;
  end;

var
 Flags: LongInt = 0;

const
 RFF_NOBROWSE = 1;

implementation

procedure RunFileDlgA(OwnerWnd: HWND; Icon: HICON; lpstrDirectory: PAnsiChar;
 lpstrTitle: PAnsiChar; lpstrDescription: PAnsiChar; Flags: LongInt); stdcall;
 external 'Shell32.dll' index 61;

constructor TRunDialog2000X.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FIcon := TIcon.Create;
end;

destructor TRunDialog2000X.Destroy;
begin
  FIcon.Free;
  inherited Destroy;
end;

procedure TRunDialog2000X.Execute;
begin
  if FHideBrowseButton = True then
  begin
    Flags := Flags or RFF_NOBROWSE;
  end;
  RunFileDlgA(0,FIcon.Handle,PChar(FInitialDir),PChar(FTitle),PChar(FDescription),Flags);
end;

procedure TRunDialog2000X.SetDescription(Value: String);
begin
  if Value <> FDescription then
  begin
    FDescription := Value;
  end;
end;

procedure TRunDialog2000X.SetHideBrowseButton(Value: Boolean);
begin
  if Value <> FHideBrowseButton then
  begin
    FHideBrowseButton := Value;
  end;
end;

procedure TRunDialog2000X.SetIcon(Value: TIcon);
begin
  if Value <> FIcon then
  begin
    FIcon.Assign(Value);
  end;
end;

procedure TRunDialog2000X.SetInitialDir(Value: String);
begin
  if Value <> FInitialDir then
  begin
    FInitialDir := Value;
  end;
end;

procedure TRunDialog2000X.SetTitle(Value: String);
begin
  if Value <> FTitle then
  begin
    FTitle := Value;
  end;
end;

end.
