{ ****************************************************************
  Info               :  TRemoveCaption2000X 
                        Freeware

  Source File Name   :  X2000RemoveCaption.PAS
  Author             :  Baldemaier Florian (Baldemaier.Florian@gmx.net)
  Compiler           :  Delphi 5.0 Professional
  Decription         :  Removes the caption of a Form.

**************************************************************** }
unit X2000RemoveCaption;

interface

uses
   Windows, SysUtils, Messages, Classes, Graphics, Controls, Forms,
   Dialogs, ExtCtrls, StdCtrls, ShellAPI, x2000AboutInfo;

type
   TRemoveCaption2000X = class(TComponent)
   private
     FAbout   : TAboutInfo2000X;
     FDiff    : Integer;
     NActive  : boolean;
     FEnabled : boolean;
     procedure SetActive(Value: Boolean);
   published
     constructor create(AOwner:TComponent); override;
     destructor destroy; override;
     procedure Add(TheForm: TForm);
     procedure Remove(TheForm: TForm);
     property Enabled   : boolean      read FEnabled  write SetActive default false;
     property About     : TAboutInfo2000X  read FAbout    write FAbout Stored False;
   end;

implementation

var ParentForm:TForm;

procedure TRemoveCaption2000X.SetActive(Value: Boolean);
begin
  if value then begin
     remove(parentform);
     FEnabled:=true;
  end;
  if not value then begin
     add(parentform);
     FEnabled:=false;
  end;
end;

procedure TRemoveCaption2000X.Remove(TheForm:TForm);
begin
  NActive:=True;
  FDiff := GetSystemMetrics(SM_CYCAPTION);
  SetWindowLong(TheForm.Handle, GWL_STYLE, GetWindowLong(TheForm.Handle, GWL_Style) and not WS_Caption);
  TheForm.Height:=TheForm.Height - FDiff;
end;

procedure TRemoveCaption2000X.Add(TheForm:TForm);
begin
  NActive:=False;
  If Self.ComponentState = [csDestroying] Then exit;
  SetWindowLong(TheForm.Handle, GWL_STYLE, GetWindowLong(TheForm.Handle, GWL_Style) + WS_Caption);
  TheForm.Height:=TheForm.Height + FDiff;
end;

constructor TRemoveCaption2000X.create(AOwner:TComponent);
begin
  inherited create(AOwner);
  ParentForm := TForm(AOwner);
end;

destructor TRemoveCaption2000X.destroy;
begin
  if NActive then Add(ParentForm);
  inherited Destroy;
end;

end.
