{ ****************************************************************
  Info               :  TRegistry2000X
                        Freeware

  Source File Name   :  X2000Registry.PAS
  Author             :  Baldemaier Florian (Baldemaier.Florian@gmx.net)
  Compiler           :  Delphi 5.0 Professional
  Decription         :  Registry 

**************************************************************** }
unit X2000Registry;

interface

uses
  Windows, SysUtils, Classes, Controls, Forms, Messages, Dialogs, Graphics, X2000Base64,
  DsgnIntf, x2000AboutInfo;

const

  KEY_NAMES: array[0..6] of string = ( 'HKEY_CLASSES_ROOT', 'HKEY_CURRENT_USER',
  'HKEY_LOCAL_MACHINE', 'HKEY_USERS', 'HKEY_PERFORMANCE_DATA', 'HKEY_CURRENT_CONFIG',
  'HKEY_DYN_DATA' );

type
  TRegKeyInfo = record
    NumSubKeys: Integer;
    MaxSubKeyLen: Integer;
    NumValues: Integer;
    MaxValueLen: Integer;
    MaxDataLen: Integer;
    FileTime: TFileTime;
  end;

  TKeyProperty = class(TPropertyEditor)
  private
  protected
  public
      function  GetAttributes: TPropertyAttributes; override;
      function  GetValue: string; override;
      procedure GetValues( Proc: TGetStrProc ); override;
      procedure SetValue( const Value: string ); override;
  end;

  TRegistry2000X = class(TComponent)
  private
      FAbout: TAboutInfo2000X;
      FAllow: Boolean;
      FSub: String;
      FRoot: HKey;
      procedure SetRootKEy(Value: HKey);
      procedure SetSubKey (Value: String);
  protected
      function  IsRelative (const Value: string): Boolean;
      function  GetKey     (const Key: string): HKEY;
      function  GetBaseKey(Relative: Boolean): HKey;
  public
      constructor Create(AOwner: TComponent); override;
      destructor Destroy; override;
      Function  ReadString      (ValName:PChar)    : String;
      Function  ReadColor       (ValName:PChar)    : TColor;
      Function  ReadDWord       (ValName:PChar)    : DWord;
      Function  ReadCryptString (ValName:PChar)    : String;

      Procedure ReadBuf         (ValName:PChar; Var Buf; BufSize:DWord);
      Procedure CreateKey       (NewSubKey:PChar);
      Procedure WriteString     (ValName:PChar; Data: String);
      Procedure WriteCryptString(ValName:PChar; Data: String);
      Procedure WriteColor      (ValName:PChar; Data: TColor);
      Procedure WriteDWord      (ValName:PChar; Data:DWord);
      Procedure WriteBuf        (ValName:PChar; Var Buf; BufSize:DWord);
      Procedure DeleteValue     (ValName:PChar);
      Procedure DeleteKey;

      Function  KeyExists: Boolean;
      Function  KeyExistsEx     (const Key: string): Boolean;
      Function  ValueExists     (ValName:PChar)    : Boolean;
      function  GetKeyInfo      (MainKey:HKEY; var Value: TRegKeyInfo  ): Boolean;
      procedure GetValueNames   (Strings: TStrings);
      procedure GetKeyNames     (Strings: TStrings);
      procedure DeleteValueNames;
  published
      property About      : TAboutInfo2000X read FAbout write FAbout Stored False;
      property RootKey    : HKEY    read FRoot  write SetRootKey;
      property OpenKey    : String  read FSub   write SetSubKey;
      property AllowCreate: Boolean read FAllow write FAllow;
  end;

var
   MainKey: HKey;
   Subkey: pchar;

implementation

procedure TRegistry2000X.SetSubKey(Value: String);
begin
  if not FAllow then begin
   if KeyExistsEx(value) then begin
     SubKey:=pchar(value);
     FSub:=value;
   end;
  end;
  if FAllow then begin
   if KeyExistsEx(value) then begin
     SubKey:=pchar(value);
     FSub:=value;
   end;
   if not KeyExistsEx(value) then begin
     SubKey:=pchar(value);
     FSub:=value;
     CreateKey(pchar(value));
   end;
  end;
end;

procedure TRegistry2000X.SetRootKey(Value: HKey);
begin
  MainKey:=value;
  FRoot:=value;
end;

constructor TRegistry2000X.Create (AOwner: TComponent);
begin
  inherited create(AOwner);
  FRoot:= HKEY_CURRENT_USER;
  MainKey:=FRoot;
end;

destructor TRegistry2000X.Destroy;
begin
  inherited destroy;
end;

function TKeyProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paValueList];
end;

procedure TKeyProperty.GetValues( Proc: TGetStrProc );
var
  i: integer;
begin
  for i := 0 to 6 do
    Proc( KEY_NAMES[i] );
end;

function TKeyProperty.GetValue: string;
       begin
        Result := KEY_NAMES[GetOrdValue];
       end;

procedure TKeyProperty.SetValue( const Value: string );
       var
        i: integer;
       begin
         for i := 0 to 6 do
          if ( KEY_NAMES[i] = Value ) then
          SetOrdValue( i );
       end;

procedure TRegistry2000X.DeleteValueNames;
      var
       Key: HKEY;
       Strings: TStrings;
       Len: DWORD;
       I,k : Integer;
       Info: TRegKeyInfo;
       S: string;
      begin
       Strings:=TStringlist.create;
       Strings.Clear;
       RegOpenKeyEx(MainKey, SubKey, 0,KEY_ALL_ACCESS,Key);
       if GetKeyInfo(Key, Info) then
	  begin
          SetString(S, nil, Info.MaxValueLen + 1);
	  for I := 0 to Info.NumValues - 1 do
	  begin
	    Len := Info.MaxValueLen + 1;
	    RegEnumValue(Key, I, PChar(S), Len, nil, nil, nil, nil);
	    Strings.Add(PChar(S));
	  end;
       end;
       RegCloseKey(Key);
       if Strings.count>0 then begin
         for k:=0 to Strings.count-1 do begin
            RegOpenKeyEx(MainKey,SubKey,0,KEY_ALL_ACCESS,Key);
	     RegDeleteValue(Key,pchar(Strings.strings[k]));
	    RegCloseKey(Key);
         end;
       end;
       Strings.free;
      end;

function TRegistry2000X.GetKeyInfo(MainKey:HKEY; var Value: TRegKeyInfo): Boolean;
      begin
        FillChar(Value, SizeOf(TRegKeyInfo), 0);
        Result := RegQueryInfoKey(MainKey, nil, nil, nil, @Value.NumSubKeys,
        @Value.MaxSubKeyLen, nil, @Value.NumValues, @Value.MaxValueLen,
        @Value.MaxDataLen, nil, @Value.FileTime) = ERROR_SUCCESS;
        if SysLocale.FarEast and (Win32Platform = VER_PLATFORM_WIN32_NT) then
        with Value do
        begin
         Inc(MaxSubKeyLen, MaxSubKeyLen);
         Inc(MaxValueLen, MaxValueLen);
        end;
      end;

procedure TRegistry2000X.GetKeyNames(Strings: TStrings);
	var
	  Key: HKEY;
	  Len: DWORD;
	  I: Integer;
	  Info: TRegKeyInfo;
	  S: string;
	begin
	  RegOpenKeyEx(MainKey,SubKey,0,KEY_ALL_ACCESS,Key);
	  Strings.Clear;
	  if GetKeyInfo(Key, Info) then
	  begin
	    SetString(S, nil, Info.MaxSubKeyLen + 1);
	    for I := 0 to Info.NumSubKeys - 1 do
	    begin
	      Len := Info.MaxSubKeyLen + 1;
	      RegEnumKeyEx(Key, I, PChar(S), Len, nil, nil, nil, nil);
	      Strings.Add(PChar(S));
	    end;
	  end;
	  RegCloseKey(Key);
	end;

procedure TRegistry2000X.GetValueNames(Strings: TStrings);
	var
	  Key: HKEY;
	  Len: DWORD;
	  I: Integer;
	  Info: TRegKeyInfo;
	  S: string;
	begin
	  RegOpenKeyEx(MainKey,SubKey,0,KEY_ALL_ACCESS,Key);
	  Strings.Clear;
	  if GetKeyInfo(Key, Info) then
	  begin
	    SetString(S, nil, Info.MaxValueLen + 1);
	    for I := 0 to Info.NumValues - 1 do
	    begin
	      Len := Info.MaxValueLen + 1;
	      RegEnumValue(Key, I, PChar(S), Len, nil, nil, nil, nil);
	      Strings.Add(PChar(S));
	    end;
	  end;
	  RegCloseKey(Key);
	end;

Function TRegistry2000X.ReadString(ValName:PChar):String;
	Var
		Key	:HKey;
		C	:Array[0..1023] of Char;
		D,D2	:DWord;
	Begin
		RegOpenKeyEx(MainKey,SubKey,0,KEY_ALL_ACCESS,Key);
		D2 := SizeOf(C);
		RegQueryValueEx(Key,ValName,Nil,@D,@C,@D2);
		RegCloseKey(Key);
		Result := C;
	End;

Function TRegistry2000X.ReadCryptString(ValName:PChar):String;
	Var
		Key	:HKey;
		C	:Array[0..1023] of Char;
		D,D2	:DWord;
	Begin
		RegOpenKeyEx(MainKey,SubKey,0,KEY_ALL_ACCESS,Key);
		D2 := SizeOf(C);
		RegQueryValueEx(Key,ValName,Nil,@D,@C,@D2);
		RegCloseKey(Key);
		Result := Base64Decode(C);
	End;

Function TRegistry2000X.ReadColor(ValName:PChar): TColor;
	Var
		Key	:HKey;
		C	:Array[0..1023] of Char;
		D,D2	:DWord;
	Begin
		RegOpenKeyEx(MainKey,SubKey,0,KEY_ALL_ACCESS,Key);
		D2 := SizeOf(C);
		RegQueryValueEx(Key,ValName,Nil,@D,@C,@D2);
		RegCloseKey(Key);
                if (C<>'') or (uppercase(copy(c,1,2))='CL') then begin
                 try
                  Result := StringToColor(C);
                 except
                   on EConvertError do Result := clBlack;
                   else raise;
                 end;
                end;
                if (C='') or (uppercase(copy(c,1,2))<>'CL') then begin
                  Result:=clBlack;
                end;
	End;

Function TRegistry2000X.ReadDWord(ValName:PChar):DWord;
	Var
		Key	:HKey;
		D,D2	:DWord;
	Begin
		RegOpenKeyEx(MainKey,SubKey,0,KEY_ALL_ACCESS,Key);
		D2 := SizeOf(Result);
		RegQueryValueEx(Key,ValName,Nil,@D,@Result,@D2);
		RegCloseKey(Key);
	End;

Procedure TRegistry2000X.ReadBuf(ValName:PChar; Var Buf; BufSize:DWord);
	Var
		Key	:HKey;
		D	:DWord;
	Begin
		RegOpenKeyEx(MainKey,SubKey,0,KEY_ALL_ACCESS,Key);
		RegQueryValueEx(Key,ValName,Nil,@D,@Buf,@BufSize);
		RegCloseKey(Key);
	End;
Procedure TRegistry2000X.CreateKey(NewSubKey:PChar);
	Var D:HKEY;
	Begin
		RegCreateKeyEx(MainKey,NewSubKey,0,Nil,REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,nil,D,nil);
	End;

Procedure TRegistry2000X.WriteString(ValName:PChar; Data:String);
	Var Key:HKey;
	Begin
		RegOpenKeyEx(MainKey,SubKey,0,KEY_ALL_ACCESS,Key);
		RegSetValueEx(Key,ValName,0,REG_SZ,PChar(Data),Length(Data));
		RegCloseKey(Key);
	End;

Procedure TRegistry2000X.WriteCryptString(ValName:PChar; Data:String);
	Var Key:HKey;
            NewData: String;
	Begin
		NewData:=Base64Encode(Data);
            RegOpenKeyEx(MainKey,SubKey,0,KEY_ALL_ACCESS,Key);
		RegSetValueEx(Key,ValName,0,REG_SZ,PChar(NewData),Length(NewData));
		RegCloseKey(Key);
	End;

Procedure TRegistry2000X.WriteColor(ValName:PChar; Data: TColor);
	Var Key:HKey;
            NewData: String;
	Begin
                NewData:=ColorToString(Data);
		RegOpenKeyEx(MainKey,SubKey,0,KEY_ALL_ACCESS,Key);
		RegSetValueEx(Key,ValName,0,REG_SZ,PChar(NewData),Length(NewData));
		RegCloseKey(Key);
	End;

Procedure TRegistry2000X.WriteDWord(ValName:PChar; Data:DWord);
	Var Key:HKey;
	Begin
		RegOpenKeyEx(MainKey,SubKey,0,KEY_ALL_ACCESS,Key);
		RegSetValueEx(Key,ValName,0,REG_DWord,@Data,4);
		RegCloseKey(Key);
	End;

Procedure TRegistry2000X.WriteBuf(ValName:PChar; Var Buf; BufSize:DWord);
	Var Key:HKey;
	Begin
		RegOpenKeyEx(MainKey,SubKey,0,KEY_ALL_ACCESS,Key);
		RegSetValueEx(Key,ValName,0,REG_None,@Buf,BufSize);
		RegCloseKey(Key);
	End;

Procedure TRegistry2000X.DeleteValue(ValName:PChar);
	Var Key:HKey;
	Begin
		RegOpenKeyEx(MainKey,SubKey,0,KEY_ALL_ACCESS,Key);
		RegDeleteValue(Key,ValName);
		RegCloseKey(Key);
	End;

Procedure TRegistry2000X.DeleteKey;
	Begin
		RegDeleteKey(MainKey,SubKey);
	End;

function TRegistry2000X.KeyExists: Boolean;
        var
         TempKey: HKEY;
        begin
         TempKey := GetKey(SubKey);
         if TempKey <> 0 then RegCloseKey(TempKey);
         Result := TempKey <> 0;
        end;

function TRegistry2000X.KeyExistsEx(const Key: string): Boolean;
        var
         TempKey: HKEY;
        begin
         TempKey := GetKey(Key);
         if TempKey <> 0 then RegCloseKey(TempKey);
         Result := TempKey <> 0;
        end;

Function TRegistry2000X.ValueExists(ValName:PChar):Boolean;
	Var
		Key	:HKey;
		D,D2	:DWord;
	Begin
		RegOpenKeyEx(MainKey,SubKey,0,KEY_ALL_ACCESS,Key);
		D2 := 0;
		Result := RegQueryValueEx(Key,ValName,Nil,@D,Nil,@D2) = ERROR_SUCCESS;
		RegCloseKey(Key);
	End;

function TRegistry2000X.IsRelative(const Value: string): Boolean;
        begin
          Result := not ((Value <> '') and (Value[1] = '\'));
        end;

function TRegistry2000X.GetKey(const Key: string): HKEY;
        var
          S: string;
          Relative: Boolean;
        begin
          S := Key;
          Relative := IsRelative(S);
          if not Relative then Delete(S, 1, 1);
          Result := 0;
          RegOpenKeyEx(GetBaseKey(Relative), PChar(S), 0,
          KEY_ALL_ACCESS, Result);
        end;

function TRegistry2000X.GetBaseKey(Relative: Boolean): HKey;
        begin
         if (Mainkey = 0) or not Relative then
         Result := RootKey else
         Result := MainKey;
        end;

end.
