{ ****************************************************************
  Info               :  TOpenDialog2000X
                        TSaveDialog2000X
                        Freeware

  Source File Name   :  X2000OpenDialog.PAS
  Author             :  Baldemaier Florian (Baldemaier.Florian@gmx.net)
  Original           :  Workshell Software
  Compiler           :  Delphi 5.0 Professional
  Decription         :  Custom Open and Save Dialog
**************************************************************** }
unit X2000OpenDialog;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, CommDlg, StdCtrls, Dlgs, x2000AboutInfo;

type
  TEnhancedOption = (ofOKButton, ofCancelButton, ofDrive,
    ofFileName, ofFileType);
  TEnhancedOptions = set of TEnhancedOption;

  TFileEditStyle = (fsEdit, fsComboBox);

  TOpenDialog2000X = class(TOpenDialog)
  private
    FAbout: TAboutInfo2000X;
    FOKText: string;
    FCancelText: string;
    FDriveText: string;
    FFileNameText: string;
    FFileTypeText: string;
    FReadOnlyText: string;
    FHelpText: string;
    FEnhancedOptions: TEnhancedOptions;
  protected
    procedure DoShow; override;
  public
    constructor Create (AOwner: TComponent); override;
    procedure SetControlText (id: integer; s: string);
    procedure HideControl (id: integer);
  published
    property About             : TAboutInfo2000X read FAbout write FAbout Stored False;
    property OKText: string
      read FOKText write FOKText;
    property CancelText: string
      read FCancelText write FCancelText;
    property DriveText: string
      read FDriveText write FDriveText;
    property FileNameText: string
      read FFileNameText write FFileNameText;
    property FileTypeText: string
      read FFileTypeText write FFileTypeText;
    property ReadOnlyText: string
      read FReadOnlyText write FReadOnlyText;
    property HelpText: string
      read FHelpText write FHelpText;
    property EnhancedOptions: TEnhancedOptions
      read FEnhancedOptions write FEnhancedOptions;
  end;

  TSaveDialog2000X = class (TOpenDialog2000X)
  private
    FAbout: TAboutInfo2000X;
  public
    constructor Create (AOwner: TComponent); override;
    function Execute: boolean; override;
  published
    property About: TAboutInfo2000X read FAbout write FAbout Stored False;
  end;

implementation

constructor TOpenDialog2000X.Create (AOwner: TComponent);
begin
  inherited Create (AOwner);

  FOKText := '&Open';
  FCancelText := 'Cancel';
  FDriveText := 'Look &in';
  FFileNameText := 'File &name';
  FFileTypeText := 'File &type';
  FReadOnlyText := 'Open as &read-only';
  FHelpText := '&Help';

  FEnhancedOptions := [ofOKButton, ofCancelButton, ofDrive,
    ofFileName, ofFileType];
end;

procedure TOpenDialog2000X.DoShow;
begin
  inherited;
  
  if (not (ofOKButton in FEnhancedOptions)) then
    HideControl (IDOK);
  if (not (ofCancelButton in FEnhancedOptions)) then
    HideControl (IDCANCEL);
  if (not (ofDrive in FEnhancedOptions)) then
  begin
    HideControl (stc4);
    HideControl (cmb2);
  end;
  if (not (ofFileName in FEnhancedOptions)) then
  begin
    HideControl (stc3);
    HideControl (edt1);
  end;
  if (not (ofFileType in FEnhancedOptions)) then
  begin
    HideControl (stc2);
    HideControl (cmb1);
  end;

  SetControlText (IDOK, FOKText);
  SetControlText (IDCANCEL, FCancelText);
  SetControlText (chx1, FReadOnlyText);
  SetControlText (stc2, FFileTypeText);
  SetControlText (stc3, FFileNameText);
  SetControlText (stc4, FDriveText);
  SetControlText (pshHelp, FHelpText);
end;

procedure TOpenDialog2000X.SetControlText (id : Integer;s : String);
begin
  SendMessage (GetParent(Handle), CDM_SETCONTROLTEXT, id,
               longint (PChar(s)));
end;

procedure TOpenDialog2000X.HideControl (id : Integer);
begin
  SendMessage (GetParent(Handle), CDM_HIDECONTROL, id, 0);
end;

constructor TSaveDialog2000X.Create (AOwner: TComponent);
begin
  inherited Create (AOwner);

  FOKText := '&Save';
end;

function TSaveDialog2000X.Execute: boolean;
begin
  Result := DoExecute (@GetSaveFileName);
end;

end.
