{ ****************************************************************
  Info               :  TNetCardInfo2000X
                        Freeware

  Source File Name   :  X2000NETCARDINFO.PAS
  Autho / Modified   :  Baldemaier Florian(Baldemaier.Florian@gmx.net)
  Compiler           :  Delphi 5.0 Professional
  Decription         :  Some informations about your Networkcard

****************************************************************   }
unit X2000NetCardInfo;
interface

uses

  WinProcs, Wintypes, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Menus, ShellApi, Winsock, nb30, x2000AboutInfo;

type
 TNBLanaResources = (lrAlloc, lrFree);

type
 PMACAddress = ^TMACAddress;
 TMACAddress = array[0..5] of Byte;

type
  TProxyInfo2000X=Class (TPersistent)
   private
    FFTP, FGopher, FHTTP, FHTTPS, FSOCKS, FProxyOverride:string;
    procedure SetNone1(Value: String);
   public
    procedure Refresh;
   published
    property FTP           : String read FFTP           write SetNone1 Stored False;
    property GOPHER        : String read FGOPHER        write SetNone1 Stored False;
    property HTTP          : String read FHTTP          write SetNone1 Stored False;
    property HTTPS         : String read FHTTPS         write SetNone1 Stored False;
    property SOCKS         : String read FSOCKS         write SetNone1 Stored False;
    property ProxyOverride : String read FProxyOverride write SetNone1 Stored False;
  end;

  TNetCardInfo2000X = class(TComponent)
   private
    FAbout     : TAboutInfo2000X;
    FProxy     : TProxyInfo2000X;
    FMacAdress : string;
    FNet   : Tstrings;
    FNetP  : Tstrings;
    FEmail : Tstrings;
    procedure SetNone1(Value: TProxyInfo2000X);
    procedure SetNone2(Value: TStrings);
   protected
    procedure ShowMacaddress;
    procedure SetNone(value: string);
   public
    FLana      : integer;
    constructor Create(AOwner: TComponent); override;
    function  LocalIP : string;
    procedure GetAllIPs(IPs: TStrings);
    function  GetLanaEnum(LanaEnum: PLanaEnum): Byte;
    function  ResetLana(LanaNum, ReqSessions, ReqNames: Byte; LanaRes: TNBLanaResources): Byte;
    function  GetMACAddress(LanaNum: byte): string;
    function  GetMACAddressEx(LanaNum: Byte; MACAddress: PMACAddress): Byte;
    procedure Refresh;
  published
    property About          : TAboutInfo2000X read FAbout     write FAbout   Stored False;
    Property Proxy          : TProxyInfo2000X read FProxy     write SetNone1 Stored False;
    property Local_IP       : String          read LocalIP    write SetNone  Stored False;
    property Mac_Adress     : String          read FMacAdress write SetNone  Stored False;
    property Net            : TStrings        read FNet       write SetNone2 Stored False;
    property NetProtocol    : TStrings        read FNetP      write SetNone2 Stored False;
    property Email_Accounts : TStrings        read FEmail     write SetNone2 Stored False;
  end;

implementation

uses X2000SystemInfoHardware;

{ TNetCardInfo2000X }

procedure TNetCardInfo2000X.SetNone1(Value: TProxyInfo2000X);
begin
end;

procedure TNetCardInfo2000X.SetNone2(Value: TStrings);
begin
end;

function TNetCardInfo2000X.GetMACAddress(LanaNum: Byte): string;
begin
  FLana:=LanaNum;
  ShowMacAddress;
  Result:=FMacAdress;
end;

procedure TNetCardInfo2000X.ShowMacaddress;
var
  LanaNum: Byte;
  MACAddress: PMACAddress;
  RetCode: Byte;
begin
  LanaNum := FLana;
  New(MACAddress);
  try
    RetCode := GetMACAddressEx(LanaNum, MACAddress);
    if RetCode = NRC_GOODRET then
    begin
      FMacAdress:= Format('%2.2x-%2.2x-%2.2x-%2.2x-%2.2x-%2.2x',
        [MACAddress[0], MACAddress[1], MACAddress[2],
         MACAddress[3], MACAddress[4], MACAddress[5]]);
    end else
    begin
      FMacAdress:= 'Error';
      ShowMessage('GetMACAddress Error! RetCode = $' + IntToHex(RetCode, 2));
    end;
  finally
    Dispose(MACAddress);
  end;
end;

function TNetCardInfo2000X.ResetLana(LanaNum, ReqSessions, ReqNames: Byte;
  LanaRes: TNBLanaResources): Byte;
var
  ResetNCB: PNCB;
begin
  New(ResetNCB);
  ZeroMemory(ResetNCB, SizeOf(TNCB));
  try
    with ResetNCB^ do
    begin
      ncb_lana_num := Char(LanaNum);        // Set Lana_Num
      ncb_lsn := Char(LanaRes);             // Allocation of new resources
      ncb_callname[0] := Char(ReqSessions); // Query of max sessions
      ncb_callname[1] := #0;                // Query of max NCBs (default)
      ncb_callname[2] := Char(ReqNames);    // Query of max names
      ncb_callname[3] := #0;                // Query of use NAME_NUMBER_1
      ncb_command  := Char(NCBRESET);
      NetBios(ResetNCB);
      Result := Byte(ncb_cmd_cplt);
    end;
  finally
    Dispose(ResetNCB);
  end;
end;

function TNetCardInfo2000X.GetMACAddressEx(LanaNum: Byte; MACAddress: PMACAddress): Byte;
var
  AdapterStatus: PAdapterStatus;
  StatNCB: PNCB;
begin
  New(StatNCB);
  ZeroMemory(StatNCB, SizeOf(TNCB));
  StatNCB.ncb_length := SizeOf(TAdapterStatus) +  255 * SizeOf(TNameBuffer);
  GetMem(AdapterStatus, StatNCB.ncb_length);
  try
    with StatNCB^ do
    begin
      ZeroMemory(MACAddress, SizeOf(TMACAddress));
      ncb_buffer := PChar(AdapterStatus);
      ncb_callname := '*              ' + #0;
      ncb_lana_num := Char(LanaNum);
      ncb_command  := Char(NCBASTAT);
      NetBios(StatNCB);
      Result := Byte(ncb_cmd_cplt);
      if Result = NRC_GOODRET then
        MoveMemory(MACAddress, AdapterStatus, SizeOf(TMACAddress));
    end;
  finally
    FreeMem(AdapterStatus);
    Dispose(StatNCB);
  end;
end;


function TNetCardInfo2000X.GetLanaEnum(LanaEnum: PLanaEnum): Byte;
var
  LanaEnumNCB: PNCB;
begin
  New(LanaEnumNCB);
  ZeroMemory(LanaEnumNCB, SizeOf(TNCB));
  try
    with LanaEnumNCB^ do
    begin
      ncb_buffer := PChar(LanaEnum);
      ncb_length := SizeOf(TLanaEnum);
      ncb_command  := Char(NCBENUM);
      NetBios(LanaEnumNCB);
      Result := Byte(ncb_cmd_cplt);
    end;
  finally
    Dispose(LanaEnumNCB);
  end;
end;

procedure TNetCardInfo2000X.SetNone(value:string);
begin
end;

procedure TNetCardInfo2000X.Refresh;
begin
//  Local_IP:=LocalIP;  { Local_IP reads from LocalIP!!! }
  ShowMacaddress;
  GetNetworkAdapters (FNet);
  GetNetworkProtocoll(FNetP);
  GetEmailAccouts    (FEmail);

  Proxy.Refresh;
end;

function TNetCardInfo2000X.LocalIP: string;
type
    TaPInAddr = array [0..10] of PInAddr;
    PaPInAddr = ^TaPInAddr;
var
    phe  : PHostEnt;
    pptr : PaPInAddr;
    Buffer : array [0..63] of char;
    I    : Integer;
    GInitData      : TWSADATA;

begin
    WSAStartup($101, GInitData);
    Result := '';
    GetHostName(Buffer, SizeOf(Buffer));
    phe :=GetHostByName(buffer);
    if phe = nil then Exit;
    pptr := PaPInAddr(Phe^.h_addr_list);
    I := 0;
    while pptr^[I] <> nil do begin
      result:=StrPas(inet_ntoa(pptr^[I]^));
      Inc(I);
    end;
    WSACleanup;
end;

procedure TNetCardInfo2000X.GetAllIPs(IPs: TStrings);
type
    TaPInAddr = array [0..10] of PInAddr;
    PaPInAddr = ^TaPInAddr;
var
    phe  : PHostEnt;
    pptr : PaPInAddr;
    Buffer : array [0..63] of char;
    I    : Integer;
    GInitData      : TWSADATA;

begin
    WSAStartup($101, GInitData);
    GetHostName(Buffer, SizeOf(Buffer));
    phe :=GetHostByName(buffer);
    if phe = nil then Exit;
    pptr := PaPInAddr(Phe^.h_addr_list);
    I := 0;
    while pptr^[I] <> nil do begin
      IPs.add(StrPas(inet_ntoa(pptr^[I]^)));
      Inc(I);
    end;
    WSACleanup;
end;

constructor TNetCardInfo2000X.Create(aOwner:TComponent);
begin
  inherited Create(aOwner);
  FLana:=0;
  FNet            := TStringList.create;
  FNetP    := TStringList.create;
  FEmail := TStringList.create;
  FProxy         :=TProxyInfo2000x.Create;
  Refresh;
end;

{ TProxyInfo2000X }

procedure TProxyInfo2000X.Refresh;
begin
  FProxyOverride:=GetProxyServer(1);
  FFTP          :=GetProxyServer(2);
  FGOPHER       :=GetProxyServer(3);
  FHTTP         :=GetProxyServer(4);
  FHTTPS        :=GetProxyServer(5);
  FSOCKS        :=GetProxyServer(6);
end;

procedure TProxyInfo2000X.SetNone1(Value: String);
begin
end;

end.
