{ ****************************************************************
  Info               :  TMotherboardInfo2000X
                        Freeware

  Source File Name   :  X2000Motherboard.PAS
  Author             :  Baldemaier Florian(Baldemaier.Florian@gmx.net)
  Compiler           :  Delphi 5.0 Professional
  Decription         :  Same as in TSystemInfo.

****************************************************************   }
unit X2000Motherboard;

interface

uses
  Windows, Messages, Forms, Classes, Graphics, Controls, SysUtils, ShellAPI, Dialogs,
  x2000AboutInfo;

type
  TMotherboardInfo2000X = class(TComponent)
  private
    FAbout    : TAboutInfo2000X;
    FBiosDate, FBiosName, FBiosVer, FBiosSer:string;
    FBusType, FMachineType:string;
    procedure SetNone1(Value: String);
  public
    constructor Create(aOwner: TComponent); override;
    destructor Destroy; override;
    procedure Refresh;
  published
    property About     : TAboutInfo2000X read FAbout write FAbout   Stored False;
    property BiosDate     : string read FBiosDate    write SetNone1 Stored False;
    property BiosCopyright: string read FBiosName    write SetNone1 Stored False;
    property BiosVersion  : string read FBiosVer     write SetNone1 Stored False;
    property BiosSerial   : string read FBiosSer     write SetNone1 Stored False;
    property BusType      : string read FBusType     write SetNone1 Stored False;
    property MachineType  : string read FMachineType write SetNone1 Stored False;
  end;

implementation

uses X2000SystemInfoHardware;

constructor TMotherboardInfo2000X.Create(aOwner: TComponent);
begin
  inherited Create(aOwner);
  refresh;
end;

destructor TMotherboardInfo2000X.Destroy;
begin
  inherited Destroy;
end;

procedure TMotherboardInfo2000X.SetNone1(Value: String);
begin
end;

procedure TMotherboardInfo2000X.Refresh;
begin
  fBiosVer      :=GetBios(1);
  fBiosName     :=GetBios(2);
  fBiosDate     :=GetBios(3);
  fBiosSer      :=GetBios(4);
  fBusType      :=GetBios(5);
  fMachineType  :=GetBios(6);
end;

end.
